SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: ac_accounts
#

DROP TABLE IF EXISTS `ac_accounts`;

CREATE TABLE `ac_accounts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `sort_code` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `account_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `account_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `balance` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `delete_bit` int DEFAULT '0',
  `account_selection_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `paymenttypes_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `expense_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `paymenttypes_id` (`paymenttypes_id`),
  KEY `customer_id` (`customer_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `expense_id` (`expense_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`) VALUES (1, 1, 2, 0, '1', 'Ibrahim', '95200717', '8.0000', 'Available for bank transfer payment ', 'Admin', '2024-08-08', '12:08:17 pm', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', 1, 0, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: ac_moneydeposits
#

DROP TABLE IF EXISTS `ac_moneydeposits`;

CREATE TABLE `ac_moneydeposits` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneydeposits_ibfk_3` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_moneytransfer
#

DROP TABLE IF EXISTS `ac_moneytransfer`;

CREATE TABLE `ac_moneytransfer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL,
  `transfer_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneytransfer_ibfk_3` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_transactions
#

DROP TABLE IF EXISTS `ac_transactions`;

CREATE TABLE `ac_transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `transaction_date` date DEFAULT NULL,
  `transaction_type` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `debit_amt` double(20,4) DEFAULT NULL,
  `credit_amt` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `ref_accounts_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_moneytransfer_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_moneydeposits_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_salespayments_id` int DEFAULT NULL,
  `ref_salespaymentsreturn_id` int DEFAULT NULL,
  `ref_purchasepayments_id` int DEFAULT NULL,
  `ref_purchasepaymentsreturn_id` int DEFAULT NULL,
  `ref_expense_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_id` (`transaction_type`),
  KEY `account_id` (`debit_account_id`),
  KEY `store_id` (`store_id`),
  KEY `ac_accounts_id` (`ref_accounts_id`),
  KEY `ac_moneytransfer_id` (`ref_moneytransfer_id`),
  KEY `ac_moneydeposits_id` (`ref_moneydeposits_id`),
  KEY `customer_id` (`customer_id`),
  KEY `ref_salespayments_id` (`ref_salespayments_id`),
  KEY `ref_purchasepayments_id` (`ref_purchasepayments_id`),
  KEY `ref_purchasepaymentsreturn_id` (`ref_purchasepaymentsreturn_id`),
  KEY `ac_transactions_ibfk_9` (`ref_salespaymentsreturn_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `ref_expense_id` (`ref_expense_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (1, 2, '', '2024-08-08', 'OPENING BALANCE', NULL, 1, NULL, '0.0000', '', 'Admin', '2024-08-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (2, 2, 'SP/2021/02/0060', '2024-08-23', 'SALES PAYMENT', NULL, 1, NULL, '8.0000', '5 rial cash payment, 3 rial balance by transfer .', 'Admin', '2024-08-23', NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL, 51, NULL, NULL);


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `timestamp` int unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fh99mcik34nln9ga6bj1ovo9qcbujffm', '5.37.235.252', 1729601170, '__ci_last_regenerate|i:1729601080;currency|s:4:\"R.O.\";currency_placement|s:5:\"Right\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:8:\"1st LINE\";inv_username|s:5:\"Admin\";user_lname|s:4:\"User\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:18:\"admin@baramiij.com\";language|s:7:\"English\";language_id|s:1:\"1\";');


#
# TABLE STRUCTURE FOR: db_brands
#

DROP TABLE IF EXISTS `db_brands`;

CREATE TABLE `db_brands` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `brand_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `brand_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (18, 2, NULL, 'Mannol', 'engine oil', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (19, 2, NULL, 'brake-pads', 'brake-pads', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (20, 2, NULL, 'toyota/lexus', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (21, 2, NULL, 'nissan filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (22, 2, NULL, 'mazda filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (23, 2, NULL, 'range-rover filter', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (24, 2, NULL, 'bmw-filter', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (25, 2, NULL, 'volkswagen-filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (26, 2, NULL, 'audi filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (27, 2, NULL, 'mercedez', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (28, 2, NULL, 'checks', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (29, 2, NULL, 'nissan', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (30, 2, NULL, 'masuma brake-pads', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (31, 2, NULL, '80w-90', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (32, 2, NULL, '75w-90', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (33, 2, NULL, '75w-140', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (34, 2, NULL, 'dexron VI', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (35, 2, NULL, 'differential', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (36, 2, NULL, 'Ac-delco filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (37, 2, NULL, 'Petrol', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (38, 2, NULL, 'Water', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (39, 2, NULL, 'Disposable oil', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (40, 2, NULL, 'Office internet', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (41, 2, NULL, 'Accommodation', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (42, 2, NULL, 'Gas', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (43, 2, NULL, 'Electricity', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (44, 2, NULL, 'Workshop tools', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (45, 2, NULL, 'Office consumable', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (46, 2, NULL, 'Office rental space', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (47, 2, NULL, 'office', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (48, 2, NULL, 'Mobile recharge', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (49, 2, NULL, 'old oil', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (50, 2, NULL, 'salary advance', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (51, 2, NULL, 'Lexus Es350', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (52, 2, NULL, 'omanoil services station', 'Gass Station', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (53, 2, NULL, 'Al Labeeb Bookshop', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (54, 2, NULL, 'house holds items', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (55, 2, NULL, 'PURCHASE', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (56, 2, NULL, 'STAFF', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (57, 2, NULL, 'CAR WASH', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (58, 2, NULL, 'LED BULB', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (59, 2, NULL, 'OVER TIME', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (60, 2, NULL, 'service', '', 1);


#
# TABLE STRUCTURE FOR: db_cash_register
#

DROP TABLE IF EXISTS `db_cash_register`;

CREATE TABLE `db_cash_register` (
  `id` int NOT NULL AUTO_INCREMENT,
  `o_amt` float DEFAULT NULL,
  `o_time` datetime DEFAULT NULL,
  `c_amt` float DEFAULT NULL,
  `c_time` datetime DEFAULT NULL,
  `warehouse_id` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_cash_register` (`id`, `o_amt`, `o_time`, `c_amt`, `c_time`, `warehouse_id`) VALUES (1, '0', '2024-02-27 15:35:00', '1', '2024-02-27 16:36:00', 2);
INSERT INTO `db_cash_register` (`id`, `o_amt`, `o_time`, `c_amt`, `c_time`, `warehouse_id`) VALUES (2, '5', '2024-02-27 17:06:00', NULL, NULL, 2);


#
# TABLE STRUCTURE FOR: db_category
#

DROP TABLE IF EXISTS `db_category`;

CREATE TABLE `db_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create category Code',
  `category_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (15, 2, 1, 'CT/02/0001', 'filters', 'oil', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (16, 2, 16, 'CT/02/0016', 'Mannol', 'oil', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (17, 2, 17, 'CT/02/0017', 'labor', 'charge', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (18, 2, 18, 'CT/02/0018', 'air', 'filters', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (19, 2, 19, 'CT/02/0019', 'brake-pads', 'brake-pads', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (20, 2, 20, 'CT/02/0020', 'cabin', 'air-filter', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (21, 2, 21, 'CT/02/0021', 'oil', 'engine', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (22, 2, 22, 'CT/02/0022', 'Service', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (23, 2, 23, 'CT/02/0023', 'Break service exchange', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (24, 2, 24, 'CT/02/0024', 'Break bads', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (25, 2, 25, 'CT/02/0025', 'Air filter', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (26, 2, 26, 'CT/02/0026', 'Ac cabin filter', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (27, 2, 27, 'CT/02/0027', 'Spark plugs', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (28, 2, 28, 'CT/02/0028', 'Fuel pump', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (29, 2, 29, 'CT/02/0029', 'Oil filter', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (30, 2, 30, 'CT/02/0030', 'Fuel Pump Seal', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (31, 2, 31, 'CT/02/0031', 'front brake-pads', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (32, 2, 32, 'CT/02/0032', 'rear brake-pads', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (33, 2, 33, 'CT/02/0033', 'gear oil', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (34, 2, 34, 'CT/02/0034', 'atf oil', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (35, 2, 35, 'CT/02/0035', 'Petrol purchase Nissan Sunny', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (36, 2, 36, 'CT/02/0036', 'Monthly dues', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (37, 2, 37, 'CT/02/0037', 'Monthly internet bills', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (38, 2, 38, 'CT/02/0038', 'Disposable oil', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (39, 2, 39, 'CT/02/0039', 'Staff accommodation', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (40, 2, 40, 'CT/02/0040', 'Cooking gas staff accommodation', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (41, 2, 41, 'CT/02/0041', 'Office drinking water', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (42, 2, 42, 'CT/02/0042', 'Workshop tools', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (43, 2, 43, 'CT/02/0043', 'Office Consumable', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (44, 2, 44, 'CT/02/0044', 'Electricity bills', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (45, 2, 45, 'CT/02/0045', 'Phone bills', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (46, 2, 46, 'CT/02/0046', 'Oredo network', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (47, 2, 47, 'CT/02/0047', 'salary', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (48, 2, 48, 'CT/02/0048', 'purchase', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (49, 2, 49, 'CT/02/0049', 'bookshop printing center', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (50, 2, 50, 'CT/02/0050', 'house hold purchase', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (51, 2, 51, 'CT/02/0051', 'ACCOMODATION', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (52, 2, 52, 'CT/02/0052', 'CAR WASH SERVICE', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (53, 2, 53, 'CT/02/0053', 'LED LIGHT', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (54, 2, 54, 'CT/02/0054', 'EMPLOYEE', '', NULL, 1);


#
# TABLE STRUCTURE FOR: db_cobpayments
#

DROP TABLE IF EXISTS `db_cobpayments`;

CREATE TABLE `db_cobpayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_company
#

DROP TABLE IF EXISTS `db_company`;

CREATE TABLE `db_company` (
  `id` double DEFAULT NULL,
  `company_code` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_name` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_website` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `mobile` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `phone` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `website` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_logo` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `logo` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `upi_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `upi_code` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `country` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `state` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `city` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `address` varchar(300) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `postcode` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `gst_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vat_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `pan_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `bank_details` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `cid` int DEFAULT NULL,
  `category_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expense_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `invoice_view` int DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `status` int DEFAULT NULL,
  `sms_status` int DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `sales_terms_and_conditions` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_company` (`id`, `company_code`, `company_name`, `company_website`, `mobile`, `phone`, `email`, `website`, `company_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `invoice_view`, `status`, `sms_status`, `sales_terms_and_conditions`) VALUES ('1', '', 'Company Name', NULL, '9999999999', '', 'admin@example.com', '', 'company_logo.png', 'logo-0.png', NULL, NULL, 'India', 'Karnataka', 'Belgaum', 'Address Details', '', '', '', '', '', 1, 'CT', 'IT', 'SP', 'PU', 'PR', 'CU', 'SL', 'PR', 'EX', 1, 1, 0, NULL);


#
# TABLE STRUCTURE FOR: db_country
#

DROP TABLE IF EXISTS `db_country`;

CREATE TABLE `db_country` (
  `id` int NOT NULL AUTO_INCREMENT,
  `country` varchar(4050) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (1, 'Abkhazia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (2, 'Afghanistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (3, 'Albania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (4, 'Algeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (5, 'Andorra', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (6, 'Angola', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (7, 'Antigua and Barbuda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (8, 'Argentina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (9, 'Armenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (10, 'Australia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (11, 'Austria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (12, 'Azerbaijan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (13, 'Bahamas', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (14, 'Bahrain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (15, 'Bangladesh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (16, 'Barbados', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (17, 'Belarus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (18, 'Belgium', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (19, 'Belize', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (20, 'Benin', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (21, 'Bhutan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (22, 'Bolivia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (23, 'Bosnia and Herzegovina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (24, 'Botswana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (25, 'Brazil', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (26, 'Brunei', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (27, 'Bulgaria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (28, 'Burkina Faso', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (29, 'Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (30, 'Burundi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (31, 'Cambodia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (32, 'Cameroon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (33, 'Canada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (34, 'Cape Verde', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (35, 'Central African Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (36, 'Chad', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (37, 'Chile', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (38, 'China', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (39, 'Colombia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (40, 'Comoros', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (41, 'Congo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (42, 'Cook Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (43, 'Costa Rica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (44, 'Croatia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (45, 'Cuba', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (46, 'Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (47, 'Czech Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (48, 'C?te d\'Ivoire', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (49, 'Denmark', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (50, 'Djibouti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (51, 'Dominica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (52, 'Dominican Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (53, 'East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (54, 'Ecuador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (55, 'Egypt', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (56, 'El Salvador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (57, 'Equatorial Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (58, 'Eritrea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (59, 'Estonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (60, 'Ethiopia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (61, 'Fiji', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (62, 'Finland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (63, 'France', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (64, 'Gabon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (65, 'Gambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (66, 'Georgia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (67, 'Germany', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (68, 'Ghana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (69, 'Greece', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (70, 'Grenada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (71, 'Guatemala', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (72, 'Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (73, 'Guinea-Bissau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (74, 'Guyana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (75, 'Haiti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (76, 'Honduras', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (77, 'Hungary', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (78, 'Iceland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (79, 'India', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (80, 'Indonesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (81, 'Iran', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (82, 'Iraq', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (83, 'Ireland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (84, 'Israel', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (85, 'Italy', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (86, 'Ivory Coast', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (87, 'Jamaica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (88, 'Japan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (89, 'Jordan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (90, 'Kazakhstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (91, 'Kenya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (92, 'Kiribati', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (93, 'Korea, North', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (94, 'Korea, South', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (95, 'Kosovo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (96, 'Kuwait', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (97, 'Kyrgyzstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (98, 'Laos', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (99, 'Latvia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (100, 'Lebanon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (101, 'Lesotho', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (102, 'Liberia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (103, 'Libya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (104, 'Liechtenstein', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (105, 'Lithuania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (106, 'Luxembourg', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (107, 'Macedonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (108, 'Madagascar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (109, 'Malawi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (110, 'Malaysia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (111, 'Maldives', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (112, 'Mali', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (113, 'Malta', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (114, 'Marshall Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (115, 'Mauritania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (116, 'Mauritius', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (117, 'Mexico', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (118, 'Micronesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (119, 'Moldova', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (120, 'Monaco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (121, 'Mongolia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (122, 'Montenegro', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (123, 'Morocco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (124, 'Mozambique', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (125, 'Myanmar / Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (126, 'Nagorno-Karabakh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (127, 'Namibia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (128, 'Nauru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (129, 'Nepal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (130, 'Netherlands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (131, 'New Zealand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (132, 'Nicaragua', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (133, 'Niger', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (134, 'Nigeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (135, 'Niue', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (136, 'Northern Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (137, 'Norway', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (138, 'Oman', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (139, 'Pakistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (140, 'Palau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (141, 'Palestine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (142, 'Panama', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (143, 'Papua New Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (144, 'Paraguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (145, 'Peru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (146, 'Philippines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (147, 'Poland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (148, 'Portugal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (149, 'Qatar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (150, 'Romania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (151, 'Russia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (152, 'Rwanda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (153, 'Sahrawi Arab Democratic Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (154, 'Saint Kitts and Nevis', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (155, 'Saint Lucia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (156, 'Saint Vincent and the Grenadines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (157, 'Samoa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (158, 'San Marino', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (159, 'Saudi Arabia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (160, 'Senegal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (161, 'Serbia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (162, 'Seychelles', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (163, 'Sierra Leone', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (164, 'Singapore', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (165, 'Slovakia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (166, 'Slovenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (167, 'Solomon Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (168, 'Somalia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (169, 'Somaliland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (170, 'South Africa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (171, 'South Ossetia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (172, 'Spain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (173, 'Sri Lanka', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (174, 'Sudan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (175, 'Suriname', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (176, 'Swaziland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (177, 'Sweden', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (178, 'Switzerland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (179, 'Syria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (180, 'S?o Tom? and Pr?ncipe', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (181, 'Taiwan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (182, 'Tajikistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (183, 'Tanzania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (184, 'Thailand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (185, 'Timor-Leste / East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (186, 'Togo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (187, 'Tonga', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (188, 'Trinidad and Tobago', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (189, 'Tunisia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (190, 'Turkey', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (191, 'Turkmenistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (192, 'Tuvalu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (193, 'Uganda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (194, 'Ukraine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (195, 'United Arab Emirates', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (196, 'United Kingdom', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (197, 'United States', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (198, 'Uruguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (199, 'Uzbekistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (200, 'Vanuatu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (201, 'Vatican City', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (202, 'Venezuela', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (203, 'Vietnam', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (204, 'Yemen', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (205, 'Zambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (206, 'Zimbabwe', '2020-11-03', 1);


#
# TABLE STRUCTURE FOR: db_currency
#

DROP TABLE IF EXISTS `db_currency`;

CREATE TABLE `db_currency` (
  `id` int NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `currency_code` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `currency` blob,
  `symbol` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (1, 'Bulgaria-Bulgarian lev(BGN)', NULL, 'лв', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (2, 'Switzerland \r-Swiss franc (CHF)', NULL, 'CHF', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (3, 'Czechia-Czech koruna(CZK))', NULL, 'Kč ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (4, 'Denmark-Danish krone(DKK)', NULL, 'kr ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (5, 'Euro area countries -Euro(EUR)', NULL, '€ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (6, 'United Kingdom-Pounds sterling (GBP)', NULL, '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (7, 'Croatia -Croatian Kuna (HRK)', NULL, 'kn', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (8, 'Georgia -Georgian lari (GEL)', NULL, '&#8382;', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (9, 'Hungary -Hungarian forint (HUF)', NULL, 'ft', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (10, 'Norway -Norwegian krone (NOK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (11, 'Poland -Polish zloty (PLN)', NULL, 'zł ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (12, 'Russia -Russian ruble (RUB)', NULL, '&#8381; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (13, 'Romania -Romanian leu (RON)', NULL, 'lei', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (14, 'Sweden - Swedish krona (SEK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (15, 'Turkey -Turkish lira (TRY)', NULL, '&#8378; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (16, 'Ukraine - Ukrainian hryvna  (UAH)', NULL, '₴ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (17, 'UAE -Emirati dirham (AED)', NULL, 'د.إ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (18, 'Israel - Israeli shekel (ILS)', NULL, '&#8362; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (19, 'Kenya - Kenyan shilling(KES)', NULL, 'Ksh', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (20, 'Morocco - Moroccan dirham (MAD)', NULL, '.د.م ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (21, 'Nigeria - Nigerian naira (NGN)', NULL, '₦ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (22, 'South Africa -South african rand** (ZAR)', NULL, 'R', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (23, 'Brazil- Brazilian real(BRL)', NULL, 'R$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (24, 'Canada-Canadian dollars (CAD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (25, 'Chile -Chilean peso (CLP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (26, 'Colombia -Colombian peso (COP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (27, 'Mexico - Mexican peso (MXN)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (28, 'Peru -Peruvian sol(PEN)', NULL, 'S/. ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (29, 'USA -US dollar (USD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (30, 'Australia -Australian dollars (AUD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (31, 'Bangladesh -Bangladeshi taka (BDT) ', NULL, '&#2547; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (32, 'China - Chinese yuan (CNY)', NULL, '&#20803; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (33, 'Hong Kong - Hong Kong dollar(HKD)', NULL, '&#36; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (34, 'Indonesia - Indonesian rupiah (IDR)', NULL, 'Rp', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (35, 'India - Indian rupee', 'INR', '₹', '?', 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (36, 'Japan - Japanese yen (JPY)', NULL, '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (37, 'Malaysia - Malaysian ringgit (MYR)', NULL, 'RM', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (38, 'New Zealand - New Zealand dollar (NZD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (39, 'Philippines- Philippine peso (PHP)', NULL, '₱ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (40, 'Pakistan- Pakistani rupee (PKR)', NULL, 'Rs ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (41, 'Singapore - Singapore dollar (SGD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (42, 'South Korea - South Korean won (KRW)', NULL, '&#8361; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (43, 'Sri Lanka - Sri Lankan rupee (LKR)', NULL, 'Rs', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (44, 'Thailand- Thai baht (THB)', NULL, '&#3647; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (45, 'Vietnam - Vietnamese dong', 'VND', '₫', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (46, 'Bitcoin - BTC or XBT', 'BTC ', '₿', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (47, 'Ripples', 'XRP', 'XRP', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (48, 'Monero', 'XMR', 'ɱ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (49, 'Litecoin', 'LTC', 'Ł', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (50, 'Ethereum', 'ETH', 'Ξ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (51, 'Euro', 'EUR', '€', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (52, 'Pounds sterling', 'GBP', '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (53, 'US dollar', 'USD', '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (54, 'Japanese yen', 'JPY', '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (55, 'Omani rial', 'OMR', 'R.O.', NULL, 1);


#
# TABLE STRUCTURE FOR: db_custadvance
#

DROP TABLE IF EXISTS `db_custadvance`;

CREATE TABLE `db_custadvance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `amount` double(20,2) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_ip` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_name` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customer_payments
#

DROP TABLE IF EXISTS `db_customer_payments`;

CREATE TABLE `db_customer_payments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `salespayment_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `salespayment_id` (`salespayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customers
#

DROP TABLE IF EXISTS `db_customers`;

CREATE TABLE `db_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Customer Code',
  `customer_code` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `mobile` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `phone` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `gstin` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax_number` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vatin` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `sales_due` double(20,4) DEFAULT NULL,
  `sales_return_due` double(20,4) DEFAULT NULL,
  `country_id` int DEFAULT NULL,
  `state_id` int DEFAULT NULL,
  `governorate` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `city` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `postcode` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `address` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ship_country_id` int DEFAULT NULL,
  `ship_state_id` int DEFAULT NULL,
  `ship_city` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ship_postcode` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ship_address` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `location_link` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `attachment_1` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `price_level_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Increase',
  `price_level` double(20,4) DEFAULT '0.0000',
  `delete_bit` int DEFAULT '0',
  `tot_advance` double(20,4) DEFAULT NULL,
  `credit_limit` double(20,4) DEFAULT '-1.0000',
  `shippingaddress_id` int DEFAULT NULL,
  `channel` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (1, 1, NULL, 'CU0001', 'Walk-in customer', NULL, '', '', '', '', NULL, '0.0000', '0.0000', '0.0000', 1, NULL, NULL, NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2019-01-01', '10:55:54 pm', 'admin', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, NULL, '-1.0000', 1, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (2, 2, 1, 'CU/02/0001', 'Walk-in customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '-23.0000', '0.0000', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-02-12', '05:53:37 pm', '', NULL, 0, NULL, NULL, 'Increase', '0.0000', 1, '0.0000', '-1.0000', 2, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (3, 2, 3, 'CU/02/0003', 'Mr ibrahim', '95200717', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '04:42:58 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (4, 2, 4, 'CU/02/0004', 'Mr Hitham', '99521740', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.83.87', '5.36.83.87.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '08:59:03 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 26, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (5, 2, 5, 'CU/02/0005', 'Mr Salim', '99200012', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:26:05 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (6, 2, 6, 'CU/02/0006', 'MR ASAAD', '92333335', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.183.143', '5.36.183.143.dynamic-dsl-ip.omantel.net.om', '2024-07-27', '12:47:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 22, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (7, 2, 7, 'CU/02/0007', 'Mr Ali Ahmad', '95555607', '96436665', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.230.14', '5.36.230.14.dynamic-dsl-ip.omantel.net.om', '2024-07-27', '05:26:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 23, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (8, 2, 8, 'CU/02/0008', 'Mr Abdullah Rashdi', '92344489', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.233.58', '5.37.233.58.dynamic-dsl-ip.omantel.net.om', '2024-07-28', '12:54:51 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 24, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (9, 2, 9, 'CU/02/0009', 'Mr Yousuf Al Burayki', '97101036', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.87.208', '5.36.87.208.dynamic-dsl-ip.omantel.net.om', '2024-07-29', '09:58:36 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 25, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (10, 2, 10, 'CU/02/0010', 'MR AHMAD', '91410009', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah North, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.125.87', '5.36.125.87.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '09:12:40 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 27, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (11, 2, 11, 'CU/02/0011', 'Mr Abdulaziz', '95223099', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah North, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.125.87', '5.36.125.87.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '12:05:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 28, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (12, 2, 12, 'CU/02/0012', 'MR AHMAD', '91167727', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '08:44:34 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 29, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (13, 2, 13, 'CU/02/0013', 'Mr Salim Al Mamri', '99775204', '', '', '', '', NULL, '0.0000', '0.0010', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '08:54:34 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 30, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (14, 2, 14, 'CU/02/0014', 'Mr Ahmad', '99029444', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '09:27:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 31, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (15, 2, 15, 'CU/02/0015', 'MR Gaith', '95169746', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', '', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.140.145', '5.36.140.145.dynamic-dsl-ip.omantel.net.om', '2024-08-04', '10:16:22 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 32, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (16, 2, 16, 'CU/02/0016', 'Mr Salim Khalid', '98171030', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah North', NULL, NULL, NULL, NULL, NULL, '5.36.140.145', '5.36.140.145.dynamic-dsl-ip.omantel.net.om', '2024-08-04', '12:11:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 33, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (17, 2, 17, 'CU/02/0017', 'Ahmed Al Badi', '99884441', '', '', '', '', NULL, '0.0000', '0.0020', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Saham', NULL, NULL, NULL, NULL, NULL, '5.36.147.73', '5.36.147.73.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '12:25:25 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 34, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (18, 2, 18, 'CU/02/0018', 'Omar AL MAMari', '92227714', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Saham', NULL, NULL, NULL, NULL, NULL, '5.36.220.161', '5.36.220.161.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '12:50:09 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 35, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (19, 2, 19, 'CU/02/0019', 'Said all badi', '99249579', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Saham', NULL, NULL, NULL, NULL, NULL, '5.36.231.215', '5.36.231.215.dynamic-dsl-ip.omantel.net.om', '2024-08-06', '06:34:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (20, 2, 20, 'CU/02/0020', 'Mr Salim Hamoud', '92002362', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.168.17', '5.36.168.17.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '05:52:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 36, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (21, 2, 21, 'CU/02/0021', 'Mr Arif buyer old oil', '97695582', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Radah', '391', 'Radah saham', NULL, NULL, NULL, NULL, NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '11:59:18 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (22, 2, 22, 'CU/02/0022', 'Mr Mahmood Al Ansari', '90949494', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '05:51:05 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 37, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (23, 2, 23, 'CU/02/0023', 'Mr Nabhan', '95571305', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.117.222', '5.36.117.222.dynamic-dsl-ip.omantel.net.om', '2024-08-10', '07:27:26 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 38, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (24, 2, 24, 'CU/02/0024', 'Mr Musaba/Toyota Camry', '96615177', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '10:46:52 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 39, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (25, 2, 25, 'CU/02/0025', 'Mr Zakaria/Toyota Camry', '97314219', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 138, NULL, 'North Batinah', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '10:58:29 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 40, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (26, 2, 26, 'CU/02/0026', 'MR AHMED', '95565035', '', '', '', '', NULL, '0.0000', NULL, NULL, 138, NULL, 'North Batinah', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '11:16:20 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, 41, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (27, 2, 27, 'CU/02/0027', 'Many', '78702808', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Saham', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '12:00:17 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (28, 2, 28, 'CU/02/0028', 'Talib all khaldi', '92922279', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '12:11:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (29, 2, 29, 'CU/02/0029', 'Mr Rashid', '77444962', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'All batina, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.228.140', '5.37.228.140.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '07:08:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (30, 2, 30, 'CU/02/0030', 'Mr Laith', '92081418', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.199.26', '5.36.199.26.dynamic-dsl-ip.omantel.net.om', '2024-08-12', '06:13:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (31, 2, 31, 'CU/02/0031', 'Walk In Customer', '', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North', NULL, NULL, NULL, NULL, NULL, '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', '2024-08-14', '06:10:11 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (32, 2, 32, 'CU/02/0032', 'Mr Ahmad', '97000161', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', '2024-08-14', '08:25:13 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (33, 2, 33, 'CU/02/0033', 'Mr Nasir AL Mamari', '99510938', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah,  saham', NULL, NULL, NULL, NULL, NULL, '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', '2024-08-14', '08:39:41 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (34, 2, 34, 'CU/02/0034', 'Ali salim', '96557685', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.88.10', '5.36.88.10.dynamic-dsl-ip.omantel.net.om', '2024-08-15', '12:23:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (35, 2, 35, 'CU/02/0035', 'Mr Ali Gafar Al Buraiki', '95697837', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', '2024-08-17', '05:30:33 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (36, 2, 36, 'CU/02/0036', 'Mr Saif', '96444463', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', '2024-08-17', '08:01:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (37, 2, 37, 'CU/02/0037', 'MR TALAL', '98880751', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'SAHAM', '', 'BATINA SAHAM', NULL, NULL, NULL, NULL, NULL, '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', '2024-08-17', '08:56:07 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (38, 2, 38, 'CU/02/0038', 'Mr Salem', 'Customers List ', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.199.217', '5.36.199.217.dynamic-dsl-ip.omantel.net.om', '2024-08-18', '10:10:13 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 42, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (39, 2, 39, 'CU/02/0039', 'Mr Mohammed Al Mamari', '98522894', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'North Batina Saham', NULL, NULL, NULL, NULL, NULL, '5.36.209.235', '5.36.209.235.dynamic-dsl-ip.omantel.net.om', '2024-08-19', '12:17:20 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (40, 2, 40, 'CU/02/0040', 'Mr Sultan Al Buraiki', '98986889', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '2024-08-19', '06:06:04 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (41, 2, 41, 'CU/02/0041', 'Mr Sultan Al Baraiki', '97776040', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 138, NULL, 'North Batinah', 'Saham', '391', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '2024-08-19', '09:11:49 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (42, 2, 42, 'CU/02/0042', 'Mr Khalid', '98885373', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batina', NULL, NULL, NULL, NULL, NULL, '5.36.216.66', '5.36.216.66.dynamic-dsl-ip.omantel.net.om', '2024-08-21', '10:06:43 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (43, 2, 43, 'CU/02/0043', 'Mr Mohammed', '93329076', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.216.66', '5.36.216.66.dynamic-dsl-ip.omantel.net.om', '2024-08-21', '11:17:33 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (44, 2, 44, 'CU/02/0044', 'Mr Ahmad Ali', '97774566', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.233.9', '5.36.233.9.dynamic-dsl-ip.omantel.net.om', '2024-08-21', '09:00:11 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 43, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (45, 2, 45, 'CU/02/0045', 'Mr Mubarak Al Balushi', '95256154', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.233.9', '5.36.233.9.dynamic-dsl-ip.omantel.net.om', '2024-08-21', '09:40:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (46, 2, 46, 'CU/02/0046', 'Mr Zubair', '96678770', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.32.218.218', '5.32.218.218', '2024-08-22', '08:23:04 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (47, 2, 47, 'CU/02/0047', 'Mr Rasheed', '99410607', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.32.218.218', '5.32.218.218', '2024-08-22', '10:49:52 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (48, 2, 48, 'CU/02/0048', 'Mr Malik Al Balushi', '71154797', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.214.32', '5.36.214.32.dynamic-dsl-ip.omantel.net.om', '2024-08-22', '04:47:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 44, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (49, 2, 49, 'CU/02/0049', 'Mr Abdullah Ibrahim', '92255241', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.214.32', '5.36.214.32.dynamic-dsl-ip.omantel.net.om', '2024-08-22', '07:42:26 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (50, 2, 50, 'CU/02/0050', 'Mr Mohammed', '94994878', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.214.32', '5.36.214.32.dynamic-dsl-ip.omantel.net.om', '2024-08-22', '08:18:13 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (51, 2, 51, 'CU/02/0051', 'Mr Abdulaziz', '72085911', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.200.129', '5.36.200.129.dynamic-dsl-ip.omantel.net.om', '2024-08-23', '07:51:40 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (52, 2, 52, 'CU/02/0052', 'Mr Muslem', '94203121', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham', NULL, NULL, NULL, NULL, NULL, '5.36.174.244', '5.36.174.244.dynamic-dsl-ip.omantel.net.om', '2024-08-24', '05:54:43 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (53, 2, 53, 'CU/02/0053', 'MR MAHMOOD', '92882806', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 138, NULL, '', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.174.244', '5.36.174.244.dynamic-dsl-ip.omantel.net.om', '2024-08-24', '07:29:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (54, 2, 54, 'CU/02/0054', 'Mr Saif', '96493430', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.254.213', '5.37.254.213.dynamic-dsl-ip.omantel.net.om', '2024-08-26', '04:43:23 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (55, 2, 55, 'CU/02/0055', 'AHMED AL BURAKI', '99233228', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.254.213', '5.37.254.213.dynamic-dsl-ip.omantel.net.om', '2024-08-26', '05:56:46 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (56, 2, 56, 'CU/02/0056', 'Mr Mohammed', '99722225', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batina saham', NULL, NULL, NULL, NULL, NULL, '5.37.254.213', '5.37.254.213.dynamic-dsl-ip.omantel.net.om', '2024-08-26', '09:32:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (57, 2, 57, 'CU/02/0057', 'MR KHAMIS', '96051562', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.140.150', '5.36.140.150.dynamic-dsl-ip.omantel.net.om', '2024-08-27', '10:40:59 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (58, 2, 58, 'CU/02/0058', 'Mr SAID', '99231233', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batina, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.140.150', '5.36.140.150.dynamic-dsl-ip.omantel.net.om', '2024-08-27', '12:22:22 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (59, 2, 59, 'CU/02/0059', 'Mr Sami', '91705626', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '3 91', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.111.241', '5.36.111.241.dynamic-dsl-ip.omantel.net.om', '2024-08-27', '08:33:49 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (60, 2, 60, 'CU/02/0060', 'Mr Ahmed', '99359070', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham\r\n\r\n', NULL, NULL, NULL, NULL, NULL, '5.36.111.241', '5.36.111.241.dynamic-dsl-ip.omantel.net.om', '2024-08-27', '09:40:38 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (61, 2, 61, 'CU/02/0061', 'Mr Sultan', '98986888', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.190.211', '5.36.190.211.dynamic-dsl-ip.omantel.net.om', '2024-08-28', '05:37:14 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (62, 2, 62, 'CU/02/0062', 'Mr Khalid', '96360919', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.190.211', '5.36.190.211.dynamic-dsl-ip.omantel.net.om', '2024-08-28', '08:01:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (63, 2, 63, 'CU/02/0063', 'Mr Mohammed', '98898119', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:49:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (64, 2, 64, 'CU/02/0064', 'Mr Ahmed', '98333493', '', '', '', '', NULL, '0.0000', NULL, NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.152.232', '5.36.152.232.dynamic-dsl-ip.omantel.net.om', '2024-08-30', '05:00:56 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (65, 2, 65, 'CU/02/0065', 'Mr Marwan', '99499235', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.152.232', '5.36.152.232.dynamic-dsl-ip.omantel.net.om', '2024-08-30', '05:29:58 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (66, 2, 66, 'CU/02/0066', 'Mr Mohammed', '96314069', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah\r\n', NULL, NULL, NULL, NULL, NULL, '5.36.152.232', '5.36.152.232.dynamic-dsl-ip.omantel.net.om', '2024-08-30', '09:11:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (67, 2, 67, 'CU/02/0067', 'Mr Ahmed', '90444757', '', '', '', '', NULL, '0.0000', NULL, NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.77.233', '5.36.77.233.dynamic-dsl-ip.omantel.net.om', '2024-08-31', '09:21:01 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (68, 2, 68, 'CU/02/0068', 'Mr Abdulhamid', '99888455', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '391', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.77.233', '5.36.77.233.dynamic-dsl-ip.omantel.net.om', '2024-08-31', '12:12:40 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 45, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (69, 2, 69, 'CU/02/0069', 'Mr Ahmad', '90177009', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North,  Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.242.189', '5.36.242.189.dynamic-dsl-ip.omantel.net.om', '2024-08-31', '07:51:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (70, 2, 70, 'CU/02/0070', 'Mr Rashid', '95792117', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.254.161', '5.37.254.161.dynamic-dsl-ip.omantel.net.om', '2024-09-02', '10:24:02 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (71, 2, 71, 'CU/02/0071', 'Mr Ali', '91141142', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.104.109', '5.36.104.109.dynamic-dsl-ip.omantel.net.om', '2024-09-02', '05:10:25 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (72, 2, 72, 'CU/02/0072', 'Khalid salim', '91187888', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.104.109', '5.36.104.109.dynamic-dsl-ip.omantel.net.om', '2024-09-02', '06:59:32 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (73, 2, 73, 'CU/02/0073', 'Mr Ahmad', '97817511', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'North Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.194.55', '5.36.194.55.dynamic-dsl-ip.omantel.net.om', '2024-09-04', '08:51:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (74, 2, 74, 'CU/02/0074', 'Mr Yousuf', '92229732', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.65.53', '5.36.65.53.dynamic-dsl-ip.omantel.net.om', '2024-09-05', '09:03:14 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (75, 2, 75, 'CU/02/0075', 'Mr Ali', '97840500', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'North Batina, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.65.53', '5.36.65.53.dynamic-dsl-ip.omantel.net.om', '2024-09-05', '01:14:51 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (76, 2, 76, 'CU/02/0076', 'Mr Nasir', '96269606', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.199.29', '5.36.199.29.dynamic-dsl-ip.omantel.net.om', '2024-09-05', '05:21:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (77, 2, 77, 'CU/02/0077', 'Mr Mashal', '96060745', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.249.98', '5.37.249.98.dynamic-dsl-ip.omantel.net.om', '2024-09-06', '06:59:34 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (78, 2, 78, 'CU/02/0078', 'Mr Nawaf', '97775269', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.249.98', '5.37.249.98.dynamic-dsl-ip.omantel.net.om', '2024-09-06', '08:57:36 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (79, 2, 79, 'CU/02/0079', 'Mr Mohammed', '93928170', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.178.154', '5.36.178.154.dynamic-dsl-ip.omantel.net.om', '2024-09-07', '05:51:17 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (80, 2, 80, 'CU/02/0080', 'Ahmad Al bulushi', '92318009', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.111.90', '5.37.111.90', '2024-09-08', '04:38:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (81, 2, 81, 'CU/02/0081', 'Mr Ali Al Buraiki', '95232612', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.111.90', '5.37.111.90', '2024-09-08', '05:28:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (82, 2, 82, 'CU/02/0082', 'Mazein Al fizary', '96515599', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.111.90', '5.37.111.90', '2024-09-08', '06:17:59 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (83, 2, 83, 'CU/02/0083', 'Mr Ghalib', '77266140', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.143.49', '5.36.143.49.dynamic-dsl-ip.omantel.net.om', '2024-09-09', '06:05:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (84, 2, 84, 'CU/02/0084', 'Mr Ahmad', '96707077', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.102.89', '5.37.102.89', '2024-09-10', '11:46:40 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (85, 2, 85, 'CU/02/0085', 'Sheikh Abdullah', '95951515', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'SAHAM', '391', 'NORTH BATINA, SAHAM ', NULL, NULL, NULL, NULL, NULL, '5.36.87.227', '5.36.87.227.dynamic-dsl-ip.omantel.net.om', '2024-09-10', '05:26:02 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (86, 2, 86, 'CU/02/0086', 'Mr Mubarak', '98000829', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.201.88', '5.37.201.88.dynamic-dsl-ip.omantel.net.om', '2024-09-13', '08:10:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (87, 2, 87, 'CU/02/0087', 'Mr Rashid', '97332607', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.188.50', '5.36.188.50.dynamic-dsl-ip.omantel.net.om', '2024-09-14', '11:57:44 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (88, 2, 88, 'CU/02/0088', 'Mr Rashid', '98828448', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.182.105', '5.36.182.105.dynamic-dsl-ip.omantel.net.om', '2024-09-14', '09:28:20 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (89, 2, 89, 'CU/02/0089', 'Mr Waheed', '96690789', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.139.36', '5.36.139.36.dynamic-dsl-ip.omantel.net.om', '2024-09-15', '11:51:33 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (90, 2, 90, 'CU/02/0090', 'Mr Ali', '99003789', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.72.162', '5.36.72.162.dynamic-dsl-ip.omantel.net.om', '2024-09-15', '05:09:49 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (91, 2, 91, 'CU/02/0091', 'Mr Nasir', '92398032', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.72.162', '5.36.72.162.dynamic-dsl-ip.omantel.net.om', '2024-09-15', '09:19:41 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (92, 2, 92, 'CU/02/0092', 'Suhail abduslam', '92792326', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.110.87', '5.37.110.87', '2024-09-17', '11:55:04 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (93, 2, 93, 'CU/02/0093', 'Mr yaqoup', '99235515', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.197.14', '5.37.197.14.dynamic-dsl-ip.omantel.net.om', '2024-09-17', '04:44:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (94, 2, 94, 'CU/02/0094', 'Mr  Al Haitham', '79452957', '', '', '', '', NULL, '0.0000', NULL, NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.112.133', '5.37.112.133', '2024-09-18', '08:45:59 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (95, 2, 95, 'CU/02/0095', 'Mr Nasir', '98913007', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.112.133', '5.37.112.133', '2024-09-18', '10:27:30 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (96, 2, 96, 'CU/02/0096', 'Mr Ali', '99210279', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.112.133', '5.37.112.133', '2024-09-18', '07:36:29 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (97, 2, 97, 'CU/02/0097', 'Said mohamad', '94518846', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.112.133', '5.37.112.133', '2024-09-18', '08:06:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 46, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (98, 2, 98, 'CU/02/0098', 'Khalid saqar', '99785020', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.117.219', '5.36.117.219.dynamic-dsl-ip.omantel.net.om', '2024-09-19', '11:53:44 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (99, 2, 99, 'CU/02/0099', 'Mr Rashid', '90648509', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.117.219', '5.36.117.219.dynamic-dsl-ip.omantel.net.om', '2024-09-19', '12:17:22 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (100, 2, 100, 'CU/02/0100', 'Mr Salim', '96628774', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.83.114', '5.36.83.114.dynamic-dsl-ip.omantel.net.om', '2024-09-20', '04:40:12 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (101, 2, 101, 'CU/02/0101', 'Mr Mohammed', '96555961', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.83.114', '5.36.83.114.dynamic-dsl-ip.omantel.net.om', '2024-09-20', '05:22:23 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (102, 2, 102, 'CU/02/0102', 'Mr Mohammed', '99046424', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.83.114', '5.36.83.114.dynamic-dsl-ip.omantel.net.om', '2024-09-20', '05:57:24 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (103, 2, 103, 'CU/02/0103', 'Mr Samid', '98075005', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.77.53', '5.36.77.53.dynamic-dsl-ip.omantel.net.om', '2024-09-21', '11:52:25 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (104, 2, 104, 'CU/02/0104', 'Mr Khalid', '96647246', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.203.49', '5.36.203.49.dynamic-dsl-ip.omantel.net.om', '2024-09-23', '09:42:59 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (105, 2, 105, 'CU/02/0105', 'Taha Al qasmi', '98762600', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.182.108', '5.36.182.108.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '09:35:56 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 47, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (106, 2, 106, 'CU/02/0106', 'Mohamed Al buraki', '97655707', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.182.108', '5.36.182.108.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '10:08:32 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 48, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (107, 2, 107, 'CU/02/0107', 'Mr Ebrahim', '123456789', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.248.100', '5.36.248.100.dynamic-dsl-ip.omantel.net.om', '2024-09-26', '09:45:56 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (108, 2, 108, 'CU/02/0108', 'Mr Suleiman', '95563312', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.214.44', '5.36.214.44.dynamic-dsl-ip.omantel.net.om', '2024-09-26', '07:18:04 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (109, 2, 109, 'CU/02/0109', 'MUTAB', '92421443', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham, ', NULL, NULL, NULL, NULL, NULL, '5.37.126.213', '5.37.126.213', '2024-09-27', '05:43:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (110, 2, 110, 'CU/02/0110', 'Mr Abdulaziz', '95958040', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.126.213', '5.37.126.213', '2024-09-27', '06:11:33 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (111, 2, 111, 'CU/02/0111', 'Mr Ahmood', '99707510', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.161.138', '5.36.161.138.dynamic-dsl-ip.omantel.net.om', '2024-09-28', '08:32:20 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (112, 2, 112, 'CU/02/0112', 'MR MARWAN', '91010033', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.161.138', '5.36.161.138.dynamic-dsl-ip.omantel.net.om', '2024-09-28', '10:04:12 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (113, 2, 113, 'CU/02/0113', 'Mr Walid', '92292472', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.143.64', '5.36.143.64.dynamic-dsl-ip.omantel.net.om', '2024-09-28', '08:24:17 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (114, 2, 114, 'CU/02/0114', 'Mr Hamid', '97541195', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '08:51:39 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (115, 2, 115, 'CU/02/0115', 'Mr Veeramani', '12345678', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Al Batinah north Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '08:55:32 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (116, 2, 116, 'CU/02/0116', 'Mr Salim Mohammed', '99038977', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '09:30:12 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (117, 2, 117, 'CU/02/0117', 'Mr Loay', '97074781', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '06:51:39 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (118, 2, 118, 'CU/02/0118', 'Mr Ahmad', '95628565', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '07:09:24 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (119, 2, 119, 'CU/02/0119', 'Mr Ali', '92644242', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '07:30:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (120, 2, 120, 'CU/02/0120', 'Mr Saif', '99577627', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.241.191', '5.36.241.191.dynamic-dsl-ip.omantel.net.om', '2024-10-01', '07:10:52 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (121, 2, 121, 'CU/02/0121', 'Hamad', '99458710', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.212.77', '5.36.212.77.dynamic-dsl-ip.omantel.net.om', '2024-10-02', '07:43:02 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (122, 2, 122, 'CU/02/0122', 'Mohamed salim', '92687916', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.201.94', '5.37.201.94.dynamic-dsl-ip.omantel.net.om', '2024-10-03', '09:50:52 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 49, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (123, 2, 123, 'CU/02/0123', 'Mr Sultan', '98559793', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.244.98', '5.37.244.98.dynamic-dsl-ip.omantel.net.om', '2024-10-03', '10:03:16 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (124, 2, 124, 'CU/02/0124', 'Mr Abdullah', '97569308', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.87.36', '5.36.87.36.dynamic-dsl-ip.omantel.net.om', '2024-10-04', '09:13:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (125, 2, 125, 'CU/02/0125', 'Mr Salim', '96054838', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.238.77', '5.36.238.77.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '09:13:32 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (126, 2, 126, 'CU/02/0126', 'Mr Mohammed', '79327543', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.238.77', '5.36.238.77.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '11:21:03 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (127, 2, 127, 'CU/02/0127', 'Mr Abdulraheem', '97314313', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.238.77', '5.36.238.77.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '01:32:52 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (128, 2, 128, 'CU/02/0128', 'Mr Nasser', '92273888', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.217.10', '5.36.217.10.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '06:01:59 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (129, 2, 129, 'CU/02/0129', 'Mr Ayman', '93637707', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.202.10', '5.36.202.10.dynamic-dsl-ip.omantel.net.om', '2024-10-06', '10:43:21 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (130, 2, 130, 'CU/02/0130', 'Mr Mohammed', '93666502', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.237.94', '5.37.237.94.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '09:02:13 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (131, 2, 131, 'CU/02/0131', 'Mr Marwan', '98110360', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '05:10:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (132, 2, 132, 'CU/02/0132', 'Mr Salim', '99353553', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '05:56:27 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (133, 2, 133, 'CU/02/0133', 'Mr Hussein Ali', '92426369', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '08:55:00 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (134, 2, 134, 'CU/02/0134', 'Mr Salah', '94467149', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '09:39:39 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (135, 2, 135, 'CU/02/0135', 'Mr Ahmad', '99623158', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'North Saham ', '', 'North Saham', NULL, NULL, NULL, NULL, NULL, '5.36.194.85', '5.36.194.85.dynamic-dsl-ip.omantel.net.om', '2024-10-10', '10:05:25 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (136, 2, 136, 'CU/02/0136', 'Mr Ghaith', '94173100', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.97.196', '5.37.97.196', '2024-10-11', '04:49:04 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (137, 2, 137, 'CU/02/0137', 'Mr Mohammad', '93533524', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.97.196', '5.37.97.196', '2024-10-11', '07:27:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (138, 2, 138, 'CU/02/0138', 'Mr Sayeed Suleiman', '94041615', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.80.170', '5.36.80.170.dynamic-dsl-ip.omantel.net.om', '2024-10-12', '05:15:12 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (139, 2, 139, 'CU/02/0139', 'Mr Rashid Al Buraiki', '99311778', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, '', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.239.49', '5.37.239.49.dynamic-dsl-ip.omantel.net.om', '2024-10-13', '10:55:27 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 50, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (140, 2, 140, 'CU/02/0140', 'Mr Mohammed Nasir', '99288895', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.128.171', '5.36.128.171.dynamic-dsl-ip.omantel.net.om', '2024-10-14', '11:08:25 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (141, 2, 141, 'CU/02/0141', 'Mohamed Al ansari', '95277972', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.220.198', '5.36.220.198.dynamic-dsl-ip.omantel.net.om', '2024-10-14', '05:52:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 51, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (142, 2, 142, 'CU/02/0142', 'Mr Faiza', '95517652', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.103.81', '5.36.103.81.dynamic-dsl-ip.omantel.net.om', '2024-10-15', '08:48:51 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (143, 2, 143, 'CU/02/0143', 'Mr Whales', '78765669', '', '', '', '', NULL, '0.0000', NULL, NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.103.81', '5.36.103.81.dynamic-dsl-ip.omantel.net.om', '2024-10-15', '11:04:10 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (144, 2, 144, 'CU/02/0144', 'Mr Abdulraheem', '91217053', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.223.97', '5.36.223.97.dynamic-dsl-ip.omantel.net.om', '2024-10-17', '05:48:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (145, 2, 145, 'CU/02/0145', 'Mr Mohammed', '92983003', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.223.97', '5.36.223.97.dynamic-dsl-ip.omantel.net.om', '2024-10-17', '07:55:30 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (146, 2, 146, 'CU/02/0146', 'Mr Salim', '92372747', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.252.135', '5.36.252.135.dynamic-dsl-ip.omantel.net.om', '2024-10-18', '09:06:57 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (147, 2, 147, 'CU/02/0147', 'Mr Said', '99557797', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.160.148', '5.36.160.148.dynamic-dsl-ip.omantel.net.om', '2024-10-19', '04:49:47 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 52, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (148, 2, 148, 'CU/02/0148', 'Mr Ibrahim Al Ansari', '99823332', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', '2024-10-20', '05:16:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (149, 2, 149, 'CU/02/0149', 'Mr Issa', '96630117', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.167.26', '5.36.167.26.dynamic-dsl-ip.omantel.net.om', '2024-10-21', '05:50:22 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');


#
# TABLE STRUCTURE FOR: db_emailtemplates
#

DROP TABLE IF EXISTS `db_emailtemplates`;

CREATE TABLE `db_emailtemplates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `key` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `template_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `content` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `variables` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  `undelete_bit` int DEFAULT NULL,
  `admin_only` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (1, 1, 'SAAS_FORGOT_PASSWORD_EMAIL', 'Site forgot password email template', 'Hi {{user_name}},\r\n\r\nyour OTP is {{email_otp}}\r\n\r\nThank you\r\n{{saas_name}}', '{{user_name}}<br>\r\n{{saas_name}}<br>\r\n{{email_otp}}<br>', 1, 1, 1);
INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (2, 1, 'SAAS_WELCOME_EMAIL', 'Site welcome email', 'Hi {{user_name}},\r\nYour email id {{email_id}},\r\nwelcome to our {{saas_name}},\r\n\r\nThank you', '{{user_name}}<br>\r\n{{email_id}}<br>\r\n{{saas_name}}<br>', 1, 1, 1);


#
# TABLE STRUCTURE FOR: db_expense
#

DROP TABLE IF EXISTS `db_expense`;

CREATE TABLE `db_expense` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Expense Code',
  `expense_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expense_for` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expense_amt` double(20,4) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `account_id` (`account_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (11, 2, 1, 'EX/2021/02/0001', 9, '2024-10-08', '491930463', 'Staff Accomodation', '50.0000', 'Bank Transfer', NULL, 'Paid', 'Admin', '2024-10-08', '10:02:40 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (12, 2, 12, 'EX/2021/02/0012', 5, '2024-10-08', '491931196', '1ST Line GSM Mobile Recharge', '10.0000', 'Bank Transfer', NULL, 'Mobile Recharge', 'Admin', '2024-10-08', '10:09:10 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (13, 2, 13, 'EX/2021/02/0013', 11, '2024-10-08', '', 'Social insurance protection', '8.5480', 'Bank Transfer', NULL, '', 'Admin', '2024-10-08', '10:19:25 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (14, 2, 14, 'EX/2021/02/0014', 12, '2024-10-08', '491931638', 'Internet subscription', '31.7650', 'Bank Transfer', NULL, '', 'Admin', '2024-10-08', '10:23:24 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (15, 2, 15, 'EX/2021/02/0015', 2, '2024-10-08', '491931935', 'Electricity bills shop1', '30.0000', 'Bank Transfer', NULL, '', 'Admin', '2024-10-08', '10:26:36 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (16, 2, 16, 'EX/2021/02/0016', 2, '2024-10-08', '491934075', 'Staff flat electricity', '20.0000', 'Bank Transfer', NULL, '', 'Admin', '2024-10-08', '10:30:45 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (17, 2, 17, 'EX/2021/02/0017', 3, '2024-10-08', '491934702', 'Staff water accommodation', '12.0500', 'Bank Transfer', NULL, '', 'Admin', '2024-10-08', '10:33:58 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');


#
# TABLE STRUCTURE FOR: db_expense_category
#

DROP TABLE IF EXISTS `db_expense_category`;

CREATE TABLE `db_expense_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `category_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (1, 2, 'EC0001', 'FOOD', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (2, 2, 'EC0002', 'ELECTRICITY', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (3, 2, 'EC0003', 'WATER', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (4, 2, 'EC0004', 'INTERNET', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (5, 2, 'EC0005', 'PHONE', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (6, 2, 'EC0006', 'delivery', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (7, 2, 'EC0007', 'Gass', 'Staff Accomodation', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (8, 2, 'EC0008', 'WATER TANKER', 'OFFICE USE', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (9, 2, 'EC0009', 'EMPLOYEE ACCOMODATION', 'FOR STAFF', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (10, 2, 'EC0010', 'Expense', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (11, 2, 'EC0011', 'SPF Security', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (12, 2, 'EC0012', '1stLine Wrk/shp internet', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (13, 2, 'EC0013', 'Shop1', '', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_hold
#

DROP TABLE IF EXISTS `db_hold`;

CREATE TABLE `db_hold` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `reference_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'Temprary',
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_holditems
#

DROP TABLE IF EXISTS `db_holditems`;

CREATE TABLE `db_holditems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `hold_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`hold_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_instamojo
#

DROP TABLE IF EXISTS `db_instamojo`;

CREATE TABLE `db_instamojo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sandbox` int DEFAULT NULL,
  `api_key` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `api_token` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_instamojo` (`id`, `store_id`, `sandbox`, `api_key`, `api_token`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_instamojopayments
#

DROP TABLE IF EXISTS `db_instamojopayments`;

CREATE TABLE `db_instamojopayments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `buyer_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `amount` decimal(16,2) NOT NULL,
  `purpose` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `expires_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `send_sms` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `send_email` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `sms_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `email_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `shorturl` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `longurl` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `redirect_url` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `webhook` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `allow_repeated_payments` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `customer_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `modified_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_items
#

DROP TABLE IF EXISTS `db_items`;

CREATE TABLE `db_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create ITEM Code',
  `item_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `sku` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `hsn` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `unit_id` int DEFAULT NULL,
  `alert_qty` int DEFAULT NULL,
  `brand_id` int DEFAULT NULL,
  `lot_number` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `price` double(20,4) DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `purchase_price` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `profit_margin` double(20,2) DEFAULT NULL,
  `sales_price` double(20,4) DEFAULT NULL,
  `stock` double(20,2) DEFAULT NULL,
  `item_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `discount_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount` double(20,2) DEFAULT NULL,
  `service_bit` int DEFAULT '0',
  `seller_points` double(20,2) DEFAULT '0.00',
  `custom_barcode` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `item_group` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `child_bit` int DEFAULT '0',
  `mrp` double(20,4) DEFAULT NULL,
  `offer_value` float NOT NULL DEFAULT '0',
  `offer_on` int NOT NULL DEFAULT '0',
  `is_package` tinyint NOT NULL DEFAULT '0',
  `package_items` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (1, 2, 1, 'csm0001', 'mannol-5w40', 21, '4036021181257', '', 20, 100, 18, NULL, NULL, '4.0000', 151, '4.0000', 'Exclusive', '0.00', '4.0000', '145.50', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:21:14 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021181257', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (2, 2, 2, 'csm0002', 'mercedez-5w40', 21, 'A000989630817AAEW', '', 20, 100, 27, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '186.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:24:45 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', 'A000989630817AAEW', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (3, 2, 3, 'csm0003', 'mannol-5w30', 21, '4036021183107', '', 20, 100, 18, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '0.00', '3.5000', '70.50', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:26:44 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021183107', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (4, 2, 4, 'csm0004', 'mannol-0w20', 21, '4036021188607', '', 20, 100, 18, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '0.00', '4.0000', '114.50', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:30:07 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021188607', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (6, 2, 6, 'csm0006', '04152-YZZD3', 15, '04152YZZD3  ', '', 21, 5, 20, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '8.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:47:34 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '04152YZZD3  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (7, 2, 7, 'csm0007', '90915-YZZN2', 15, '90915YZZN2  ', '', 21, 5, 20, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '1.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:49:54 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '90915YZZN2  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (8, 2, 8, 'csm0008', '04152-YZZD8', 15, '04152YZZD8  ', '', 21, 5, 20, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '13.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:55:05 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '04152YZZD8  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (9, 2, 9, 'csm0009', '04152-YZZD4', 15, '04152YZZD4  ', '', 21, 5, 20, NULL, NULL, '3.5000', 151, '3.5000', 'Exclusive', '0.00', '3.5000', '16.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '11:10:28 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '04152YZZD4  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (10, 2, 10, 'csm0010', '04152YZZD6', 15, '04152YZZD6  ', '', 21, 5, 20, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '10.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '11:53:45 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '04152YZZD6  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (11, 2, 11, 'csm0011', '90915-YZZE2', 15, '90915YZZE2  ', '', 21, 5, 20, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '10.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '11:56:31 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '90915YZZE2  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (12, 2, 12, 'csm0012', '90915-YZZD4', 15, '90915YZZD4  ', '', 21, 5, 20, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '7.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '12:00:22 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '90915YZZD4  ', 'metal type', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (13, 2, 13, 'csm0013', 'Labor charge', 17, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '04:49:00 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (14, 2, 14, 'csm0014', 'mechanic inspection', 22, '111777994mvh', '', 21, 0, 28, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '52.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '06:04:03 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (15, 2, 15, 'csm0015', 'computer scan', 22, '11115544678fsk', '', 21, 0, 28, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '40.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '06:06:46 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (16, 2, 16, 'csm0016', 'Break service exchange', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '15.0000', 151, '15.0000', 'Inclusive', NULL, '15.0000', NULL, '', '5.36.241.204', '5.36.241.204.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '09:53:34 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', 'NA', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (18, 2, 18, 'csm0018', 'atf fluid exchange', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '20.0000', 151, '20.0000', 'Exclusive', NULL, '20.0000', NULL, NULL, '5.36.241.204', '5.36.241.204.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '10:35:56 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', 'NA', 'fluid change', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (19, 2, 19, 'csm0019', 'computer scan', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Exclusive', NULL, '5.0000', NULL, NULL, '5.36.241.204', '5.36.241.204.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '10:38:56 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', 'NA', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (20, 2, 20, 'csm0020', 'mechanic inspection service', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Exclusive', NULL, '5.0000', NULL, '', '5.36.241.204', '5.36.241.204.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '10:40:40 am', 'Admin', NULL, 1, 'Percentage', '100.00', 1, '0.00', 'NA', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (21, 2, 21, 'csm0021', 'Break bads', 19, '', '', 19, 0, 0, NULL, NULL, '20.0000', 151, '20.0000', 'Inclusive', '0.00', '20.0000', '-6.00', NULL, '5.36.83.87', '5.36.83.87.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '08:57:09 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (23, 2, 23, 'csm0023', 'Cabin filter', 20, '', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '0.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:22:24 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (24, 2, 24, 'csm0024', 'replace air filter', 25, 'service charge', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '8.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:23:30 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (25, 2, 25, 'csm0025', 'Fuel pump', 28, '', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '49.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:24:54 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (26, 2, 26, 'csm0026', 'Oil filter', 29, '', '', 21, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '71.50', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:34:02 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (29, 2, 29, 'csm0029', 'replace sparkplugs', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '4.4000', 151, '4.4000', 'Exclusive', NULL, '4.4000', NULL, '', '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '09:13:46 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '4560116440054', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (30, 2, 30, 'csm0030', 'f1l-sparkplugs', 22, '', '', 2, 0, 20, NULL, NULL, '4.4000', 151, '4.4000', 'Exclusive', '0.00', '4.4000', '25.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '09:38:11 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116440054', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (31, 2, 31, 'csm0031', 'nissan', 29, '152081HC0A', '', 2, 0, 0, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '0.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '09:47:29 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '152081HC0A', 'oil filter', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (32, 2, 32, 'csm0032', 'f1l-nissan oil filter', 22, '152081HC0A', '', 2, 0, 29, NULL, NULL, '2.5000', 151, '2.5000', 'Exclusive', '0.00', '2.5000', '15.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '09:51:20 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '152081HC0A', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (33, 2, 33, 'csm0033', 'replace front brake pads', 22, 'service charge', '', 21, 0, 19, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '45.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:17:36 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', 'labor charge ', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (34, 2, 34, 'csm0034', 'rear brake pads', 22, '4560116413089', '', 21, 0, 19, NULL, NULL, '25.0000', 151, '25.0000', 'Exclusive', '0.00', '25.0000', '55.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:20:17 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116413089', 'labor charge', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (35, 2, 35, 'csm0035', 'sparkplugs labor', 22, 'service charge', '', 21, 0, 0, NULL, NULL, '8.0000', 151, '8.0000', 'Exclusive', '0.00', '8.0000', '98.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:35:35 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (36, 2, 36, 'csm0036', 'petrol', 22, '', '', 20, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '101.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:37:06 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (37, 2, 37, 'csm0037', 'replace ac filter', 22, '', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '46.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:42:37 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (38, 2, 38, 'csm0038', 'fuel pump labor charge', 22, '', '', 21, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Exclusive', '0.00', '10.0000', '49.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '12:09:42 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (39, 2, 39, 'csm0039', 'Change seal gazget', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', NULL, '10.0000', NULL, NULL, '5.36.87.208', '5.36.87.208.dynamic-dsl-ip.omantel.net.om', '2024-07-29', '08:38:22 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (40, 2, 40, 'csm0040', 'Break fluid', 21, '', '', 2, 0, 18, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '0.00', NULL, '5.36.87.208', '5.36.87.208.dynamic-dsl-ip.omantel.net.om', '2024-07-29', '08:40:24 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', 'Mannol break fluid ', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (41, 2, 41, 'csm0041', 'fuel pump seal', 22, 'xxk13cck0001', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Exclusive', '10.00', '11.0000', '49.00', NULL, '5.36.219.132', '5.36.219.132.dynamic-dsl-ip.omantel.net.om', '2024-07-29', '06:01:23 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (42, 2, 42, 'csm0042', 'front brake-pads', 19, 'BRKPGLK011', '', 21, 3, 30, NULL, NULL, '35.0000', 151, '35.0000', 'Exclusive', '0.00', '35.0000', '6.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '11:24:53 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116435982', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (43, 2, 43, 'csm0043', 'ms-u0149n rear brake-pads', 19, '4560116413058', '', 21, 5, 30, NULL, NULL, '25.0000', 151, '25.0000', 'Inclusive', '0.00', '25.0000', '2.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '11:52:23 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116413058', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (44, 2, 44, 'csm0044', 'Carry out rear brake-pads replacement', 19, '4560116413669', '', 21, 10, 30, NULL, NULL, '23.0000', 151, '23.0000', 'Inclusive', '0.00', '23.0000', '2.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:04:39 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116413669', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (45, 2, 45, 'csm0045', 'ms-2413 front brake-pads', 19, '4560116414222', '', 21, 10, 30, NULL, NULL, '29.0000', 151, '29.0000', 'Inclusive', '0.00', '29.0000', '4.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:12:24 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116414222', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (46, 2, 46, 'csm0046', 'ms-1541 front brake-pads', 19, '4560116411184', '', 21, 10, 30, NULL, NULL, '29.0000', 151, '29.0000', 'Inclusive', '0.00', '29.0000', '5.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:33:01 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116411184', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (47, 2, 47, 'csm0047', 'ms-1542n rear brakpads', 19, '4560116411191', '', 21, 5, 0, NULL, NULL, '24.0000', 151, '24.0000', 'Inclusive', '0.00', '24.0000', '4.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:39:37 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116411191', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (48, 2, 48, 'csm0048', 'ms-u0072n f150 front brake-pads', 19, '4560116411832', '', 21, 0, 30, NULL, NULL, '32.0000', 151, '32.0000', 'Inclusive', '0.00', '32.0000', '2.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:51:50 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116411832', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (49, 2, 49, 'csm0049', 'gear oil 80w-90', 33, '4036021101064', '', 21, 0, 31, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '0.00', '4.5000', '2.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:11:40 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021101064', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (50, 2, 50, 'csm0050', 'gear oil 75w-90', 33, '4036021101903', '', 21, 0, 32, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '18.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:24:19 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021101903', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (51, 2, 51, 'csm0051', 'gear oil 75w-140', 33, '4036021102009', '', 21, 0, 33, NULL, NULL, '7.0000', 151, '7.0000', 'Inclusive', '0.00', '7.0000', '20.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:30:35 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021102009', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (52, 2, 52, 'csm0052', 'atf dexron VI 1ltr', 34, '4036021101057', '', 21, 0, 34, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '0.00', '4.0000', '6.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:39:24 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021101057', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (53, 2, 53, 'csm0053', 'atf-dexron VI 4ltrs', 34, '4036021401058', '', 21, 0, 34, NULL, NULL, '14.0000', 151, '14.0000', 'Inclusive', '0.00', '14.0000', '1.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:52:10 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021401058', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (54, 2, 54, 'csm0054', 'front diff replacement', 22, '4036021401058', '', 21, 0, 35, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '54.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:59:25 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021401058', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (55, 2, 55, 'csm0055', 'rear diff replacement', 22, '', '', 21, 0, 35, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '49.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '07:05:28 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (56, 2, 56, 'csm0056', 'coolant exchange', 22, '', '', 21, 0, 18, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '48.00', NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '08:59:57 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (57, 2, 57, 'csm0057', 'radiator flush', 22, '', '', 21, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Exclusive', '0.00', '3.0000', '9.00', NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '09:01:14 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (58, 2, 58, 'csm0058', '5ltrs-mannol coolant', 22, '4036021157887', '', 21, 0, 18, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '97.00', NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '09:02:55 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021157887', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (60, 2, 60, 'csm0060', 'Radiator flush', 22, '4036021894195', '', 21, 0, 18, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:17:48 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021894195', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (61, 2, 61, 'csm0061', '56Ceramo Ester', 22, '4036021982922', '', 2, 0, 18, NULL, NULL, '3.5000', 151, '3.5000', 'Exclusive', '0.00', '3.5000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:25:23 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021982922', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (63, 2, 63, 'csm0063', 'Injector cleaner', 22, '4036021894638', '', 2, 0, 18, NULL, NULL, '3.0000', 151, '3.0000', 'Exclusive', '0.00', '3.0000', '8.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:36:59 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021894638', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (64, 2, 64, 'csm0064', 'Ac-delco pf63', 15, NULL, '', NULL, NULL, NULL, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', NULL, '3.5000', NULL, NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:41:26 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '195491660946', 'oil filters', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (65, 2, 65, 'csm0065', 'Ac-delco pf63', 29, '195491660946', '', 2, 7, 36, NULL, NULL, '3.5000', 151, '3.5000', 'Exclusive', '0.00', '3.5000', '5.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:44:25 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '195491660946', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (66, 2, 66, 'csm0066', 'Ac-delco pf48', 29, '193468688443', '', 2, 0, 36, NULL, NULL, '3.0000', 151, '3.0000', 'Exclusive', '0.00', '3.0000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '06:49:25 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '193468688443', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (67, 2, 67, 'csm0067', 'Ac-delco pf64', 29, '195491705081', '', 2, 0, 36, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '0.00', '3.5000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '06:53:56 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '195491705081', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (68, 2, 68, 'csm0068', 'Ac-delco pf457g', 29, '707773193907', '', 2, 0, 36, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '0.00', '3.5000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '06:56:28 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '707773193907', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (69, 2, 69, 'csm0069', 'Nissan sunny petrol purchase', 35, '1234567', '', 20, 0, 37, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '62.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '09:43:42 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (70, 2, 70, 'csm0070', 'Office internet rental bill', 37, '1234567', '', 17, 0, 40, NULL, NULL, '31.0000', 151, '31.0000', 'Inclusive', '0.00', '31.0000', '53.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '10:09:16 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (71, 2, 71, 'csm0071', 'Cooking gas staff accommodation', 39, '1234567', '', 18, 0, 41, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '70.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '10:32:36 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (72, 2, 72, 'csm0072', 'Office drinking water', 41, '1234567', '', 21, 0, 38, NULL, NULL, '0.8000', 151, '0.8000', 'Exclusive', '0.00', '0.8000', '53.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '10:39:43 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (73, 2, 73, 'csm0073', 'Water tanker', 43, '1234567', '', 21, 0, 38, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '51.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '10:58:48 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (74, 2, 74, 'csm0074', '1st office electricity bills', 44, '1234567', '', 21, 0, 43, NULL, NULL, '20.0000', 151, '20.0000', 'Inclusive', '0.00', '20.0000', '52.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '11:10:17 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (75, 2, 75, 'csm0075', '2nd office electricity acct:', 44, '1234567', '', 21, 0, 43, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '51.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '11:14:39 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (76, 2, 76, 'csm0076', '3rd office electricity acct:', 44, '1234567', '', 21, 0, 43, NULL, NULL, '20.0000', 151, '20.0000', 'Inclusive', '0.00', '20.0000', '52.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '12:09:22 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (77, 2, 77, 'csm0077', '4th office electricity acct', 44, '1234567', '', 21, 0, 43, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '52.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '12:16:22 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (78, 2, 78, 'csm0078', 'staff flat rent', 39, '1234567', '', 21, 0, 41, NULL, NULL, '50.0000', 151, '50.0000', 'Inclusive', '0.00', '50.0000', '52.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '10:04:35 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (79, 2, 79, 'csm0079', 'staff accomodation water bill', 39, '1234567', '', 21, 0, 41, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '52.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '10:19:30 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (80, 2, 80, 'csm0080', 'staff accomodation electricity bill', 39, '1234567', '', 21, 0, 41, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '50.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '10:29:51 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (81, 2, 81, 'csm0081', 'Office line mobile recharge', 46, '1234567', '', 21, 0, 48, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '102.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '11:41:47 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (82, 2, 82, 'csm0082', 'sales of use oil', 38, '123456', '', 20, 0, 49, NULL, NULL, '22.0000', 151, '22.0000', 'Inclusive', '0.00', '22.0000', '99.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '11:56:07 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (83, 2, 83, 'csm0083', 'Manni salary advance', 47, '123456', '', 21, 0, 50, NULL, NULL, '22.0000', 151, '22.0000', 'Inclusive', '0.00', '22.0000', '501.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '12:16:05 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', 'advance salary payment', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (84, 2, 84, 'csm0084', 'Employee accomodation internal bills', 39, '123', '', 21, 15, 41, NULL, NULL, '15.0000', 151, '15.0000', 'Inclusive', '0.00', '15.0000', '51.00', NULL, '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '05:10:22 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234', '', 'Single', NULL, NULL, 0, '0.0000', '1500', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (85, 2, 85, 'csm0085', 'Rear Right Hub Bearing', 22, '123', '', 21, 0, 51, NULL, NULL, '15.0000', 151, '15.0000', 'Inclusive', '0.00', '15.0000', '49.00', NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '11:28:29 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (86, 2, 86, 'csm0086', 'mekaniki', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '0.0000', 151, '0.0000', 'Exclusive', NULL, '0.0000', NULL, NULL, '5.37.228.140', '5.37.228.140.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '06:00:55 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '123', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (87, 2, 87, 'csm0087', 'Al Labeeb bookshop printing center', 49, 'Printing press', '', 21, 0, 37, NULL, NULL, '3.3000', 151, '3.3000', 'Inclusive', '0.00', '3.3000', '1.00', NULL, '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '2024-08-19', '08:42:05 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (88, 2, 88, 'csm0088', 'House hold electronics', 50, '', '', 21, 0, 54, NULL, NULL, '3.7400', 151, '3.7400', 'Inclusive', '0.00', '3.7400', '1.00', NULL, '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '2024-08-20', '09:49:30 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (89, 2, 89, 'csm0089', 'Purchase of miscellaneous', 48, '', '', 21, 0, 55, NULL, NULL, '2.2900', 151, '2.2900', 'Inclusive', '0.00', '2.2900', '6.00', NULL, '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '2024-08-20', '10:04:06 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (90, 2, 90, 'csm0090', 'Throttle Service', 22, '', '', 21, 0, 29, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '106.00', NULL, '5.36.200.129', '5.36.200.129.dynamic-dsl-ip.omantel.net.om', '2024-08-23', '08:45:12 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (91, 2, 91, 'csm0091', 'CAR WASH NISSAN SUUNY', 52, '123456', '', 21, 0, 57, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '0.00', '1.0000', '13.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '09:41:34 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (92, 2, 92, 'csm0092', 'LED BULB', 53, '123456', '', 21, 0, 58, NULL, NULL, '0.5000', 151, '0.5000', 'Inclusive', '0.00', '0.5000', '52.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '10:02:17 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (93, 2, 93, 'csm0093', '01FRIDAY OVER TIME ABDULRAUF', 54, '319', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Exclusive', '0.00', '0.6000', '105.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:40:47 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '319', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (94, 2, 94, 'csm0094', '02 FRIDAY OVER TIME ABDULRAUF', 54, '3119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:46:53 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (95, 2, 95, 'csm0095', '03FRIDAY OVER TIME ABDULRAUF', 54, '31119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:53:38 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '31119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (96, 2, 96, 'csm0096', '04FRIDAY OVER TIME ABDULRAUF', 54, '311119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:54:43 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '311119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (97, 2, 97, 'csm0097', '05FRIDAY OVER TIME ABDULRAUF', 54, '3111119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:55:40 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3111119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (98, 2, 98, 'csm0098', '01FRIDAY OVERTIME MANNY', 54, '319', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:24:10 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '319', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (99, 2, 99, 'csm0099', '02FRIDAY OVER TIME MANNY', 54, '3119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:25:38 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (100, 2, 100, 'csm0100', '03FRIDAY OVER TIME MANNY', 54, '31119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:26:29 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '31119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (101, 2, 101, 'csm0101', '04FRIDAY OVER TIME MANNY', 54, '311119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:27:29 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '311119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (102, 2, 102, 'csm0102', '5FRIDAY OVERTIME FOR MANNY', 54, '39111119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '155.00', NULL, '5.36.152.232', '5.36.152.232.dynamic-dsl-ip.omantel.net.om', '2024-08-30', '07:10:15 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3111119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (103, 2, 103, 'csm0103', 'Intake manifold gasket replacement', 17, '123456', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '99.00', NULL, '5.36.134.175', '5.36.134.175.dynamic-dsl-ip.omantel.net.om', '2024-09-07', '08:56:26 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (104, 2, 104, 'csm0104', 'Catalytic Cleaning Lubricant(Mannol)', 22, '12345', '', 21, 0, 60, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '0.00', '3.5000', '40.00', NULL, '5.36.134.175', '5.36.134.175.dynamic-dsl-ip.omantel.net.om', '2024-09-07', '09:27:25 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '12345', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (105, 2, 105, 'csm0105', 'Ac air-outlet damper replacement', 22, '12345', '', 21, 0, 60, NULL, NULL, '15.0000', 151, '15.0000', 'Inclusive', '0.00', '15.0000', '9.00', NULL, '5.37.111.90', '5.37.111.90', '2024-09-08', '09:46:24 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '12345', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (106, 2, 106, 'csm0106', 'WATER PUMP LABOR CHARGE', 22, '123456', '', 21, 0, 60, NULL, NULL, '24.0000', 151, '24.0000', 'Inclusive', '0.00', '24.0000', '9.00', NULL, '5.36.87.227', '5.36.87.227.dynamic-dsl-ip.omantel.net.om', '2024-09-10', '05:53:25 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (107, 2, 107, 'csm0107', 'Front wiper blade replacement', 22, '123', '', 21, 0, 60, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '98.00', NULL, '5.36.77.53', '5.36.77.53.dynamic-dsl-ip.omantel.net.om', '2024-09-21', '12:27:19 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (108, 2, 108, 'csm0108', 'Inner tie-rod end with boot FL', 22, '231', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '8.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:19:45 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '231', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (109, 2, 109, 'csm0109', 'Inner tie-rod end with boot FR', 22, '3211', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '8.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:24:16 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3211', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (110, 2, 110, 'csm0110', 'Outer tie-rod end Fl', 22, '32111', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '9.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:27:17 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '32111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (111, 2, 111, 'csm0111', 'Outer tie-rod end FR', 22, '321111y', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '9.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:28:43 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '321111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (112, 2, 112, 'csm0112', 'Throttle cleaning FR&amp;FL', 22, ' 3211111', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '9.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:34:43 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3211111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (113, 2, 113, 'csm0113', 'Throttle programming', 22, '32111111', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '9.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:36:55 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '32111111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (114, 2, 114, 'csm0114', 'Salary payment for September', 47, '23111111', '', 21, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '4.00', NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '05:48:28 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '231111111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (115, 2, 115, 'csm0115', 'Salary payment for September', 47, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '05:49:46 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', 'Salary', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (116, 2, 116, 'csm0116', 'Overtime for September', 47, NULL, '', NULL, NULL, NULL, NULL, NULL, '3.2000', 151, '3.2000', 'Inclusive', NULL, '3.2000', NULL, NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '05:51:35 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', 'Service ', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (117, 2, 117, 'csm0117', 'Overtime payment for the month', 22, '3211111111', '', 21, 0, 0, NULL, NULL, '3.2000', 151, '3.2000', 'Inclusive', '0.00', '3.2000', '144.00', NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '05:56:10 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '321111111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (118, 2, 118, 'csm0118', 'Windshield wiper fluid', 22, '323', '', 21, 0, 60, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '49.00', NULL, '5.36.238.77', '5.36.238.77.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '12:04:05 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (119, 2, 119, 'csm0119', 'Drive Belt', 22, '32300', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '99.00', NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '08:57:56 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (120, 2, 120, 'csm0120', 'workshop lamp', 48, '323000', '', 21, 0, 55, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '11.00', NULL, '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '2024-10-08', '10:56:10 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (121, 2, 121, 'csm0121', 'cable tie', 48, '323000', '', 21, 0, 55, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '11.00', NULL, '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '2024-10-08', '10:58:28 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (122, 2, 122, 'csm0122', 'cable tie', 48, '3230000', '', 21, 0, 55, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '11.00', NULL, '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '2024-10-08', '11:00:41 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (123, 2, 123, 'csm0123', 'white tape', 48, '3230000', '', 21, 0, 55, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '11.00', NULL, '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '2024-10-08', '11:02:03 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3230000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (124, 2, 124, 'csm0124', 'Purchase', 22, '323001', '', 21, 0, 60, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '97.00', NULL, '5.36.103.81', '5.36.103.81.dynamic-dsl-ip.omantel.net.om', '2024-10-15', '11:01:51 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323001', 'Walk in customer', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');


#
# TABLE STRUCTURE FOR: db_languages
#

DROP TABLE IF EXISTS `db_languages`;

CREATE TABLE `db_languages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (1, 'English', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (2, 'Russian', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (3, 'Spanish', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (4, 'Arabic', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (5, 'Bangla', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (6, 'French', 0);


#
# TABLE STRUCTURE FOR: db_package
#

DROP TABLE IF EXISTS `db_package`;

CREATE TABLE `db_package` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `package_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `package_code` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `package_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `monthly_price` double(20,2) DEFAULT NULL,
  `annual_price` double(20,2) DEFAULT NULL,
  `trial_days` int DEFAULT NULL,
  `max_users` int DEFAULT NULL,
  `max_items` int DEFAULT NULL,
  `max_invoices` int DEFAULT NULL,
  `max_warehouses` int DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_paymenttypes
#

DROP TABLE IF EXISTS `db_paymenttypes`;

CREATE TABLE `db_paymenttypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (36, 2, 'Cash', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (37, 2, 'Visa', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (39, 2, 'Bank Transfer', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (40, 2, 'CHEQUE', 1);


#
# TABLE STRUCTURE FOR: db_paypal
#

DROP TABLE IF EXISTS `db_paypal`;

CREATE TABLE `db_paypal` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sandbox` int DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_paypal` (`id`, `store_id`, `sandbox`, `email`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_paypalpaylog
#

DROP TABLE IF EXISTS `db_paypalpaylog`;

CREATE TABLE `db_paypalpaylog` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `product_id` int NOT NULL,
  `txn_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_gross` float(10,2) NOT NULL,
  `currency_code` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payer_email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_permissions
#

DROP TABLE IF EXISTS `db_permissions`;

CREATE TABLE `db_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  `permissions` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7226 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4414, 1, 17, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4415, 1, 17, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4416, 1, 17, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4417, 1, 17, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4418, 1, 17, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4419, 1, 17, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4420, 1, 17, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4421, 1, 17, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4422, 1, 17, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4423, 1, 17, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4424, 1, 17, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4425, 1, 17, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4426, 1, 17, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4427, 1, 17, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4428, 1, 17, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4429, 1, 17, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4430, 1, 17, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4431, 1, 17, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4432, 1, 17, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4433, 1, 17, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4434, 1, 17, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4435, 1, 17, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4436, 1, 17, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4437, 1, 17, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4438, 1, 17, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4439, 1, 17, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4440, 1, 17, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4441, 1, 17, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4442, 1, 17, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4443, 1, 17, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4444, 1, 17, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4445, 1, 17, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4446, 1, 17, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4447, 1, 17, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4448, 1, 17, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4449, 1, 17, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4450, 1, 17, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4451, 1, 17, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4452, 1, 17, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4453, 1, 17, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4454, 1, 17, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4455, 1, 17, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4456, 1, 17, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4457, 1, 17, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4458, 1, 17, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4459, 1, 17, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4460, 1, 17, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4461, 1, 17, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4462, 1, 17, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4463, 1, 17, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4464, 1, 17, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4465, 1, 17, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4466, 1, 17, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4467, 1, 17, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4468, 1, 17, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4469, 1, 17, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4470, 1, 17, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4471, 1, 17, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4472, 1, 17, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4473, 1, 17, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4474, 1, 17, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4475, 1, 17, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4476, 1, 17, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4477, 1, 17, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4478, 1, 17, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4479, 1, 17, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4480, 1, 17, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4481, 1, 17, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4482, 1, 17, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4483, 1, 17, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4484, 1, 17, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4485, 1, 17, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4486, 1, 17, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4487, 1, 17, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4488, 1, 17, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4489, 1, 17, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4490, 1, 17, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4491, 1, 17, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4492, 1, 18, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4493, 1, 18, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4494, 1, 18, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4495, 1, 18, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4496, 1, 18, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4497, 1, 18, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4498, 1, 18, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4499, 1, 18, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4500, 1, 18, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4501, 1, 18, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4502, 1, 18, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4503, 1, 18, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4504, 1, 18, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4505, 1, 18, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4506, 1, 18, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4507, 1, 18, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4508, 1, 18, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4509, 1, 18, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4510, 1, 18, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4511, 1, 18, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4512, 1, 18, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4513, 1, 18, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4514, 1, 18, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4515, 1, 18, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4516, 1, 18, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4517, 1, 18, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4518, 1, 18, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4519, 1, 18, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4520, 1, 18, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4521, 1, 18, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4522, 1, 18, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4523, 1, 18, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4524, 1, 18, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4525, 1, 18, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4526, 1, 18, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4527, 1, 18, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4528, 1, 18, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4529, 1, 18, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4530, 1, 18, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4531, 1, 18, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4532, 1, 18, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4533, 1, 18, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4534, 1, 18, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4535, 1, 18, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4536, 1, 18, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4537, 1, 18, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4538, 1, 18, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4539, 1, 18, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4540, 1, 18, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4541, 1, 18, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4542, 1, 18, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4543, 1, 18, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4544, 1, 18, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4545, 1, 18, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4546, 1, 18, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4547, 1, 18, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4548, 1, 18, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4549, 1, 18, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4550, 1, 18, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4551, 1, 18, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4552, 1, 18, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4553, 1, 18, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4554, 1, 18, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4555, 1, 18, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4556, 1, 18, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4557, 1, 18, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4558, 1, 18, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4559, 1, 18, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4560, 1, 18, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4561, 1, 18, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4562, 1, 18, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4563, 1, 18, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4564, 1, 18, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4565, 1, 18, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4566, 1, 18, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4567, 1, 18, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4568, 1, 18, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4569, 1, 18, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4570, 1, 18, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4571, 1, 18, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4572, 1, 18, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4573, 1, 18, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4574, 1, 18, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4575, 1, 18, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4576, 1, 18, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4577, 1, 18, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4578, 1, 18, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4579, 1, 18, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4580, 1, 18, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5818, 1, 2, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5819, 1, 2, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5820, 1, 2, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5821, 1, 2, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5822, 1, 2, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5823, 1, 2, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5824, 1, 2, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5825, 1, 2, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5826, 1, 2, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5827, 1, 2, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5828, 1, 2, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5829, 1, 2, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5830, 1, 2, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5831, 1, 2, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5832, 1, 2, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5833, 1, 2, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5834, 1, 2, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5835, 1, 2, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5836, 1, 2, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5837, 1, 2, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5838, 1, 2, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5839, 1, 2, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5840, 1, 2, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5841, 1, 2, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5842, 1, 2, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5843, 1, 2, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5844, 1, 2, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5845, 1, 2, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5846, 1, 2, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5847, 1, 2, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5848, 1, 2, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5849, 1, 2, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5850, 1, 2, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5851, 1, 2, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5852, 1, 2, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5853, 1, 2, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5854, 1, 2, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5855, 1, 2, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5856, 1, 2, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5857, 1, 2, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5858, 1, 2, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5859, 1, 2, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5860, 1, 2, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5861, 1, 2, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5862, 1, 2, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5863, 1, 2, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5864, 1, 2, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5865, 1, 2, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5866, 1, 2, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5867, 1, 2, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5868, 1, 2, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5869, 1, 2, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5870, 1, 2, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5871, 1, 2, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5872, 1, 2, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5873, 1, 2, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5874, 1, 2, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5875, 1, 2, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5876, 1, 2, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5877, 1, 2, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5878, 1, 2, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5879, 1, 2, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5880, 1, 2, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5881, 1, 2, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5882, 1, 2, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5883, 1, 2, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5884, 1, 2, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5885, 1, 2, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5886, 1, 2, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5887, 1, 2, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5888, 1, 2, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5889, 1, 2, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5890, 1, 2, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5891, 1, 2, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5892, 1, 2, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5893, 1, 2, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5894, 1, 2, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5895, 1, 2, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5896, 1, 2, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5897, 1, 2, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5898, 1, 2, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5899, 1, 2, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5900, 1, 2, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5901, 1, 2, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5902, 1, 2, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5903, 1, 2, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5904, 1, 2, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5905, 1, 2, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5906, 1, 2, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5907, 1, 2, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5908, 1, 2, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5909, 1, 2, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5910, 1, 2, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5911, 1, 2, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5912, 1, 2, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5913, 1, 2, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5914, 1, 2, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5915, 1, 2, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5916, 1, 2, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5917, 1, 2, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5918, 1, 2, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5919, 1, 2, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5920, 1, 2, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5921, 1, 2, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5922, 1, 2, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5923, 1, 2, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5924, 1, 2, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5925, 1, 2, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5926, 1, 2, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5927, 1, 2, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5928, 1, 2, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5929, 1, 2, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5930, 1, 2, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5931, 1, 2, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5932, 1, 2, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5933, 1, 2, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5934, 1, 2, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5935, 1, 2, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5936, 1, 2, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5937, 1, 2, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5938, 1, 2, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5939, 1, 2, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5940, 1, 2, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5941, 1, 2, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5942, 1, 2, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5943, 1, 2, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5944, 1, 2, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5945, 1, 2, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5946, 1, 2, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5947, 1, 2, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5948, 1, 2, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5949, 1, 2, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5950, 1, 2, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5951, 1, 2, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5952, 1, 2, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5953, 1, 2, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5954, 1, 2, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5955, 1, 2, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5956, 1, 2, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5957, 1, 2, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5958, 1, 2, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5959, 1, 2, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5960, 1, 2, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5961, 1, 2, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5962, 1, 2, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5963, 1, 2, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5964, 1, 2, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5965, 1, 2, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5966, 1, 2, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5967, 1, 2, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5968, 1, 2, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5969, 1, 2, 'subscription');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5970, 1, 2, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5971, 1, 2, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5972, 1, 2, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5973, 1, 2, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5974, 1, 2, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5975, 1, 2, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5976, 1, 2, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5977, 1, 2, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5978, 1, 2, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5999, 2, 28, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6000, 2, 28, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6001, 2, 28, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6002, 2, 28, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6011, 2, 29, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6012, 2, 29, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6013, 2, 29, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6014, 2, 29, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6015, 2, 29, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6016, 2, 29, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6017, 2, 29, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6018, 2, 29, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6019, 2, 29, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6020, 2, 29, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6021, 2, 29, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6022, 2, 29, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6023, 2, 29, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6024, 2, 29, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6025, 2, 29, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6026, 2, 29, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6027, 2, 29, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6028, 2, 29, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6029, 2, 29, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6030, 2, 29, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6031, 2, 29, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6032, 2, 29, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6033, 2, 29, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6034, 2, 29, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6035, 2, 29, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6036, 2, 29, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6037, 2, 29, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6038, 2, 29, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6039, 2, 29, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6040, 2, 29, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6041, 2, 29, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6042, 2, 29, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6043, 2, 29, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6044, 2, 29, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6045, 2, 29, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6046, 2, 29, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6047, 2, 29, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6048, 2, 29, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6049, 2, 29, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6050, 2, 29, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6051, 2, 29, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6052, 2, 29, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6053, 2, 29, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6054, 2, 29, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6055, 2, 29, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6056, 2, 29, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6057, 2, 29, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6058, 2, 29, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6059, 2, 29, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6060, 2, 29, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6061, 2, 29, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6062, 2, 29, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6063, 2, 29, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6064, 2, 29, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6065, 2, 29, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6066, 2, 29, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6067, 2, 29, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6068, 2, 29, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6069, 2, 29, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6070, 2, 29, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6071, 2, 29, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6072, 2, 29, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6073, 2, 29, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6074, 2, 29, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6075, 2, 29, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6076, 2, 29, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6077, 2, 29, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6078, 2, 29, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6079, 2, 29, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6080, 2, 29, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6081, 2, 29, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6082, 2, 29, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6083, 2, 29, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6084, 2, 29, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6085, 2, 29, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6086, 2, 29, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6087, 2, 29, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6088, 2, 29, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6089, 2, 29, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6090, 2, 29, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6091, 2, 29, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6092, 2, 29, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6093, 2, 29, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6094, 2, 29, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6095, 2, 29, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6096, 2, 29, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6097, 2, 29, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6098, 2, 29, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6099, 2, 29, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6100, 2, 29, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6101, 2, 29, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6102, 2, 29, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6103, 2, 29, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6104, 2, 29, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6105, 2, 29, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6106, 2, 29, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6107, 2, 29, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6108, 2, 29, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6109, 2, 29, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6110, 2, 29, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6111, 2, 29, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6112, 2, 29, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6113, 2, 29, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6114, 2, 29, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6115, 2, 29, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6116, 2, 29, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6117, 2, 29, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6118, 2, 29, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6119, 2, 29, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6120, 2, 29, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6121, 2, 29, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6122, 2, 29, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6123, 2, 29, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6124, 2, 29, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6125, 2, 29, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6126, 2, 29, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6127, 2, 29, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6128, 2, 29, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6129, 2, 29, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6130, 2, 29, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6131, 2, 29, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6132, 2, 29, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6133, 2, 29, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6134, 2, 29, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6135, 2, 29, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6136, 2, 29, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6137, 2, 29, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6138, 2, 29, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6139, 2, 29, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6140, 2, 29, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6141, 2, 29, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6142, 2, 29, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6143, 2, 29, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6144, 2, 29, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6145, 2, 29, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6146, 2, 29, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6147, 2, 29, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6148, 2, 29, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6149, 2, 29, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6150, 2, 29, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6151, 2, 29, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6152, 2, 29, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6153, 2, 29, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6154, 2, 29, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6155, 2, 29, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6156, 2, 29, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6157, 2, 29, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6158, 2, 29, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6159, 2, 29, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6160, 2, 29, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6161, 2, 29, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6162, 2, 29, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6163, 2, 29, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6164, 2, 29, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6165, 2, 29, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6166, 2, 29, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6167, 2, 29, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6168, 2, 29, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6169, 2, 29, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6170, 2, 29, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6179, 1, 2, 'gstr_1_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6180, 1, 2, 'gstr_2_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6181, 1, 2, 'delivery_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6182, 1, 2, 'load_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6183, 1, 2, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6184, 1, 2, 'customer_orders_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6965, 2, 4, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6966, 2, 4, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6967, 2, 4, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6968, 2, 4, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6969, 2, 4, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6970, 2, 4, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6971, 2, 4, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6972, 2, 4, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6973, 2, 4, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6974, 2, 4, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6975, 2, 4, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6976, 2, 4, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6977, 2, 4, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6978, 2, 4, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6979, 2, 4, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6980, 2, 4, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6981, 2, 4, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6982, 2, 4, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6983, 2, 4, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6984, 2, 4, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6985, 2, 4, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6986, 2, 4, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6987, 2, 4, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6988, 2, 4, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6989, 2, 4, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6990, 2, 4, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6991, 2, 4, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6992, 2, 4, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6993, 2, 4, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6994, 2, 4, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6995, 2, 4, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6996, 2, 4, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6997, 2, 4, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6998, 2, 4, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6999, 2, 4, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7000, 2, 4, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7001, 2, 4, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7002, 2, 4, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7003, 2, 4, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7004, 2, 4, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7005, 2, 4, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7006, 2, 4, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7007, 2, 4, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7008, 2, 4, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7009, 2, 4, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7010, 2, 4, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7011, 2, 4, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7012, 2, 4, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7013, 2, 4, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7014, 2, 4, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7015, 2, 4, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7016, 2, 4, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7017, 2, 4, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7018, 2, 4, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7019, 2, 4, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7020, 2, 4, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7021, 2, 4, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7022, 2, 4, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7023, 2, 4, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7024, 2, 4, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7025, 2, 4, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7026, 2, 4, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7027, 2, 4, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7028, 2, 4, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7029, 2, 4, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7030, 2, 4, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7031, 2, 4, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7032, 2, 4, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7033, 2, 4, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7034, 2, 4, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7035, 2, 4, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7036, 2, 4, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7037, 2, 4, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7038, 2, 4, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7039, 2, 4, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7040, 2, 4, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7041, 2, 4, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7042, 2, 4, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7043, 2, 4, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7044, 2, 4, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7045, 2, 4, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7046, 2, 4, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7047, 2, 4, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7048, 2, 4, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7049, 2, 4, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7050, 2, 4, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7051, 2, 4, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7052, 2, 4, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7053, 2, 4, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7054, 2, 4, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7055, 2, 4, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7056, 2, 4, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7057, 2, 4, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7058, 2, 4, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7059, 2, 4, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7060, 2, 4, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7061, 2, 4, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7062, 2, 4, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7063, 2, 4, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7064, 2, 4, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7065, 2, 4, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7066, 2, 4, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7067, 2, 4, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7068, 2, 4, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7069, 2, 4, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7070, 2, 4, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7071, 2, 4, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7072, 2, 4, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7073, 2, 4, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7074, 2, 4, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7075, 2, 4, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7076, 2, 4, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7077, 2, 4, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7168, 2, 3, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7169, 2, 3, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7170, 2, 3, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7171, 2, 3, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7172, 2, 3, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7173, 2, 3, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7174, 2, 3, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7175, 2, 3, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7176, 2, 3, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7177, 2, 3, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7178, 2, 3, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7179, 2, 3, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7180, 2, 3, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7181, 2, 3, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7182, 2, 3, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7183, 2, 3, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7184, 2, 3, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7185, 2, 3, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7186, 2, 3, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7187, 2, 3, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7188, 2, 3, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7189, 2, 3, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7190, 2, 3, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7191, 2, 3, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7192, 2, 3, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7193, 2, 3, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7194, 2, 3, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7195, 2, 3, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7196, 2, 3, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7197, 2, 3, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7198, 2, 3, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7199, 2, 3, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7200, 2, 3, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7201, 2, 3, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7202, 2, 3, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7203, 2, 3, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7204, 2, 3, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7205, 2, 3, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7206, 2, 3, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7207, 2, 3, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7208, 2, 3, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7209, 2, 3, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7210, 2, 3, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7211, 2, 3, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7212, 2, 3, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7213, 2, 3, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7214, 2, 3, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7215, 2, 3, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7216, 2, 3, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7217, 2, 3, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7218, 2, 3, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7219, 2, 3, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7220, 2, 3, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7221, 2, 3, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7222, 2, 3, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7223, 2, 3, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7224, 2, 3, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7225, 2, 3, 'show_purchase_price');


#
# TABLE STRUCTURE FOR: db_purchase
#

DROP TABLE IF EXISTS `db_purchase`;

CREATE TABLE `db_purchase` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Purchase Code',
  `purchase_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `purchase_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'Purchase return raised',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `supplier_id` (`supplier_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (1, 2, 2, 1, 'PU/2021/02/0001', 'Nissan sunny', '2024-08-07', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '12.5000', NULL, '12.5000', 'company vehicle petrol purchase between the periods below:\r\n01-08-2024(5.5 rial)\r\n05-08-2024(7.5 rial)\r\nTotal 12.500 rial\r\n', 'Paid', '12.5000', '2024-08-07', '09:45:12 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (2, 2, 2, 2, 'PU/2021/02/0002', 'Acct: 150643019', '2024-08-07', 'Received', 4, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '25.0000', NULL, '25.0000', '', 'Paid', '25.0000', '2024-08-07', '10:14:19 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (3, 2, 2, 3, 'PU/2021/02/0003', 'Acct: 99769738', '2024-08-07', 'Received', 5, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.0000', NULL, '0.0000', '', 'Paid', '0.0000', '2024-08-07', '10:34:25 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (4, 2, 2, 4, 'PU/2021/02/0004', 'Office drinking water ', '2024-08-07', 'Received', 6, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.0000', NULL, '0.0000', '', 'Paid', '0.0000', '2024-08-07', '10:42:48 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (5, 2, 2, 5, 'PU/2021/02/0005', '92384656', '2024-08-07', 'Received', 7, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.0000', NULL, '0.0000', '', 'Paid', '0.0000', '2024-08-07', '11:00:07 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (6, 2, 2, 6, 'PU/2021/02/0006', 'office acct no: 00619530', '2024-08-07', 'Received', 8, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '20.0000', NULL, '20.0000', '', 'Paid', '20.0000', '2024-08-07', '11:16:06 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (7, 2, 2, 7, 'PU/2021/02/0007', 'office acct no: 00619531', '2024-08-07', 'Received', 9, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.0000', NULL, '0.0000', '', 'Paid', '0.0000', '2024-08-07', '12:11:39 pm', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (8, 2, 2, 8, 'PU/2021/02/0008', 'office acct no: 00619533', '2024-08-07', 'Received', 10, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '20.0000', NULL, '20.0000', '', 'Paid', '20.0000', '2024-08-07', '12:14:12 pm', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (9, 2, 2, 9, 'PU/2021/02/0009', 'office acct no: 00619534', '2024-08-07', 'Received', 11, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-07', '12:18:56 pm', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (10, 2, 2, 10, 'PU/2021/02/0010', 'accomodation:95080928', '2024-08-08', 'Received', 12, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '50.0000', NULL, '50.0000', '', 'Paid', '50.0000', '2024-08-08', '10:07:16 am', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (11, 2, 2, 11, 'PU/2021/02/0011', 'accomodation:00664481', '2024-08-08', 'Received', 13, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-08', '10:21:13 am', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (12, 2, 2, 12, 'PU/2021/02/0012', 'office mobile line: 94551017', '2024-08-08', 'Received', 15, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.0000', NULL, '10.0000', '', 'Paid', '10.0000', '2024-08-08', '11:42:37 am', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (13, 2, 2, 13, 'PU/2021/02/0013', 'office acct no: 00664481', '2024-08-08', 'Received', 13, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-08', '11:47:40 am', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (14, 2, 2, 14, 'PU/2021/02/0014', '1stline employee salary advance', '2024-08-08', 'Received', 16, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '22.0000', NULL, '22.0000', '', 'Paid', '22.0000', '2024-08-08', '12:18:52 pm', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (15, 2, 2, 15, 'PU/2021/02/0015', 'purchase of cooling fan', '2024-08-08', 'Received', 12, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '15.0000', NULL, '15.0000', 'purchase of cooling fan for the staff accommodation', 'Paid', '15.0000', '2024-08-08', '05:13:10 pm', 'Admin', '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (16, 2, 2, 16, 'PU/2021/02/0016', '212754-Nissan Sunny Mr Ibrahim', '2024-08-19', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.3000', NULL, '8.3000', '', 'Paid', '8.3000', '2024-08-19', '08:02:35 pm', 'Admin', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (17, 2, 2, 17, 'PU/2021/02/0017', 'Al Labeeb  Printing center', '2024-08-19', 'Received', 18, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.3000', NULL, '3.3000', '', 'Paid', '3.3000', '2024-08-19', '08:43:14 pm', 'Admin', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (18, 2, 2, 18, 'PU/2021/02/0018', 'OM1100065315', '2024-08-20', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '7.0000', NULL, '7.0000', '', 'Paid', '7.0000', '2024-08-20', '09:28:13 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (19, 2, 2, 19, 'PU/2021/02/0019', 'OM1100098109', '2024-08-20', 'Received', 20, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.7400', NULL, '3.7400', '', 'Paid', '3.7400', '2024-08-20', '09:53:46 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (20, 2, 2, 20, 'PU/2021/02/0020', 'OM1100049868', '2024-08-20', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '2.2900', NULL, '2.2900', '', 'Paid', '2.2900', '2024-08-20', '10:06:19 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (21, 2, 2, 21, 'PU/2021/02/0021', '0430245', '2024-08-20', 'Received', 18, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.1000', NULL, '3.1000', '', 'Paid', '3.1000', '2024-08-20', '10:21:36 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (22, 2, 2, 22, 'PU/2021/02/0022', 'Acct: 150643019', '2024-08-20', 'Received', 4, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.4950', NULL, '8.4950', 'Balance part payment of monthly internet rental bill', 'Paid', '8.4950', '2024-08-20', '11:49:10 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (23, 2, 2, 23, 'PU/2021/02/0023', 'NISSAN SUNNY', '2024-08-26', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.2000', NULL, '9.2000', 'DATE OF SUPPLY: 20/08/2024', 'Paid', '9.2000', '2024-08-26', '09:46:47 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (24, 2, 2, 24, 'PU/2021/02/0024', 'NISSAN SUNNY ', '2024-08-26', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.0000', NULL, '8.0000', 'DATE OF PURCHASE 25-08-2024', 'Paid', '8.0000', '2024-08-26', '09:49:44 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (25, 2, 2, 25, 'PU/2021/02/0025', 'PILOT MARKER PURCHASE', '2024-08-26', 'Received', 18, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '2.2900', NULL, '2.2900', 'PILOT MARKER PURCHASE', 'Paid', '2.2900', '2024-08-26', '09:52:43 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (26, 2, 2, 26, 'PU/2021/02/0026', 'OIL FILTER YZZD1', '2024-08-26', 'Received', 22, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '23.0000', NULL, '23.0000', 'ITEM CODE: 04152YZZD1 OIL FILTER 04152-31090\r\n10 PIECES', 'Paid', '23.0000', '2024-08-26', '10:02:48 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (27, 2, 2, 27, 'PU/2021/02/0027', 'OIL FILTER YZZN2', '2024-08-26', 'Received', 22, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '14.0700', NULL, '14.0700', 'OIL FILTER MVP 90915YZZN2, 10 PIECES', 'Paid', '14.0700', '2024-08-26', '10:09:42 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (28, 2, 2, 28, 'PU/2021/02/0028', 'OIL FILTERS', '2024-08-26', 'Received', 23, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '16.9010', NULL, '16.9010', 'A1-F026407199 OIL FILTER MB CARS GL QTY:2 NET PRICE7.031\r\nA11457429263 OIL FILTER A001802209 QTY:2 NET PRICE 4.200\r\nA1-1457429243 OIL FILTER VW/AUDI/ SKODA QTY2 NET PRICE:5.670\r\nTOTAL 16.901', 'Paid', '16.9010', '2024-08-26', '10:24:58 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (29, 2, 2, 29, 'PU/2021/02/0029', 'OIL FILTERS', '2024-08-26', 'Received', 24, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '30.0000', NULL, '30.0000', 'OIL FILTER 3 QTY 13.199\r\nOIL FILTER 2 QTY 13.999\r\nOIL FILTER 1 QTY 3\r\n\r\nTOTAL 30 OMR', 'Paid', '30.0000', '2024-08-26', '10:31:02 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (30, 2, 2, 30, 'PU/2021/02/0030', 'CAR WASH', '2024-08-29', 'Received', 26, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.0000', NULL, '1.0000', 'MR IBRAHIM CAR WASH', 'Paid', '1.0000', '2024-08-29', '09:46:19 am', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (31, 2, 2, 31, 'PU/2021/02/0031', 'PETROL PURCHASE', '2024-08-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.4000', NULL, '3.4000', 'PETROL PURCHASE 28-08-2024', 'Paid', '3.4000', '2024-08-29', '09:49:05 am', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (33, 2, 2, 33, 'PU/2021/02/0033', 'LIGHTING BULB', '2024-08-29', 'Received', 27, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.0000', NULL, '1.0000', '', 'Paid', '1.0000', '2024-08-29', '10:04:38 am', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (34, 2, 2, 34, 'PU/2021/02/0034', 'GROCERIES', '2024-08-29', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.2000', NULL, '3.2000', 'PURCHASE 27 AUGUST', 'Paid', '3.2000', '2024-08-29', '10:10:28 am', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (36, 2, 2, 36, 'PU/2021/02/0036', 'EMPLOYEE OVERTIME PAYMENT SLIP ABDULRAUF', '2024-08-29', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '15.0000', NULL, '15.0000', 'EMPLOYEE OVERTIME PAYMENT SLIP', 'Paid', '15.0000', '2024-08-29', '12:03:12 pm', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (37, 2, 2, 37, 'PU/2021/02/0037', 'EMPLOYEE OVERTIME PAYMENT SLIP MANNY ', '2024-08-29', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '12.5000', NULL, '12.5000', 'EMPLOYEE OVERTIME PAYMENT SLIP FOR MANNY ', 'Paid', '12.5000', '2024-08-29', '12:31:26 pm', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (38, 2, 2, 38, 'PU/2021/02/0038', 'Petrol Purchase(Nissan Sunny)', '2024-09-16', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.8000', NULL, '9.8000', 'purchase 05/09/2024', 'Paid', '9.8000', '2024-09-16', '11:02:27 am', 'Admin', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (39, 2, 2, 39, 'PU/2021/02/0039', 'Petrol Purchase(Nissan Sunny)', '2024-09-16', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '12/09/2024', 'Paid', '9.5000', '2024-09-16', '11:04:21 am', 'Admin', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (40, 2, 2, 40, 'PU/2021/02/0040', 'Miscellaneous Purchase ', '2024-09-16', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.9550', NULL, '4.9550', 'purchase include: donuts , top-fruits, tifanny, al rayyan and kinza, bake one.', 'Paid', '4.9550', '2024-09-16', '11:08:09 am', 'Admin', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (41, 2, 2, 41, 'PU/2021/02/0041', '', '2024-09-16', 'Received', 29, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', 'bet', 'Paid', '5.0000', '2024-09-16', '11:12:02 am', 'Admin', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (42, 2, 2, 42, 'PU/2021/02/0042', 'Electricity payment', '2024-09-18', 'Received', 30, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '35.0980', NULL, '35.0980', '', 'Paid', '35.0980', '2024-09-18', '05:07:48 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (43, 2, 2, 43, 'PU/2021/02/0043', 'Electricity payment', '2024-09-18', 'Received', 33, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.1250', NULL, '8.1250', '', 'Paid', '8.1250', '2024-09-18', '05:14:02 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (44, 2, 2, 44, 'PU/2021/02/0044', 'Electricity payment', '2024-09-18', 'Received', 34, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '35.0000', NULL, '35.0000', '', 'Paid', '35.0000', '2024-09-18', '05:16:43 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (45, 2, 2, 45, 'PU/2021/02/0045', 'Mobile recharge', '2024-09-18', 'Received', 35, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '13.5300', NULL, '13.5300', '', 'Paid', '13.5300', '2024-09-18', '05:25:31 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (46, 2, 2, 46, 'PU/2021/02/0046', 'Office Internet', '2024-09-18', 'Received', 4, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '31.7650', NULL, '31.7650', '', 'Paid', '31.7650', '2024-09-18', '05:27:07 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (47, 2, 2, 47, 'PU/2021/02/0047', 'Staff Accommodation', '2024-09-18', 'Received', 36, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '50.0000', NULL, '50.0000', '', 'Paid', '50.0000', '2024-09-18', '05:32:18 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (48, 2, 2, 48, 'PU/2021/02/0048', 'Gasoline purchase ', '2024-09-29', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '26/09/2024', 'Paid', '9.5000', '2024-09-29', '05:32:36 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (49, 2, 2, 49, 'PU/2021/02/0049', 'Gasoline purchase ', '2024-09-29', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '18/09/2024', 'Paid', '9.5000', '2024-09-29', '05:34:23 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (50, 2, 2, 50, 'PU/2021/02/0050', 'Gasoline purchase ', '2024-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '22/09/2024', 'Paid', '5.0000', '2024-09-29', '05:35:30 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (51, 2, 2, 51, 'PU/2021/02/0051', 'Car wash', '2024-09-29', 'Received', 37, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.5000', NULL, '1.5000', '', 'Paid', '1.5000', '2024-09-29', '05:38:15 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (52, 2, 2, 52, 'PU/2021/02/0052', 'Manni Payslip 31/09/2024 ', '2024-09-29', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '151.0000', NULL, '151.0000', 'Paycheck 151OMR= 2.5 Overtime deductible from payslip = Bal = 148.5rial', 'Paid', '151.0000', '2024-09-29', '05:54:24 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (53, 2, 2, 53, 'PU/2021/02/0053', 'Abdulrauf Payslip 31/09/2024', '2024-09-29', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '183.2000', NULL, '183.2000', '', 'Paid', '183.2000', '2024-09-29', '06:11:24 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (54, 2, 2, 54, 'PU/2021/02/0054', 'Payslip For Mr Ibrahim 31/09/2024', '2024-09-30', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '400.0000', NULL, '400.0000', '', 'Paid', '400.0000', '2024-09-30', '10:52:17 am', 'Admin', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (55, 2, 2, 55, 'PU/2021/02/0055', 'Petrol Purchase(Nissan Sunny)', '2024-10-08', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '03/10/2024', 'Paid', '9.5000', '2024-10-08', '10:45:23 am', 'Admin', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (56, 2, 2, 56, 'PU/2021/02/0056', 'Office drinkable water ', '2024-10-08', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.4900', NULL, '4.4900', '03/10/2024', 'Paid', '4.4900', '2024-10-08', '10:48:50 am', 'Admin', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (57, 2, 2, 57, 'PU/2021/02/0057', 'Workshop consumable', '2024-10-08', 'Received', 40, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.1000', NULL, '4.1000', '', 'Paid', '4.1000', '2024-10-08', '11:05:53 am', 'Admin', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (58, 2, 2, 58, 'PU/2021/02/0058', 'Petrol Purchase(Nissan Sunny)', '2024-10-20', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', 'purchase in the month of 20 October 2024.', 'Paid', '9.5000', '2024-10-20', '05:01:59 pm', 'Admin', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (59, 2, 2, 59, 'PU/2021/02/0059', 'Petrol Purchase(Nissan Sunny)', '2024-10-20', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', 'Purchase for the month 10 October 2024', 'Paid', '9.5000', '2024-10-20', '05:04:03 pm', 'Admin', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (60, 2, 2, 60, 'PU/2021/02/0060', 'Car Wash Nissan Sunny', '2024-10-20', 'Received', 37, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.5000', NULL, '1.5000', 'Washing was carried out 13/10/2024', 'Paid', '1.5000', '2024-10-20', '05:08:45 pm', 'Admin', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);


#
# TABLE STRUCTURE FOR: db_purchaseitems
#

DROP TABLE IF EXISTS `db_purchaseitems`;

CREATE TABLE `db_purchaseitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `purchase_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `purchase_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (24, 2, 11, 'Received', 79, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (25, 2, 10, 'Received', 78, '1.00', '50.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '50.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (27, 2, 9, 'Received', 77, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (28, 2, 8, 'Received', 76, '1.00', '20.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '20.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (30, 2, 7, 'Received', 75, '1.00', '0.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.0000', '0.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (31, 2, 6, 'Received', 74, '1.00', '20.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '20.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (33, 2, 5, 'Received', 73, '1.00', '0.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.0000', '0.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (35, 2, 4, 'Received', 72, '2.00', '0.0000', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.0000', '0.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (37, 2, 3, 'Received', 71, '20.00', '0.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.0000', '0.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (38, 2, 2, 'Received', 70, '1.00', '25.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '25.0000', '25.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (41, 2, 12, 'Received', 81, '1.00', '10.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '10.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (42, 2, 13, 'Received', 79, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (44, 2, 14, 'Received', 83, '1.00', '22.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '22.0000', '22.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (45, 2, 15, 'Received', 84, '1.00', '15.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '15.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (46, 2, 1, 'Received', 69, '1.00', '12.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '12.5000', '12.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (47, 2, 16, 'Received', 36, '1.00', '8.3000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.3000', '8.3000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (49, 2, 18, 'Received', 36, '1.00', '7.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '7.0000', '7.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (50, 2, 19, 'Received', 88, '1.00', '3.7400', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.7400', '3.7400', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (51, 2, 20, 'Received', 89, '1.00', '2.2900', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.2900', '2.2900', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (53, 2, 17, 'Received', 87, '1.00', '3.3000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.3000', '3.3000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (54, 2, 21, 'Received', 89, '1.00', '3.1000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.1000', '3.1000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (56, 2, 22, 'Received', 70, '1.00', '8.4950', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.4950', '8.4950', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (58, 2, 23, 'Received', 69, '1.00', '9.2000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.2000', '9.2000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (59, 2, 24, 'Received', 69, '1.00', '8.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.0000', '8.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (60, 2, 25, 'Received', 89, '1.00', '2.2900', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.2900', '2.2900', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (62, 2, 27, 'Received', 26, '10.00', '1.4070', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.4070', '14.0700', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (63, 2, 26, 'Received', 26, '10.00', '2.3000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.3000', '23.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (65, 2, 29, 'Received', 26, '8.00', '3.7500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.7500', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (66, 2, 28, 'Received', 26, '1.00', '16.9010', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '16.9010', '16.9010', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (67, 2, 30, 'Received', 91, '1.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '1.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (68, 2, 31, 'Received', 69, '1.00', '3.4000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.4000', '3.4000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (70, 2, 33, 'Received', 92, '2.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '1.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (72, 2, 34, 'Received', 89, '1.00', '3.2000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.2000', '3.2000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (93, 2, 37, 'Received', 98, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (94, 2, 37, 'Received', 99, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (95, 2, 37, 'Received', 100, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (96, 2, 37, 'Received', 101, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (97, 2, 37, 'Received', 102, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (98, 2, 36, 'Received', 93, '5.00', '0.6000', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (99, 2, 36, 'Received', 94, '5.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (100, 2, 36, 'Received', 95, '5.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (101, 2, 36, 'Received', 96, '5.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (102, 2, 36, 'Received', 97, '5.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (103, 2, 38, 'Received', 69, '1.00', '9.8000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.8000', '9.8000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (104, 2, 39, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (105, 2, 40, 'Received', 89, '1.00', '4.9550', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.9550', '4.9550', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (106, 2, 41, 'Received', 89, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (107, 2, 42, 'Received', 76, '1.00', '35.0980', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '35.0980', '35.0980', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (108, 2, 43, 'Received', 77, '1.00', '8.1250', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.1250', '8.1250', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (109, 2, 44, 'Received', 74, '1.00', '35.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '35.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (110, 2, 45, 'Received', 81, '1.00', '13.5300', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '13.5300', '13.5300', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (111, 2, 46, 'Received', 70, '1.00', '31.7650', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '31.7650', '31.7650', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (112, 2, 47, 'Received', 78, '1.00', '50.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '50.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (113, 2, 48, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (114, 2, 49, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (115, 2, 50, 'Received', 69, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (116, 2, 51, 'Received', 91, '1.00', '1.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.5000', '1.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (120, 2, 53, 'Received', 114, '1.00', '170.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '170.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (121, 2, 53, 'Received', 117, '22.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '13.2000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (124, 2, 52, 'Received', 114, '1.00', '140.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '140.0000', '140.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (125, 2, 52, 'Received', 117, '22.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '11.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (126, 2, 54, 'Received', 114, '1.00', '400.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '400.0000', '400.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (127, 2, 55, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (128, 2, 56, 'Received', 72, '1.00', '4.4900', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.4900', '4.4900', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (129, 2, 57, 'Received', 120, '1.00', '1.8000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.8000', '1.8000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (130, 2, 57, 'Received', 121, '1.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '0.6000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (131, 2, 57, 'Received', 122, '1.00', '0.9000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.9000', '0.9000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (132, 2, 57, 'Received', 123, '1.00', '0.8000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.8000', '0.8000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (133, 2, 58, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (134, 2, 59, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (135, 2, 60, 'Received', 91, '1.00', '1.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.5000', '1.5000', NULL, NULL, 1, '');


#
# TABLE STRUCTURE FOR: db_purchaseitemsreturn
#

DROP TABLE IF EXISTS `db_purchaseitemsreturn`;

CREATE TABLE `db_purchaseitemsreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_id` int DEFAULT NULL,
  `return_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `purchase_id` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepayments
#

DROP TABLE IF EXISTS `db_purchasepayments`;

CREATE TABLE `db_purchasepayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  KEY `supplier_id` (`supplier_id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (1, 1, 'PP/2021/02/0001', 2, 11, '2024-08-08', 'Cash', '5.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:15:36', '2024-08-08', 'Admin', 1, NULL, 13, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (2, 2, 'PP/2021/02/0002', 2, 10, '2024-08-08', 'Bank Transfer', '50.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:18:00', '2024-08-08', 'Admin', 1, NULL, 12, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (3, 3, 'PP/2021/02/0003', 2, 8, '2024-08-08', 'Bank Transfer', '20.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:26:06', '2024-08-08', 'Admin', 1, NULL, 10, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (4, 4, 'PP/2021/02/0004', 2, 9, '2024-08-08', 'Bank Transfer', '5.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:26:25', '2024-08-08', 'Admin', 1, NULL, 11, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (5, 5, 'PP/2021/02/0005', 2, 6, '2024-08-08', 'Bank Transfer', '20.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:28:04', '2024-08-08', 'Admin', 1, NULL, 8, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (6, 6, 'PP/2021/02/0006', 2, 2, '2024-08-08', 'Bank Transfer', '25.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:32:36', '2024-08-08', 'Admin', 1, NULL, 4, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (7, 7, 'PP/2021/02/0007', 2, 12, '2024-08-08', 'Bank Transfer', '10.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:44:07', '2024-08-08', 'Admin', 1, NULL, 15, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (8, 8, 'PP/2021/02/0008', 2, 13, '2024-08-08', 'Bank Transfer', '5.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:48:14', '2024-08-08', 'Admin', 1, NULL, 13, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (9, 9, 'PP/2021/02/0009', 2, 14, '2024-08-08', 'Cash', '22.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '12:19:33', '2024-08-08', 'Admin', 1, NULL, 16, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (10, 10, 'PP/2021/02/0010', 2, 15, '2024-08-08', 'Cash', '15.0000', '', '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', '05:13:37', '2024-08-08', 'Admin', 1, NULL, 12, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (11, 11, 'PP/2021/02/0011', 2, 1, '2024-08-08', 'Cash', '12.5000', 'company vehicle petrol purchase between the periods below:\n01-08-2024(5.5 rial)\n05-08-2024(7.5 rial)\nTotal 12.500 rial\n', '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', '05:20:50', '2024-08-08', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (12, 12, 'PP/2021/02/0012', 2, 16, '2024-08-19', 'Cash', '8.3000', '', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '08:03:23', '2024-08-19', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (13, 13, 'PP/2021/02/0013', 2, 17, '2024-08-19', 'Cash', '3.3000', '', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '08:43:33', '2024-08-19', 'Admin', 1, NULL, 18, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (14, 14, 'PP/2021/02/0014', 2, 18, '2024-08-20', 'Cash', '7.0000', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '09:29:59', '2024-08-20', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (15, 15, 'PP/2021/02/0015', 2, 19, '2024-08-20', 'Cash', '3.7400', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '09:54:05', '2024-08-20', 'Admin', 1, NULL, 20, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (16, 16, 'PP/2021/02/0016', 2, 20, '2024-08-20', 'Cash', '2.2900', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '10:06:43', '2024-08-20', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (17, 17, 'PP/2021/02/0017', 2, 21, '2024-08-20', 'Cash', '3.1000', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '10:21:58', '2024-08-20', 'Admin', 1, NULL, 18, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (18, 18, 'PP/2021/02/0018', 2, 22, '2024-08-20', 'Cash', '8.4950', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '11:50:39', '2024-08-20', 'Admin', 1, NULL, 4, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (19, 19, 'PP/2021/02/0019', 2, 29, '2024-08-26', 'Cash', '30.0000', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:38:50', '2024-08-26', 'Admin', 1, NULL, 24, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (20, 20, 'PP/2021/02/0020', 2, 28, '2024-08-26', 'Cash', '16.9010', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:41:10', '2024-08-26', 'Admin', 1, NULL, 23, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (21, 21, 'PP/2021/02/0021', 2, 27, '2024-08-26', 'Cash', '14.0700', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:41:41', '2024-08-26', 'Admin', 1, NULL, 22, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (22, 22, 'PP/2021/02/0022', 2, 26, '2024-08-26', 'Cash', '23.0000', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:41:49', '2024-08-26', 'Admin', 1, NULL, 22, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (23, 23, 'PP/2021/02/0023', 2, 25, '2024-08-26', 'Cash', '2.2900', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:41:55', '2024-08-26', 'Admin', 1, NULL, 18, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (24, 24, 'PP/2021/02/0024', 2, 24, '2024-08-26', 'Cash', '8.0000', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:42:20', '2024-08-26', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (25, 25, 'PP/2021/02/0025', 2, 23, '2024-08-26', 'Cash', '9.2000', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:42:29', '2024-08-26', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (26, 26, 'PP/2021/02/0026', 2, 30, '2024-08-29', 'Cash', '1.0000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '09:46:47', '2024-08-29', 'Admin', 1, NULL, 26, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (27, 27, 'PP/2021/02/0027', 2, 31, '2024-08-29', 'Cash', '3.4000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '09:49:20', '2024-08-29', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (29, 29, 'PP/2021/02/0029', 2, 33, '2024-08-29', 'Cash', '1.0000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '10:04:54', '2024-08-29', 'Admin', 1, NULL, 27, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (30, 30, 'PP/2021/02/0030', 2, 34, '2024-08-29', 'Cash', '3.2000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '10:10:39', '2024-08-29', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (31, 31, 'PP/2021/02/0031', 2, 36, '2024-08-29', 'Cash', '15.0000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '12:16:19', '2024-08-29', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (32, 32, 'PP/2021/02/0032', 2, 37, '2024-08-29', 'Cash', '12.5000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '12:38:00', '2024-08-29', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (33, 33, 'PP/2021/02/0033', 2, 41, '2024-09-16', 'Cash', '5.0000', '', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', '11:12:26', '2024-09-16', 'Admin', 1, NULL, 29, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (34, 34, 'PP/2021/02/0034', 2, 40, '2024-09-16', 'Cash', '4.9550', '', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', '11:12:34', '2024-09-16', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (35, 35, 'PP/2021/02/0035', 2, 39, '2024-09-16', 'Cash', '9.5000', '', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', '11:12:44', '2024-09-16', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (36, 36, 'PP/2021/02/0036', 2, 38, '2024-09-16', 'Cash', '9.8000', '', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', '11:12:55', '2024-09-16', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (37, 37, 'PP/2021/02/0037', 2, 42, '2024-09-18', 'Visa', '35.0980', '', '5.37.112.133', '5.37.112.133', '05:09:36', '2024-09-18', 'Admin', 1, NULL, 30, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (38, 38, 'PP/2021/02/0038', 2, 43, '2024-09-18', 'Visa', '8.1250', '', '5.37.112.133', '5.37.112.133', '05:14:37', '2024-09-18', 'Admin', 1, NULL, 33, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (39, 39, 'PP/2021/02/0039', 2, 44, '2024-09-18', 'Visa', '35.0000', '', '5.37.112.133', '5.37.112.133', '05:17:08', '2024-09-18', 'Admin', 1, NULL, 34, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (40, 40, 'PP/2021/02/0040', 2, 45, '2024-09-18', 'Visa', '13.5300', '', '5.37.112.133', '5.37.112.133', '05:27:52', '2024-09-18', 'Admin', 1, NULL, 35, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (41, 41, 'PP/2021/02/0041', 2, 46, '2024-09-18', 'Visa', '31.7650', '', '5.37.112.133', '5.37.112.133', '05:28:02', '2024-09-18', 'Admin', 1, NULL, 4, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (42, 42, 'PP/2021/02/0042', 2, 47, '2024-09-18', 'Visa', '50.0000', '', '5.37.112.133', '5.37.112.133', '05:32:44', '2024-09-18', 'Admin', 1, NULL, 36, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (43, 43, 'PP/2021/02/0043', 2, 54, '2024-09-30', 'Visa', '400.0000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '11:56:00', '2024-09-30', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (44, 44, 'PP/2021/02/0044', 2, 53, '2024-09-30', 'Bank Transfer', '183.2000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:05:41', '2024-09-30', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (45, 45, 'PP/2021/02/0045', 2, 52, '2024-09-30', 'Bank Transfer', '151.0000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:06:01', '2024-09-30', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (46, 46, 'PP/2021/02/0046', 2, 51, '2024-09-30', 'Cash', '1.5000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:07:19', '2024-09-30', 'Admin', 1, NULL, 37, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (47, 47, 'PP/2021/02/0047', 2, 50, '2024-09-30', 'Visa', '5.0000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:07:33', '2024-09-30', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (48, 48, 'PP/2021/02/0048', 2, 49, '2024-09-30', 'Visa', '9.5000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:07:59', '2024-09-30', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (49, 49, 'PP/2021/02/0049', 2, 48, '2024-09-30', 'Visa', '9.5000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:08:12', '2024-09-30', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (50, 50, 'PP/2021/02/0050', 2, 57, '2024-10-08', 'Bank Transfer', '4.1000', '', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '11:09:10', '2024-10-08', 'Admin', 1, NULL, 40, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (51, 51, 'PP/2021/02/0051', 2, 56, '2024-10-08', 'Bank Transfer', '4.4900', '', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '11:09:23', '2024-10-08', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (52, 52, 'PP/2021/02/0052', 2, 55, '2024-10-08', 'Bank Transfer', '9.5000', '', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '11:09:34', '2024-10-08', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (53, 53, 'PP/2021/02/0053', 2, 60, '2024-10-20', 'Cash', '1.5000', '', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', '05:09:38', '2024-10-20', 'Admin', 1, NULL, 37, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (54, 54, 'PP/2021/02/0054', 2, 59, '2024-10-20', 'Visa', '9.5000', '', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', '05:10:17', '2024-10-20', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (55, 55, 'PP/2021/02/0055', 2, 58, '2024-10-20', 'Visa', '9.5000', '', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', '05:10:35', '2024-10-20', 'Admin', 1, NULL, 19, NULL);


#
# TABLE STRUCTURE FOR: db_purchasepaymentsreturn
#

DROP TABLE IF EXISTS `db_purchasepaymentsreturn`;

CREATE TABLE `db_purchasepaymentsreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `supplier_id` (`supplier_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasereturn
#

DROP TABLE IF EXISTS `db_purchasereturn`;

CREATE TABLE `db_purchasereturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Purchase Return Code',
  `warehouse_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotation
#

DROP TABLE IF EXISTS `db_quotation`;

CREATE TABLE `db_quotation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create quotation Code',
  `quotation_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `quotation_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `quotation_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `quotation_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'quotation return raised',
  `customer_previous_due` double(20,4) DEFAULT NULL,
  `customer_total_due` double(20,4) DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_quotation` (`id`, `store_id`, `warehouse_id`, `count_id`, `quotation_code`, `reference_no`, `quotation_date`, `expire_date`, `quotation_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `quotation_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `sales_status`) VALUES (1, 2, 2, 1, 'QT/2021/02/0001', '', '2024-07-18', NULL, 'Quotation', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '23.2500', NULL, '23.2500', 'Oil and filter service and full inspection ', NULL, NULL, '2024-07-18', '05:00:27 pm', 'Admin', '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: db_quotationitems
#

DROP TABLE IF EXISTS `db_quotationitems`;

CREATE TABLE `db_quotationitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `quotation_id` int DEFAULT NULL,
  `quotation_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `quotation_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `seller_points` double(20,4) DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `quotation_id` (`quotation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_quotationitems` (`id`, `store_id`, `quotation_id`, `quotation_status`, `item_id`, `description`, `quotation_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (7, 2, 1, 'Quotation', 3, '', '4.50', '3.5000', 'Inclusive', 151, NULL, 'Percentage', NULL, '0.0000', '3.5000', '15.7500', 1, '0.0000');
INSERT INTO `db_quotationitems` (`id`, `store_id`, `quotation_id`, `quotation_status`, `item_id`, `description`, `quotation_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (8, 2, 1, 'Quotation', 7, '', '1.00', '2.5000', 'Inclusive', 151, NULL, 'Percentage', NULL, '0.0000', '2.5000', '2.5000', 1, '0.0000');
INSERT INTO `db_quotationitems` (`id`, `store_id`, `quotation_id`, `quotation_status`, `item_id`, `description`, `quotation_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (9, 2, 1, 'Quotation', 13, '', '1.00', '5.0000', 'Inclusive', 151, NULL, 'Percentage', NULL, '0.0000', '5.0000', '5.0000', 1, '0.0000');


#
# TABLE STRUCTURE FOR: db_roles
#

DROP TABLE IF EXISTS `db_roles`;

CREATE TABLE `db_roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `role_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (1, 1, 'Admin', 'All Rights Permitted.', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (2, 1, 'Store Admin', 'Note: Apply this role for New Store Admin. ', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (3, 2, 'sales', '', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (4, 2, 'Manager', '', 1);


#
# TABLE STRUCTURE FOR: db_sales
#

DROP TABLE IF EXISTS `db_sales`;

CREATE TABLE `db_sales` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `init_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `count_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'Use to create Sales Code',
  `sales_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'sales return raised',
  `customer_previous_due` double(20,2) DEFAULT NULL,
  `customer_total_due` double(20,2) DEFAULT NULL,
  `quotation_id` int DEFAULT NULL,
  `vehicle_reg` varchar(50) COLLATE utf8mb3_unicode_ci NOT NULL,
  `vehicle_chassis` varchar(50) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vehicle_model` varchar(50) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vehicle_make` varchar(100) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vehicle_year` int DEFAULT NULL,
  `next_service_date` date DEFAULT NULL,
  `brake_condition` varchar(100) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tires_condition` text COLLATE utf8mb3_unicode_ci,
  `engine_oil` text COLLATE utf8mb3_unicode_ci,
  `odo_meter` varchar(20) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `picture_gallary` text COLLATE utf8mb3_unicode_ci,
  `brake_fluid_level` text COLLATE utf8mb3_unicode_ci,
  `gear_oil` text COLLATE utf8mb3_unicode_ci,
  `signature` text COLLATE utf8mb3_unicode_ci,
  `inspection_image` text COLLATE utf8mb3_unicode_ci,
  `inspection_data` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (19, 2, 2, 'GMC/YUKON', '001', 'GMC/YUKON001', '', '2024-08-01', NULL, 'Final', 10, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '40.50', NULL, '40.5000', 'Need to change transmission oil \r\nBrake-fluid change next service .', 'Paid', '40.5000', '2024-08-01', '09:19:00 am', 'Admin', '5.36.125.87', '5.36.125.87.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '6662H', 'NA', 'YUKON', 'GMC', 2015, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (20, 2, 2, 'Nissan/Patrol', '001', 'Nissan/Patrol001', '', '2024-08-01', NULL, 'Final', 11, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.00', NULL, '10.0000', '', 'Paid', '10.0000', '2024-08-01', '12:07:51 pm', 'Admin', '5.36.125.87', '5.36.125.87.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '1681B', 'NA', 'Patrol', 'Nissan', 2013, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (21, 2, 2, 'Chevrolet', '001', 'Chevrolet001', '', '2024-08-01', NULL, 'Final', 12, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.00', NULL, '10.0000', 'Computer scan report attach', 'Paid', '10.0000', '2024-08-01', '08:47:35 pm', 'Admin', '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '31498Y', 'NA', 'Tahoe', 'Chevrolet', 2016, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (22, 2, 2, 'Nissan Patrol', '001', 'Nissan Patrol001', '', '2024-08-01', NULL, 'Final', 13, NULL, NULL, NULL, '35.71', 'in_percentage', '10.00', '28.00', NULL, '18.0010', '', 'Partial', '18.0000', '2024-08-01', '08:58:13 pm', 'Admin', '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '920B', '', 'Patrol', 'Nissan ', 2016, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (23, 2, 2, 'Dodge/Ram', '001', 'Dodge/Ram001', '', '2024-08-01', NULL, 'Final', 14, NULL, NULL, NULL, '14.65', 'in_percentage', '5.49', '37.50', NULL, '32.0060', '', 'Paid', '32.0060', '2024-08-01', '09:35:58 pm', 'Admin', '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '78239w', '', 'Ram', 'Dodge', 0, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (24, 2, 2, 'Hyundai', '001', 'Hyundai001', '', '2024-08-04', NULL, 'Final', 15, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.00', NULL, '10.0000', '', 'Paid', '10.0000', '2024-08-04', '10:34:30 am', 'Admin', '5.36.140.145', '5.36.140.145.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, 'NA', '', 'Sonata', 'Hyundai ', 2014, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (25, 2, 2, 'Toyota/Camry', '001', 'Toyota/Camry001', '', '2024-08-04', NULL, 'Final', 16, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-04', '12:17:58 pm', 'Admin', '5.36.140.145', '5.36.140.145.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '26269B', 'NA', 'Camry', 'Toyota ', 2019, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (27, 2, 2, 'Porsche cayenne ', '001', 'Porsche cayenne 001', '', '2024-08-05', NULL, 'Final', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '59.00', NULL, '59.0020', 'Need change spark plugs\r\nNeed change air filter', 'Partial', '59.0000', '2024-08-05', '12:42:28 pm', 'Admin', '5.36.220.161', '5.36.220.161.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '659 S', '', 'Cayenne gts', 'Porsche ', 2013, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (28, 2, 2, 'Mercedes E', '350', 'Mercedes E350', '', '2024-08-05', NULL, 'Final', 18, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '47.00', NULL, '47.0000', ' Need change air Filter, front and rear brake pads, steblizer bush, engine belt, \r\n', 'Paid', '47.0000', '2024-08-05', '12:57:43 pm', 'Admin', '5.36.220.161', '5.36.220.161.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '9373AS', '', 'E 350', 'Mercedes ', 2011, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (29, 2, 2, NULL, '29', 'SL/ECS/0029', NULL, '2024-08-06', NULL, 'Final', 19, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '28.00', '0.00', '28.0000', '', 'Paid', '28.0000', '2024-08-06', '06:36:08 pm', 'Admin', '5.36.231.215', '5.36.231.215.dynamic-dsl-ip.omantel.net.om', NULL, 1, 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (30, 2, 2, 'Toyota/Camry', '001', 'Toyota/Camry001', '', '2024-08-07', NULL, 'Final', 20, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', 'Findings: engine oil pump and drive belt. ', 'Paid', '5.0000', '2024-08-07', '05:56:43 pm', 'Admin', '5.36.168.17', '5.36.168.17.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '65843', 'NA', 'Camry', 'Toyota', 2015, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', 'iVBORw0KGgoAAAANSUhEUgAAAlgAAAEsCAYAAAAfPc2WAAAAAXNSR0IArs4c6QAADuZJREFUeF7t1jERAAAIAzHq3zQmfgwCOuQYfucIECBAgAABAgRSgaVrxggQIECAAAECBE5geQICBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAIEHgNkBLevR78cAAAAASUVORK5CYII=', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (31, 2, 2, 'Old oil', '001', 'Old oil001', 'NA', '2024-08-08', NULL, 'Final', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '22.00', NULL, '22.0000', '', 'Paid', '22.0000', '2024-08-08', '12:01:30 pm', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, 'NA', 'NA', 'NA', 'NA', 0, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (32, 2, 2, 'Mazda', '006', 'Mazda006', 'Oil Service', '2024-08-08', NULL, 'Final', 22, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '23.00', NULL, '23.0000', '', 'Paid', '23.0000', '2024-08-08', '05:59:02 pm', 'Admin', '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '1347S', '1k1312450', '6', 'Mazda', 2018, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (33, 2, 2, 'Lexus/RX', '350', 'Lexus/RX350', 'OIL SERVICE', '2024-08-10', NULL, 'Final', 23, NULL, NULL, NULL, '8.40', 'in_percentage', '2.75', '32.75', NULL, '30.0000', 'Need to check condition of engine head gasket for leak . Next Service.', 'Paid', '30.0000', '2024-08-10', '07:33:20 pm', 'Admin', '5.36.117.222', '5.36.117.222.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '8628AB', '', 'RX350', 'LEXUS', 2017, NULL, '', '', '', '140657KM', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (34, 2, 2, 'Toyot', '01', 'Toyot01', 'FRONT BRAKEPAD REPLACEMENT', '2024-08-11', NULL, 'Final', 24, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '7.00', NULL, '7.0000', '', 'Paid', '7.0000', '2024-08-11', '10:55:15 am', 'Admin', '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, 'NA', 'NA', 'CAMRY', 'TOYOTA', 2017, NULL, '', '', '', 'NA', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (35, 2, 2, 'Toyot', '001', 'Toyot001', 'SERVICE CHECK', '2024-08-11', NULL, 'Final', 25, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.00', NULL, '10.0000', '', 'Paid', '10.0000', '2024-08-11', '11:00:51 am', 'Admin', '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, 'NA', 'NA', 'CAMRY', 'TOYOTA ', 2017, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (36, 2, 2, 'LEXUS/ES', '350', 'LEXUS/ES350', 'SERVICE REQUEST ON REPAIR ORDER 001', '2024-08-11', NULL, 'Final', 10, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '30.00', NULL, '30.0000', '', 'Paid', '30.0000', '2024-08-11', '11:20:14 am', 'Admin', '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, 'NA', 'NA', 'ES350', 'LEXUS', 2017, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (38, 2, 2, NULL, '38', 'SL/ECS/0038', NULL, '2024-08-11', NULL, 'Final', 28, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2024-08-11', '12:45:36 pm', 'Admin', '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', NULL, 1, 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (39, 2, 2, 'Mazda CX', '5', 'Mazda CX5', 'Brakepad Service ', '2024-08-11', NULL, 'Final', 29, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '15.00', NULL, '15.0000', '', 'Paid', '15.0000', '2024-08-11', '07:12:01 pm', 'Admin', '5.37.228.140', '5.37.228.140.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '57585A', 'NA', 'CX-5', 'Mazda', 2017, NULL, '', '', '', '262461KM', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (41, 2, 2, 'Dodge Charger', '01', 'Dodge Charger01', 'Computer Scan/Mechanic Inspection Check', '2024-08-12', NULL, 'Final', 30, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.00', NULL, '10.0000', '', 'Paid', '10.0000', '2024-08-12', '06:18:40 pm', 'Admin', '5.36.199.26', '5.36.199.26.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '31592 M', 'NA', 'Charger', 'Dodge', 2019, NULL, '', '', '', '149114KM', '', '', '', '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', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (42, 2, 2, NULL, '42', 'SL/ECS/0042', NULL, '2024-08-14', NULL, 'Final', 31, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2024-08-14', '06:10:38 pm', 'Admin', '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', NULL, 1, 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (43, 2, 2, 'MERCEDES', '43', 'MERCEDES43', 'OIL SERVICE', '2024-08-14', NULL, 'Final', 32, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '43.00', NULL, '43.0000', '', 'Paid', '43.0000', '2024-08-14', '08:33:12 pm', 'Admin', '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '87196R', 'NA', 'GLC43', 'MERCEDES ', 2014, NULL, '', '', '', '10200KM', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAAEndJREFUeF7tnU+2JUURxosVCDuAHcAKxBVwHDICVgCuQJ05A1eArsCxI3GmI3EF6MxZ4wr0ff1u0Nn1MjIj/1ZG1nfP6QPdN6sq64vI342MjMp65+CHClABKuBEgXec9JPdpAJUgAocBBadgApQATcKEFhuTMWOUgEqQGDRB6gAFXCjAIHlxlTsKBWgAgQWfYAKUAE3ChBYbkzFjlIBKkBg0QeoABVwowCB5cZU7CgVoAIEFn2AClABNwoQWG5MxY5SASpAYNEHqAAVcKMAgeXGVOwoFaACBBZ9gApQATcKEFhuTMWOUgEqQGDRB6gAFXCjAIHlxlTsKBWgAgQWfYAKUAE3ChBYbkzFjlIBKkBg0QeoABVwowCB5cZU7CgVoAIEFn2AClABNwoQWG+b6jePv/78OI6Pn/58dxzHbx//dWNUdpQK7KoAgfVsWYDq1xkj//XRDhDjhwpQgQsUILCO4w/HcXxWoD0iLonECg5jUypABVoVILCO49VxHO8WCkndCgVjcyrQQ4G7Dzzkqf5SISSjrArReAgVaFWAwKoDFnS/u3atvmc9Hj8q58/53ySvyPyiVVWn7e4+6CzJds20jLL6O72ASBZAYrCyXFXAhYUSfPB3wsyi3OJtCCx9dfBHQ27r7vq1ujeA1Aqnkj4AWoRYiWKLtb37gEvlsODYqMdKfRhllTu0QKo2eiq/Yv4Igiyv0RIt7g4sGOF/iiX+dRzHHzP1WXD0XyxhybU7MQJSMsUbCb4QZCxlWcDHCKzj+OE4jvcjtgCwPkgATQ6hhrojt4IKwIBtEO2iXk7yUbEr4lofPr74/pSzwnch2HJFwrmoGt8TYBcAjINNr3KX6V4uMU8NXzpuDagkYoLuKTD1HCYCnVqASQRGePW0SuJcHGx5YOVqtTAl5ArUs5Pl4B66YgioFfSTKIzwmgSfmssQWM9ThVjxaJhQ1/Jc0JzAsoNKHiafFUHVjAkcI/CSh+BLz8PIq1QxY3sC61moGJCswLqzhpaIygukUkOmZeqIXOgXE6e5xqHvs9mdB1toMQKr3H9zsMIK6+flp13+iBZ4cbuiRvMSWHqEJauEaKGtJN51SpjS4061aYRXI4BKDyewnhXTdmwQfZDj0up97pbD0rS4e01aLbwYdRVQi8B6FkuLGESf1PTnLhFFqlQBdU8fFfjd7k3hL9hjLVbfp9275LpWWDFd1j4E1rNpNCBJ9ERg6U8E3HVabB3UtTVp3Jo7ojCBlQaWpXj0DhFWakp8h/u3winVrhZcfPQrUJXAsgErVTy6e+4G96c9BH63/F0PcOEcpfCizg/lCaxnIVJAEo204tGdgZWCFSOrdnzB77415rp29jOzkgTWG6k0IOVWCnd1pBTECSvzEDM1/Oo4jk8SK9HhSX71tE/bN6azbtiIwMoDK5fH2hVYGsCxc8LILV02HGZFt5QryJWT3fJHg8B640uao0jFtvb9jsBKJdlv/QtfhJ62xikb3BZaBFYeWNgq+b1Enms3YLGEow00PY/O7RRyO3ARWG/cK5d4t+zq0NNZrzjXnVdDr9Dbes1/BJsTasfcYopIYL1tfq3iXZaVY3mdnZacU9MQ+ooVL2PaWd5Qvj206IRvO5cWYaSAtUtOJxVd7QTlMTiZd9ZcUn5rWxFYNmBJnioWge3iIFp0tf2v9jzWdLtSClq75VTfEo3AeulD2sCFVrHvdgCWFl1t7fzd8HHNiVLQ2sEno6oSWC9l0QYvpn6x4r4dnEOD9A73dg1O5lz1dk9fEFhxx9KS63hBwblo0vugvsPq5xx8zL/K7aIsAivuZLFlZO3Fnd5zPLHoilPB+fCpveKtoiwCK+4mqZzOOcLyDKzcqmjtIOJx8xRIRVnbje/tbqijn1gejcDlPAOL0VVHh7nwVLEoK3wnwYVd63tpAkvX0/pYhNe3w2j3R5/oO8ZmnC0GrC0fUqdzpt0p9QJVOdIrsGKV056jxRlgWPEat/rhIbDSLmh5hstrgvoMY3nIe8VByT7pCsRyWF59MmtnAistETZW+zqjokfniP0qey/PyDr7hg20hPu2kTKBlffi3LTQI7DOyXaP95C33L4t8EP6ZWJr5W3H9bY31tFXcw+behvsjK46OsfkU8EX8UIQbcfX7V/KSmDZPC4VZXkLv2OlDPQDmx9c0cr6hh1vP5xVWtJRbbKloixvq4QEls3mV7eyggr99PajWa0tgWWTLgUsb/Uu52hxywJDm1mXaIV81PePaZ68/9H6kg+s7P7y6djbvN6ewLL7rDYt9BRhxfJXLGew+0CvliXRU+ya2+eqNKEJLLsLalvUegcWIyy7D5S2DCMl7PSBjzV6IqgiChBYdhfcYb/zWxUZ2k3bvWXJG50tF79tRHUWh8CyuMtzmxSwvCQ9Y/fgpe92S81vCUDhT6rkoLRXkpeCfW6To8qJRGDlFHrzfW73Bg9aElh2e8daAkofPr0q/t0HnHpM8d5/XAipBQETAaXYycMga3OxfkfnKt49vD2HwHrpD2FOSf5fVutagSRXEwBhRZlQahiTBJZNPMtWMx4K9+4CrHNiexSIQu+JQQnfM1qyjTFTKwLLJNPr/AQGe+6z+gPEsaS7p1VCLRrCFA1/ZHqVs1PL99ALpSCIqM8RVMt5eaxBAQLLINJTk9zzhKHjAlqrfrTSjKv8IATQ5w/gnKfeLWUALXYIk94EU4uSHY+9ylE73sKUU8WmUviVxa/6+bNylIVBGOZnpO8j+jwjN9RqfOaWWhWcfDyBZRM8Biw8ToEVo/Nn5VxWySu9tDyQ3G8MfFdFQ6ENwpwRktyx6Ih5JZvfL9eKwLKZpOQ9hTjjiIjF1tN0Kw1YyMvgzwrAwR2cgaKBh1O1Hl7h6BwEls1YMWBBuxQAPrCdulsrgQ3+iwEvj4LgAjNAhGsi6Y16ohh0tH/rJgBPtL8CBFbexjEohdM+raC0Z13WOR/Uu04or8JLCElNEadXVvXYrlkBAisvYQxY4ZRPi7JKc1mxKupZ0VGoAuuJ8j7BFhcpQGDlhY+9Oeesm7b6FrbToqQZ07Uw14NpW6xeadW8W95CbHEbBQisvKlfncoX/nMcx6eRvNBnERDMTGbjWiizwOqlJKm1x0BiOTk+BJ33Bba4WAEC69kAYcIafy/d+XG0Gc9L9eHfa3JIBNZoi/H8QxS4C7BWyQ+djXgGEaZqqEbHpwZEVifRKvfv4g9WndhuMQV2dFDZm0gipZk5Is28fz6O43cTQGR1L22hgHksq4Jsd4kCuwALEQM+Ye3RaEG1xzq8wOAuOzeM9gOef6ICnoEFMOCBWSS7Z31QW4Wkdm66Zlk1nNVn7TrcLvlqC/D6xQp4A5ZM93pHUrFo6U+Rh5tLpkyxxHZpbVaxQQsP0Cr4C0/D5lRgjgJegNU65QMo5F7lXFBYi5R6bMOiJbZXKh+I9bFnhf4cL+ZVbqOAB2BZ96IKjQYoCJBy07eYsWPFojUb3XmA1jnKwpT3o9uMAN6oKwVWBRamfhjssS1MNIEFUmEEVWMMLWle+/5BbS/4VbT/IVLwWjL1rdGYx1CBKgVWGTTSecAC+SlLKQIip38/BpulvVWg3jVKq0dZuYe7rbqxHRUYrsAqwLKCqlcUlRJ2RBW4FmWtks+KlTgwyho+/HiBUgWuBtZKoIJ2o6KhVB7uahvgvr3UjpX6N9tvpsBVg8UKKshdmzsqNdUoWEk/PEZZ6DsjrVJPYvthClwBLOuqH3JUM1/TPRooqfteYWqoRVlcNRw2/LY98XkrJbnR1of2f6pNmqWcFVazB7BWd9W7H6tPDWPlHIyyZo0Of9cJwfT1YwEs9iap1J0VvbloZoSlbSV8vpnekMi5wWyIaJFcTZ1X7t5Kv//qOA44XuzDqWGpmvu1F0DFngLpfbeI7P/52L3kp8hsBrCs+arZU8BUsnlk7iwFyBWqzFefuvYeGDxfWgEZvzJertLrNR9GAyv1ix3e+FXP2GlR3+i8zeyortTJUtEwdjPtWfdW2je2H6uAAApTu9h7N8dePXP2kcBaNV8lkqT6N2P6MzrJ3+JYWgJezjl72t5yLzw2H0HB3niqZPkfolHAWh1WqQE5A1ZwodXzRTkbElp+UWhN07TeYeqFuD8+dkMp2o58FLC06CEUYBYYYqJrU57Zg1CDwlVT5LNWOWhdkXdsHUR3Pb4VUrC1vNxE3ryEhSLZ0lt0xTTSsmdczA7o47fKW51etx8BrJyT460z2DIYN6u91WWkU60GCQ2eVwL9nF/MPYQ+G/Qj/WOXc8vecbG3OVnv8aofJG0DzO7AysHKIlRsOxiQXaguuzHUbBuzwlTwrIHWpxXKHKSvWp1aeC+ElsW7x7bpsaJ3FaS0iOutzRB6R1gqGcfa6cVGfGHoiktj8OOj/dqUDLYRiUnUPsVWZFYocxDTWX6MSnQc7BK3OD3yoLJFeMuKnkAKotUEAjPEfu1/vYGl5a5EhBGDfYZYK16j1LEQoQLkAm+5p9h5tHPnVg/lnATXWI9pzUcJmGY++tZDkY97AstScHjelI8A62HGeecAyGAzQC/2uvuwJ/LW69reSZRsOT4H79z3lmus0KYVVLDJFwtHUZrGwomuEZYGLEuhoXRIAxiSvhggKGaD6FgSPX9wbCyS0wYX/h07QcQ+OA/eyHOORs7JZwJ3hWHc3gcL0M4AhT+GC0epiLWlhy2QWmmqdx4rUvsl2mBsQ1OMbegaHVs9I6xVtwKOgXR02UANyHBMLMeGVdVPWzy+4FiJoFKHyA8DgI7PzNesFdzKck1TUJQfdYwh/P8nlQ8Sy2DHzcd+1FOipCJaWfCK5ahrfL3aOKOBdXUuIwYrGPK9asXGHxgD/yolDtrdWxLy4XQk9msbOzciWgykXFkFjp06cMa7Aa8QU6AXsLSq7SuBNXpDvlEeFUtsr1TikLpvC7iu9Akr2CSKTEFQcnnntIGmzxm6MgVC+9ItWUb53vLn7QUsbR+lq5blZ+1vNcrAq1Ti196fBVwr1fvU3mfpcTX5KMwI/n4cx98eFwvBd7uosgewVivGXH0nBIuTpzS9OkKx9F/aWMAl+RbsfQSISWFwyXVWbfvT6lbFlLUG6NapdqhXarqN8+Exm5Yar6622Q1Yuwx0GDn2vkAx/uhFg65O9oAQKpatnxlvR7L2pbRdC6RwrRpQlfaxpX1qRV9yjuH50f5nvaDXA1ipvZN6nN8qbgpWltIK63VmtUvdj/Rh9WT82XGt75w8a4xf+f8+/hED+opnUFN2h63w58vKfNTqkOrl86JT+MNbcu7vegAlBaxZAyr3rJunaVRoQMu20t7urSaPk3NqDPhwWX4E0LQ6oto80ko1Ujl9l/neO7DgLLn9pb0N6HNUAmjlPh7vEbbTnqHM3W/p9wKwM9Sk7iwsOA5r0RARSg1S6TVj7QmpRhVHA2vkQLIkdEdev1F68+GWKAsnmxXNmjte0FAS7SV5roLTX9r0LtO9KSJ7BJZ1SrEDrOAEllyWx5yW5uA7wEuKZHGPlsd+pgz2HS7iDViWqAp22QVW4mPWKMt7pBUbUwC2QKzbalPHwStAkpVNAqqjuOdT9QBWKuHd6zXz1qhqxwFbGmV5K3loce/zqlPs4fQUQOD/510lzueQFWZpF56PcGqxXsWxPYAVeyBSutLjkRJrVIWlb1TW7+pEJVHWnaBV4fY8xKsCPYCVirBa3u9XElXtNgXUpkaWFUM5ltDyOirZb1WBHsBKJYVrB02urioclN52TWxxR2u0Kddo+cFo6SePpQJDFOgBLHQs9VqvkkED+CVf8xOocIeoKmb0Umh5LncY4vQ8qV8FegHLkl85r6LUFuWxruU4LHqLV3p8LMnviGLPhyrQC1gltUK1N0RQva2c5WW1OKLHwketzXgcFeiqQC9goVOlUxXrjRBUcaVKfiR62tlqN7ajAt0V6O3IPaHVq4aru2gLndAKLU4LFzIau1KvQG9gtUZa8tT9Tpu41VvHdqQVWlft/mq7C7aiAgYFRgALl7WWJUgXkWf5/dNeQt8Y+swmcQVSBbw4YvWXb9CuVCCrwChgyYXxcgqUNcieQeFjD5imhJuxZTvLBiYFdtgi2nSjbHQ/BUYD636KrnHHryI7XzKPtYZt2IsGBQisBvEWPhSRLerc5PVRnA4ubCx2za4AgWXXymNLgAsf5gY9Wo99fqEAgUWnoAJUwI0CBJYbU7GjVIAKEFj0ASpABdwoQGC5MRU7SgWoAIFFH6ACVMCNAgSWG1Oxo1SAChBY9AEqQAXcKEBguTEVO0oFqACBRR+gAlTAjQIElhtTsaNUgAr8H8LKq/XhbnJCAAAAAElFTkSuQmCC', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (44, 2, 2, 'MITSUBISHI PAJERO', '01', 'MITSUBISHI PAJERO01', 'OIL SERVICE', '2024-08-14', NULL, 'Final', 33, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '25.00', NULL, '25.0000', '', 'Paid', '25.0000', '2024-08-14', '08:44:09 pm', 'Admin', '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '61735AA', 'NA', 'PAJERO', 'MITSUBISHI', 2019, NULL, '', '', '', '69160KM', '', '', '', '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', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (45, 2, 2, 'SL/ECS/', '2', 'SL/ECS/2', 'Computer scan ', '2024-08-15', NULL, 'Final', 34, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-15', '12:25:31 pm', 'Admin', '5.36.88.10', '5.36.88.10.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '32775', '', 'Camry', 'Toyota ', 2019, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (46, 2, 2, 'SL/ECS/', '3', 'SL/ECS/3', 'Mechanic Inspection Check', '2024-08-17', NULL, 'Final', 35, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-17', '05:33:21 pm', 'Admin', '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '91084H', '', '', 'Toyota Camry', 2007, NULL, '', '', '', '', '', '', '', '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', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (47, 2, 2, 'SL/ECS/', '4', 'SL/ECS/4', 'Mechanic Inspection Check', '2024-08-17', NULL, 'Final', 36, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', 'Check List: Gear Box Seal, Engine Oil Seal, Bank1 and Bank 2 Head Gasket, Brake fluid and Engine Air Filta', 'Paid', '5.0000', '2024-08-17', '08:04:38 pm', 'Admin', '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '601BD', '', 'PATROL', 'NISSAN ', 2014, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (48, 2, 2, 'TOYOTA/HYBRID', '001', 'TOYOTA/HYBRID001', 'COOLANT CHANGE ', '2024-08-17', NULL, 'Final', 37, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-17', '08:58:30 pm', 'Admin', '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '493AB', 'NA', 'HYBRID', 'TOYOTA ', 2020, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', 'iVBORw0KGgoAAAANSUhEUgAAAlgAAAEsCAYAAAAfPc2WAAAAAXNSR0IArs4c6QAADuZJREFUeF7t1jERAAAIAzHq3zQmfgwCOuQYfucIECBAgAABAgRSgaVrxggQIECAAAECBE5geQICBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAIEHgNkBLevR78cAAAAASUVORK5CYII=', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (49, 2, 2, 'LEXUS EX', '350', 'LEXUS EX350', 'OIL SERVICE', '2024-08-18', NULL, 'Final', 38, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '30.00', NULL, '30.0000', 'Mechanic Inspection and Computer Scan Free Of Cost(FOC) No Charge. ', 'Paid', '30.0000', '2024-08-18', '11:03:42 am', 'Admin', '5.36.199.217', '5.36.199.217.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '9581W', 'NA', 'ES350', 'LEXUS', 2016, NULL, '', '', '', '', '', '', '', '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', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (50, 2, 2, 'GMC/SIERRA', '001', 'GMC/SIERRA001', 'ATF &amp; DIFFERENTIAL OIL SERVICE', '2024-08-19', NULL, 'Final', 39, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '61.00', NULL, '61.0000', '', 'Paid', '61.0000', '2024-08-19', '12:21:08 pm', 'Admin', '5.36.209.235', '5.36.209.235.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '28674D', 'NA', 'SIERRA', 'GMC', 2021, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (51, 2, 2, 'BMW/5Series', '001', 'BMW/5Series001', 'Oil Service &amp; Coolant Exchange ', '2024-08-19', NULL, 'Final', 40, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '37.75', NULL, '37.7500', '', 'Paid', '37.7500', '2024-08-19', '07:28:05 pm', 'Admin', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '8085R', 'NA', '5Series', 'BMW', 2011, NULL, '', '', '', '', '', '', '', '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', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (52, 2, 2, 'HONDA ACCORD', '001', 'HONDA ACCORD001', 'COMPUTER SCAN', '2024-08-19', NULL, 'Final', 41, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-19', '09:13:20 pm', 'Admin', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '1395BS', 'NA', 'ACCORD', 'HONDA ', 2012, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (53, 2, 2, 'LEXUS 570', '001', 'LEXUS 570001', 'OIL CHANGE ', '2024-08-21', NULL, 'Final', 42, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '35.00', NULL, '35.0000', '', 'Paid', '35.0000', '2024-08-21', '10:12:15 am', 'Admin', '5.36.216.66', '5.36.216.66.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '1788HY', 'NA', 'LX570', 'LEXUS', 2021, NULL, '', '', '', '', '', '', '', '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', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (54, 2, 2, 'SL/ECS/', '2', 'SL/ECS/2', 'COMPUTER SCAN', '2024-08-21', NULL, 'Final', 43, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-21', '11:20:29 am', 'Admin', '5.36.216.66', '5.36.216.66.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '1420HH', '', 'Patrol', 'Nissan', 2014, NULL, '', '', '', '', '', '', '', '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', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (55, 2, 2, 'ToyotaCamry', '001', 'ToyotaCamry001', '', '2024-08-21', NULL, 'Final', 44, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-21', '09:27:45 pm', 'Admin', '5.36.233.9', '5.36.233.9.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '24425A', 'NA', 'Camry', 'Toyota', 2007, NULL, '', '', '', '', '', '', '', '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', 'iVBORw0KGgoAAAANSUhEUgAAAlgAAAEsCAYAAAAfPc2WAAAAAXNSR0IArs4c6QAADuZJREFUeF7t1jERAAAIAzHq3zQmfgwCOuQYfucIECBAgAABAgRSgaVrxggQIECAAAECBE5geQICBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAAGB5QcIECBAgAABArGAwIpBzREgQIAAAQIEBJYfIECAAAECBAjEAgIrBjVHgAABAgQIEBBYfoAAAQIECBAgEAsIrBjUHAECBAgQIEBAYPkBAgQIECBAgEAsILBiUHMECBAgQIAAAYHlBwgQIECAAAECsYDAikHNESBAgAABAgQElh8gQIAAAQIECMQCAisGNUeAAAECBAgQEFh+gAABAgQIECAQCwisGNQcAQIECBAgQEBg+QECBAgQIECAQCwgsGJQcwQIECBAgAABgeUHCBAgQIAAAQKxgMCKQc0RIECAAAECBASWHyBAgAABAgQIxAICKwY1R4AAAQIECBAQWH6AAAECBAgQIBALCKwY1BwBAgQIECBAQGD5AQIECBAgQIBALCCwYlBzBAgQIECAAIEHgNkBLevR78cAAAAASUVORK5CYII=', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (56, 2, 2, 'Nissan Patrol/', '001', 'Nissan Patrol/001', 'Oil Service ', '2024-08-21', NULL, 'Final', 45, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '30.00', NULL, '30.0000', 'Mechanic Inspection\r\nComputer Scan\r\nFree of Charge', 'Paid', '30.0000', '2024-08-21', '10:12:15 pm', 'Admin', '5.36.233.9', '5.36.233.9.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '31752HH', 'NA', 'Patrol', 'Nissan ', 2010, NULL, '', '', '', '', '', '', '', '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', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (57, 2, 2, 'Mercedes AMG E63', '001', 'Mercedes AMG E63001', 'Oil Service', '2024-08-22', NULL, 'Final', 46, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '59.00', NULL, '59.0000', 'MECHANIC INSPECTION\r\nCOMPUTER SCAN\r\nALL FREE OF COST.', 'Paid', '59.0000', '2024-08-22', '08:27:32 am', 'Admin', '5.32.218.218', '5.32.218.218', NULL, NULL, 1, NULL, NULL, NULL, NULL, '97441Y', 'NA', 'AMG', 'Mercedez', 2014, NULL, '', '', '', '', '', '', '', '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