SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: ac_accounts
#

DROP TABLE IF EXISTS `ac_accounts`;

CREATE TABLE `ac_accounts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `sort_code` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `account_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `account_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `balance` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `delete_bit` int DEFAULT '0',
  `account_selection_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `paymenttypes_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `expense_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `paymenttypes_id` (`paymenttypes_id`),
  KEY `customer_id` (`customer_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `expense_id` (`expense_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`) VALUES (1, 1, 2, 0, '1', 'Ibrahim', '95200717', '8.0000', 'Available for bank transfer payment ', 'Admin', '2024-08-08', '12:08:17 pm', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', 1, 0, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: ac_moneydeposits
#

DROP TABLE IF EXISTS `ac_moneydeposits`;

CREATE TABLE `ac_moneydeposits` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneydeposits_ibfk_3` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_moneytransfer
#

DROP TABLE IF EXISTS `ac_moneytransfer`;

CREATE TABLE `ac_moneytransfer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL,
  `transfer_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneytransfer_ibfk_3` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_transactions
#

DROP TABLE IF EXISTS `ac_transactions`;

CREATE TABLE `ac_transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `transaction_date` date DEFAULT NULL,
  `transaction_type` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `debit_amt` double(20,4) DEFAULT NULL,
  `credit_amt` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `ref_accounts_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_moneytransfer_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_moneydeposits_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_salespayments_id` int DEFAULT NULL,
  `ref_salespaymentsreturn_id` int DEFAULT NULL,
  `ref_purchasepayments_id` int DEFAULT NULL,
  `ref_purchasepaymentsreturn_id` int DEFAULT NULL,
  `ref_expense_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_id` (`transaction_type`),
  KEY `account_id` (`debit_account_id`),
  KEY `store_id` (`store_id`),
  KEY `ac_accounts_id` (`ref_accounts_id`),
  KEY `ac_moneytransfer_id` (`ref_moneytransfer_id`),
  KEY `ac_moneydeposits_id` (`ref_moneydeposits_id`),
  KEY `customer_id` (`customer_id`),
  KEY `ref_salespayments_id` (`ref_salespayments_id`),
  KEY `ref_purchasepayments_id` (`ref_purchasepayments_id`),
  KEY `ref_purchasepaymentsreturn_id` (`ref_purchasepaymentsreturn_id`),
  KEY `ac_transactions_ibfk_9` (`ref_salespaymentsreturn_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `ref_expense_id` (`ref_expense_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (1, 2, '', '2024-08-08', 'OPENING BALANCE', NULL, 1, NULL, '0.0000', '', 'Admin', '2024-08-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (2, 2, 'SP/2021/02/0060', '2024-08-23', 'SALES PAYMENT', NULL, 1, NULL, '8.0000', '5 rial cash payment, 3 rial balance by transfer .', 'Admin', '2024-08-23', NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL, 51, NULL, NULL);


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `timestamp` int unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ajq6oi47cd930csjchmh0lofesbbsbnf', '5.162.96.146', 1738934173, '__ci_last_regenerate|i:1738934173;currency|s:4:\"R.O.\";currency_placement|s:5:\"Right\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:28:\"1stLINE.....(C.R.No:1430197)\";inv_username|s:5:\"Admin\";user_lname|s:4:\"User\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:18:\"admin@baramiij.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2iudj42ps2i58d31fr6hc7onhajd9p02', '5.162.96.146', 1738934175, '__ci_last_regenerate|i:1738934173;currency|s:4:\"R.O.\";currency_placement|s:5:\"Right\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:28:\"1stLINE.....(C.R.No:1430197)\";inv_username|s:5:\"Admin\";user_lname|s:4:\"User\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:18:\"admin@baramiij.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('popfc1eldegrteie8otgfrq4s4d656g1', '5.37.110.71', 1738937985, '__ci_last_regenerate|i:1738937985;currency|s:4:\"R.O.\";currency_placement|s:5:\"Right\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:28:\"1stLINE.....(C.R.No:1430197)\";inv_username|s:5:\"Admin\";user_lname|s:4:\"User\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:18:\"admin@baramiij.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m76lu4jegnlm1floa3tl7ecplmi9mpnn', '5.37.110.71', 1738938143, '__ci_last_regenerate|i:1738937985;currency|s:4:\"R.O.\";currency_placement|s:5:\"Right\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:28:\"1stLINE.....(C.R.No:1430197)\";inv_username|s:5:\"Admin\";user_lname|s:4:\"User\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:18:\"admin@baramiij.com\";language|s:7:\"English\";language_id|s:1:\"1\";');


#
# TABLE STRUCTURE FOR: db_brands
#

DROP TABLE IF EXISTS `db_brands`;

CREATE TABLE `db_brands` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `brand_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `brand_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (18, 2, NULL, 'Mannol', 'engine oil', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (19, 2, NULL, 'brake-pads', 'brake-pads', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (20, 2, NULL, 'toyota/lexus', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (21, 2, NULL, 'nissan filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (22, 2, NULL, 'mazda filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (23, 2, NULL, 'range-rover filter', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (24, 2, NULL, 'bmw-filter', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (25, 2, NULL, 'volkswagen-filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (26, 2, NULL, 'audi filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (27, 2, NULL, 'mercedez', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (28, 2, NULL, 'checks', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (29, 2, NULL, 'nissan', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (30, 2, NULL, 'masuma brake-pads', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (31, 2, NULL, '80w-90', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (32, 2, NULL, '75w-90', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (33, 2, NULL, '75w-140', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (34, 2, NULL, 'dexron VI', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (35, 2, NULL, 'differential', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (36, 2, NULL, 'Ac-delco filters', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (37, 2, NULL, 'Petrol', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (38, 2, NULL, 'Water', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (39, 2, NULL, 'Disposable oil', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (40, 2, NULL, 'Office internet', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (41, 2, NULL, 'Accommodation', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (42, 2, NULL, 'Gas', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (43, 2, NULL, 'Electricity', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (44, 2, NULL, 'Workshop tools', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (45, 2, NULL, 'Office consumable', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (46, 2, NULL, 'Office rental space', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (47, 2, NULL, 'office', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (48, 2, NULL, 'Mobile recharge', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (49, 2, NULL, 'old oil', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (50, 2, NULL, 'salary advance', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (51, 2, NULL, 'Lexus Es350', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (52, 2, NULL, 'omanoil services station', 'Gass Station', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (53, 2, NULL, 'Al Labeeb Bookshop', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (54, 2, NULL, 'house holds items', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (55, 2, NULL, 'PURCHASE', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (56, 2, NULL, 'STAFF', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (57, 2, NULL, 'CAR WASH', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (58, 2, NULL, 'LED BULB', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (59, 2, NULL, 'OVER TIME', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (60, 2, NULL, 'service', '', 1);


#
# TABLE STRUCTURE FOR: db_cash_register
#

DROP TABLE IF EXISTS `db_cash_register`;

CREATE TABLE `db_cash_register` (
  `id` int NOT NULL AUTO_INCREMENT,
  `o_amt` float DEFAULT NULL,
  `o_time` datetime DEFAULT NULL,
  `c_amt` float DEFAULT NULL,
  `c_time` datetime DEFAULT NULL,
  `warehouse_id` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_cash_register` (`id`, `o_amt`, `o_time`, `c_amt`, `c_time`, `warehouse_id`) VALUES (1, '0', '2024-02-27 15:35:00', '1', '2024-02-27 16:36:00', 2);
INSERT INTO `db_cash_register` (`id`, `o_amt`, `o_time`, `c_amt`, `c_time`, `warehouse_id`) VALUES (2, '5', '2024-02-27 17:06:00', '0', '2024-10-24 11:01:00', 2);


#
# TABLE STRUCTURE FOR: db_category
#

DROP TABLE IF EXISTS `db_category`;

CREATE TABLE `db_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create category Code',
  `category_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (15, 2, 1, 'CT/02/0001', 'filters', 'oil', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (16, 2, 16, 'CT/02/0016', 'Mannol', 'oil', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (17, 2, 17, 'CT/02/0017', 'labor', 'charge', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (18, 2, 18, 'CT/02/0018', 'air', 'filters', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (19, 2, 19, 'CT/02/0019', 'brake-pads', 'brake-pads', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (20, 2, 20, 'CT/02/0020', 'cabin', 'air-filter', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (21, 2, 21, 'CT/02/0021', 'oil', 'engine', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (22, 2, 22, 'CT/02/0022', 'Service', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (23, 2, 23, 'CT/02/0023', 'Break service exchange', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (24, 2, 24, 'CT/02/0024', 'Break bads', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (25, 2, 25, 'CT/02/0025', 'Air filter', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (26, 2, 26, 'CT/02/0026', 'Ac cabin filter', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (27, 2, 27, 'CT/02/0027', 'Spark plugs', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (28, 2, 28, 'CT/02/0028', 'Fuel pump', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (29, 2, 29, 'CT/02/0029', 'Oil filter', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (30, 2, 30, 'CT/02/0030', 'Fuel Pump Seal', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (31, 2, 31, 'CT/02/0031', 'front brake-pads', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (32, 2, 32, 'CT/02/0032', 'rear brake-pads', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (33, 2, 33, 'CT/02/0033', 'gear oil', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (34, 2, 34, 'CT/02/0034', 'atf oil', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (35, 2, 35, 'CT/02/0035', 'Petrol purchase Nissan Sunny', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (36, 2, 36, 'CT/02/0036', 'Monthly dues', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (37, 2, 37, 'CT/02/0037', 'Monthly internet bills', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (38, 2, 38, 'CT/02/0038', 'Disposable oil', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (39, 2, 39, 'CT/02/0039', 'Staff accommodation', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (40, 2, 40, 'CT/02/0040', 'Cooking gas staff accommodation', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (41, 2, 41, 'CT/02/0041', 'Office drinking water', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (42, 2, 42, 'CT/02/0042', 'Workshop tools', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (43, 2, 43, 'CT/02/0043', 'Office Consumable', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (44, 2, 44, 'CT/02/0044', 'Electricity bills', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (45, 2, 45, 'CT/02/0045', 'Phone bills', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (46, 2, 46, 'CT/02/0046', 'Oredo network', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (47, 2, 47, 'CT/02/0047', 'salary', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (48, 2, 48, 'CT/02/0048', 'purchase', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (49, 2, 49, 'CT/02/0049', 'bookshop printing center', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (50, 2, 50, 'CT/02/0050', 'house hold purchase', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (51, 2, 51, 'CT/02/0051', 'ACCOMODATION', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (52, 2, 52, 'CT/02/0052', 'CAR WASH SERVICE', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (53, 2, 53, 'CT/02/0053', 'LED LIGHT', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (54, 2, 54, 'CT/02/0054', 'EMPLOYEE', '', NULL, 1);


#
# TABLE STRUCTURE FOR: db_cobpayments
#

DROP TABLE IF EXISTS `db_cobpayments`;

CREATE TABLE `db_cobpayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_company
#

DROP TABLE IF EXISTS `db_company`;

CREATE TABLE `db_company` (
  `id` double DEFAULT NULL,
  `company_code` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_name` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_website` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `mobile` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `phone` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `website` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_logo` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `logo` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `upi_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `upi_code` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `country` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `state` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `city` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `address` varchar(300) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `postcode` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `gst_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vat_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `pan_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `bank_details` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `cid` int DEFAULT NULL,
  `category_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expense_init` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `invoice_view` int DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `status` int DEFAULT NULL,
  `sms_status` int DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `sales_terms_and_conditions` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_company` (`id`, `company_code`, `company_name`, `company_website`, `mobile`, `phone`, `email`, `website`, `company_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `invoice_view`, `status`, `sms_status`, `sales_terms_and_conditions`) VALUES ('1', '', 'Company Name', NULL, '9999999999', '', 'admin@example.com', '', 'company_logo.png', 'logo-0.png', NULL, NULL, 'India', 'Karnataka', 'Belgaum', 'Address Details', '', '', '', '', '', 1, 'CT', 'IT', 'SP', 'PU', 'PR', 'CU', 'SL', 'PR', 'EX', 1, 1, 0, NULL);


#
# TABLE STRUCTURE FOR: db_country
#

DROP TABLE IF EXISTS `db_country`;

CREATE TABLE `db_country` (
  `id` int NOT NULL AUTO_INCREMENT,
  `country` varchar(4050) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (1, 'Abkhazia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (2, 'Afghanistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (3, 'Albania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (4, 'Algeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (5, 'Andorra', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (6, 'Angola', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (7, 'Antigua and Barbuda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (8, 'Argentina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (9, 'Armenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (10, 'Australia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (11, 'Austria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (12, 'Azerbaijan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (13, 'Bahamas', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (14, 'Bahrain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (15, 'Bangladesh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (16, 'Barbados', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (17, 'Belarus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (18, 'Belgium', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (19, 'Belize', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (20, 'Benin', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (21, 'Bhutan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (22, 'Bolivia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (23, 'Bosnia and Herzegovina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (24, 'Botswana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (25, 'Brazil', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (26, 'Brunei', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (27, 'Bulgaria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (28, 'Burkina Faso', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (29, 'Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (30, 'Burundi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (31, 'Cambodia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (32, 'Cameroon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (33, 'Canada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (34, 'Cape Verde', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (35, 'Central African Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (36, 'Chad', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (37, 'Chile', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (38, 'China', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (39, 'Colombia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (40, 'Comoros', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (41, 'Congo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (42, 'Cook Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (43, 'Costa Rica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (44, 'Croatia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (45, 'Cuba', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (46, 'Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (47, 'Czech Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (48, 'C?te d\'Ivoire', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (49, 'Denmark', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (50, 'Djibouti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (51, 'Dominica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (52, 'Dominican Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (53, 'East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (54, 'Ecuador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (55, 'Egypt', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (56, 'El Salvador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (57, 'Equatorial Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (58, 'Eritrea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (59, 'Estonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (60, 'Ethiopia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (61, 'Fiji', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (62, 'Finland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (63, 'France', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (64, 'Gabon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (65, 'Gambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (66, 'Georgia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (67, 'Germany', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (68, 'Ghana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (69, 'Greece', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (70, 'Grenada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (71, 'Guatemala', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (72, 'Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (73, 'Guinea-Bissau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (74, 'Guyana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (75, 'Haiti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (76, 'Honduras', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (77, 'Hungary', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (78, 'Iceland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (79, 'India', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (80, 'Indonesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (81, 'Iran', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (82, 'Iraq', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (83, 'Ireland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (84, 'Israel', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (85, 'Italy', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (86, 'Ivory Coast', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (87, 'Jamaica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (88, 'Japan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (89, 'Jordan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (90, 'Kazakhstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (91, 'Kenya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (92, 'Kiribati', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (93, 'Korea, North', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (94, 'Korea, South', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (95, 'Kosovo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (96, 'Kuwait', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (97, 'Kyrgyzstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (98, 'Laos', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (99, 'Latvia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (100, 'Lebanon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (101, 'Lesotho', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (102, 'Liberia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (103, 'Libya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (104, 'Liechtenstein', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (105, 'Lithuania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (106, 'Luxembourg', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (107, 'Macedonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (108, 'Madagascar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (109, 'Malawi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (110, 'Malaysia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (111, 'Maldives', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (112, 'Mali', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (113, 'Malta', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (114, 'Marshall Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (115, 'Mauritania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (116, 'Mauritius', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (117, 'Mexico', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (118, 'Micronesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (119, 'Moldova', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (120, 'Monaco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (121, 'Mongolia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (122, 'Montenegro', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (123, 'Morocco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (124, 'Mozambique', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (125, 'Myanmar / Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (126, 'Nagorno-Karabakh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (127, 'Namibia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (128, 'Nauru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (129, 'Nepal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (130, 'Netherlands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (131, 'New Zealand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (132, 'Nicaragua', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (133, 'Niger', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (134, 'Nigeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (135, 'Niue', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (136, 'Northern Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (137, 'Norway', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (138, 'Oman', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (139, 'Pakistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (140, 'Palau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (141, 'Palestine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (142, 'Panama', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (143, 'Papua New Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (144, 'Paraguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (145, 'Peru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (146, 'Philippines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (147, 'Poland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (148, 'Portugal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (149, 'Qatar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (150, 'Romania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (151, 'Russia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (152, 'Rwanda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (153, 'Sahrawi Arab Democratic Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (154, 'Saint Kitts and Nevis', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (155, 'Saint Lucia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (156, 'Saint Vincent and the Grenadines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (157, 'Samoa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (158, 'San Marino', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (159, 'Saudi Arabia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (160, 'Senegal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (161, 'Serbia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (162, 'Seychelles', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (163, 'Sierra Leone', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (164, 'Singapore', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (165, 'Slovakia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (166, 'Slovenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (167, 'Solomon Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (168, 'Somalia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (169, 'Somaliland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (170, 'South Africa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (171, 'South Ossetia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (172, 'Spain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (173, 'Sri Lanka', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (174, 'Sudan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (175, 'Suriname', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (176, 'Swaziland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (177, 'Sweden', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (178, 'Switzerland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (179, 'Syria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (180, 'S?o Tom? and Pr?ncipe', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (181, 'Taiwan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (182, 'Tajikistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (183, 'Tanzania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (184, 'Thailand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (185, 'Timor-Leste / East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (186, 'Togo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (187, 'Tonga', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (188, 'Trinidad and Tobago', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (189, 'Tunisia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (190, 'Turkey', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (191, 'Turkmenistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (192, 'Tuvalu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (193, 'Uganda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (194, 'Ukraine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (195, 'United Arab Emirates', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (196, 'United Kingdom', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (197, 'United States', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (198, 'Uruguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (199, 'Uzbekistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (200, 'Vanuatu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (201, 'Vatican City', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (202, 'Venezuela', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (203, 'Vietnam', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (204, 'Yemen', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (205, 'Zambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (206, 'Zimbabwe', '2020-11-03', 1);


#
# TABLE STRUCTURE FOR: db_currency
#

DROP TABLE IF EXISTS `db_currency`;

CREATE TABLE `db_currency` (
  `id` int NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `currency_code` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `currency` blob,
  `symbol` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (1, 'Bulgaria-Bulgarian lev(BGN)', NULL, 'лв', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (2, 'Switzerland \r-Swiss franc (CHF)', NULL, 'CHF', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (3, 'Czechia-Czech koruna(CZK))', NULL, 'Kč ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (4, 'Denmark-Danish krone(DKK)', NULL, 'kr ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (5, 'Euro area countries -Euro(EUR)', NULL, '€ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (6, 'United Kingdom-Pounds sterling (GBP)', NULL, '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (7, 'Croatia -Croatian Kuna (HRK)', NULL, 'kn', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (8, 'Georgia -Georgian lari (GEL)', NULL, '&#8382;', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (9, 'Hungary -Hungarian forint (HUF)', NULL, 'ft', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (10, 'Norway -Norwegian krone (NOK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (11, 'Poland -Polish zloty (PLN)', NULL, 'zł ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (12, 'Russia -Russian ruble (RUB)', NULL, '&#8381; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (13, 'Romania -Romanian leu (RON)', NULL, 'lei', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (14, 'Sweden - Swedish krona (SEK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (15, 'Turkey -Turkish lira (TRY)', NULL, '&#8378; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (16, 'Ukraine - Ukrainian hryvna  (UAH)', NULL, '₴ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (17, 'UAE -Emirati dirham (AED)', NULL, 'د.إ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (18, 'Israel - Israeli shekel (ILS)', NULL, '&#8362; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (19, 'Kenya - Kenyan shilling(KES)', NULL, 'Ksh', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (20, 'Morocco - Moroccan dirham (MAD)', NULL, '.د.م ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (21, 'Nigeria - Nigerian naira (NGN)', NULL, '₦ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (22, 'South Africa -South african rand** (ZAR)', NULL, 'R', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (23, 'Brazil- Brazilian real(BRL)', NULL, 'R$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (24, 'Canada-Canadian dollars (CAD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (25, 'Chile -Chilean peso (CLP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (26, 'Colombia -Colombian peso (COP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (27, 'Mexico - Mexican peso (MXN)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (28, 'Peru -Peruvian sol(PEN)', NULL, 'S/. ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (29, 'USA -US dollar (USD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (30, 'Australia -Australian dollars (AUD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (31, 'Bangladesh -Bangladeshi taka (BDT) ', NULL, '&#2547; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (32, 'China - Chinese yuan (CNY)', NULL, '&#20803; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (33, 'Hong Kong - Hong Kong dollar(HKD)', NULL, '&#36; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (34, 'Indonesia - Indonesian rupiah (IDR)', NULL, 'Rp', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (35, 'India - Indian rupee', 'INR', '₹', '?', 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (36, 'Japan - Japanese yen (JPY)', NULL, '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (37, 'Malaysia - Malaysian ringgit (MYR)', NULL, 'RM', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (38, 'New Zealand - New Zealand dollar (NZD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (39, 'Philippines- Philippine peso (PHP)', NULL, '₱ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (40, 'Pakistan- Pakistani rupee (PKR)', NULL, 'Rs ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (41, 'Singapore - Singapore dollar (SGD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (42, 'South Korea - South Korean won (KRW)', NULL, '&#8361; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (43, 'Sri Lanka - Sri Lankan rupee (LKR)', NULL, 'Rs', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (44, 'Thailand- Thai baht (THB)', NULL, '&#3647; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (45, 'Vietnam - Vietnamese dong', 'VND', '₫', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (46, 'Bitcoin - BTC or XBT', 'BTC ', '₿', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (47, 'Ripples', 'XRP', 'XRP', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (48, 'Monero', 'XMR', 'ɱ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (49, 'Litecoin', 'LTC', 'Ł', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (50, 'Ethereum', 'ETH', 'Ξ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (51, 'Euro', 'EUR', '€', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (52, 'Pounds sterling', 'GBP', '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (53, 'US dollar', 'USD', '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (54, 'Japanese yen', 'JPY', '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (55, 'Omani rial', 'OMR', 'R.O.', NULL, 1);


#
# TABLE STRUCTURE FOR: db_custadvance
#

DROP TABLE IF EXISTS `db_custadvance`;

CREATE TABLE `db_custadvance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `amount` double(20,2) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_ip` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_name` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customer_payments
#

DROP TABLE IF EXISTS `db_customer_payments`;

CREATE TABLE `db_customer_payments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `salespayment_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `salespayment_id` (`salespayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customers
#

DROP TABLE IF EXISTS `db_customers`;

CREATE TABLE `db_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Customer Code',
  `customer_code` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `mobile` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `phone` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `gstin` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax_number` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vatin` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `sales_due` double(20,4) DEFAULT NULL,
  `sales_return_due` double(20,4) DEFAULT NULL,
  `country_id` int DEFAULT NULL,
  `state_id` int DEFAULT NULL,
  `governorate` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `city` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `postcode` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `address` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ship_country_id` int DEFAULT NULL,
  `ship_state_id` int DEFAULT NULL,
  `ship_city` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ship_postcode` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ship_address` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `location_link` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `attachment_1` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `price_level_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Increase',
  `price_level` double(20,4) DEFAULT '0.0000',
  `delete_bit` int DEFAULT '0',
  `tot_advance` double(20,4) DEFAULT NULL,
  `credit_limit` double(20,4) DEFAULT '-1.0000',
  `shippingaddress_id` int DEFAULT NULL,
  `channel` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=288 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (1, 1, NULL, 'CU0001', 'Walk-in customer', NULL, '', '', '', '', NULL, '0.0000', '0.0000', '0.0000', 1, NULL, NULL, NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2019-01-01', '10:55:54 pm', 'admin', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, NULL, '-1.0000', 1, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (2, 2, 1, 'CU/02/0001', 'Walk-in customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0.0000', '0.0000', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-02-12', '05:53:37 pm', '', NULL, 0, NULL, NULL, 'Increase', '0.0000', 1, '0.0000', '-1.0000', 2, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (3, 2, 3, 'CU/02/0003', 'Mr ibrahim', '95200717', '', '', '', '', NULL, '0.0000', '50.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '04:42:58 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (4, 2, 4, 'CU/02/0004', 'Mr Hitham', '99521740', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.83.87', '5.36.83.87.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '08:59:03 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 26, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (5, 2, 5, 'CU/02/0005', 'Mr kamis', '99200012', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham ', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:26:05 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 56, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (6, 2, 6, 'CU/02/0006', 'MR ASAAD', '92333335', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.183.143', '5.36.183.143.dynamic-dsl-ip.omantel.net.om', '2024-07-27', '12:47:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 22, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (7, 2, 7, 'CU/02/0007', 'Mr Ali Ahmad', '95555607', '96436665', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.230.14', '5.36.230.14.dynamic-dsl-ip.omantel.net.om', '2024-07-27', '05:26:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 23, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (8, 2, 8, 'CU/02/0008', 'Mr Abdullah Rashdi', '92344489', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.233.58', '5.37.233.58.dynamic-dsl-ip.omantel.net.om', '2024-07-28', '12:54:51 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 24, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (9, 2, 9, 'CU/02/0009', 'Mr Yousuf Al Burayki', '97101036', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.87.208', '5.36.87.208.dynamic-dsl-ip.omantel.net.om', '2024-07-29', '09:58:36 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 25, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (10, 2, 10, 'CU/02/0010', 'MR AHMAD', '91410009', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah North, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.125.87', '5.36.125.87.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '09:12:40 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 27, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (11, 2, 11, 'CU/02/0011', 'Mr Abdulaziz', '95223099', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah North, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.125.87', '5.36.125.87.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '12:05:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 28, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (12, 2, 12, 'CU/02/0012', 'MR AHMAD', '91167727', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '08:44:34 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 29, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (13, 2, 13, 'CU/02/0013', 'Mr Salim Al Mamri', '99775204', '', '', '', '', NULL, '0.0000', '0.0010', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '08:54:34 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 30, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (14, 2, 14, 'CU/02/0014', 'Mr Ahmad', '99029444', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '09:27:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 31, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (15, 2, 15, 'CU/02/0015', 'MR Gaith', '95169746', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', '', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.140.145', '5.36.140.145.dynamic-dsl-ip.omantel.net.om', '2024-08-04', '10:16:22 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 32, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (16, 2, 16, 'CU/02/0016', 'Mr Salim Khalid', '98171030', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah North', NULL, NULL, NULL, NULL, NULL, '5.36.140.145', '5.36.140.145.dynamic-dsl-ip.omantel.net.om', '2024-08-04', '12:11:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 33, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (17, 2, 17, 'CU/02/0017', 'Ahmed Al Badi', '99884441', '', '', '', '', NULL, '0.0000', '0.0020', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Saham', NULL, NULL, NULL, NULL, NULL, '5.36.147.73', '5.36.147.73.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '12:25:25 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 34, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (18, 2, 18, 'CU/02/0018', 'Omar AL MAMari', '92227714', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Saham', NULL, NULL, NULL, NULL, NULL, '5.36.220.161', '5.36.220.161.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '12:50:09 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 35, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (19, 2, 19, 'CU/02/0019', 'Said all badi', '99249579', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Saham', NULL, NULL, NULL, NULL, NULL, '5.36.231.215', '5.36.231.215.dynamic-dsl-ip.omantel.net.om', '2024-08-06', '06:34:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (20, 2, 20, 'CU/02/0020', 'Mr Salim Hamoud', '92002362', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.168.17', '5.36.168.17.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '05:52:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 36, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (21, 2, 21, 'CU/02/0021', 'Mr Arif buyer old oil', '97695582', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Radah', '391', 'Radah saham', NULL, NULL, NULL, NULL, NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '11:59:18 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (22, 2, 22, 'CU/02/0022', 'Mr Mahmood Al Ansari', '90949494', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '05:51:05 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 37, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (23, 2, 23, 'CU/02/0023', 'Mr Nabhan', '95571305', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.117.222', '5.36.117.222.dynamic-dsl-ip.omantel.net.om', '2024-08-10', '07:27:26 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 38, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (24, 2, 24, 'CU/02/0024', 'Mr Musaba/Toyota Camry', '96615177', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '10:46:52 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 39, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (25, 2, 25, 'CU/02/0025', 'Mr Zakaria/Toyota Camry', '97314219', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 138, NULL, 'North Batinah', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '10:58:29 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 40, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (26, 2, 26, 'CU/02/0026', 'MR AHMED', '95565035', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 138, NULL, 'North Batinah', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '11:16:20 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 41, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (27, 2, 27, 'CU/02/0027', 'Many', '78702808', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Saham', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '12:00:17 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (28, 2, 28, 'CU/02/0028', 'Talib all khaldi', '92922279', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '12:11:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (29, 2, 29, 'CU/02/0029', 'Mr Rashid', '77444962', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'All batina, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.228.140', '5.37.228.140.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '07:08:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (30, 2, 30, 'CU/02/0030', 'Mr Laith', '92081418', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Al Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.199.26', '5.36.199.26.dynamic-dsl-ip.omantel.net.om', '2024-08-12', '06:13:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (31, 2, 31, 'CU/02/0031', 'Walk In Customer', '', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North', NULL, NULL, NULL, NULL, NULL, '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', '2024-08-14', '06:10:11 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (32, 2, 32, 'CU/02/0032', 'Mr Ahmad', '97000161', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', '2024-08-14', '08:25:13 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (33, 2, 33, 'CU/02/0033', 'Mr Nasir AL Mamari', '99510938', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah,  saham', NULL, NULL, NULL, NULL, NULL, '5.36.242.95', '5.36.242.95.dynamic-dsl-ip.omantel.net.om', '2024-08-14', '08:39:41 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (34, 2, 34, 'CU/02/0034', 'Ali salim', '96557685', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.88.10', '5.36.88.10.dynamic-dsl-ip.omantel.net.om', '2024-08-15', '12:23:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (35, 2, 35, 'CU/02/0035', 'Mr Ali Gafar Al Buraiki', '95697837', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', '2024-08-17', '05:30:33 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (36, 2, 36, 'CU/02/0036', 'Mr Saif', '96444463', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', '2024-08-17', '08:01:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (37, 2, 37, 'CU/02/0037', 'MR TALAL', '98880751', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'SAHAM', '', 'BATINA SAHAM', NULL, NULL, NULL, NULL, NULL, '5.37.219.53', '5.37.219.53.dynamic-dsl-ip.omantel.net.om', '2024-08-17', '08:56:07 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (38, 2, 38, 'CU/02/0038', 'Mr Salem', 'Customers List ', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.199.217', '5.36.199.217.dynamic-dsl-ip.omantel.net.om', '2024-08-18', '10:10:13 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 42, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (39, 2, 39, 'CU/02/0039', 'Mr Mohammed Al Mamari', '98522894', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'North Batina Saham', NULL, NULL, NULL, NULL, NULL, '5.36.209.235', '5.36.209.235.dynamic-dsl-ip.omantel.net.om', '2024-08-19', '12:17:20 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (40, 2, 40, 'CU/02/0040', 'Mr Sultan Al Buraiki', '98986889', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '2024-08-19', '06:06:04 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (41, 2, 41, 'CU/02/0041', 'Mr Sultan Al Baraiki', '97776040', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 138, NULL, 'North Batinah', 'Saham', '391', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '2024-08-19', '09:11:49 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (42, 2, 42, 'CU/02/0042', 'Mr Khalid', '98885373', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batina', NULL, NULL, NULL, NULL, NULL, '5.36.216.66', '5.36.216.66.dynamic-dsl-ip.omantel.net.om', '2024-08-21', '10:06:43 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (43, 2, 43, 'CU/02/0043', 'Mr Mohammed', '93329076', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.216.66', '5.36.216.66.dynamic-dsl-ip.omantel.net.om', '2024-08-21', '11:17:33 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (44, 2, 44, 'CU/02/0044', 'Mr Ahmad Ali', '97774566', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.233.9', '5.36.233.9.dynamic-dsl-ip.omantel.net.om', '2024-08-21', '09:00:11 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 43, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (45, 2, 45, 'CU/02/0045', 'Mr Mubarak Al Balushi', '95256154', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.233.9', '5.36.233.9.dynamic-dsl-ip.omantel.net.om', '2024-08-21', '09:40:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (46, 2, 46, 'CU/02/0046', 'Mr Zubair', '96678770', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.32.218.218', '5.32.218.218', '2024-08-22', '08:23:04 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (47, 2, 47, 'CU/02/0047', 'Mr Rasheed', '99410607', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.32.218.218', '5.32.218.218', '2024-08-22', '10:49:52 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (48, 2, 48, 'CU/02/0048', 'Mr Malik Al Balushi', '71154797', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.214.32', '5.36.214.32.dynamic-dsl-ip.omantel.net.om', '2024-08-22', '04:47:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 44, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (49, 2, 49, 'CU/02/0049', 'Mr Abdullah Ibrahim', '92255241', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.214.32', '5.36.214.32.dynamic-dsl-ip.omantel.net.om', '2024-08-22', '07:42:26 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (50, 2, 50, 'CU/02/0050', 'Mr Mohammed', '94994878', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.214.32', '5.36.214.32.dynamic-dsl-ip.omantel.net.om', '2024-08-22', '08:18:13 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (51, 2, 51, 'CU/02/0051', 'Mr Abdulaziz', '72085911', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.200.129', '5.36.200.129.dynamic-dsl-ip.omantel.net.om', '2024-08-23', '07:51:40 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (52, 2, 52, 'CU/02/0052', 'Mr Muslem', '94203121', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham', NULL, NULL, NULL, NULL, NULL, '5.36.174.244', '5.36.174.244.dynamic-dsl-ip.omantel.net.om', '2024-08-24', '05:54:43 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (53, 2, 53, 'CU/02/0053', 'MR MAHMOOD', '92882806', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 138, NULL, '', 'Saham', '', 'Al Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.174.244', '5.36.174.244.dynamic-dsl-ip.omantel.net.om', '2024-08-24', '07:29:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (54, 2, 54, 'CU/02/0054', 'Mr Saif', '96493430', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North, Saham', NULL, NULL, NULL, NULL, NULL, '5.37.254.213', '5.37.254.213.dynamic-dsl-ip.omantel.net.om', '2024-08-26', '04:43:23 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (55, 2, 55, 'CU/02/0055', 'AHMED AL BURAKI', '99233228', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.254.213', '5.37.254.213.dynamic-dsl-ip.omantel.net.om', '2024-08-26', '05:56:46 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (56, 2, 56, 'CU/02/0056', 'Mr Mohammed', '99722225', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batina saham', NULL, NULL, NULL, NULL, NULL, '5.37.254.213', '5.37.254.213.dynamic-dsl-ip.omantel.net.om', '2024-08-26', '09:32:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (57, 2, 57, 'CU/02/0057', 'MR KHAMIS', '96051562', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.140.150', '5.36.140.150.dynamic-dsl-ip.omantel.net.om', '2024-08-27', '10:40:59 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (58, 2, 58, 'CU/02/0058', 'Mr SAID', '99231233', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batina, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.140.150', '5.36.140.150.dynamic-dsl-ip.omantel.net.om', '2024-08-27', '12:22:22 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (59, 2, 59, 'CU/02/0059', 'Mr Sami', '91705626', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '3 91', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.111.241', '5.36.111.241.dynamic-dsl-ip.omantel.net.om', '2024-08-27', '08:33:49 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (60, 2, 60, 'CU/02/0060', 'Mr Ahmed', '99359070', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham\r\n\r\n', NULL, NULL, NULL, NULL, NULL, '5.36.111.241', '5.36.111.241.dynamic-dsl-ip.omantel.net.om', '2024-08-27', '09:40:38 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (61, 2, 61, 'CU/02/0061', 'Mr Sultan', '98986888', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.190.211', '5.36.190.211.dynamic-dsl-ip.omantel.net.om', '2024-08-28', '05:37:14 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (62, 2, 62, 'CU/02/0062', 'Mr Khalid', '96360919', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah Saham', NULL, NULL, NULL, NULL, NULL, '5.36.190.211', '5.36.190.211.dynamic-dsl-ip.omantel.net.om', '2024-08-28', '08:01:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (63, 2, 63, 'CU/02/0063', 'Mr Mohammed', '98898119', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:49:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (64, 2, 64, 'CU/02/0064', 'Mr Ahmed', '98333493', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.152.232', '5.36.152.232.dynamic-dsl-ip.omantel.net.om', '2024-08-30', '05:00:56 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (65, 2, 65, 'CU/02/0065', 'Mr Marwan', '99499235', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.152.232', '5.36.152.232.dynamic-dsl-ip.omantel.net.om', '2024-08-30', '05:29:58 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (66, 2, 66, 'CU/02/0066', 'Mr Mohammed', '96314069', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah\r\n', NULL, NULL, NULL, NULL, NULL, '5.36.152.232', '5.36.152.232.dynamic-dsl-ip.omantel.net.om', '2024-08-30', '09:11:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (67, 2, 67, 'CU/02/0067', 'Mr Ahmed', '90444757', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.77.233', '5.36.77.233.dynamic-dsl-ip.omantel.net.om', '2024-08-31', '09:21:01 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (68, 2, 68, 'CU/02/0068', 'Mr Abdulhamid', '99888455', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '391', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.77.233', '5.36.77.233.dynamic-dsl-ip.omantel.net.om', '2024-08-31', '12:12:40 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 45, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (69, 2, 69, 'CU/02/0069', 'Mr Ahmad', '90177009', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North,  Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.242.189', '5.36.242.189.dynamic-dsl-ip.omantel.net.om', '2024-08-31', '07:51:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (70, 2, 70, 'CU/02/0070', 'Mr Rashid', '95792117', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.254.161', '5.37.254.161.dynamic-dsl-ip.omantel.net.om', '2024-09-02', '10:24:02 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (71, 2, 71, 'CU/02/0071', 'Mr Ali', '91141142', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.104.109', '5.36.104.109.dynamic-dsl-ip.omantel.net.om', '2024-09-02', '05:10:25 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (72, 2, 72, 'CU/02/0072', 'Khalid salim', '91187888', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.104.109', '5.36.104.109.dynamic-dsl-ip.omantel.net.om', '2024-09-02', '06:59:32 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (73, 2, 73, 'CU/02/0073', 'Mr Ahmad', '97817511', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'North Batinah, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.194.55', '5.36.194.55.dynamic-dsl-ip.omantel.net.om', '2024-09-04', '08:51:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (74, 2, 74, 'CU/02/0074', 'Mr Yousuf', '92229732', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.65.53', '5.36.65.53.dynamic-dsl-ip.omantel.net.om', '2024-09-05', '09:03:14 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (75, 2, 75, 'CU/02/0075', 'Mr Ali', '97840500', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'North Batina, Saham', NULL, NULL, NULL, NULL, NULL, '5.36.65.53', '5.36.65.53.dynamic-dsl-ip.omantel.net.om', '2024-09-05', '01:14:51 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (76, 2, 76, 'CU/02/0076', 'Mr Nasir', '96269606', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.199.29', '5.36.199.29.dynamic-dsl-ip.omantel.net.om', '2024-09-05', '05:21:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (77, 2, 77, 'CU/02/0077', 'Mr Mashal', '96060745', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah, Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.249.98', '5.37.249.98.dynamic-dsl-ip.omantel.net.om', '2024-09-06', '06:59:34 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (78, 2, 78, 'CU/02/0078', 'Mr Nawaf', '97775269', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.249.98', '5.37.249.98.dynamic-dsl-ip.omantel.net.om', '2024-09-06', '08:57:36 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (79, 2, 79, 'CU/02/0079', 'Mr Mohammed', '93928170', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.178.154', '5.36.178.154.dynamic-dsl-ip.omantel.net.om', '2024-09-07', '05:51:17 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (80, 2, 80, 'CU/02/0080', 'Ahmad Al bulushi', '92318009', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.111.90', '5.37.111.90', '2024-09-08', '04:38:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (81, 2, 81, 'CU/02/0081', 'Mr Ali Al Buraiki', '95232612', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.111.90', '5.37.111.90', '2024-09-08', '05:28:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (82, 2, 82, 'CU/02/0082', 'Mazein Al fizary', '96515599', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.111.90', '5.37.111.90', '2024-09-08', '06:17:59 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (83, 2, 83, 'CU/02/0083', 'Mr Ghalib', '77266140', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.143.49', '5.36.143.49.dynamic-dsl-ip.omantel.net.om', '2024-09-09', '06:05:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (84, 2, 84, 'CU/02/0084', 'Mr Ahmad', '96707077', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.102.89', '5.37.102.89', '2024-09-10', '11:46:40 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (85, 2, 85, 'CU/02/0085', 'Sheikh Abdullah', '95951515', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'SAHAM', '391', 'NORTH BATINA, SAHAM ', NULL, NULL, NULL, NULL, NULL, '5.36.87.227', '5.36.87.227.dynamic-dsl-ip.omantel.net.om', '2024-09-10', '05:26:02 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (86, 2, 86, 'CU/02/0086', 'Mr Mubarak', '98000829', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.201.88', '5.37.201.88.dynamic-dsl-ip.omantel.net.om', '2024-09-13', '08:10:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (87, 2, 87, 'CU/02/0087', 'Mr Rashid', '97332607', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.188.50', '5.36.188.50.dynamic-dsl-ip.omantel.net.om', '2024-09-14', '11:57:44 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (88, 2, 88, 'CU/02/0088', 'Mr Rashid', '98828448', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.182.105', '5.36.182.105.dynamic-dsl-ip.omantel.net.om', '2024-09-14', '09:28:20 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (89, 2, 89, 'CU/02/0089', 'Mr Waheed', '96690789', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.139.36', '5.36.139.36.dynamic-dsl-ip.omantel.net.om', '2024-09-15', '11:51:33 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (90, 2, 90, 'CU/02/0090', 'Mr Ali', '99003789', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.72.162', '5.36.72.162.dynamic-dsl-ip.omantel.net.om', '2024-09-15', '05:09:49 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (91, 2, 91, 'CU/02/0091', 'Mr Nasir', '92398032', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.72.162', '5.36.72.162.dynamic-dsl-ip.omantel.net.om', '2024-09-15', '09:19:41 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (92, 2, 92, 'CU/02/0092', 'Suhail abduslam', '92792326', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.110.87', '5.37.110.87', '2024-09-17', '11:55:04 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (93, 2, 93, 'CU/02/0093', 'Mr yaqoup', '99235515', '', '', '', '', NULL, '0.0000', '73.0000', NULL, NULL, NULL, 'North Batinah', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.197.14', '5.37.197.14.dynamic-dsl-ip.omantel.net.om', '2024-09-17', '04:44:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (94, 2, 94, 'CU/02/0094', 'Mr  Al Haitham', '79452957', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.112.133', '5.37.112.133', '2024-09-18', '08:45:59 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (95, 2, 95, 'CU/02/0095', 'Mr Nasir', '98913007', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.112.133', '5.37.112.133', '2024-09-18', '10:27:30 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (96, 2, 96, 'CU/02/0096', 'Mr Ali', '99210279', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.112.133', '5.37.112.133', '2024-09-18', '07:36:29 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (97, 2, 97, 'CU/02/0097', 'Said mohamad', '94518846', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.112.133', '5.37.112.133', '2024-09-18', '08:06:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 46, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (98, 2, 98, 'CU/02/0098', 'Khalid saqar', '99785020', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.117.219', '5.36.117.219.dynamic-dsl-ip.omantel.net.om', '2024-09-19', '11:53:44 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (99, 2, 99, 'CU/02/0099', 'Mr Rashid', '90648509', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.117.219', '5.36.117.219.dynamic-dsl-ip.omantel.net.om', '2024-09-19', '12:17:22 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (100, 2, 100, 'CU/02/0100', 'Mr Salim', '96628774', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.83.114', '5.36.83.114.dynamic-dsl-ip.omantel.net.om', '2024-09-20', '04:40:12 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (101, 2, 101, 'CU/02/0101', 'Mr Mohammed', '96555961', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.83.114', '5.36.83.114.dynamic-dsl-ip.omantel.net.om', '2024-09-20', '05:22:23 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (102, 2, 102, 'CU/02/0102', 'Mr Mohammed', '99046424', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.83.114', '5.36.83.114.dynamic-dsl-ip.omantel.net.om', '2024-09-20', '05:57:24 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (103, 2, 103, 'CU/02/0103', 'Mr Samid', '98075005', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.77.53', '5.36.77.53.dynamic-dsl-ip.omantel.net.om', '2024-09-21', '11:52:25 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (104, 2, 104, 'CU/02/0104', 'Mr Khalid', '96647246', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.203.49', '5.36.203.49.dynamic-dsl-ip.omantel.net.om', '2024-09-23', '09:42:59 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (105, 2, 105, 'CU/02/0105', 'Taha Al qasmi', '98762600', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.182.108', '5.36.182.108.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '09:35:56 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 47, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (106, 2, 106, 'CU/02/0106', 'Mohamed Al buraki', '97655707', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.182.108', '5.36.182.108.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '10:08:32 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 48, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (107, 2, 107, 'CU/02/0107', 'Mr Ebrahim', '123456789', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.248.100', '5.36.248.100.dynamic-dsl-ip.omantel.net.om', '2024-09-26', '09:45:56 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (108, 2, 108, 'CU/02/0108', 'Mr Suleiman', '95563312', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.214.44', '5.36.214.44.dynamic-dsl-ip.omantel.net.om', '2024-09-26', '07:18:04 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (109, 2, 109, 'CU/02/0109', 'MUTAB', '92421443', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham, ', NULL, NULL, NULL, NULL, NULL, '5.37.126.213', '5.37.126.213', '2024-09-27', '05:43:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (110, 2, 110, 'CU/02/0110', 'Mr Abdulaziz', '95958040', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.126.213', '5.37.126.213', '2024-09-27', '06:11:33 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (111, 2, 111, 'CU/02/0111', 'Mr Ahmood', '99707510', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.161.138', '5.36.161.138.dynamic-dsl-ip.omantel.net.om', '2024-09-28', '08:32:20 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (112, 2, 112, 'CU/02/0112', 'MR MARWAN', '91010033', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.161.138', '5.36.161.138.dynamic-dsl-ip.omantel.net.om', '2024-09-28', '10:04:12 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (113, 2, 113, 'CU/02/0113', 'Mr Walid', '92292472', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.143.64', '5.36.143.64.dynamic-dsl-ip.omantel.net.om', '2024-09-28', '08:24:17 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (114, 2, 114, 'CU/02/0114', 'Mr Hamid', '97541195', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '08:51:39 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (115, 2, 115, 'CU/02/0115', 'Mr Veeramani', '12345678', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Al Batinah north Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '08:55:32 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (116, 2, 116, 'CU/02/0116', 'Mr Salim Mohammed', '99038977', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '09:30:12 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (117, 2, 117, 'CU/02/0117', 'Mr Loay', '97074781', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '06:51:39 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (118, 2, 118, 'CU/02/0118', 'Mr Ahmad', '95628565', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '07:09:24 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (119, 2, 119, 'CU/02/0119', 'Mr Ali', '92644242', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '2024-09-30', '07:30:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (120, 2, 120, 'CU/02/0120', 'Mr Saif', '99577627', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.241.191', '5.36.241.191.dynamic-dsl-ip.omantel.net.om', '2024-10-01', '07:10:52 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (121, 2, 121, 'CU/02/0121', 'Hamad', '99458710', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.212.77', '5.36.212.77.dynamic-dsl-ip.omantel.net.om', '2024-10-02', '07:43:02 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (122, 2, 122, 'CU/02/0122', 'Mohamed salim', '92687916', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.201.94', '5.37.201.94.dynamic-dsl-ip.omantel.net.om', '2024-10-03', '09:50:52 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 49, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (123, 2, 123, 'CU/02/0123', 'Mr Sultan', '98559793', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.244.98', '5.37.244.98.dynamic-dsl-ip.omantel.net.om', '2024-10-03', '10:03:16 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (124, 2, 124, 'CU/02/0124', 'Mr Abdullah', '97569308', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.87.36', '5.36.87.36.dynamic-dsl-ip.omantel.net.om', '2024-10-04', '09:13:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (125, 2, 125, 'CU/02/0125', 'Mr Salim', '96054838', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.238.77', '5.36.238.77.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '09:13:32 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (126, 2, 126, 'CU/02/0126', 'Mr Mohammed', '79327543', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.238.77', '5.36.238.77.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '11:21:03 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (127, 2, 127, 'CU/02/0127', 'Mr Abdulraheem', '97314313', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.238.77', '5.36.238.77.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '01:32:52 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (128, 2, 128, 'CU/02/0128', 'Mr Nasser', '92273888', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.217.10', '5.36.217.10.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '06:01:59 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (129, 2, 129, 'CU/02/0129', 'Mr Ayman', '93637707', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.202.10', '5.36.202.10.dynamic-dsl-ip.omantel.net.om', '2024-10-06', '10:43:21 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (130, 2, 130, 'CU/02/0130', 'Mr Mohammed', '93666502', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.237.94', '5.37.237.94.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '09:02:13 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (131, 2, 131, 'CU/02/0131', 'Mr Marwan', '98110360', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '05:10:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (132, 2, 132, 'CU/02/0132', 'Mr Salim', '99353553', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '05:56:27 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (133, 2, 133, 'CU/02/0133', 'Mr Hussein Ali', '92426369', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '08:55:00 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (134, 2, 134, 'CU/02/0134', 'Mr Salah', '94467149', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '09:39:39 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (135, 2, 135, 'CU/02/0135', 'Mr Ahmad', '99623158', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'North Saham ', '', 'North Saham', NULL, NULL, NULL, NULL, NULL, '5.36.194.85', '5.36.194.85.dynamic-dsl-ip.omantel.net.om', '2024-10-10', '10:05:25 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (136, 2, 136, 'CU/02/0136', 'Mr Ghaith', '94173100', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.97.196', '5.37.97.196', '2024-10-11', '04:49:04 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (137, 2, 137, 'CU/02/0137', 'Mr Mohammad', '93533524', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.97.196', '5.37.97.196', '2024-10-11', '07:27:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (138, 2, 138, 'CU/02/0138', 'Mr Sayeed Suleiman', '94041615', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.80.170', '5.36.80.170.dynamic-dsl-ip.omantel.net.om', '2024-10-12', '05:15:12 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (139, 2, 139, 'CU/02/0139', 'Mr Rashid Al Buraiki', '99311778', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, '', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.239.49', '5.37.239.49.dynamic-dsl-ip.omantel.net.om', '2024-10-13', '10:55:27 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 50, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (140, 2, 140, 'CU/02/0140', 'Mr Mohammed Nasir', '99288895', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.128.171', '5.36.128.171.dynamic-dsl-ip.omantel.net.om', '2024-10-14', '11:08:25 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (141, 2, 141, 'CU/02/0141', 'Mohamed Al ansari', '95277972', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.220.198', '5.36.220.198.dynamic-dsl-ip.omantel.net.om', '2024-10-14', '05:52:08 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 51, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (142, 2, 142, 'CU/02/0142', 'Mr Faiza', '95517652', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.103.81', '5.36.103.81.dynamic-dsl-ip.omantel.net.om', '2024-10-15', '08:48:51 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (143, 2, 143, 'CU/02/0143', 'Mr Whales', '78765669', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.103.81', '5.36.103.81.dynamic-dsl-ip.omantel.net.om', '2024-10-15', '11:04:10 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (144, 2, 144, 'CU/02/0144', 'Mr Abdulraheem', '91217053', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.223.97', '5.36.223.97.dynamic-dsl-ip.omantel.net.om', '2024-10-17', '05:48:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (145, 2, 145, 'CU/02/0145', 'Mr Mohammed', '92983003', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.223.97', '5.36.223.97.dynamic-dsl-ip.omantel.net.om', '2024-10-17', '07:55:30 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (146, 2, 146, 'CU/02/0146', 'Mr Salim', '92372747', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.252.135', '5.36.252.135.dynamic-dsl-ip.omantel.net.om', '2024-10-18', '09:06:57 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (147, 2, 147, 'CU/02/0147', 'Mr Said', '99557797', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.160.148', '5.36.160.148.dynamic-dsl-ip.omantel.net.om', '2024-10-19', '04:49:47 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 52, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (148, 2, 148, 'CU/02/0148', 'Mr Ibrahim Al Ansari', '99823332', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', '2024-10-20', '05:16:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (149, 2, 149, 'CU/02/0149', 'Mr Issa', '96630117', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.167.26', '5.36.167.26.dynamic-dsl-ip.omantel.net.om', '2024-10-21', '05:50:22 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (150, 2, 150, 'CU/02/0150', 'Mr Mohammad', '97005086', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.65.219', '5.36.65.219.dynamic-dsl-ip.omantel.net.om', '2024-10-23', '10:47:26 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (151, 2, 151, 'CU/02/0151', 'Khalid Al mamary', '91448337', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.65.219', '5.36.65.219.dynamic-dsl-ip.omantel.net.om', '2024-10-23', '01:00:02 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 53, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (152, 2, 152, 'CU/02/0152', 'Hashi Al burki', '96551770', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.207.22', '5.36.207.22.dynamic-dsl-ip.omantel.net.om', '2024-10-23', '05:26:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 54, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (153, 2, 153, 'CU/02/0153', 'Mr Omar', '95581020', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.207.22', '5.36.207.22.dynamic-dsl-ip.omantel.net.om', '2024-10-23', '07:49:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (154, 2, 154, 'CU/02/0154', 'MR Omar Al shik', '96411337', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'Muscat', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.138.48', '5.36.138.48.dynamic-dsl-ip.omantel.net.om', '2024-10-24', '10:56:24 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 55, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (155, 2, 155, 'CU/02/0155', 'Mr Rashid Al Araimi', '95848636', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.138.48', '5.36.138.48.dynamic-dsl-ip.omantel.net.om', '2024-10-24', '08:19:47 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (156, 2, 156, 'CU/02/0156', 'Mr Soleiyman', '79463575', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.100.12', '5.37.100.12', '2024-10-25', '06:30:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (157, 2, 157, 'CU/02/0157', 'Mr Abdulmajid', '94174329', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.100.12', '5.37.100.12', '2024-10-25', '07:07:47 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (158, 2, 158, 'CU/02/0158', 'Mr Abdulrahman', '96481331', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.100.12', '5.37.100.12', '2024-10-25', '07:47:51 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (159, 2, 159, 'CU/02/0159', 'Mr Samid', '92640736', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.122.114', '5.37.122.114', '2024-10-27', '07:05:02 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (160, 2, 160, 'CU/02/0160', 'Mr Abdullah Ali', '92334942', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.122.114', '5.37.122.114', '2024-10-27', '09:12:46 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (161, 2, 161, 'CU/02/0161', 'Mr Omar', '97077072', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.122.114', '5.37.122.114', '2024-10-27', '10:35:59 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (162, 2, 162, 'CU/02/0162', 'ONEIC', '94990007', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.216.15', '5.37.216.15.dynamic-dsl-ip.omantel.net.om', '2024-10-28', '12:48:46 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 57, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (163, 2, 163, 'CU/02/0163', 'Zainab', '94295551', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.252.219', '5.37.252.219.dynamic-dsl-ip.omantel.net.om', '2024-10-29', '10:07:17 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (164, 2, 164, 'CU/02/0164', 'MrFaisal', '71958968', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.117.153', '5.36.117.153.dynamic-dsl-ip.omantel.net.om', '2024-10-29', '05:11:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (165, 2, 165, 'CU/02/0165', 'Mrs. Aniya', '71725955', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.117.153', '5.36.117.153.dynamic-dsl-ip.omantel.net.om', '2024-10-29', '06:49:56 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (166, 2, 166, 'CU/02/0166', 'Said  Al kasbi', '93393983', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.120.97', '5.36.120.97.dynamic-dsl-ip.omantel.net.om', '2024-10-30', '05:06:45 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, 58, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (167, 2, 167, 'CU/02/0167', 'Salim Al abdsalam', '99807373', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.120.97', '5.36.120.97.dynamic-dsl-ip.omantel.net.om', '2024-10-30', '05:16:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 59, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (168, 2, 168, 'CU/02/0168', 'Mr Abdullah', '95558181', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.253.164', '5.37.253.164.dynamic-dsl-ip.omantel.net.om', '2024-10-31', '11:15:39 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (169, 2, 169, 'CU/02/0169', 'Mr Abdullah', '96115588', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.223.188', '5.37.223.188.dynamic-dsl-ip.omantel.net.om', '2024-10-31', '04:59:05 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 60, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (170, 2, 170, 'CU/02/0170', 'Mr Mohand', '958626251', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.223.188', '5.37.223.188.dynamic-dsl-ip.omantel.net.om', '2024-10-31', '06:35:32 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (171, 2, 171, 'CU/02/0171', 'Mr Mohammed Al Buraiki', '92972227', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', '', '391', 'Al Batinah North', NULL, NULL, NULL, NULL, NULL, '5.36.101.33', '5.36.101.33.dynamic-dsl-ip.omantel.net.om', '2024-11-01', '05:36:32 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (172, 2, 172, 'CU/02/0172', 'Mr Abdullah', '90444430', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'saham', '391', 'Al Batinah North', NULL, NULL, NULL, NULL, NULL, '5.36.101.33', '5.36.101.33.dynamic-dsl-ip.omantel.net.om', '2024-11-01', '05:45:41 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (173, 2, 173, 'CU/02/0173', 'Mr Abdul Hakim', '95770885', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.229.53', '5.37.229.53.dynamic-dsl-ip.omantel.net.om', '2024-11-02', '10:20:19 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (174, 2, 174, 'CU/02/0174', 'Mr Mazin', '98241460', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.229.53', '5.37.229.53.dynamic-dsl-ip.omantel.net.om', '2024-11-02', '07:36:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (175, 2, 175, 'CU/02/0175', 'Mr Suleiman', '92723238', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.229.53', '5.37.229.53.dynamic-dsl-ip.omantel.net.om', '2024-11-02', '07:57:40 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (176, 2, 176, 'CU/02/0176', 'Mr Fahad', '97447500', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.92.142', '5.36.92.142.dynamic-dsl-ip.omantel.net.om', '2024-11-03', '07:57:03 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (177, 2, 177, 'CU/02/0177', 'Mr Badar', '99722211', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.252.146', '5.36.252.146.dynamic-dsl-ip.omantel.net.om', '2024-11-04', '10:09:35 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (178, 2, 178, 'CU/02/0178', 'Mr Suleiman Al Buraiki', '72000852', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.74.250', '5.36.74.250.dynamic-dsl-ip.omantel.net.om', '2024-11-05', '04:27:40 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (179, 2, 179, 'CU/02/0179', 'Mr Suleiman', '96654502', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.233.220', '5.37.233.220.dynamic-dsl-ip.omantel.net.om', '2024-11-06', '11:07:21 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (180, 2, 180, 'CU/02/0180', 'Mr Fahad Al Rashdi', '72667244', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.193.117', '5.36.193.117.dynamic-dsl-ip.omantel.net.om', '2024-11-07', '08:35:35 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (181, 2, 181, 'CU/02/0181', 'Mr Mazin', '95996956', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.193.117', '5.36.193.117.dynamic-dsl-ip.omantel.net.om', '2024-11-07', '10:18:21 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (182, 2, 182, 'CU/02/0182', 'Mr Khalifa', '92295115', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.193.117', '5.36.193.117.dynamic-dsl-ip.omantel.net.om', '2024-11-07', '05:25:19 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (183, 2, 183, 'CU/02/0183', 'Mr Hussein Ali', '95119905', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.193.117', '5.36.193.117.dynamic-dsl-ip.omantel.net.om', '2024-11-07', '06:21:23 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (184, 2, 184, 'CU/02/0184', 'Mr Rashid', '91005150', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.126.129', '5.36.126.129.dynamic-dsl-ip.omantel.net.om', '2024-11-08', '06:49:42 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (185, 2, 185, 'CU/02/0185', 'Mr Alkhatab', '98164555', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.229.120', '5.36.229.120.dynamic-dsl-ip.omantel.net.om', '2024-11-09', '09:18:08 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (186, 2, 186, 'CU/02/0186', 'Mr Ahmad', '95393342', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.212.197', '5.36.212.197.dynamic-dsl-ip.omantel.net.om', '2024-11-09', '06:34:26 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (187, 2, 187, 'CU/02/0187', 'Mr Jalwali', '71169699', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.220.63', '5.36.220.63.dynamic-dsl-ip.omantel.net.om', '2024-11-12', '07:54:24 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (188, 2, 188, 'CU/02/0188', 'Mr Mohammad Al Ansari', '92702007', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.255.141', '5.36.255.141.dynamic-dsl-ip.omantel.net.om', '2024-11-14', '05:50:00 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (189, 2, 189, 'CU/02/0189', 'Mr Mohammad', '77203016', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.70.44', '5.36.70.44.dynamic-dsl-ip.omantel.net.om', '2024-11-15', '06:55:24 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (190, 2, 190, 'CU/02/0190', 'Mr Saud Al Mamari', '90778887', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.75.36', '5.36.75.36.dynamic-dsl-ip.omantel.net.om', '2024-11-16', '11:44:59 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (191, 2, 191, 'CU/02/0191', 'Mr Abdullah', '93825225', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.132.95', '5.36.132.95.dynamic-dsl-ip.omantel.net.om', '2024-11-17', '12:24:46 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (192, 2, 192, 'CU/02/0192', 'Abdul juma', '96959535', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.185.22', '5.36.185.22.dynamic-dsl-ip.omantel.net.om', '2024-11-17', '06:36:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', 61, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (193, 2, 193, 'CU/02/0193', 'Monther', '90952535', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.141.14', '5.36.141.14.dynamic-dsl-ip.omantel.net.om', '2024-11-19', '12:14:58 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', 62, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (194, 2, 194, 'CU/02/0194', 'Mohamad Salim Al buraki', '92974664', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.36.141.14', '5.36.141.14.dynamic-dsl-ip.omantel.net.om', '2024-11-19', '12:53:28 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 63, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (195, 2, 195, 'CU/02/0195', 'MR AHMED ABDULLAH', '95368019', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.37.230.13', '5.37.230.13.dynamic-dsl-ip.omantel.net.om', '2024-11-21', '10:19:16 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (196, 2, 196, 'CU/02/0196', 'Mr Tariq Khalid', '99331933', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Batinah ', '', 'Kahboura', NULL, NULL, NULL, NULL, NULL, '5.37.230.13', '5.37.230.13.dynamic-dsl-ip.omantel.net.om', '2024-11-21', '10:28:11 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (197, 2, 197, 'CU/02/0197', 'Mr Obaid', '95773367', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah North ', NULL, NULL, NULL, NULL, NULL, '5.36.178.188', '5.36.178.188.dynamic-dsl-ip.omantel.net.om', '2024-11-22', '08:19:54 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (198, 2, 198, 'CU/02/0198', 'Mr Said', '92217973', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.123.100', '5.37.123.100', '2024-11-23', '08:28:19 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (199, 2, 199, 'CU/02/0199', 'Mr Gaith', '93380058', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.255.80', '5.36.255.80.dynamic-dsl-ip.omantel.net.om', '2024-11-24', '09:51:17 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (200, 2, 200, 'CU/02/0200', 'Mr Saif Mohammed', '9957779', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.251.86', '5.37.251.86.dynamic-dsl-ip.omantel.net.om', '2024-11-24', '04:34:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (201, 2, 201, 'CU/02/0201', 'Mr Ahmed', '92090221', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.251.86', '5.37.251.86.dynamic-dsl-ip.omantel.net.om', '2024-11-24', '05:59:56 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (202, 2, 202, 'CU/02/0202', 'Mr Mohamed Al Maruqi', '99169889', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.194.17', '5.37.194.17.dynamic-dsl-ip.omantel.net.om', '2024-11-25', '05:40:51 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (203, 2, 203, 'CU/02/0203', 'Mr Ghassn', '95271693', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.194.17', '5.37.194.17.dynamic-dsl-ip.omantel.net.om', '2024-11-25', '08:31:03 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (204, 2, 204, 'CU/02/0204', 'Mr Salim', '90906833', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Batinah North Saham ', '', 'North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.194.17', '5.37.194.17.dynamic-dsl-ip.omantel.net.om', '2024-11-25', '09:09:31 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (205, 2, 205, 'CU/02/0205', 'Mr Salim', '95133306', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.68.112', '5.36.68.112.dynamic-dsl-ip.omantel.net.om', '2024-11-28', '08:18:14 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (206, 2, 206, 'CU/02/0206', 'MR Saif', '99205242', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.108.1', '5.37.108.1', '2024-11-30', '04:48:57 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (207, 2, 207, 'CU/02/0207', 'Mr Hamed Al Badi', '99336863', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.108.1', '5.37.108.1', '2024-11-30', '06:44:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (208, 2, 208, 'CU/02/0208', 'Mr Mohamed', '92139054', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.108.1', '5.37.108.1', '2024-11-30', '07:12:29 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (209, 2, 209, 'CU/02/0209', 'Mr Naseer', '99009726', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.132.164', '5.36.132.164.dynamic-dsl-ip.omantel.net.om', '2024-12-01', '11:37:40 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (210, 2, 210, 'CU/02/0210', 'Mr Khalfan', '97019889', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.132.164', '5.36.132.164.dynamic-dsl-ip.omantel.net.om', '2024-12-01', '12:31:30 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (211, 2, 211, 'CU/02/0211', 'Mr Sultan', '92932444', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.226.164', '5.36.226.164.dynamic-dsl-ip.omantel.net.om', '2024-12-01', '05:26:00 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (212, 2, 212, 'CU/02/0212', 'Mr Gahsan', '99088489', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.246.105', '5.37.246.105.dynamic-dsl-ip.omantel.net.om', '2024-12-02', '07:07:44 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (213, 2, 213, 'CU/02/0213', 'Mr Rashid Abdullah', '92557234', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.243.179', '5.37.243.179.dynamic-dsl-ip.omantel.net.om', '2024-12-03', '08:55:10 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (214, 2, 214, 'CU/02/0214', 'Mr Jihad', '99266652', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.243.179', '5.37.243.179.dynamic-dsl-ip.omantel.net.om', '2024-12-03', '12:10:28 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (215, 2, 215, 'CU/02/0215', 'Al Mamri', '98099699', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.242.1', '5.37.242.1.dynamic-dsl-ip.omantel.net.om', '2024-12-03', '04:33:22 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (216, 2, 216, 'CU/02/0216', 'Mr Almunther', '97672329', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.181.123', '5.36.181.123.dynamic-dsl-ip.omantel.net.om', '2024-12-04', '09:36:29 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (217, 2, 217, 'CU/02/0217', 'Mr Hamid Ali', '99633366', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.181.123', '5.36.181.123.dynamic-dsl-ip.omantel.net.om', '2024-12-04', '04:24:47 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (218, 2, 218, 'CU/02/0218', 'Mr Al Moatasen', '94890056', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.181.123', '5.36.181.123.dynamic-dsl-ip.omantel.net.om', '2024-12-04', '06:38:41 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (219, 2, 219, 'CU/02/0219', 'Mr Musabah', '95291415', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.181.123', '5.36.181.123.dynamic-dsl-ip.omantel.net.om', '2024-12-04', '07:35:23 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (220, 2, 220, 'CU/02/0220', 'Mr Omar', '92266620', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.162.29', '5.36.162.29.dynamic-dsl-ip.omantel.net.om', '2024-12-05', '08:02:46 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (221, 2, 221, 'CU/02/0221', 'Mr Alyaqdhan', '98998350', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.123.70', '5.37.123.70', '2024-12-06', '05:59:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (222, 2, 222, 'CU/02/0222', 'Mr Rhma', '92598036', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.95.76', '5.36.95.76.dynamic-dsl-ip.omantel.net.om', '2024-12-07', '04:45:02 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (223, 2, 223, 'CU/02/0223', 'Mr Hilal Amin', '98055987', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.95.76', '5.36.95.76.dynamic-dsl-ip.omantel.net.om', '2024-12-07', '06:16:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 64, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (224, 2, 224, 'CU/02/0224', 'Mr Ahmed Abdullah', '94528311', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.214.12', '5.37.214.12.dynamic-dsl-ip.omantel.net.om', '2024-12-09', '04:19:02 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (225, 2, 225, 'CU/02/0225', 'Hilal Al badi', '94007790', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '5.37.214.12', '5.37.214.12.dynamic-dsl-ip.omantel.net.om', '2024-12-09', '04:50:03 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 65, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (226, 2, 226, 'CU/02/0226', 'Mr Zakariya', '90657199', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'North Batinah Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.214.12', '5.37.214.12.dynamic-dsl-ip.omantel.net.om', '2024-12-09', '05:11:40 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (227, 2, 227, 'CU/02/0227', 'Mr Ibrahim', '92383741', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.82.89', '5.36.82.89.dynamic-dsl-ip.omantel.net.om', '2024-12-11', '06:47:11 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (228, 2, 228, 'CU/02/0228', 'Mr Mohammed Ali', '99613118', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.82.89', '5.36.82.89.dynamic-dsl-ip.omantel.net.om', '2024-12-11', '07:57:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (229, 2, 229, 'CU/02/0229', 'Mr Ahmed', '99637345', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.200.173', '5.36.200.173.dynamic-dsl-ip.omantel.net.om', '2024-12-14', '05:15:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (230, 2, 230, 'CU/02/0230', 'Mr Sami', '92151167', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Suwaq', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.200.173', '5.36.200.173.dynamic-dsl-ip.omantel.net.om', '2024-12-14', '07:38:58 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (231, 2, 231, 'CU/02/0231', 'Mr Mohammed', '92481010', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.193.149', '5.36.193.149.dynamic-dsl-ip.omantel.net.om', '2024-12-16', '08:11:38 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (232, 2, 232, 'CU/02/0232', 'Mr Said', '99619079', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.222.149', '5.37.222.149.dynamic-dsl-ip.omantel.net.om', '2024-12-18', '11:24:56 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (233, 2, 233, 'CU/02/0233', 'Mr Munthasir', '95059042', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.163.243', '5.36.163.243.dynamic-dsl-ip.omantel.net.om', '2024-12-18', '06:14:55 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (234, 2, 234, 'CU/02/0234', 'Mr Mohammed', '93179990', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.163.243', '5.36.163.243.dynamic-dsl-ip.omantel.net.om', '2024-12-18', '08:17:58 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (235, 2, 235, 'CU/02/0235', 'Mr Mohammed', '97569918', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.143.87', '5.36.143.87.dynamic-dsl-ip.omantel.net.om', '2024-12-20', '05:02:45 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (236, 2, 236, 'CU/02/0236', 'Mr Ali', '95584313', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.155.59', '5.36.155.59.dynamic-dsl-ip.omantel.net.om', '2024-12-24', '09:59:32 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (237, 2, 237, 'CU/02/0237', 'Mr Saif', '92927389', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.155.59', '5.36.155.59.dynamic-dsl-ip.omantel.net.om', '2024-12-24', '01:13:19 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (238, 2, 238, 'CU/02/0238', 'Mr Salem', '95404840', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.74.154', '5.36.74.154.dynamic-dsl-ip.omantel.net.om', '2024-12-25', '11:25:21 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (239, 2, 239, 'CU/02/0239', 'Mr Salem', '97333791', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.97.76', '5.37.97.76', '2024-12-26', '12:24:13 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (240, 2, 240, 'CU/02/0240', 'Mr Zayid', '99005494', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.97.76', '5.37.97.76', '2024-12-26', '01:16:46 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (241, 2, 241, 'CU/02/0241', 'Mr Salim', '97865337', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.141.172', '5.36.141.172.dynamic-dsl-ip.omantel.net.om', '2024-12-27', '05:24:01 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (242, 2, 242, 'CU/02/0242', 'Mr Nawaf', '+971506136510', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.143.178', '5.36.143.178.dynamic-dsl-ip.omantel.net.om', '2024-12-29', '12:57:56 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 66, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (243, 2, 243, 'CU/02/0243', 'Mr Taher', '92690493', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', '2024-12-29', '09:17:15 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (244, 2, 244, 'CU/02/0244', 'Mr Rashid', '95560160', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.233.223', '5.37.233.223.dynamic-dsl-ip.omantel.net.om', '2024-12-31', '09:11:10 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (245, 2, 245, 'CU/02/0245', 'Mr Ali', '91944734', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.217.136', '5.36.217.136.dynamic-dsl-ip.omantel.net.om', '2024-12-31', '06:53:20 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (246, 2, 246, 'CU/02/0246', 'Vision Consultant Engineering', '9711 5588', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.204.0', '5.36.204.0.dynamic-dsl-ip.omantel.net.om', '2025-01-01', '08:03:35 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (247, 2, 247, 'CU/02/0247', 'Mr Mohammed', '99266679', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.227.215', '5.37.227.215.dynamic-dsl-ip.omantel.net.om', '2025-01-02', '12:03:18 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (248, 2, 248, 'CU/02/0248', 'Amar', '99669696', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'Muscat', '', '', '', NULL, NULL, NULL, NULL, NULL, '188.135.85.249', 'dynamic.isp.ooredoo.om', '2025-01-02', '09:56:22 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 67, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (249, 2, 249, 'CU/02/0249', 'Mr Abdullah Salem', '95952644', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah 2', NULL, NULL, NULL, NULL, NULL, '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '2025-01-03', '05:35:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (250, 2, 250, 'CU/02/0250', 'Mr Basel', '94166604', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '2025-01-03', '07:46:44 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (251, 2, 251, 'CU/02/0251', 'Mr Rashid', '96668465', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '2025-01-03', '08:45:52 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (252, 2, 252, 'CU/02/0252', 'Mr Majeed', '94445299', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '2025-01-03', '09:55:40 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (253, 2, 253, 'CU/02/0253', 'Mr Said', '79970696', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.162.133', '5.36.162.133.dynamic-dsl-ip.omantel.net.om', '2025-01-04', '06:55:05 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (254, 2, 254, 'CU/02/0254', 'Mr Abdulaziz', '96679967', '', '', '', '', NULL, '0.0000', NULL, NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.162.133', '5.36.162.133.dynamic-dsl-ip.omantel.net.om', '2025-01-04', '07:52:31 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, 68, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (255, 2, 255, 'CU/02/0255', 'Mr Yousuf Abdullah', '94777449', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.239.81', '5.36.239.81.dynamic-dsl-ip.omantel.net.om', '2025-01-05', '10:31:51 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, 69, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (256, 2, 256, 'CU/02/0256', 'Mr Sultan', '96973992', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.68.137', '5.36.68.137.dynamic-dsl-ip.omantel.net.om', '2025-01-06', '05:07:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (257, 2, 257, 'CU/02/0257', 'Mr Ahmed', '95124413', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.252.56', '5.37.252.56.dynamic-dsl-ip.omantel.net.om', '2025-01-07', '12:04:16 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (258, 2, 258, 'CU/02/0258', 'Mr Ali', '97115588', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.252.56', '5.37.252.56.dynamic-dsl-ip.omantel.net.om', '2025-01-07', '08:19:53 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (259, 2, 259, 'CU/02/0259', 'Mr Ebrahim Al bureki', '99882282+', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', '2025-01-08', '11:13:39 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (260, 2, 260, 'CU/02/0260', 'Mr Abdullah', '98828555', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.126.15', '5.37.126.15', '2025-01-10', '05:21:29 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (261, 2, 261, 'CU/02/0261', 'Mr Faisal', '94443403', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'saham', '', 'batina', NULL, NULL, NULL, NULL, NULL, '5.37.126.15', '5.37.126.15', '2025-01-10', '09:45:48 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (262, 2, 262, 'CU/02/0262', 'Mr Mohamed', '97720041', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.203.142', '5.37.203.142.dynamic-dsl-ip.omantel.net.om', '2025-01-11', '05:35:21 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (263, 2, 263, 'CU/02/0263', 'Mr Alwakas', '77116095', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.81.211', '5.36.81.211.dynamic-dsl-ip.omantel.net.om', '2025-01-12', '06:46:32 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (264, 2, 264, 'CU/02/0264', 'Mr Said', '99439483', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Sahx ', '', 'Khaboura', NULL, NULL, NULL, NULL, NULL, '5.36.87.47', '5.36.87.47.dynamic-dsl-ip.omantel.net.om', '2025-01-14', '10:22:01 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (265, 2, 265, 'CU/02/0265', 'Mr Mohammed', '92222769', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'saham', '391', 'Batina', NULL, NULL, NULL, NULL, NULL, '5.36.87.47', '5.36.87.47.dynamic-dsl-ip.omantel.net.om', '2025-01-14', '10:10:12 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (266, 2, 266, 'CU/02/0266', 'Mr Khamis', '99246483', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '', 'Batina', NULL, NULL, NULL, NULL, NULL, '5.37.229.194', '5.37.229.194.dynamic-dsl-ip.omantel.net.om', '2025-01-18', '09:47:57 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (267, 2, 267, 'CU/02/0267', 'Mr Yousuf', '77043676', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.229.194', '5.37.229.194.dynamic-dsl-ip.omantel.net.om', '2025-01-18', '01:10:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (268, 2, 268, 'CU/02/0268', 'Mr Mohammad', '91917296', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, NULL, '', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.197.128', '5.36.197.128.dynamic-dsl-ip.omantel.net.om', '2025-01-22', '08:23:25 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '0.0000', 70, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (269, 2, 269, 'CU/02/0269', 'Mr Munir', '94362662', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.192.45', '5.37.192.45.dynamic-dsl-ip.omantel.net.om', '2025-01-24', '07:07:43 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (270, 2, 270, 'CU/02/0270', 'Mr Omar', '93535115', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.192.45', '5.37.192.45.dynamic-dsl-ip.omantel.net.om', '2025-01-24', '08:16:51 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (271, 2, 271, 'CU/02/0271', 'Mr Ali Ali', '92124918', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batina', NULL, NULL, NULL, NULL, NULL, '5.36.141.213', '5.36.141.213.dynamic-dsl-ip.omantel.net.om', '2025-01-25', '10:10:26 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (272, 2, 272, 'CU/02/0272', 'Mr Hamid', '98821977', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.141.213', '5.36.141.213.dynamic-dsl-ip.omantel.net.om', '2025-01-25', '04:50:17 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (273, 2, 273, 'CU/02/0273', 'Mr Saif', '97209808', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.161.7', '5.36.161.7.dynamic-dsl-ip.omantel.net.om', '2025-01-26', '05:01:37 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (274, 2, 274, 'CU/02/0274', 'ABUL Khamis Al Badi', '99889016', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.161.7', '5.36.161.7.dynamic-dsl-ip.omantel.net.om', '2025-01-26', '07:58:25 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (275, 2, 275, 'CU/02/0275', 'Mr Salem', '99333616', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.161.7', '5.36.161.7.dynamic-dsl-ip.omantel.net.om', '2025-01-26', '09:01:19 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (276, 2, 276, 'CU/02/0276', 'Mr Majeed', '95224889', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.161.7', '5.36.161.7.dynamic-dsl-ip.omantel.net.om', '2025-01-26', '09:09:54 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (277, 2, 277, 'CU/02/0277', 'Mr Salem', '92682795', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.137.49', '5.36.137.49.dynamic-dsl-ip.omantel.net.om', '2025-01-27', '07:10:19 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (278, 2, 278, 'CU/02/0278', 'Mr Fahad', '94391954', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '391', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.137.49', '5.36.137.49.dynamic-dsl-ip.omantel.net.om', '2025-01-27', '08:04:24 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (279, 2, 279, 'CU/02/0279', 'Dilshad Ahmad', '0', '', '', '', '', NULL, '0.0000', NULL, NULL, NULL, NULL, 'North Batinah', 'Saham', '391', 'Batina', NULL, NULL, NULL, NULL, NULL, '5.36.137.49', '5.36.137.49.dynamic-dsl-ip.omantel.net.om', '2025-01-27', '09:29:45 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (280, 2, 280, 'CU/02/0280', 'Mr Asan', '93928288', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.70.85', '5.36.70.85.dynamic-dsl-ip.omantel.net.om', '2025-01-28', '04:28:27 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (281, 2, 281, 'CU/02/0281', 'Mr salim', '99224699', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.183.235', '5.36.183.235.dynamic-dsl-ip.omantel.net.om', '2025-01-30', '06:57:54 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (282, 2, 282, 'CU/02/0282', 'Mr Mohammed', '99718208', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batina', NULL, NULL, NULL, NULL, NULL, '5.36.183.235', '5.36.183.235.dynamic-dsl-ip.omantel.net.om', '2025-01-30', '07:50:05 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (283, 2, 283, 'CU/02/0283', 'Mr Junaid', '92553098', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.123.153', '5.36.123.153.dynamic-dsl-ip.omantel.net.om', '2025-01-31', '08:46:29 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (284, 2, 284, 'CU/02/0284', 'Mr Hamed', '93387798', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham', '391', 'Batina', NULL, NULL, NULL, NULL, NULL, '5.37.251.165', '5.37.251.165.dynamic-dsl-ip.omantel.net.om', '2025-02-01', '12:31:05 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (285, 2, 285, 'CU/02/0285', 'Mr Ali', '99478534', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', 'Saham ', '', 'Batinah North Saham ', NULL, NULL, NULL, NULL, NULL, '5.36.153.38', '5.36.153.38.dynamic-dsl-ip.omantel.net.om', '2025-02-03', '04:51:50 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (286, 2, 286, 'CU/02/0286', 'Mr Said', '97004117', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.36.153.38', '5.36.153.38.dynamic-dsl-ip.omantel.net.om', '2025-02-03', '08:57:11 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `governorate`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`, `channel`) VALUES (287, 2, 287, 'CU/02/0287', 'Mr Mohammad', '92285959', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, 'North Batinah', 'Saham ', '', 'Batinah ', NULL, NULL, NULL, NULL, NULL, '5.37.206.228', '5.37.206.228.dynamic-dsl-ip.omantel.net.om', '2025-02-05', '12:25:32 pm', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', NULL, NULL, '');


#
# TABLE STRUCTURE FOR: db_emailtemplates
#

DROP TABLE IF EXISTS `db_emailtemplates`;

CREATE TABLE `db_emailtemplates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `key` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `template_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `content` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `variables` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  `undelete_bit` int DEFAULT NULL,
  `admin_only` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (1, 1, 'SAAS_FORGOT_PASSWORD_EMAIL', 'Site forgot password email template', 'Hi {{user_name}},\r\n\r\nyour OTP is {{email_otp}}\r\n\r\nThank you\r\n{{saas_name}}', '{{user_name}}<br>\r\n{{saas_name}}<br>\r\n{{email_otp}}<br>', 1, 1, 1);
INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (2, 1, 'SAAS_WELCOME_EMAIL', 'Site welcome email', 'Hi {{user_name}},\r\nYour email id {{email_id}},\r\nwelcome to our {{saas_name}},\r\n\r\nThank you', '{{user_name}}<br>\r\n{{email_id}}<br>\r\n{{saas_name}}<br>', 1, 1, 1);


#
# TABLE STRUCTURE FOR: db_expense
#

DROP TABLE IF EXISTS `db_expense`;

CREATE TABLE `db_expense` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Expense Code',
  `expense_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expense_for` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expense_amt` double(20,4) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `account_id` (`account_id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (11, 2, 1, 'EX/2021/02/0001', 9, '2024-10-08', '491930463', 'Staff Accomodation', '50.0000', 'Bank Transfer', NULL, 'Paid', 'Admin', '2024-10-08', '10:02:40 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (12, 2, 12, 'EX/2021/02/0012', 5, '2024-10-08', '491931196', '1ST Line GSM Mobile Recharge', '10.0000', 'Bank Transfer', NULL, 'Mobile Recharge', 'Admin', '2024-10-08', '10:09:10 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (13, 2, 13, 'EX/2021/02/0013', 11, '2024-10-08', '', 'Social insurance protection', '8.5480', 'Bank Transfer', NULL, '', 'Admin', '2024-10-08', '10:19:25 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (14, 2, 14, 'EX/2021/02/0014', 12, '2024-10-08', '491931638', 'Internet subscription', '31.7650', 'Bank Transfer', NULL, '', 'Admin', '2024-10-08', '10:23:24 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (15, 2, 15, 'EX/2021/02/0015', 2, '2024-10-08', '491931935', 'Electricity bills shop1', '30.0000', 'Bank Transfer', NULL, '', 'Admin', '2024-10-08', '10:26:36 am', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (18, 2, 18, 'EX/2021/02/0018', 2, '2024-11-18', '', 'SHOP 3', '10.0000', 'Visa', NULL, '', 'Admin', '2024-11-18', '12:34:52 pm', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (19, 2, 19, 'EX/2021/02/0019', 2, '2024-11-18', '', 'SHOP 4', '3.0000', 'Visa', NULL, '', 'Admin', '2024-11-18', '12:35:49 pm', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (20, 2, 20, 'EX/2021/02/0020', 2, '2024-11-18', '', 'Employee Accomodation', '20.0000', 'Visa', NULL, '', 'Admin', '2024-11-18', '12:36:44 pm', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (21, 2, 21, 'EX/2021/02/0021', 3, '2024-11-18', '', 'Employee Accomodation', '12.0000', 'Visa', NULL, '', 'Admin', '2024-11-18', '12:40:22 pm', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (22, 2, 22, 'EX/2021/02/0022', 2, '2024-11-18', '', 'SHOP 1', '25.0000', 'Visa', NULL, '', 'Admin', '2024-11-18', '12:45:01 pm', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (23, 2, 23, 'EX/2021/02/0023', 4, '2024-11-18', '', 'OFFICE INTERNET SUBSCRIPTION', '32.0000', 'Visa', NULL, '', 'Admin', '2024-11-18', '12:46:05 pm', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (24, 2, 24, 'EX/2021/02/0024', 5, '2024-11-18', '', 'Firstline phone bills', '11.0000', 'Visa', NULL, '', 'Admin', '2024-11-18', '12:46:54 pm', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (25, 2, 25, 'EX/2021/02/0025', 9, '2024-11-18', '', 'House Rent', '50.0000', 'Visa', NULL, '', 'Admin', '2024-11-18', '04:21:21 pm', '5.36.199.52', '5.36.199.52.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (26, 2, 26, 'EX/2021/02/0026', 14, '2024-11-18', '', 'Social security protection', '8.0270', 'Visa', NULL, '', 'Admin', '2024-11-18', '04:23:23 pm', '5.36.199.52', '5.36.199.52.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (27, 2, 27, 'EX/2021/02/0027', 10, '2024-11-26', 'Payment for wrkshp price list printing', 'Al Labeeb A3 Price List Printing', '1.1000', 'Visa', NULL, 'Payment for wrkshp price list printing\r\nDate 24/11/2024', 'Admin', '2024-11-26', '08:52:44 pm', '5.36.193.162', '5.36.193.162.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (28, 2, 28, 'EX/2021/02/0028', 10, '2024-11-27', 'Nissan Sunny ', 'Car wash', '1.5000', 'Cash', NULL, 'Car wash\r\nDate: 27/11/2024', 'Admin', '2024-11-27', '11:15:03 am', '5.36.101.142', '5.36.101.142.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (29, 2, 29, 'EX/2021/02/0029', 3, '2024-12-10', '03-dec-2024', 'office drinking water', '5.6900', 'Visa', NULL, '', 'Admin', '2024-12-10', '09:15:56 am', '185.185.133.69', '185.185.133.69', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (30, 2, 30, 'EX/2021/02/0030', 10, '2025-01-27', 'Ahmad Advance Salary Payment', 'Dilshad Ahmad', '25.0000', 'Cash', NULL, 'Advance Salary payment from Income Cash', 'Admin', '2025-01-27', '08:59:12 pm', '5.36.137.49', '5.36.137.49.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (31, 2, 31, 'EX/2021/02/0031', 10, '2025-01-29', '', 'Nissan sunny paint and repair', '50.0000', 'Cash', NULL, 'Nissan sunny reipar. Payed cash  withdrawal from atm.\r\nNiyaz   garage ', 'Admin', '2025-01-29', '09:43:21 pm', '188.135.25.55', '188.135.25.55', 1, 0, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (32, 2, 32, 'EX/2021/02/0032', 10, '2025-02-01', 'Mubarak said sulaiman tyer shop', 'Nissan sunny', '1.0000', 'Visa', NULL, 'Tyer reaper ', 'Admin', '2025-02-01', '08:21:52 pm', '188.135.25.55', '188.135.25.55', 1, 0, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (33, 2, 33, 'EX/2021/02/0033', 10, '2025-02-01', 'Oifc mylkia renew ', 'Nissan suny', '29.0500', 'Visa', NULL, 'Mylkia renew 18 rial\r\nTrafic fine 10 rial\r\nMulkia printing 1.050 rial', 'Admin', '2025-02-01', '08:26:06 pm', '188.135.25.55', '188.135.25.55', 1, 0, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (34, 2, 34, 'EX/2021/02/0034', 10, '2025-02-02', 'Nissan Sunny', 'Purchase of petrol', '8.6000', 'Visa', NULL, 'Petrol purchase ', 'Admin', '2025-02-02', '10:13:32 am', '5.37.254.168', '5.37.254.168.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Exclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (35, 2, 35, 'EX/2021/02/0035', 10, '2025-02-02', 'Sanad Office', 'Salary transfer charges', '1.0000', 'Visa', NULL, 'Salary transfer charges', 'Admin', '2025-02-02', '12:32:31 pm', '5.37.254.168', '5.37.254.168.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (36, 2, 36, 'EX/2021/02/0036', 10, '2025-02-02', 'Sudanese office', 'Service sticker charges', '3.0000', 'Visa', NULL, 'Service sticker bill: 3rial', 'Admin', '2025-02-02', '12:34:28 pm', '5.37.254.168', '5.37.254.168.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (37, 2, 37, 'EX/2021/02/0037', 10, '2025-02-02', 'Nissan sunny  ', 'Nissan suny', '5.0000', 'Cash', NULL, 'Nissan sunny steering cover and seat repair  cash from atm', 'Admin', '2025-02-02', '07:14:52 pm', '188.135.25.55', '188.135.25.55', 1, 0, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (38, 2, 38, 'EX/2021/02/0038', 10, '2025-02-02', 'Nissan sunny  cash from atm', 'Nissan suny', '10.0000', 'Cash', NULL, 'Nissan sunny tier purshes\r\nQty 1', 'Admin', '2025-02-02', '07:16:55 pm', '188.135.25.55', '188.135.25.55', 1, 0, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (39, 2, 39, 'EX/2021/02/0039', 10, '2025-02-04', 'Nissan sunny petrol ', 'Petrol.', '8.8000', 'Visa', NULL, 'Petrol', 'Admin', '2025-02-04', '05:21:28 pm', '5.162.96.146', 'dynamic.isp.ooredoo.om', 1, 0, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (40, 2, 40, 'EX/2021/02/0040', 4, '2025-02-05', 'Nissan Sunny', 'Car wash', '2.0000', 'Visa', NULL, 'Car wash', 'Admin', '2025-02-05', '07:46:21 pm', '5.37.206.228', '5.37.206.228.dynamic-dsl-ip.omantel.net.om', 1, 151, 'Inclusive');
INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `tax_id`, `tax_type`) VALUES (41, 2, 41, 'EX/2021/02/0041', 10, '2025-02-06', 'Nissan sunny   alignment ', 'Nissan sunny', '5.0000', 'Cash', NULL, 'Paid cash from ATM', 'Admin', '2025-02-06', '11:47:55 am', '5.162.96.146', 'dynamic.isp.ooredoo.om', 1, 0, 'Inclusive');


#
# TABLE STRUCTURE FOR: db_expense_category
#

DROP TABLE IF EXISTS `db_expense_category`;

CREATE TABLE `db_expense_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `category_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (1, 2, 'EC0001', 'FOOD', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (2, 2, 'EC0002', 'ELECTRICITY', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (3, 2, 'EC0003', 'WATER', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (4, 2, 'EC0004', 'INTERNET', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (5, 2, 'EC0005', 'PHONE', '', 'Manager', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (6, 2, 'EC0006', 'delivery', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (7, 2, 'EC0007', 'Gass', 'Staff Accomodation', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (8, 2, 'EC0008', 'WATER TANKER', 'OFFICE USE', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (9, 2, 'EC0009', 'EMPLOYEE ACCOMODATION', 'FOR STAFF', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (10, 2, 'EC0010', 'Expense', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (11, 2, 'EC0011', 'SPF Security', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (12, 2, 'EC0012', '1stLine Wrk/shp internet', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (13, 2, 'EC0013', 'Shop1', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (14, 2, 'EC0014', 'SPF', 'Social Security Protection', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_hold
#

DROP TABLE IF EXISTS `db_hold`;

CREATE TABLE `db_hold` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `reference_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'Temprary',
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_holditems
#

DROP TABLE IF EXISTS `db_holditems`;

CREATE TABLE `db_holditems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `hold_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`hold_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_instamojo
#

DROP TABLE IF EXISTS `db_instamojo`;

CREATE TABLE `db_instamojo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sandbox` int DEFAULT NULL,
  `api_key` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `api_token` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_instamojo` (`id`, `store_id`, `sandbox`, `api_key`, `api_token`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_instamojopayments
#

DROP TABLE IF EXISTS `db_instamojopayments`;

CREATE TABLE `db_instamojopayments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `buyer_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `amount` decimal(16,2) NOT NULL,
  `purpose` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `expires_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `send_sms` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `send_email` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `sms_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `email_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `shorturl` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `longurl` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `redirect_url` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `webhook` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `allow_repeated_payments` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `customer_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `modified_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_items
#

DROP TABLE IF EXISTS `db_items`;

CREATE TABLE `db_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create ITEM Code',
  `item_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `sku` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `hsn` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `unit_id` int DEFAULT NULL,
  `alert_qty` int DEFAULT NULL,
  `brand_id` int DEFAULT NULL,
  `lot_number` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `price` double(20,4) DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `purchase_price` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `profit_margin` double(20,2) DEFAULT NULL,
  `sales_price` double(20,4) DEFAULT NULL,
  `stock` double(20,2) DEFAULT NULL,
  `item_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `discount_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount` double(20,2) DEFAULT NULL,
  `service_bit` int DEFAULT '0',
  `seller_points` double(20,2) DEFAULT '0.00',
  `custom_barcode` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `item_group` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `child_bit` int DEFAULT '0',
  `mrp` double(20,4) DEFAULT NULL,
  `offer_value` float NOT NULL DEFAULT '0',
  `offer_on` int NOT NULL DEFAULT '0',
  `is_package` tinyint NOT NULL DEFAULT '0',
  `package_items` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (1, 2, 1, 'csm0001', 'mannol-5w40', 21, '4036021181257', '', 20, 100, 18, NULL, NULL, '4.0000', 151, '4.0000', 'Exclusive', '0.00', '4.0000', '241.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:21:14 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021181257', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (2, 2, 2, 'csm0002', 'mercedez-5w40', 21, 'A000989630817AAEW', '', 20, 100, 27, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '178.50', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:24:45 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', 'A000989630817AAEW', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (3, 2, 3, 'csm0003', 'mannol-5w30', 21, '4036021183107', '', 20, 100, 18, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '0.00', '3.5000', '53.50', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:26:44 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021183107', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (4, 2, 4, 'csm0004', 'mannol-0w20', 21, '4036021188607', '', 20, 100, 18, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '0.00', '4.0000', '96.50', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:30:07 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021188607', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (6, 2, 6, 'csm0006', '04152-YZZD3', 15, '04152YZZD3  ', '', 21, 5, 20, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '8.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:47:34 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '04152YZZD3  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (7, 2, 7, 'csm0007', '90915-YZZN2', 15, '90915YZZN2  ', '', 21, 5, 20, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '1.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:49:54 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '90915YZZN2  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (8, 2, 8, 'csm0008', '04152-YZZD8', 15, '04152YZZD8  ', '', 21, 5, 20, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '13.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '10:55:05 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '04152YZZD8  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (9, 2, 9, 'csm0009', '04152-YZZD4', 15, '04152YZZD4  ', '', 21, 5, 20, NULL, NULL, '3.5000', 151, '3.5000', 'Exclusive', '0.00', '3.5000', '16.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '11:10:28 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '04152YZZD4  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (10, 2, 10, 'csm0010', '04152YZZD6', 15, '04152YZZD6  ', '', 21, 5, 20, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '10.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '11:53:45 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '04152YZZD6  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (11, 2, 11, 'csm0011', '90915-YZZE2', 15, '90915YZZE2  ', '', 21, 5, 20, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '10.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '11:56:31 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '90915YZZE2  ', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (12, 2, 12, 'csm0012', '90915-YZZD4', 15, '90915YZZD4  ', '', 21, 5, 20, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '7.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '12:00:22 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '90915YZZD4  ', 'metal type', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (13, 2, 13, 'csm0013', 'Labor charge', 17, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '04:49:00 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (14, 2, 14, 'csm0014', 'mechanic inspection', 22, '111777994mvh', '', 21, 0, 28, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '12.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '06:04:03 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (15, 2, 15, 'csm0015', 'computer scan', 22, '11115544678fsk', '', 21, 0, 28, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '59.00', NULL, '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', '2024-07-18', '06:06:46 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (16, 2, 16, 'csm0016', 'Break service exchange', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '15.0000', 151, '15.0000', 'Inclusive', NULL, '15.0000', NULL, '', '5.36.241.204', '5.36.241.204.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '09:53:34 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', 'NA', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (18, 2, 18, 'csm0018', 'atf fluid exchange', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '20.0000', 151, '20.0000', 'Exclusive', NULL, '20.0000', NULL, NULL, '5.36.241.204', '5.36.241.204.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '10:35:56 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', 'NA', 'fluid change', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (19, 2, 19, 'csm0019', 'computer scan', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Exclusive', NULL, '5.0000', NULL, NULL, '5.36.241.204', '5.36.241.204.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '10:38:56 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', 'NA', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (20, 2, 20, 'csm0020', 'mechanic inspection service', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Exclusive', NULL, '5.0000', NULL, '', '5.36.241.204', '5.36.241.204.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '10:40:40 am', 'Admin', NULL, 1, 'Percentage', '100.00', 1, '0.00', 'NA', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (21, 2, 21, 'csm0021', 'Break bads', 19, '', '', 19, 0, 0, NULL, NULL, '20.0000', 151, '20.0000', 'Inclusive', '0.00', '20.0000', '9.00', NULL, '5.36.83.87', '5.36.83.87.dynamic-dsl-ip.omantel.net.om', '2024-07-22', '08:57:09 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (23, 2, 23, 'csm0023', 'Cabin filter', 20, '', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '0.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:22:24 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (24, 2, 24, 'csm0024', 'replace air filter', 25, 'service charge', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '8.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:23:30 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (25, 2, 25, 'csm0025', 'Fuel pump', 28, '', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '49.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:24:54 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (26, 2, 26, 'csm0026', 'Oil filter', 29, '', '', 21, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '77.50', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '08:34:02 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (29, 2, 29, 'csm0029', 'replace sparkplugs', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '4.4000', 151, '4.4000', 'Exclusive', NULL, '4.4000', NULL, '', '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '09:13:46 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '4560116440054', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (30, 2, 30, 'csm0030', 'f1l-sparkplugs', 22, '', '', 2, 0, 20, NULL, NULL, '4.4000', 151, '4.4000', 'Exclusive', '0.00', '4.4000', '21.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '09:38:11 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116440054', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (31, 2, 31, 'csm0031', 'nissan', 29, '152081HC0A', '', 2, 0, 0, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '0.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '09:47:29 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '152081HC0A', 'oil filter', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (32, 2, 32, 'csm0032', 'f1l-nissan oil filter', 22, '152081HC0A', '', 2, 0, 29, NULL, NULL, '2.5000', 151, '2.5000', 'Exclusive', '0.00', '2.5000', '15.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '09:51:20 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '152081HC0A', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (33, 2, 33, 'csm0033', 'replace front brake pads', 22, 'service charge', '', 21, 0, 19, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '43.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:17:36 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', 'labor charge ', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (34, 2, 34, 'csm0034', 'rear brake pads', 22, '4560116413089', '', 21, 0, 19, NULL, NULL, '25.0000', 151, '25.0000', 'Exclusive', '0.00', '25.0000', '53.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:20:17 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116413089', 'labor charge', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (35, 2, 35, 'csm0035', 'sparkplugs labor', 22, 'service charge', '', 21, 0, 0, NULL, NULL, '8.0000', 151, '8.0000', 'Exclusive', '0.00', '8.0000', '98.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:35:35 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (36, 2, 36, 'csm0036', 'petrol', 22, '', '', 20, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '102.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:37:06 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (37, 2, 37, 'csm0037', 'replace ac filter', 22, '', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '46.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '11:42:37 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (38, 2, 38, 'csm0038', 'fuel pump labor charge', 22, '', '', 21, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Exclusive', '0.00', '10.0000', '49.00', NULL, '5.36.233.111', '5.36.233.111.dynamic-dsl-ip.omantel.net.om', '2024-07-24', '12:09:42 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (39, 2, 39, 'csm0039', 'Change seal gazget', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', NULL, '10.0000', NULL, NULL, '5.36.87.208', '5.36.87.208.dynamic-dsl-ip.omantel.net.om', '2024-07-29', '08:38:22 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (40, 2, 40, 'csm0040', 'Break fluid', 21, '', '', 2, 0, 18, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '41.00', NULL, '5.36.87.208', '5.36.87.208.dynamic-dsl-ip.omantel.net.om', '2024-07-29', '08:40:24 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', 'Mannol break fluid ', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (41, 2, 41, 'csm0041', 'fuel pump seal', 22, 'xxk13cck0001', '', 2, 0, 0, NULL, NULL, '10.0000', 151, '10.0000', 'Exclusive', '10.00', '11.0000', '49.00', NULL, '5.36.219.132', '5.36.219.132.dynamic-dsl-ip.omantel.net.om', '2024-07-29', '06:01:23 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (42, 2, 42, 'csm0042', 'front brake-pads', 19, 'BRKPGLK011', '', 21, 3, 30, NULL, NULL, '35.0000', 151, '35.0000', 'Exclusive', '0.00', '35.0000', '4.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '11:24:53 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116435982', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (43, 2, 43, 'csm0043', 'ms-u0149n rear brake-pads', 19, '4560116413058', '', 21, 5, 30, NULL, NULL, '25.0000', 151, '25.0000', 'Inclusive', '0.00', '25.0000', '2.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '11:52:23 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116413058', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (44, 2, 44, 'csm0044', 'Carry out rear brake-pads replacement', 19, '4560116413669', '', 21, 10, 30, NULL, NULL, '23.0000', 151, '23.0000', 'Inclusive', '0.00', '23.0000', '0.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:04:39 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116413669', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (45, 2, 45, 'csm0045', 'ms-2413 front brake-pads', 19, '4560116414222', '', 21, 10, 30, NULL, NULL, '29.0000', 151, '29.0000', 'Inclusive', '0.00', '29.0000', '5.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:12:24 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116414222', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (46, 2, 46, 'csm0046', 'ms-1541 front brake-pads', 19, '4560116411184', '', 21, 10, 30, NULL, NULL, '29.0000', 151, '29.0000', 'Inclusive', '0.00', '29.0000', '5.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:33:01 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116411184', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (47, 2, 47, 'csm0047', 'ms-1542n rear brakpads', 19, '4560116411191', '', 21, 5, 0, NULL, NULL, '24.0000', 151, '24.0000', 'Inclusive', '0.00', '24.0000', '4.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:39:37 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116411191', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (48, 2, 48, 'csm0048', 'ms-u0072n f150 front brake-pads', 19, '4560116411832', '', 21, 0, 30, NULL, NULL, '32.0000', 151, '32.0000', 'Inclusive', '0.00', '32.0000', '2.00', NULL, '5.37.231.89', '5.37.231.89.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '12:51:50 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4560116411832', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (49, 2, 49, 'csm0049', 'gear oil 80w-90', 33, '4036021101064', '', 21, 0, 31, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '0.00', '4.5000', '0.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:11:40 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021101064', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (50, 2, 50, 'csm0050', 'gear oil 75w-90', 33, '4036021101903', '', 21, 0, 32, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '15.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:24:19 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021101903', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (51, 2, 51, 'csm0051', 'gear oil 75w-140', 33, '4036021102009', '', 21, 0, 33, NULL, NULL, '7.0000', 151, '7.0000', 'Inclusive', '0.00', '7.0000', '19.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:30:35 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021102009', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (52, 2, 52, 'csm0052', 'atf dexron VI 1ltr', 34, '4036021101057', '', 21, 0, 34, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '0.00', '4.0000', '2.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:39:24 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021101057', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (53, 2, 53, 'csm0053', 'atf-dexron VI 4ltrs', 34, '4036021401058', '', 21, 0, 34, NULL, NULL, '14.0000', 151, '14.0000', 'Inclusive', '0.00', '14.0000', '1.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:52:10 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021401058', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (54, 2, 54, 'csm0054', 'front diff replacement', 22, '4036021401058', '', 21, 0, 35, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '53.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '06:59:25 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021401058', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (55, 2, 55, 'csm0055', 'rear diff oil replacement', 22, '', '', 21, 0, 35, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '44.00', NULL, '5.37.219.15', '5.37.219.15.dynamic-dsl-ip.omantel.net.om', '2024-07-30', '07:05:28 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (56, 2, 56, 'csm0056', 'coolant exchange', 22, '', '', 21, 0, 18, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '43.00', NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '08:59:57 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (57, 2, 57, 'csm0057', 'radiator flush', 22, '', '', 21, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Exclusive', '0.00', '3.0000', '8.00', NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '09:01:14 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (58, 2, 58, 'csm0058', '5ltrs-mannol coolant', 22, '4036021157887', '', 21, 0, 18, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '89.00', NULL, '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', '2024-08-01', '09:02:55 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021157887', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (60, 2, 60, 'csm0060', 'Radiator flush', 22, '4036021894195', '', 21, 0, 18, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:17:48 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021894195', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (61, 2, 61, 'csm0061', '56Ceramo Ester', 22, '4036021982922', '', 2, 0, 18, NULL, NULL, '3.5000', 151, '3.5000', 'Exclusive', '0.00', '3.5000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:25:23 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021982922', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (63, 2, 63, 'csm0063', 'Injector cleaner', 22, '4036021894638', '', 2, 0, 18, NULL, NULL, '3.0000', 151, '3.0000', 'Exclusive', '0.00', '3.0000', '92.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:36:59 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '4036021894638', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (64, 2, 64, 'csm0064', 'Ac-delco pf63', 15, NULL, '', NULL, NULL, NULL, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', NULL, '3.5000', NULL, NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:41:26 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '195491660946', 'oil filters', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (65, 2, 65, 'csm0065', 'Ac-delco pf63', 29, '195491660946', '', 2, 7, 36, NULL, NULL, '3.5000', 151, '3.5000', 'Exclusive', '0.00', '3.5000', '5.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '05:44:25 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '195491660946', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (66, 2, 66, 'csm0066', 'Ac-delco pf48', 29, '193468688443', '', 2, 0, 36, NULL, NULL, '3.0000', 151, '3.0000', 'Exclusive', '0.00', '3.0000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '06:49:25 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '193468688443', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (67, 2, 67, 'csm0067', 'Ac-delco pf64', 29, '195491705081', '', 2, 0, 36, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '0.00', '3.5000', '10.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '06:53:56 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '195491705081', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (68, 2, 68, 'csm0068', 'Ac-delco pf457g', 29, '707773193907', '', 2, 0, 36, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '0.00', '3.5000', '11.00', NULL, '5.36.126.10', '5.36.126.10.dynamic-dsl-ip.omantel.net.om', '2024-08-05', '06:56:28 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '707773193907', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (69, 2, 69, 'csm0069', 'Nissan sunny petrol purchase', 35, '1234567', '', 20, 0, 37, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '75.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '09:43:42 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (70, 2, 70, 'csm0070', 'Office internet rental bill', 37, '1234567', '', 17, 0, 40, NULL, NULL, '31.0000', 151, '31.0000', 'Inclusive', '0.00', '31.0000', '55.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '10:09:16 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (71, 2, 71, 'csm0071', 'Cooking gas staff accommodation', 39, '1234567', '', 18, 0, 41, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '70.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '10:32:36 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (72, 2, 72, 'csm0072', 'Office drinking water', 41, '1234567', '', 21, 0, 38, NULL, NULL, '0.8000', 151, '0.8000', 'Exclusive', '0.00', '0.8000', '54.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '10:39:43 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (73, 2, 73, 'csm0073', 'Water tanker', 43, '1234567', '', 21, 0, 38, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '51.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '10:58:48 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (74, 2, 74, 'csm0074', '1st office electricity bills', 44, '1234567', '', 21, 0, 43, NULL, NULL, '20.0000', 151, '20.0000', 'Inclusive', '0.00', '20.0000', '53.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '11:10:17 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (75, 2, 75, 'csm0075', '2nd office electricity acct:', 44, '1234567', '', 21, 0, 43, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '51.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '11:14:39 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (76, 2, 76, 'csm0076', '3rd office electricity acct:', 44, '1234567', '', 21, 0, 43, NULL, NULL, '20.0000', 151, '20.0000', 'Inclusive', '0.00', '20.0000', '53.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '12:09:22 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (77, 2, 77, 'csm0077', '4th office electricity acct', 44, '1234567', '', 21, 0, 43, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '52.00', NULL, '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', '2024-08-07', '12:16:22 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (78, 2, 78, 'csm0078', 'staff flat rent', 39, '1234567', '', 21, 0, 41, NULL, NULL, '50.0000', 151, '50.0000', 'Inclusive', '0.00', '50.0000', '53.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '10:04:35 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (79, 2, 79, 'csm0079', 'staff accomodation water bill', 39, '1234567', '', 21, 0, 41, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '53.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '10:19:30 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (80, 2, 80, 'csm0080', 'staff accomodation electricity bill', 39, '1234567', '', 21, 0, 41, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '51.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '10:29:51 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (81, 2, 81, 'csm0081', 'Office line mobile recharge', 46, '1234567', '', 21, 0, 48, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '104.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '11:41:47 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (82, 2, 82, 'csm0082', 'sales of use oil', 38, '123456', '', 20, 0, 49, NULL, NULL, '22.0000', 151, '22.0000', 'Inclusive', '0.00', '22.0000', '99.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '11:56:07 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (83, 2, 83, 'csm0083', 'Manni salary advance', 47, '123456', '', 21, 0, 50, NULL, NULL, '22.0000', 151, '22.0000', 'Inclusive', '0.00', '22.0000', '501.00', NULL, '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '12:16:05 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', 'advance salary payment', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (84, 2, 84, 'csm0084', 'Employee accomodation internal bills', 39, '123', '', 21, 15, 41, NULL, NULL, '15.0000', 151, '15.0000', 'Inclusive', '0.00', '15.0000', '52.00', NULL, '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', '2024-08-08', '05:10:22 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234', '', 'Single', NULL, NULL, 0, '0.0000', '1500', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (85, 2, 85, 'csm0085', 'Rear Right Hub Bearing', 22, '123', '', 21, 0, 51, NULL, NULL, '15.0000', 151, '15.0000', 'Inclusive', '0.00', '15.0000', '49.00', NULL, '5.36.158.48', '5.36.158.48.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '11:28:29 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (86, 2, 86, 'csm0086', 'mekaniki', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '0.0000', 151, '0.0000', 'Exclusive', NULL, '0.0000', NULL, NULL, '5.37.228.140', '5.37.228.140.dynamic-dsl-ip.omantel.net.om', '2024-08-11', '06:00:55 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '123', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (87, 2, 87, 'csm0087', 'Al Labeeb bookshop printing center', 49, 'Printing press', '', 21, 0, 37, NULL, NULL, '3.3000', 151, '3.3000', 'Inclusive', '0.00', '3.3000', '1.00', NULL, '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '2024-08-19', '08:42:05 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (88, 2, 88, 'csm0088', 'House hold electronics', 50, '', '', 21, 0, 54, NULL, NULL, '3.7400', 151, '3.7400', 'Inclusive', '0.00', '3.7400', '1.00', NULL, '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '2024-08-20', '09:49:30 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (89, 2, 89, 'csm0089', 'Purchase of miscellaneous', 48, '', '', 21, 0, 55, NULL, NULL, '2.2900', 151, '2.2900', 'Inclusive', '0.00', '2.2900', '7.00', NULL, '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '2024-08-20', '10:04:06 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (90, 2, 90, 'csm0090', 'Throttle Service', 22, '', '', 21, 0, 29, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '106.00', NULL, '5.36.200.129', '5.36.200.129.dynamic-dsl-ip.omantel.net.om', '2024-08-23', '08:45:12 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (91, 2, 91, 'csm0091', 'CAR WASH NISSAN SUUNY', 52, '123456', '', 21, 0, 57, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '0.00', '1.0000', '15.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '09:41:34 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (92, 2, 92, 'csm0092', 'LED BULB', 53, '123456', '', 21, 0, 58, NULL, NULL, '0.5000', 151, '0.5000', 'Inclusive', '0.00', '0.5000', '51.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '10:02:17 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (93, 2, 93, 'csm0093', '01FRIDAY OVER TIME ABDULRAUF', 54, '319', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Exclusive', '0.00', '0.6000', '105.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:40:47 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '319', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (94, 2, 94, 'csm0094', '02 FRIDAY OVER TIME ABDULRAUF', 54, '3119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:46:53 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (95, 2, 95, 'csm0095', '03FRIDAY OVER TIME ABDULRAUF', 54, '31119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:53:38 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '31119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (96, 2, 96, 'csm0096', '04FRIDAY OVER TIME ABDULRAUF', 54, '311119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:54:43 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '311119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (97, 2, 97, 'csm0097', '05FRIDAY OVER TIME ABDULRAUF', 54, '3111119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '11:55:40 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3111119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (98, 2, 98, 'csm0098', '01FRIDAY OVERTIME MANNY', 54, '319', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:24:10 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '319', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (99, 2, 99, 'csm0099', '02FRIDAY OVER TIME MANNY', 54, '3119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:25:38 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (100, 2, 100, 'csm0100', '03FRIDAY OVER TIME MANNY', 54, '31119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:26:29 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '31119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (101, 2, 101, 'csm0101', '04FRIDAY OVER TIME MANNY', 54, '311119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '55.00', NULL, '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '2024-08-29', '12:27:29 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '311119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (102, 2, 102, 'csm0102', '5FRIDAY OVERTIME FOR MANNY', 54, '39111119', '', 21, 0, 59, NULL, NULL, '0.6000', 151, '0.6000', 'Inclusive', '0.00', '0.6000', '155.00', NULL, '5.36.152.232', '5.36.152.232.dynamic-dsl-ip.omantel.net.om', '2024-08-30', '07:10:15 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3111119', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (103, 2, 103, 'csm0103', 'Intake manifold gasket replacement', 17, '123456', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '98.00', NULL, '5.36.134.175', '5.36.134.175.dynamic-dsl-ip.omantel.net.om', '2024-09-07', '08:56:26 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (104, 2, 104, 'csm0104', 'Catalytic Cleaning Lubricant(Mannol)', 22, '12345', '', 21, 0, 60, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '0.00', '3.5000', '40.00', NULL, '5.36.134.175', '5.36.134.175.dynamic-dsl-ip.omantel.net.om', '2024-09-07', '09:27:25 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '12345', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (105, 2, 105, 'csm0105', 'Ac air-outlet damper replacement', 22, '12345', '', 21, 0, 60, NULL, NULL, '15.0000', 151, '15.0000', 'Inclusive', '0.00', '15.0000', '9.00', NULL, '5.37.111.90', '5.37.111.90', '2024-09-08', '09:46:24 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '12345', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (106, 2, 106, 'csm0106', 'WATER PUMP LABOR CHARGE', 22, '123456', '', 21, 0, 60, NULL, NULL, '24.0000', 151, '24.0000', 'Inclusive', '0.00', '24.0000', '9.00', NULL, '5.36.87.227', '5.36.87.227.dynamic-dsl-ip.omantel.net.om', '2024-09-10', '05:53:25 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123456', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (107, 2, 107, 'csm0107', 'Front wiper blade replacement', 22, '123', '', 21, 0, 60, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '98.00', NULL, '5.36.77.53', '5.36.77.53.dynamic-dsl-ip.omantel.net.om', '2024-09-21', '12:27:19 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (108, 2, 108, 'csm0108', 'Inner tie-rod end with boot FL', 22, '231', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '8.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:19:45 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '231', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (109, 2, 109, 'csm0109', 'Inner tie-rod end with boot FR', 22, '3211', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '8.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:24:16 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3211', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (110, 2, 110, 'csm0110', 'Outer tie-rod end Fl', 22, '32111', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '9.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:27:17 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '32111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (111, 2, 111, 'csm0111', 'Outer tie-rod end FR', 22, '321111y', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '9.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:28:43 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '321111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (112, 2, 112, 'csm0112', 'Throttle cleaning FR&amp;FL', 22, ' 3211111', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '9.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:34:43 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3211111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (113, 2, 113, 'csm0113', 'Throttle programming', 22, '32111111', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '9.00', NULL, '5.36.222.49', '5.36.222.49.dynamic-dsl-ip.omantel.net.om', '2024-09-24', '08:36:55 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '32111111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (114, 2, 114, 'csm0114', 'Salary payment for September', 47, '23111111', '', 21, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '0.00', '5.0000', '5.00', NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '05:48:28 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '231111111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (115, 2, 115, 'csm0115', 'Salary payment for September', 47, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '05:49:46 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', 'Salary', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (116, 2, 116, 'csm0116', 'Overtime for September', 47, NULL, '', NULL, NULL, NULL, NULL, NULL, '3.2000', 151, '3.2000', 'Inclusive', NULL, '3.2000', NULL, NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '05:51:35 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', 'Service ', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (117, 2, 117, 'csm0117', 'Overtime payment for the month', 22, '3211111111', '', 21, 0, 0, NULL, NULL, '3.2000', 151, '3.2000', 'Inclusive', '0.00', '3.2000', '144.00', NULL, '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', '2024-09-29', '05:56:10 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '321111111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (118, 2, 118, 'csm0118', 'Windshield wiper fluid', 22, '323', '', 21, 0, 60, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '48.00', NULL, '5.36.238.77', '5.36.238.77.dynamic-dsl-ip.omantel.net.om', '2024-10-05', '12:04:05 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (119, 2, 119, 'csm0119', 'Drive Belt', 22, '32300', '', 21, 0, 60, NULL, NULL, '10.0000', 151, '10.0000', 'Inclusive', '0.00', '10.0000', '99.00', NULL, '5.37.230.137', '5.37.230.137.dynamic-dsl-ip.omantel.net.om', '2024-10-07', '08:57:56 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (120, 2, 120, 'csm0120', 'workshop lamp', 48, '323000', '', 21, 0, 55, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '11.00', NULL, '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '2024-10-08', '10:56:10 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (121, 2, 121, 'csm0121', 'cable tie', 48, '323000', '', 21, 0, 55, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '11.00', NULL, '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '2024-10-08', '10:58:28 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (122, 2, 122, 'csm0122', 'cable tie', 48, '3230000', '', 21, 0, 55, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '11.00', NULL, '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '2024-10-08', '11:00:41 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (123, 2, 123, 'csm0123', 'white tape', 48, '3230000', '', 21, 0, 55, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '2.0000', '11.00', NULL, '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '2024-10-08', '11:02:03 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3230000', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (124, 2, 124, 'csm0124', 'Purchase', 22, '323001', '', 21, 0, 60, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '0.00', '3.0000', '118.00', NULL, '5.36.103.81', '5.36.103.81.dynamic-dsl-ip.omantel.net.om', '2024-10-15', '11:01:51 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '323001', 'Walk in customer', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (125, 2, 125, 'csm0125', '1stLine 20% discount promotional offer', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '0.0000', 151, '0.0000', 'Exclusive', NULL, '0.0000', NULL, '', '5.37.235.252', '5.37.235.252.dynamic-dsl-ip.omantel.net.om', '2024-10-22', '08:33:56 pm', 'Admin', NULL, 1, 'Percentage', '20.00', 1, '0.00', '001', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (126, 2, 126, 'csm0126', 'Oil sump gasket replacement', 22, '23200', '', 21, 0, 60, NULL, NULL, '35.0000', 151, '35.0000', 'Inclusive', '0.00', '35.0000', '99.00', NULL, '5.37.122.114', '5.37.122.114', '2024-10-27', '08:36:02 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (127, 2, 127, 'csm0127', 'Transfercase oil replacement', 22, '', '', 21, 0, 60, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '0.00', '4.5000', '99.00', NULL, '5.36.251.210', '5.36.251.210.dynamic-dsl-ip.omantel.net.om', '2024-10-28', '06:24:43 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (130, 2, 130, 'csm0130', 'Car wheel bolt', 22, '2111', '', 21, 0, 60, NULL, NULL, '0.5000', 151, '0.5000', 'Inclusive', '0.00', '0.5000', '116.00', NULL, '5.37.253.164', '5.37.253.164.dynamic-dsl-ip.omantel.net.om', '2024-10-31', '11:06:04 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '2111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (131, 2, 131, 'csm0131', 'Service', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', NULL, '1.0000', NULL, NULL, '188.135.20.158', '188.135.20.158', '2024-11-01', '02:17:34 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', 'Oil service ', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (132, 2, 132, 'csm0132', 'Ac Filter', 22, '23211', '', 21, 0, 60, NULL, NULL, '8.0000', 151, '8.0000', 'Inclusive', '0.00', '8.0000', '101.00', NULL, '5.36.92.142', '5.36.92.142.dynamic-dsl-ip.omantel.net.om', '2024-11-03', '05:06:45 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '23211', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (133, 2, 133, 'csm0133', 'Engine Air filter', 22, '232111', '', 21, 0, 60, NULL, NULL, '10.6000', 151, '10.6000', 'Inclusive', '0.00', '10.6000', '100.00', NULL, '5.36.92.142', '5.36.92.142.dynamic-dsl-ip.omantel.net.om', '2024-11-03', '05:08:03 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '232111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (134, 2, 134, 'csm0134', 'Recovery service', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', NULL, '1.0000', NULL, NULL, '5.36.252.146', '5.36.252.146.dynamic-dsl-ip.omantel.net.om', '2024-11-04', '11:07:29 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (135, 2, 135, 'csm0135', 'Recovery.', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', NULL, '1.0000', NULL, NULL, '5.36.252.146', '5.36.252.146.dynamic-dsl-ip.omantel.net.om', '2024-11-04', '11:13:50 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (136, 2, 136, 'csm0136', 'Labour charge', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.36.252.146', '5.36.252.146.dynamic-dsl-ip.omantel.net.om', '2024-11-04', '11:37:04 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '232111', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (137, 2, 137, 'csm0137', 'Computer scan', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.36.252.146', '5.36.252.146.dynamic-dsl-ip.omantel.net.om', '2024-11-04', '11:38:14 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (138, 2, 138, 'csm0138', 'Mechanic Inspection', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.36.252.146', '5.36.252.146.dynamic-dsl-ip.omantel.net.om', '2024-11-04', '11:38:55 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (139, 2, 139, 'csm0139', 'Carry out Oil Service Replacement', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Exclusive', NULL, '5.0000', NULL, NULL, '5.36.255.141', '5.36.255.141.dynamic-dsl-ip.omantel.net.om', '2024-11-14', '05:28:01 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (140, 2, 140, 'csm0140', 'Labour charge.', 17, NULL, '', NULL, NULL, NULL, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', NULL, '1.0000', NULL, NULL, '5.36.185.22', '5.36.185.22.dynamic-dsl-ip.omantel.net.om', '2024-11-17', '05:37:55 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (141, 2, 141, 'csm0141', 'Delivery charges', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', NULL, '2.0000', NULL, NULL, '5.36.166.229', '5.36.166.229.dynamic-dsl-ip.omantel.net.om', '2024-11-19', '05:40:10 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (142, 2, 142, 'csm0142', 'Labor payment', 22, '1234567', '', 21, 0, 60, NULL, NULL, '2.0000', 151, '2.0000', 'Exclusive', '0.00', '2.0000', '101.00', NULL, '5.36.193.162', '5.36.193.162.dynamic-dsl-ip.omantel.net.om', '2024-11-26', '08:45:28 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1234567', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (143, 2, 143, 'csm0143', 'Propeller shaft removal', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.37.192.165', '5.37.192.165.dynamic-dsl-ip.omantel.net.om', '2024-11-27', '05:01:12 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (144, 2, 144, 'csm0144', '75w/85', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', NULL, '4.5000', NULL, NULL, '5.36.101.116', '5.36.101.116.dynamic-dsl-ip.omantel.net.om', '2024-12-02', '10:35:33 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '121000', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (145, 2, 145, 'csm0145', '80w/90', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', NULL, '4.5000', NULL, NULL, '5.36.101.116', '5.36.101.116.dynamic-dsl-ip.omantel.net.om', '2024-12-02', '10:37:06 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '1211100', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (146, 2, 146, 'csm0146', 'circuit braker purchase', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '7.0000', 151, '7.0000', 'Inclusive', NULL, '7.0000', NULL, NULL, '185.185.133.69', '185.185.133.69', '2024-12-10', '09:23:57 am', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '123001', 'electricity circuit braker', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (147, 2, 147, 'csm0147', 'circuit braker purchase', 22, '231110', '', 21, 0, 60, NULL, NULL, '7.0000', 151, '7.0000', 'Exclusive', '0.00', '7.0000', '26.00', NULL, '185.185.133.69', '185.185.133.69', '2024-12-10', '09:26:11 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '1230011', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (148, 2, 148, 'csm0148', 'mvp element kit oil', 22, '123001', '', 21, 0, 60, NULL, NULL, '1.8740', 151, '1.8740', 'Inclusive', '0.00', '1.8740', '102.00', NULL, '185.185.133.69', '185.185.133.69', '2024-12-10', '09:40:34 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123101', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (149, 2, 149, 'csm0149', 'Eng.oil filter', 22, '123001', '', 21, 0, 60, NULL, NULL, '1.2790', 151, '1.2790', 'Inclusive', '0.00', '1.2790', '104.00', NULL, '185.185.133.69', '185.185.133.69', '2024-12-10', '09:42:01 am', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123001', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (150, 2, 150, 'csm0150', 'oil filter m.b cars, e.c,Gl, ML', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '14.5010', 151, '14.5010', 'Inclusive', NULL, '14.5010', NULL, NULL, '185.185.132.54', '185.185.132.54', '2024-12-10', '07:37:04 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', 'service', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (151, 2, 151, 'csm0151', 'brakefluid dot4', 22, '', '', 21, 0, 60, NULL, NULL, '12.0020', 151, '12.0020', 'Inclusive', '0.00', '12.0020', '99.00', NULL, '185.185.132.54', '185.185.132.54', '2024-12-10', '07:38:59 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (152, 2, 152, 'csm0152', 'oil filter-m.b cars, e,c,gl,ml', 22, '', '', 21, 0, 60, NULL, NULL, '14.5010', 151, '14.5010', 'Inclusive', '0.00', '14.5010', '101.00', NULL, '185.185.132.54', '185.185.132.54', '2024-12-10', '07:42:36 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (153, 2, 153, 'csm0153', 'Employee social insurance protection', 22, '1230011', '', 21, 0, 60, NULL, NULL, '4.9440', 151, '4.9440', 'Inclusive', '0.00', '4.9440', '52.00', NULL, '185.185.133.70', '185.185.133.70', '2024-12-11', '12:11:42 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '123011', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (154, 2, 154, 'csm0154', 'Parts', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', NULL, '5.0000', NULL, NULL, '5.36.98.2', '5.36.98.2.dynamic-dsl-ip.omantel.net.om', '2024-12-15', '06:46:52 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (155, 2, 155, 'csm0155', 'Parts', 22, '121001', '', 21, 0, 60, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '0.00', '6.0000', '101.00', NULL, '5.36.98.2', '5.36.98.2.dynamic-dsl-ip.omantel.net.om', '2024-12-15', '07:01:27 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '121001', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (156, 2, 156, 'csm0156', 'Cotton waste', 22, '12111', '', 21, 0, 60, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '0.00', '2.5000', '52.00', NULL, '5.36.129.91', '5.36.129.91.dynamic-dsl-ip.omantel.net.om', '2024-12-16', '04:32:18 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '12111', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (157, 2, 157, 'csm0157', 'Sanad office salary receipt', 22, NULL, '', NULL, NULL, NULL, NULL, NULL, '0.5000', 151, '0.5000', 'Inclusive', NULL, '0.5000', NULL, NULL, '5.37.227.215', '5.37.227.215.dynamic-dsl-ip.omantel.net.om', '2025-01-02', '12:44:15 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 1, '0.00', '', '', NULL, NULL, NULL, 0, NULL, '0', 0, 0, NULL);
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`, `offer_value`, `offer_on`, `is_package`, `package_items`) VALUES (158, 2, 158, 'csm0158', 'Sanad office tax receipt', 22, '', '', 21, 0, 60, NULL, NULL, '0.5000', 151, '0.5000', 'Inclusive', '0.00', '0.5000', '101.00', NULL, '5.37.227.215', '5.37.227.215.dynamic-dsl-ip.omantel.net.om', '2025-01-02', '12:47:02 pm', 'Admin', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000', '0', 0, 0, '');


#
# TABLE STRUCTURE FOR: db_languages
#

DROP TABLE IF EXISTS `db_languages`;

CREATE TABLE `db_languages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (1, 'English', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (2, 'Russian', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (3, 'Spanish', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (4, 'Arabic', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (5, 'Bangla', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (6, 'French', 0);


#
# TABLE STRUCTURE FOR: db_package
#

DROP TABLE IF EXISTS `db_package`;

CREATE TABLE `db_package` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `package_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `package_code` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `package_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `monthly_price` double(20,2) DEFAULT NULL,
  `annual_price` double(20,2) DEFAULT NULL,
  `trial_days` int DEFAULT NULL,
  `max_users` int DEFAULT NULL,
  `max_items` int DEFAULT NULL,
  `max_invoices` int DEFAULT NULL,
  `max_warehouses` int DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_paymenttypes
#

DROP TABLE IF EXISTS `db_paymenttypes`;

CREATE TABLE `db_paymenttypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (36, 2, 'Cash', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (37, 2, 'Visa', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (39, 2, 'Bank Transfer', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (40, 2, 'CHEQUE', 1);


#
# TABLE STRUCTURE FOR: db_paypal
#

DROP TABLE IF EXISTS `db_paypal`;

CREATE TABLE `db_paypal` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sandbox` int DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_paypal` (`id`, `store_id`, `sandbox`, `email`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_paypalpaylog
#

DROP TABLE IF EXISTS `db_paypalpaylog`;

CREATE TABLE `db_paypalpaylog` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `product_id` int NOT NULL,
  `txn_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_gross` float(10,2) NOT NULL,
  `currency_code` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payer_email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_permissions
#

DROP TABLE IF EXISTS `db_permissions`;

CREATE TABLE `db_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  `permissions` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7226 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4414, 1, 17, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4415, 1, 17, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4416, 1, 17, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4417, 1, 17, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4418, 1, 17, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4419, 1, 17, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4420, 1, 17, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4421, 1, 17, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4422, 1, 17, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4423, 1, 17, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4424, 1, 17, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4425, 1, 17, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4426, 1, 17, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4427, 1, 17, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4428, 1, 17, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4429, 1, 17, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4430, 1, 17, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4431, 1, 17, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4432, 1, 17, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4433, 1, 17, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4434, 1, 17, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4435, 1, 17, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4436, 1, 17, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4437, 1, 17, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4438, 1, 17, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4439, 1, 17, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4440, 1, 17, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4441, 1, 17, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4442, 1, 17, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4443, 1, 17, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4444, 1, 17, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4445, 1, 17, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4446, 1, 17, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4447, 1, 17, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4448, 1, 17, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4449, 1, 17, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4450, 1, 17, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4451, 1, 17, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4452, 1, 17, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4453, 1, 17, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4454, 1, 17, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4455, 1, 17, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4456, 1, 17, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4457, 1, 17, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4458, 1, 17, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4459, 1, 17, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4460, 1, 17, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4461, 1, 17, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4462, 1, 17, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4463, 1, 17, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4464, 1, 17, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4465, 1, 17, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4466, 1, 17, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4467, 1, 17, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4468, 1, 17, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4469, 1, 17, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4470, 1, 17, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4471, 1, 17, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4472, 1, 17, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4473, 1, 17, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4474, 1, 17, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4475, 1, 17, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4476, 1, 17, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4477, 1, 17, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4478, 1, 17, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4479, 1, 17, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4480, 1, 17, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4481, 1, 17, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4482, 1, 17, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4483, 1, 17, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4484, 1, 17, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4485, 1, 17, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4486, 1, 17, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4487, 1, 17, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4488, 1, 17, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4489, 1, 17, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4490, 1, 17, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4491, 1, 17, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4492, 1, 18, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4493, 1, 18, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4494, 1, 18, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4495, 1, 18, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4496, 1, 18, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4497, 1, 18, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4498, 1, 18, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4499, 1, 18, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4500, 1, 18, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4501, 1, 18, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4502, 1, 18, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4503, 1, 18, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4504, 1, 18, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4505, 1, 18, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4506, 1, 18, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4507, 1, 18, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4508, 1, 18, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4509, 1, 18, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4510, 1, 18, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4511, 1, 18, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4512, 1, 18, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4513, 1, 18, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4514, 1, 18, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4515, 1, 18, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4516, 1, 18, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4517, 1, 18, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4518, 1, 18, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4519, 1, 18, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4520, 1, 18, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4521, 1, 18, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4522, 1, 18, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4523, 1, 18, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4524, 1, 18, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4525, 1, 18, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4526, 1, 18, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4527, 1, 18, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4528, 1, 18, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4529, 1, 18, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4530, 1, 18, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4531, 1, 18, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4532, 1, 18, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4533, 1, 18, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4534, 1, 18, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4535, 1, 18, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4536, 1, 18, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4537, 1, 18, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4538, 1, 18, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4539, 1, 18, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4540, 1, 18, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4541, 1, 18, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4542, 1, 18, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4543, 1, 18, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4544, 1, 18, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4545, 1, 18, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4546, 1, 18, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4547, 1, 18, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4548, 1, 18, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4549, 1, 18, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4550, 1, 18, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4551, 1, 18, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4552, 1, 18, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4553, 1, 18, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4554, 1, 18, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4555, 1, 18, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4556, 1, 18, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4557, 1, 18, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4558, 1, 18, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4559, 1, 18, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4560, 1, 18, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4561, 1, 18, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4562, 1, 18, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4563, 1, 18, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4564, 1, 18, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4565, 1, 18, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4566, 1, 18, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4567, 1, 18, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4568, 1, 18, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4569, 1, 18, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4570, 1, 18, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4571, 1, 18, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4572, 1, 18, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4573, 1, 18, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4574, 1, 18, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4575, 1, 18, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4576, 1, 18, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4577, 1, 18, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4578, 1, 18, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4579, 1, 18, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4580, 1, 18, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5818, 1, 2, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5819, 1, 2, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5820, 1, 2, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5821, 1, 2, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5822, 1, 2, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5823, 1, 2, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5824, 1, 2, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5825, 1, 2, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5826, 1, 2, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5827, 1, 2, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5828, 1, 2, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5829, 1, 2, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5830, 1, 2, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5831, 1, 2, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5832, 1, 2, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5833, 1, 2, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5834, 1, 2, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5835, 1, 2, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5836, 1, 2, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5837, 1, 2, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5838, 1, 2, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5839, 1, 2, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5840, 1, 2, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5841, 1, 2, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5842, 1, 2, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5843, 1, 2, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5844, 1, 2, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5845, 1, 2, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5846, 1, 2, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5847, 1, 2, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5848, 1, 2, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5849, 1, 2, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5850, 1, 2, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5851, 1, 2, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5852, 1, 2, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5853, 1, 2, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5854, 1, 2, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5855, 1, 2, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5856, 1, 2, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5857, 1, 2, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5858, 1, 2, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5859, 1, 2, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5860, 1, 2, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5861, 1, 2, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5862, 1, 2, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5863, 1, 2, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5864, 1, 2, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5865, 1, 2, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5866, 1, 2, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5867, 1, 2, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5868, 1, 2, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5869, 1, 2, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5870, 1, 2, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5871, 1, 2, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5872, 1, 2, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5873, 1, 2, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5874, 1, 2, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5875, 1, 2, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5876, 1, 2, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5877, 1, 2, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5878, 1, 2, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5879, 1, 2, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5880, 1, 2, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5881, 1, 2, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5882, 1, 2, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5883, 1, 2, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5884, 1, 2, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5885, 1, 2, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5886, 1, 2, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5887, 1, 2, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5888, 1, 2, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5889, 1, 2, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5890, 1, 2, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5891, 1, 2, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5892, 1, 2, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5893, 1, 2, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5894, 1, 2, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5895, 1, 2, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5896, 1, 2, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5897, 1, 2, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5898, 1, 2, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5899, 1, 2, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5900, 1, 2, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5901, 1, 2, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5902, 1, 2, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5903, 1, 2, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5904, 1, 2, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5905, 1, 2, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5906, 1, 2, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5907, 1, 2, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5908, 1, 2, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5909, 1, 2, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5910, 1, 2, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5911, 1, 2, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5912, 1, 2, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5913, 1, 2, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5914, 1, 2, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5915, 1, 2, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5916, 1, 2, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5917, 1, 2, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5918, 1, 2, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5919, 1, 2, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5920, 1, 2, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5921, 1, 2, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5922, 1, 2, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5923, 1, 2, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5924, 1, 2, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5925, 1, 2, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5926, 1, 2, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5927, 1, 2, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5928, 1, 2, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5929, 1, 2, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5930, 1, 2, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5931, 1, 2, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5932, 1, 2, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5933, 1, 2, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5934, 1, 2, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5935, 1, 2, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5936, 1, 2, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5937, 1, 2, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5938, 1, 2, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5939, 1, 2, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5940, 1, 2, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5941, 1, 2, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5942, 1, 2, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5943, 1, 2, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5944, 1, 2, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5945, 1, 2, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5946, 1, 2, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5947, 1, 2, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5948, 1, 2, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5949, 1, 2, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5950, 1, 2, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5951, 1, 2, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5952, 1, 2, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5953, 1, 2, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5954, 1, 2, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5955, 1, 2, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5956, 1, 2, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5957, 1, 2, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5958, 1, 2, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5959, 1, 2, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5960, 1, 2, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5961, 1, 2, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5962, 1, 2, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5963, 1, 2, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5964, 1, 2, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5965, 1, 2, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5966, 1, 2, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5967, 1, 2, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5968, 1, 2, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5969, 1, 2, 'subscription');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5970, 1, 2, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5971, 1, 2, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5972, 1, 2, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5973, 1, 2, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5974, 1, 2, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5975, 1, 2, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5976, 1, 2, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5977, 1, 2, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5978, 1, 2, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5999, 2, 28, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6000, 2, 28, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6001, 2, 28, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6002, 2, 28, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6011, 2, 29, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6012, 2, 29, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6013, 2, 29, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6014, 2, 29, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6015, 2, 29, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6016, 2, 29, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6017, 2, 29, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6018, 2, 29, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6019, 2, 29, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6020, 2, 29, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6021, 2, 29, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6022, 2, 29, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6023, 2, 29, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6024, 2, 29, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6025, 2, 29, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6026, 2, 29, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6027, 2, 29, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6028, 2, 29, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6029, 2, 29, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6030, 2, 29, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6031, 2, 29, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6032, 2, 29, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6033, 2, 29, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6034, 2, 29, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6035, 2, 29, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6036, 2, 29, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6037, 2, 29, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6038, 2, 29, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6039, 2, 29, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6040, 2, 29, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6041, 2, 29, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6042, 2, 29, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6043, 2, 29, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6044, 2, 29, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6045, 2, 29, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6046, 2, 29, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6047, 2, 29, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6048, 2, 29, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6049, 2, 29, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6050, 2, 29, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6051, 2, 29, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6052, 2, 29, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6053, 2, 29, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6054, 2, 29, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6055, 2, 29, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6056, 2, 29, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6057, 2, 29, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6058, 2, 29, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6059, 2, 29, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6060, 2, 29, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6061, 2, 29, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6062, 2, 29, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6063, 2, 29, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6064, 2, 29, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6065, 2, 29, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6066, 2, 29, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6067, 2, 29, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6068, 2, 29, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6069, 2, 29, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6070, 2, 29, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6071, 2, 29, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6072, 2, 29, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6073, 2, 29, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6074, 2, 29, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6075, 2, 29, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6076, 2, 29, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6077, 2, 29, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6078, 2, 29, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6079, 2, 29, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6080, 2, 29, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6081, 2, 29, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6082, 2, 29, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6083, 2, 29, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6084, 2, 29, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6085, 2, 29, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6086, 2, 29, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6087, 2, 29, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6088, 2, 29, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6089, 2, 29, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6090, 2, 29, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6091, 2, 29, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6092, 2, 29, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6093, 2, 29, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6094, 2, 29, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6095, 2, 29, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6096, 2, 29, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6097, 2, 29, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6098, 2, 29, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6099, 2, 29, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6100, 2, 29, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6101, 2, 29, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6102, 2, 29, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6103, 2, 29, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6104, 2, 29, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6105, 2, 29, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6106, 2, 29, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6107, 2, 29, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6108, 2, 29, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6109, 2, 29, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6110, 2, 29, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6111, 2, 29, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6112, 2, 29, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6113, 2, 29, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6114, 2, 29, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6115, 2, 29, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6116, 2, 29, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6117, 2, 29, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6118, 2, 29, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6119, 2, 29, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6120, 2, 29, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6121, 2, 29, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6122, 2, 29, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6123, 2, 29, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6124, 2, 29, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6125, 2, 29, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6126, 2, 29, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6127, 2, 29, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6128, 2, 29, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6129, 2, 29, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6130, 2, 29, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6131, 2, 29, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6132, 2, 29, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6133, 2, 29, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6134, 2, 29, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6135, 2, 29, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6136, 2, 29, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6137, 2, 29, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6138, 2, 29, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6139, 2, 29, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6140, 2, 29, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6141, 2, 29, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6142, 2, 29, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6143, 2, 29, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6144, 2, 29, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6145, 2, 29, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6146, 2, 29, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6147, 2, 29, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6148, 2, 29, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6149, 2, 29, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6150, 2, 29, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6151, 2, 29, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6152, 2, 29, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6153, 2, 29, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6154, 2, 29, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6155, 2, 29, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6156, 2, 29, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6157, 2, 29, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6158, 2, 29, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6159, 2, 29, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6160, 2, 29, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6161, 2, 29, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6162, 2, 29, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6163, 2, 29, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6164, 2, 29, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6165, 2, 29, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6166, 2, 29, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6167, 2, 29, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6168, 2, 29, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6169, 2, 29, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6170, 2, 29, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6179, 1, 2, 'gstr_1_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6180, 1, 2, 'gstr_2_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6181, 1, 2, 'delivery_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6182, 1, 2, 'load_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6183, 1, 2, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6184, 1, 2, 'customer_orders_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6965, 2, 4, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6966, 2, 4, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6967, 2, 4, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6968, 2, 4, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6969, 2, 4, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6970, 2, 4, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6971, 2, 4, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6972, 2, 4, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6973, 2, 4, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6974, 2, 4, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6975, 2, 4, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6976, 2, 4, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6977, 2, 4, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6978, 2, 4, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6979, 2, 4, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6980, 2, 4, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6981, 2, 4, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6982, 2, 4, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6983, 2, 4, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6984, 2, 4, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6985, 2, 4, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6986, 2, 4, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6987, 2, 4, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6988, 2, 4, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6989, 2, 4, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6990, 2, 4, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6991, 2, 4, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6992, 2, 4, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6993, 2, 4, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6994, 2, 4, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6995, 2, 4, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6996, 2, 4, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6997, 2, 4, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6998, 2, 4, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6999, 2, 4, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7000, 2, 4, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7001, 2, 4, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7002, 2, 4, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7003, 2, 4, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7004, 2, 4, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7005, 2, 4, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7006, 2, 4, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7007, 2, 4, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7008, 2, 4, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7009, 2, 4, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7010, 2, 4, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7011, 2, 4, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7012, 2, 4, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7013, 2, 4, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7014, 2, 4, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7015, 2, 4, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7016, 2, 4, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7017, 2, 4, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7018, 2, 4, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7019, 2, 4, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7020, 2, 4, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7021, 2, 4, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7022, 2, 4, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7023, 2, 4, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7024, 2, 4, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7025, 2, 4, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7026, 2, 4, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7027, 2, 4, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7028, 2, 4, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7029, 2, 4, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7030, 2, 4, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7031, 2, 4, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7032, 2, 4, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7033, 2, 4, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7034, 2, 4, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7035, 2, 4, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7036, 2, 4, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7037, 2, 4, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7038, 2, 4, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7039, 2, 4, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7040, 2, 4, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7041, 2, 4, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7042, 2, 4, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7043, 2, 4, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7044, 2, 4, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7045, 2, 4, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7046, 2, 4, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7047, 2, 4, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7048, 2, 4, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7049, 2, 4, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7050, 2, 4, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7051, 2, 4, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7052, 2, 4, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7053, 2, 4, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7054, 2, 4, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7055, 2, 4, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7056, 2, 4, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7057, 2, 4, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7058, 2, 4, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7059, 2, 4, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7060, 2, 4, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7061, 2, 4, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7062, 2, 4, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7063, 2, 4, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7064, 2, 4, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7065, 2, 4, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7066, 2, 4, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7067, 2, 4, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7068, 2, 4, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7069, 2, 4, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7070, 2, 4, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7071, 2, 4, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7072, 2, 4, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7073, 2, 4, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7074, 2, 4, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7075, 2, 4, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7076, 2, 4, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7077, 2, 4, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7168, 2, 3, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7169, 2, 3, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7170, 2, 3, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7171, 2, 3, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7172, 2, 3, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7173, 2, 3, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7174, 2, 3, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7175, 2, 3, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7176, 2, 3, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7177, 2, 3, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7178, 2, 3, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7179, 2, 3, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7180, 2, 3, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7181, 2, 3, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7182, 2, 3, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7183, 2, 3, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7184, 2, 3, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7185, 2, 3, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7186, 2, 3, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7187, 2, 3, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7188, 2, 3, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7189, 2, 3, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7190, 2, 3, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7191, 2, 3, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7192, 2, 3, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7193, 2, 3, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7194, 2, 3, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7195, 2, 3, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7196, 2, 3, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7197, 2, 3, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7198, 2, 3, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7199, 2, 3, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7200, 2, 3, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7201, 2, 3, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7202, 2, 3, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7203, 2, 3, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7204, 2, 3, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7205, 2, 3, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7206, 2, 3, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7207, 2, 3, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7208, 2, 3, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7209, 2, 3, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7210, 2, 3, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7211, 2, 3, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7212, 2, 3, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7213, 2, 3, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7214, 2, 3, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7215, 2, 3, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7216, 2, 3, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7217, 2, 3, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7218, 2, 3, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7219, 2, 3, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7220, 2, 3, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7221, 2, 3, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7222, 2, 3, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7223, 2, 3, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7224, 2, 3, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7225, 2, 3, 'show_purchase_price');


#
# TABLE STRUCTURE FOR: db_purchase
#

DROP TABLE IF EXISTS `db_purchase`;

CREATE TABLE `db_purchase` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Purchase Code',
  `purchase_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `purchase_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'Purchase return raised',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `supplier_id` (`supplier_id`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (1, 2, 2, 1, 'PU/2021/02/0001', 'Nissan sunny', '2024-08-07', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '12.5000', NULL, '12.5000', 'company vehicle petrol purchase between the periods below:\r\n01-08-2024(5.5 rial)\r\n05-08-2024(7.5 rial)\r\nTotal 12.500 rial\r\n', 'Paid', '12.5000', '2024-08-07', '09:45:12 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (2, 2, 2, 2, 'PU/2021/02/0002', 'Acct: 150643019', '2024-08-07', 'Received', 4, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '25.0000', NULL, '25.0000', '', 'Paid', '25.0000', '2024-08-07', '10:14:19 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (3, 2, 2, 3, 'PU/2021/02/0003', 'Acct: 99769738', '2024-08-07', 'Received', 5, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.0000', NULL, '0.0000', '', 'Paid', '0.0000', '2024-08-07', '10:34:25 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (4, 2, 2, 4, 'PU/2021/02/0004', 'Office drinking water ', '2024-08-07', 'Received', 6, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.0000', NULL, '0.0000', '', 'Paid', '0.0000', '2024-08-07', '10:42:48 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (5, 2, 2, 5, 'PU/2021/02/0005', '92384656', '2024-08-07', 'Received', 7, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.0000', NULL, '0.0000', '', 'Paid', '0.0000', '2024-08-07', '11:00:07 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (6, 2, 2, 6, 'PU/2021/02/0006', 'office acct no: 00619530', '2024-08-07', 'Received', 8, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '20.0000', NULL, '20.0000', '', 'Paid', '20.0000', '2024-08-07', '11:16:06 am', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (7, 2, 2, 7, 'PU/2021/02/0007', 'office acct no: 00619531', '2024-08-07', 'Received', 9, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.0000', NULL, '0.0000', '', 'Paid', '0.0000', '2024-08-07', '12:11:39 pm', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (8, 2, 2, 8, 'PU/2021/02/0008', 'office acct no: 00619533', '2024-08-07', 'Received', 10, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '20.0000', NULL, '20.0000', '', 'Paid', '20.0000', '2024-08-07', '12:14:12 pm', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (9, 2, 2, 9, 'PU/2021/02/0009', 'office acct no: 00619534', '2024-08-07', 'Received', 11, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-07', '12:18:56 pm', 'Admin', '5.36.199.202', '5.36.199.202.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (10, 2, 2, 10, 'PU/2021/02/0010', 'accomodation:95080928', '2024-08-08', 'Received', 12, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '50.0000', NULL, '50.0000', '', 'Paid', '50.0000', '2024-08-08', '10:07:16 am', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (11, 2, 2, 11, 'PU/2021/02/0011', 'accomodation:00664481', '2024-08-08', 'Received', 13, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-08', '10:21:13 am', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (12, 2, 2, 12, 'PU/2021/02/0012', 'office mobile line: 94551017', '2024-08-08', 'Received', 15, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.0000', NULL, '10.0000', '', 'Paid', '10.0000', '2024-08-08', '11:42:37 am', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (13, 2, 2, 13, 'PU/2021/02/0013', 'office acct no: 00664481', '2024-08-08', 'Received', 13, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-08', '11:47:40 am', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (14, 2, 2, 14, 'PU/2021/02/0014', '1stline employee salary advance', '2024-08-08', 'Received', 16, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '22.0000', NULL, '22.0000', '', 'Paid', '22.0000', '2024-08-08', '12:18:52 pm', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (15, 2, 2, 15, 'PU/2021/02/0015', 'purchase of cooling fan', '2024-08-08', 'Received', 12, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '15.0000', NULL, '15.0000', 'purchase of cooling fan for the staff accommodation', 'Paid', '15.0000', '2024-08-08', '05:13:10 pm', 'Admin', '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (16, 2, 2, 16, 'PU/2021/02/0016', '212754-Nissan Sunny Mr Ibrahim', '2024-08-19', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.3000', NULL, '8.3000', '', 'Paid', '8.3000', '2024-08-19', '08:02:35 pm', 'Admin', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (17, 2, 2, 17, 'PU/2021/02/0017', 'Al Labeeb  Printing center', '2024-08-19', 'Received', 18, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.3000', NULL, '3.3000', '', 'Paid', '3.3000', '2024-08-19', '08:43:14 pm', 'Admin', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (18, 2, 2, 18, 'PU/2021/02/0018', 'OM1100065315', '2024-08-20', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '7.0000', NULL, '7.0000', '', 'Paid', '7.0000', '2024-08-20', '09:28:13 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (19, 2, 2, 19, 'PU/2021/02/0019', 'OM1100098109', '2024-08-20', 'Received', 20, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.7400', NULL, '3.7400', '', 'Paid', '3.7400', '2024-08-20', '09:53:46 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (20, 2, 2, 20, 'PU/2021/02/0020', 'OM1100049868', '2024-08-20', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '2.2900', NULL, '2.2900', '', 'Paid', '2.2900', '2024-08-20', '10:06:19 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (21, 2, 2, 21, 'PU/2021/02/0021', '0430245', '2024-08-20', 'Received', 18, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.1000', NULL, '3.1000', '', 'Paid', '3.1000', '2024-08-20', '10:21:36 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (22, 2, 2, 22, 'PU/2021/02/0022', 'Acct: 150643019', '2024-08-20', 'Received', 4, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.4950', NULL, '8.4950', 'Balance part payment of monthly internet rental bill', 'Paid', '8.4950', '2024-08-20', '11:49:10 am', 'Admin', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (23, 2, 2, 23, 'PU/2021/02/0023', 'NISSAN SUNNY', '2024-08-26', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.2000', NULL, '9.2000', 'DATE OF SUPPLY: 20/08/2024', 'Paid', '9.2000', '2024-08-26', '09:46:47 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (24, 2, 2, 24, 'PU/2021/02/0024', 'NISSAN SUNNY ', '2024-08-26', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.0000', NULL, '8.0000', 'DATE OF PURCHASE 25-08-2024', 'Paid', '8.0000', '2024-08-26', '09:49:44 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (25, 2, 2, 25, 'PU/2021/02/0025', 'PILOT MARKER PURCHASE', '2024-08-26', 'Received', 18, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '2.2900', NULL, '2.2900', 'PILOT MARKER PURCHASE', 'Paid', '2.2900', '2024-08-26', '09:52:43 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (26, 2, 2, 26, 'PU/2021/02/0026', 'OIL FILTER YZZD1', '2024-08-26', 'Received', 22, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '23.0000', NULL, '23.0000', 'ITEM CODE: 04152YZZD1 OIL FILTER 04152-31090\r\n10 PIECES', 'Paid', '23.0000', '2024-08-26', '10:02:48 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (27, 2, 2, 27, 'PU/2021/02/0027', 'OIL FILTER YZZN2', '2024-08-26', 'Received', 22, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '14.0700', NULL, '14.0700', 'OIL FILTER MVP 90915YZZN2, 10 PIECES', 'Paid', '14.0700', '2024-08-26', '10:09:42 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (28, 2, 2, 28, 'PU/2021/02/0028', 'OIL FILTERS', '2024-08-26', 'Received', 23, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '16.9010', NULL, '16.9010', 'A1-F026407199 OIL FILTER MB CARS GL QTY:2 NET PRICE7.031\r\nA11457429263 OIL FILTER A001802209 QTY:2 NET PRICE 4.200\r\nA1-1457429243 OIL FILTER VW/AUDI/ SKODA QTY2 NET PRICE:5.670\r\nTOTAL 16.901', 'Paid', '16.9010', '2024-08-26', '10:24:58 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (29, 2, 2, 29, 'PU/2021/02/0029', 'OIL FILTERS', '2024-08-26', 'Received', 24, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '30.0000', NULL, '30.0000', 'OIL FILTER 3 QTY 13.199\r\nOIL FILTER 2 QTY 13.999\r\nOIL FILTER 1 QTY 3\r\n\r\nTOTAL 30 OMR', 'Paid', '30.0000', '2024-08-26', '10:31:02 am', 'Admin', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (30, 2, 2, 30, 'PU/2021/02/0030', 'CAR WASH', '2024-08-29', 'Received', 26, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.0000', NULL, '1.0000', 'MR IBRAHIM CAR WASH', 'Paid', '1.0000', '2024-08-29', '09:46:19 am', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (31, 2, 2, 31, 'PU/2021/02/0031', 'PETROL PURCHASE', '2024-08-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.4000', NULL, '3.4000', 'PETROL PURCHASE 28-08-2024', 'Paid', '3.4000', '2024-08-29', '09:49:05 am', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (33, 2, 2, 33, 'PU/2021/02/0033', 'LIGHTING BULB', '2024-08-29', 'Received', 27, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.0000', NULL, '1.0000', '', 'Paid', '1.0000', '2024-08-29', '10:04:38 am', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (34, 2, 2, 34, 'PU/2021/02/0034', 'GROCERIES', '2024-08-29', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.2000', NULL, '3.2000', 'PURCHASE 27 AUGUST', 'Paid', '3.2000', '2024-08-29', '10:10:28 am', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (36, 2, 2, 36, 'PU/2021/02/0036', 'EMPLOYEE OVERTIME PAYMENT SLIP ABDULRAUF', '2024-08-29', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '15.0000', NULL, '15.0000', 'EMPLOYEE OVERTIME PAYMENT SLIP', 'Paid', '15.0000', '2024-08-29', '12:03:12 pm', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (37, 2, 2, 37, 'PU/2021/02/0037', 'EMPLOYEE OVERTIME PAYMENT SLIP MANNY ', '2024-08-29', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '12.5000', NULL, '12.5000', 'EMPLOYEE OVERTIME PAYMENT SLIP FOR MANNY ', 'Paid', '12.5000', '2024-08-29', '12:31:26 pm', 'Admin', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (38, 2, 2, 38, 'PU/2021/02/0038', 'Petrol Purchase(Nissan Sunny)', '2024-09-16', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.8000', NULL, '9.8000', 'purchase 05/09/2024', 'Paid', '9.8000', '2024-09-16', '11:02:27 am', 'Admin', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (39, 2, 2, 39, 'PU/2021/02/0039', 'Petrol Purchase(Nissan Sunny)', '2024-09-16', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '12/09/2024', 'Paid', '9.5000', '2024-09-16', '11:04:21 am', 'Admin', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (40, 2, 2, 40, 'PU/2021/02/0040', 'Miscellaneous Purchase ', '2024-09-16', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.9550', NULL, '4.9550', 'purchase include: donuts , top-fruits, tifanny, al rayyan and kinza, bake one.', 'Paid', '4.9550', '2024-09-16', '11:08:09 am', 'Admin', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (41, 2, 2, 41, 'PU/2021/02/0041', '', '2024-09-16', 'Received', 29, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', 'bet', 'Paid', '5.0000', '2024-09-16', '11:12:02 am', 'Admin', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (42, 2, 2, 42, 'PU/2021/02/0042', 'Electricity payment', '2024-09-18', 'Received', 30, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '35.0980', NULL, '35.0980', '', 'Paid', '35.0980', '2024-09-18', '05:07:48 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (43, 2, 2, 43, 'PU/2021/02/0043', 'Electricity payment', '2024-09-18', 'Received', 33, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.1250', NULL, '8.1250', '', 'Paid', '8.1250', '2024-09-18', '05:14:02 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (44, 2, 2, 44, 'PU/2021/02/0044', 'Electricity payment', '2024-09-18', 'Received', 34, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '35.0000', NULL, '35.0000', '', 'Paid', '35.0000', '2024-09-18', '05:16:43 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (45, 2, 2, 45, 'PU/2021/02/0045', 'Mobile recharge', '2024-09-18', 'Received', 35, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '13.5300', NULL, '13.5300', '', 'Paid', '13.5300', '2024-09-18', '05:25:31 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (46, 2, 2, 46, 'PU/2021/02/0046', 'Office Internet', '2024-09-18', 'Received', 4, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '31.7650', NULL, '31.7650', '', 'Paid', '31.7650', '2024-09-18', '05:27:07 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (47, 2, 2, 47, 'PU/2021/02/0047', 'Staff Accommodation', '2024-09-18', 'Received', 36, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '50.0000', NULL, '50.0000', '', 'Paid', '50.0000', '2024-09-18', '05:32:18 pm', 'Admin', '5.37.112.133', '5.37.112.133', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (48, 2, 2, 48, 'PU/2021/02/0048', 'Gasoline purchase ', '2024-09-29', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '26/09/2024', 'Paid', '9.5000', '2024-09-29', '05:32:36 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (49, 2, 2, 49, 'PU/2021/02/0049', 'Gasoline purchase ', '2024-09-29', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '18/09/2024', 'Paid', '9.5000', '2024-09-29', '05:34:23 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (50, 2, 2, 50, 'PU/2021/02/0050', 'Gasoline purchase ', '2024-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '22/09/2024', 'Paid', '5.0000', '2024-09-29', '05:35:30 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (51, 2, 2, 51, 'PU/2021/02/0051', 'Car wash', '2024-09-29', 'Received', 37, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.5000', NULL, '1.5000', '', 'Paid', '1.5000', '2024-09-29', '05:38:15 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (52, 2, 2, 52, 'PU/2021/02/0052', 'Manni Payslip 31/09/2024 ', '2024-09-29', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '151.0000', NULL, '151.0000', 'Paycheck 151OMR= 2.5 Overtime deductible from payslip = Bal = 148.5rial', 'Paid', '151.0000', '2024-09-29', '05:54:24 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (53, 2, 2, 53, 'PU/2021/02/0053', 'Abdulrauf Payslip 31/09/2024', '2024-09-29', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '183.2000', NULL, '183.2000', '', 'Paid', '183.2000', '2024-09-29', '06:11:24 pm', 'Admin', '5.36.106.155', '5.36.106.155.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (54, 2, 2, 54, 'PU/2021/02/0054', 'Payslip For Mr Ibrahim 31/09/2024', '2024-09-30', 'Received', 28, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '400.0000', NULL, '400.0000', '', 'Paid', '400.0000', '2024-09-30', '10:52:17 am', 'Admin', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (55, 2, 2, 55, 'PU/2021/02/0055', 'Petrol Purchase(Nissan Sunny)', '2024-10-08', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '03/10/2024', 'Paid', '9.5000', '2024-10-08', '10:45:23 am', 'Admin', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (56, 2, 2, 56, 'PU/2021/02/0056', 'Office drinkable water ', '2024-10-08', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.4900', NULL, '4.4900', '03/10/2024', 'Paid', '4.4900', '2024-10-08', '10:48:50 am', 'Admin', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (57, 2, 2, 57, 'PU/2021/02/0057', 'Workshop consumable', '2024-10-08', 'Received', 40, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.1000', NULL, '4.1000', '', 'Paid', '4.1000', '2024-10-08', '11:05:53 am', 'Admin', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (58, 2, 2, 58, 'PU/2021/02/0058', 'Petrol Purchase(Nissan Sunny)', '2024-10-20', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', 'purchase in the month of 20 October 2024.', 'Paid', '9.5000', '2024-10-20', '05:01:59 pm', 'Admin', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (59, 2, 2, 59, 'PU/2021/02/0059', 'Petrol Purchase(Nissan Sunny)', '2024-10-20', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', 'Purchase for the month 10 October 2024', 'Paid', '9.5000', '2024-10-20', '05:04:03 pm', 'Admin', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (60, 2, 2, 60, 'PU/2021/02/0060', 'Car Wash Nissan Sunny', '2024-10-20', 'Received', 37, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.5000', NULL, '1.5000', 'Washing was carried out 13/10/2024', 'Paid', '1.5000', '2024-10-20', '05:08:45 pm', 'Admin', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (61, 2, 2, 61, 'PU/2021/02/0061', 'Petrol Nissan Sunny', '2024-10-31', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.0100', NULL, '9.0100', 'Purchase date: 27/10/2024\r\nOman oil service station. ', 'Paid', '9.0100', '2024-10-31', '10:53:22 am', 'Admin', '5.37.253.164', '5.37.253.164.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (62, 2, 2, 62, 'PU/2021/02/0062', 'Nissan Sunny ', '2024-10-31', 'Received', 41, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.0000', NULL, '4.0000', 'Car wheel bolt purchase date: 23/10/2024 ', 'Paid', '4.0000', '2024-10-31', '11:09:33 am', 'Admin', '5.37.253.164', '5.37.253.164.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (63, 2, 2, 63, 'PU/2021/02/0063', 'Nissan Sunny car wash', '2024-10-31', 'Received', 37, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.0000', NULL, '1.0000', 'Car wash: 30/10/2024 ', 'Paid', '1.0000', '2024-10-31', '11:11:26 am', 'Admin', '5.37.253.164', '5.37.253.164.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (64, 2, 2, 64, 'PU/2021/02/0064', 'Ac/Engine Air Filter Purchase ', '2024-11-03', 'Received', 42, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '19.9500', NULL, '19.9500', 'The purchase of the items above are for October records. ', 'Paid', '19.9500', '2024-11-03', '05:05:26 pm', 'Admin', '5.36.92.142', '5.36.92.142.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (65, 2, 2, 65, 'PU/2021/02/0065', 'Parts Purchase', '2024-11-18', 'Received', 43, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '23.1000', NULL, '23.1000', '', 'Paid', '23.1000', '2024-11-18', '11:51:44 am', 'Admin', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (66, 2, 2, 66, 'PU/2021/02/0066', 'Al Rayan ', '2024-11-18', 'Received', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '', 'Paid', '5.0000', '2024-11-18', '12:03:05 pm', 'Admin', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (67, 2, 2, 67, 'PU/2021/02/0067', 'Petrol Purchase(Nissan Sunny)', '2024-11-18', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', 'petrol purchase for Nissan Sunny.\r\nDate: 10-11-2024', 'Paid', '9.5000', '2024-11-18', '12:11:30 pm', 'Admin', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (68, 2, 2, 68, 'PU/2021/02/0068', 'Petrol Purchase(Nissan Sunny)', '2024-11-18', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', 'nissan sunny petrol purchase 17/11/2024', 'Paid', '9.5000', '2024-11-18', '12:15:44 pm', 'Admin', '5.36.153.164', '5.36.153.164.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (69, 2, 2, 69, 'PU/2021/02/0069', '', '2024-11-18', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '', 'Paid', '9.5000', '2024-11-18', '04:50:41 pm', 'Admin', '5.36.199.52', '5.36.199.52.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (70, 2, 2, 70, 'PU/2021/02/0070', '', '2024-11-26', 'Received', 44, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '24.0000', NULL, '24.0000', 'Workshop spare part purchase\r\nDate 20/11/2024. Store AG Parts. Wadil Kabir', 'Paid', '24.0000', '2024-11-26', '08:41:36 pm', 'Admin', '5.36.193.162', '5.36.193.162.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (71, 2, 2, 71, 'PU/2021/02/0071', 'REMO&amp;REFIX ALTERNATOR MOTOR', '2024-11-26', 'Received', 45, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '2.0000', NULL, '2.0000', 'REMO&amp;REFIX ALTERNATOR MOTOR sheik Abdullah infinity\r\nDate 25/11/2026. Cash payment of 2 rial to pakistani', 'Paid', '2.0000', '2024-11-26', '08:44:31 pm', 'Admin', '5.36.193.162', '5.36.193.162.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (72, 2, 2, 72, 'PU/2021/02/0072', 'Petrol Refill(Nissan Sunny)', '2024-11-26', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.2000', NULL, '9.2000', 'Petrol refill for nissan suny\r\nDate 24/11/2024', 'Paid', '9.2000', '2024-11-26', '08:49:27 pm', 'Admin', '5.36.193.162', '5.36.193.162.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (73, 2, 2, 73, 'PU/2021/02/0073', 'Petrol Refill(Nissan Sunny)', '2024-12-10', 'Received', 17, '0.4301', 149, '0.4520', NULL, 'in_percentage', NULL, '9.0480', NULL, '9.5000', '08-dec-2024', 'Paid', '9.5000', '2024-12-10', '09:18:27 am', 'Admin', '185.185.133.69', '185.185.133.69', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (74, 2, 2, 74, 'PU/2021/02/0074', '10906-oil filter', '2024-12-10', 'Received', 41, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '6.0000', NULL, '6.0000', '08-dec-2024', 'Paid', '6.0000', '2024-12-10', '09:20:29 am', 'Admin', '185.185.133.69', '185.185.133.69', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (75, 2, 2, 75, 'PU/2021/02/0075', '11798-Circuit braker', '2024-12-10', 'Received', 27, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '7.0000', NULL, '7.0000', '09-dec-2024', 'Paid', '7.0000', '2024-12-10', '09:27:21 am', 'Admin', '185.185.133.69', '185.185.133.69', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (76, 2, 2, 76, 'PU/2021/02/0076', 'oil filter', '2024-12-10', 'Received', 46, '0.4520', 149, '0.4750', NULL, 'in_percentage', NULL, '9.5000', NULL, '9.9750', '', 'Paid', '9.9750', '2024-12-10', '09:33:03 am', 'Admin', '185.185.133.69', '185.185.133.69', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (77, 2, 2, 77, 'PU/2021/02/0077', 'BR8/oil filter', '2024-12-10', 'Received', 43, '0.5950', 149, '0.6250', NULL, 'in_percentage', NULL, '12.5000', NULL, '13.1250', '', 'Paid', '13.1250', '2024-12-10', '09:35:55 am', 'Admin', '185.185.133.69', '185.185.133.69', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (78, 2, 2, 78, 'PU/2021/02/0078', '20107/oil filter', '2024-12-10', 'Received', 22, '0.6490', 149, '0.6810', NULL, 'in_percentage', NULL, '13.6280', NULL, '14.3090', '', 'Paid', '14.3090', '2024-12-10', '09:47:57 am', 'Admin', '185.185.133.69', '185.185.133.69', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (79, 2, 2, 79, 'PU/2021/02/0079', 'F150 rear brakepads purchase', '2024-12-10', 'Received', 47, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '25.0000', NULL, '25.0000', 'F150 rear brakepads purchase', 'Paid', '25.0000', '2024-12-10', '07:32:03 pm', 'Admin', '185.185.132.54', '185.185.132.54', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (80, 2, 2, 80, 'PU/2021/02/0080', 'Oil filter/Bosch brake fluid purchase', '2024-12-10', 'Received', 23, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '26.5000', NULL, '26.5000', 'Purchase of bosch oil filter for mercedes 5Qty, Plus the purchase of bosch dot4 brakefluid 10 Qty', 'Paid', '26.5000', '2024-12-10', '07:34:54 pm', 'Admin', '185.185.132.54', '185.185.132.54', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (81, 2, 2, 81, 'PU/2021/02/0081', 'Petrol Purchase(Nissan Sunny)', '2024-12-10', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', 'Nissan sunny petrol refill.', 'Paid', '5.0000', '2024-12-10', '07:54:20 pm', 'Admin', '185.185.132.54', '185.185.132.54', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (82, 2, 2, 82, 'PU/2021/02/0082', 'Mobile recharge', '2024-12-11', 'Received', 15, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.0000', NULL, '10.0000', 'mobile recharge: 94551017', 'Paid', '10.0000', '2024-12-11', '12:02:51 pm', 'Admin', '185.185.133.70', '185.185.133.70', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (83, 2, 2, 83, 'PU/2021/02/0083', 'monthly internet subscription', '2024-12-11', 'Received', 4, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '31.5300', NULL, '31.5300', 'monthly office internet subscription. 10-Dec-2024', 'Paid', '31.5300', '2024-12-11', '12:06:36 pm', 'Admin', '185.185.133.70', '185.185.133.70', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (84, 2, 2, 84, 'PU/2021/02/0084', 'Electricity payment shop 3', '2024-12-11', 'Received', 30, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.2700', NULL, '8.2700', 'Shop 3. Electricity payment 10-Dec-2024', 'Paid', '8.2700', '2024-12-11', '12:09:02 pm', 'Admin', '185.185.133.70', '185.185.133.70', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (85, 2, 2, 85, 'PU/2021/02/0085', 'PASI', '2024-12-11', 'Received', 39, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.9500', NULL, '4.9500', 'employee social insurance protection 10-Dec-2024', 'Paid', '4.9500', '2024-12-11', '12:14:59 pm', 'Admin', '185.185.133.70', '185.185.133.70', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (86, 2, 2, 86, 'PU/2021/02/0086', 'Employee water accomodation', '2024-12-11', 'Received', 13, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '16.3100', NULL, '16.3100', 'employee water accomodation. 10-Dec-2024', 'Paid', '16.3100', '2024-12-11', '12:19:27 pm', 'Admin', '185.185.133.70', '185.185.133.70', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (87, 2, 2, 87, 'PU/2021/02/0087', 'shop no:1 Electricity bill', '2024-12-11', 'Received', 34, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '27.7200', NULL, '27.7200', 'shop no:1 electricity bill. 10Dec-2024', 'Paid', '27.7200', '2024-12-11', '12:22:00 pm', 'Admin', '185.185.133.70', '185.185.133.70', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (88, 2, 2, 88, 'PU/2021/02/0088', 'Employee accommodation electricity bill', '2024-12-11', 'Received', 14, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '21.3000', NULL, '21.3000', 'employee accomodation electricity bill 10-Dec-2024', 'Paid', '21.3000', '2024-12-11', '12:23:59 pm', 'Admin', '185.185.133.70', '185.185.133.70', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (89, 2, 2, 89, 'PU/2021/02/0089', 'Employee Rental Accomodation', '2024-12-11', 'Received', 36, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '50.0000', NULL, '50.0000', 'Employee monthly rental accomodation ', 'Paid', '50.0000', '2024-12-11', '12:26:28 pm', 'Admin', '185.185.133.70', '185.185.133.70', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (90, 2, 2, 90, 'PU/2021/02/0090', 'Starter motor carbon brush', '2024-12-15', 'Received', 45, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '6.0000', NULL, '6.0000', 'Starter motor carbon brush purchase 4rial plus fixing 2 rial. Total 6rial', 'Paid', '6.0000', '2024-12-15', '07:03:04 pm', 'Admin', '5.36.98.2', '5.36.98.2.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (91, 2, 2, 91, 'PU/2021/02/0091', 'Cotton material ', '2024-12-16', 'Received', 48, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', 'Cotton waste for workshop ', 'Paid', '5.0000', '2024-12-16', '04:34:11 pm', 'Admin', '5.36.129.91', '5.36.129.91.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (92, 2, 2, 92, 'PU/2021/02/0092', 'Petrol purchase for Nissan Sunny petrol ', '2024-12-16', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', 'Petrol refill for Nissan Sunny', 'Paid', '9.5000', '2024-12-16', '04:36:56 pm', 'Admin', '5.36.129.91', '5.36.129.91.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (93, 2, 2, 93, 'PU/2021/02/0093', 'GROCERIES', '2024-12-29', 'Received', 2, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '8.4400', NULL, '8.4400', '', 'Paid', '8.4400', '2024-12-29', '04:34:44 pm', 'Admin', '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (94, 2, 2, 94, 'PU/2021/02/0094', 'Petrol Purchase(Nissan Sunny)', '2024-12-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', 'purchase of petrol for Nissan 23-12-2024', 'Paid', '9.5000', '2024-12-29', '04:37:39 pm', 'Admin', '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (95, 2, 2, 95, 'PU/2021/02/0095', 'Petrol Purchase(Nissan Sunny)', '2024-12-29', 'Received', 19, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.6000', NULL, '3.6000', 'purchase of petrol for Nissan 19-12-2024', 'Paid', '3.6000', '2024-12-29', '04:39:03 pm', 'Admin', '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (96, 2, 2, 96, 'PU/2021/02/0096', 'SOCKET/LED LIGHT/ TESTER', '2024-12-29', 'Received', 27, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.1000', NULL, '3.1000', 'SOCKET/LED LIGHT/ TESTER', 'Paid', '3.1000', '2024-12-29', '04:59:46 pm', 'Admin', '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (97, 2, 2, 97, 'PU/2021/02/0097', 'Petrol purchase GMC', '2024-12-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '2.0000', NULL, '2.0000', '', 'Paid', '2.0000', '2024-12-30', '05:04:39 pm', 'Admin', '5.36.147.110', '5.36.147.110.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (98, 2, 2, 98, 'PU/2021/02/0098', 'Miscellaneous ', '2024-12-30', 'Received', 49, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '3.1500', NULL, '3.1500', '', 'Paid', '3.1500', '2024-12-30', '05:07:25 pm', 'Admin', '5.36.147.110', '5.36.147.110.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (99, 2, 2, 99, 'PU/2021/02/0099', 'Safety Boot Purchase ', '2024-12-30', 'Received', 50, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.5000', NULL, '5.5000', '', 'Paid', '5.5000', '2024-12-30', '05:12:47 pm', 'Admin', '5.36.147.110', '5.36.147.110.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (100, 2, 2, 100, 'PU/2021/02/0100', 'Nissan Sunny Petrol purchase', '2025-01-02', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.5000', NULL, '9.5000', '', 'Paid', '9.5000', '2025-01-02', '12:34:38 pm', 'Admin', '5.37.227.215', '5.37.227.215.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (101, 2, 2, 101, 'PU/2021/02/0101', 'Mr Ibrahim Mobile line Recharge ', '2025-01-02', 'Received', 15, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.5000', NULL, '10.5000', '', 'Paid', '10.5000', '2025-01-02', '12:36:45 pm', 'Admin', '5.37.227.215', '5.37.227.215.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (102, 2, 2, 102, 'PU/2021/02/0102', 'PASI', '2025-01-02', 'Received', 39, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.9000', NULL, '4.9000', '', 'Paid', '4.9000', '2025-01-02', '12:37:41 pm', 'Admin', '5.37.227.215', '5.37.227.215.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (103, 2, 2, 103, 'PU/2021/02/0103', 'Office internet subscription ', '2025-01-02', 'Received', 4, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '32.0000', NULL, '32.0000', '', 'Paid', '32.0000', '2025-01-02', '12:39:08 pm', 'Admin', '5.37.227.215', '5.37.227.215.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (104, 2, 2, 104, 'PU/2021/02/0104', 'Sanad office salary receipt', '2025-01-02', 'Received', 51, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '0.5000', NULL, '0.5000', '', 'Paid', '0.5000', '2025-01-02', '12:47:56 pm', 'Admin', '5.37.227.215', '5.37.227.215.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (105, 2, 2, 105, 'PU/2021/02/0105', 'Car Wash Nissan Sunny', '2025-01-08', 'Received', 37, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.0000', NULL, '1.0000', '', 'Paid', '1.0000', '2025-01-08', '08:05:31 pm', 'Admin', '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (106, 2, 2, 106, 'PU/2021/02/0106', 'Petrol Purchase(Nissan Sunny)', '2025-01-08', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '7.8000', NULL, '7.8000', 'Date 05/01/2025', 'Paid', '7.8000', '2025-01-08', '08:07:57 pm', 'Admin', '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (107, 2, 2, 107, 'PU/2021/02/0107', 'SPARE PARTS', '2025-01-08', 'Received', 52, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '38.0000', NULL, '38.0000', '', 'Paid', '38.0000', '2025-01-08', '08:12:51 pm', 'Admin', '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (108, 2, 2, 108, 'PU/2021/02/0108', 'SPARE PART', '2025-01-08', 'Received', 53, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '63.9600', NULL, '63.9600', '', 'Paid', '63.9600', '2025-01-08', '08:18:07 pm', 'Admin', '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (109, 2, 2, 109, 'PU/2021/02/0109', 'Nissan sunny ', '2025-01-13', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.3000', NULL, '9.3000', '', 'Paid', '9.3000', '2025-01-13', '04:49:50 pm', 'Admin', '5.36.132.242', '5.36.132.242.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (110, 2, 2, 110, 'PU/2021/02/0110', 'Parts purchase', '2025-01-13', 'Received', 24, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '38.0000', NULL, '38.0000', '', 'Paid', '38.0000', '2025-01-13', '04:55:22 pm', 'Admin', '5.36.132.242', '5.36.132.242.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (111, 2, 2, 111, 'PU/2021/02/0111', 'Staff accommodation ', '2025-01-13', 'Received', 12, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '50.0000', NULL, '50.0000', '', 'Paid', '50.0000', '2025-01-13', '04:57:03 pm', 'Admin', '5.36.132.242', '5.36.132.242.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (112, 2, 2, 112, 'PU/2021/02/0112', 'Lower Arm part purchase', '2025-01-13', 'Received', 52, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '16.0000', NULL, '16.0000', '', 'Paid', '16.0000', '2025-01-13', '05:03:47 pm', 'Admin', '5.36.132.242', '5.36.132.242.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (113, 2, 2, 113, 'PU/2021/02/0113', 'Visa aply for mecanic', '2025-01-22', 'Received', 54, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '30.0000', NULL, '30.0000', '', 'Paid', '30.0000', '2025-01-22', '12:35:32 pm', 'Admin', '37.200.247.27', '37.200.247.27', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (114, 2, 2, 114, 'PU/2021/02/0114', 'Oil filters ', '2025-01-22', 'Received', 46, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '16.1700', NULL, '16.1700', '', 'Paid', '16.1700', '2025-01-22', '05:32:47 pm', 'Admin', '37.200.247.27', '37.200.247.27', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (115, 2, 2, 115, 'PU/2021/02/0115', 'Oil filters ', '2025-01-22', 'Received', 43, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '12.2850', NULL, '12.2850', '', 'Paid', '12.2850', '2025-01-22', '05:36:22 pm', 'Admin', '37.200.247.27', '37.200.247.27', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (116, 2, 2, 116, 'PU/2021/02/0116', 'Oil filters', '2025-01-22', 'Received', 22, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '30.5990', NULL, '30.5990', '', 'Paid', '30.5990', '2025-01-22', '05:38:03 pm', 'Admin', '37.200.247.27', '37.200.247.27', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (117, 2, 2, 117, 'PU/2021/02/0117', 'Petrol Nissan sunny ', '2025-01-25', 'Received', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '9.1000', NULL, '9.1000', '', 'Paid', '9.1000', '2025-01-25', '12:28:45 pm', 'Admin', '188.135.25.55', '188.135.25.55', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (118, 2, 2, 118, 'PU/2021/02/0118', 'Nissan sunny, A/66845 Insurance ', '2025-01-26', 'Received', 55, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '48.0000', NULL, '48.0000', '', 'Paid', '48.0000', '2025-01-26', '06:01:49 pm', 'Admin', '188.135.25.55', '188.135.25.55', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (119, 2, 2, 119, 'PU/2021/02/0119', 'Airport Parking ', '2025-01-27', 'Received', 56, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.1000', NULL, '1.1000', '', 'Paid', '1.1000', '2025-01-27', '04:56:27 pm', 'Admin', '5.36.86.76', '5.36.86.76.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (120, 2, 2, 120, 'PU/2021/02/0120', 'Miscellaneous Items', '2025-01-27', 'Received', 49, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '12.2700', NULL, '12.2700', '', 'Paid', '12.2700', '2025-01-27', '05:05:34 pm', 'Admin', '5.36.86.76', '5.36.86.76.dynamic-dsl-ip.omantel.net.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (121, 2, 2, 121, 'PU/2021/02/0121', 'Tools for work shop ', '2025-02-02', 'Received', 57, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '7.0000', NULL, '7.0000', '', 'Paid', '7.0000', '2025-02-02', '07:21:26 pm', 'Admin', '188.135.25.55', '188.135.25.55', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (122, 2, 2, 122, 'PU/2021/02/0122', 'Break fluid ', '2025-02-02', 'Received', 23, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '35.7000', NULL, '35.7000', '', 'Paid', '35.7000', '2025-02-02', '07:24:02 pm', 'Admin', '188.135.25.55', '188.135.25.55', NULL, 1, NULL);


#
# TABLE STRUCTURE FOR: db_purchaseitems
#

DROP TABLE IF EXISTS `db_purchaseitems`;

CREATE TABLE `db_purchaseitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `purchase_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `purchase_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=225 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (24, 2, 11, 'Received', 79, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (25, 2, 10, 'Received', 78, '1.00', '50.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '50.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (27, 2, 9, 'Received', 77, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (28, 2, 8, 'Received', 76, '1.00', '20.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '20.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (30, 2, 7, 'Received', 75, '1.00', '0.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.0000', '0.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (31, 2, 6, 'Received', 74, '1.00', '20.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '20.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (33, 2, 5, 'Received', 73, '1.00', '0.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.0000', '0.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (35, 2, 4, 'Received', 72, '2.00', '0.0000', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.0000', '0.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (37, 2, 3, 'Received', 71, '20.00', '0.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.0000', '0.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (38, 2, 2, 'Received', 70, '1.00', '25.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '25.0000', '25.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (41, 2, 12, 'Received', 81, '1.00', '10.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '10.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (42, 2, 13, 'Received', 79, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (44, 2, 14, 'Received', 83, '1.00', '22.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '22.0000', '22.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (45, 2, 15, 'Received', 84, '1.00', '15.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '15.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (46, 2, 1, 'Received', 69, '1.00', '12.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '12.5000', '12.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (47, 2, 16, 'Received', 36, '1.00', '8.3000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.3000', '8.3000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (49, 2, 18, 'Received', 36, '1.00', '7.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '7.0000', '7.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (50, 2, 19, 'Received', 88, '1.00', '3.7400', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.7400', '3.7400', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (51, 2, 20, 'Received', 89, '1.00', '2.2900', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.2900', '2.2900', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (53, 2, 17, 'Received', 87, '1.00', '3.3000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.3000', '3.3000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (54, 2, 21, 'Received', 89, '1.00', '3.1000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.1000', '3.1000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (56, 2, 22, 'Received', 70, '1.00', '8.4950', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.4950', '8.4950', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (58, 2, 23, 'Received', 69, '1.00', '9.2000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.2000', '9.2000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (59, 2, 24, 'Received', 69, '1.00', '8.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.0000', '8.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (60, 2, 25, 'Received', 89, '1.00', '2.2900', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.2900', '2.2900', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (62, 2, 27, 'Received', 26, '10.00', '1.4070', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.4070', '14.0700', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (63, 2, 26, 'Received', 26, '10.00', '2.3000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.3000', '23.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (65, 2, 29, 'Received', 26, '8.00', '3.7500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.7500', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (66, 2, 28, 'Received', 26, '1.00', '16.9010', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '16.9010', '16.9010', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (67, 2, 30, 'Received', 91, '1.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '1.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (68, 2, 31, 'Received', 69, '1.00', '3.4000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.4000', '3.4000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (70, 2, 33, 'Received', 92, '2.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '1.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (72, 2, 34, 'Received', 89, '1.00', '3.2000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.2000', '3.2000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (93, 2, 37, 'Received', 98, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (94, 2, 37, 'Received', 99, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (95, 2, 37, 'Received', 100, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (96, 2, 37, 'Received', 101, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (97, 2, 37, 'Received', 102, '5.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '2.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (98, 2, 36, 'Received', 93, '5.00', '0.6000', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (99, 2, 36, 'Received', 94, '5.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (100, 2, 36, 'Received', 95, '5.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (101, 2, 36, 'Received', 96, '5.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (102, 2, 36, 'Received', 97, '5.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (103, 2, 38, 'Received', 69, '1.00', '9.8000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.8000', '9.8000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (104, 2, 39, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (105, 2, 40, 'Received', 89, '1.00', '4.9550', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.9550', '4.9550', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (106, 2, 41, 'Received', 89, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (107, 2, 42, 'Received', 76, '1.00', '35.0980', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '35.0980', '35.0980', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (108, 2, 43, 'Received', 77, '1.00', '8.1250', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.1250', '8.1250', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (109, 2, 44, 'Received', 74, '1.00', '35.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '35.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (110, 2, 45, 'Received', 81, '1.00', '13.5300', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '13.5300', '13.5300', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (111, 2, 46, 'Received', 70, '1.00', '31.7650', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '31.7650', '31.7650', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (112, 2, 47, 'Received', 78, '1.00', '50.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '50.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (113, 2, 48, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (114, 2, 49, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (115, 2, 50, 'Received', 69, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (116, 2, 51, 'Received', 91, '1.00', '1.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.5000', '1.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (120, 2, 53, 'Received', 114, '1.00', '170.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '170.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (121, 2, 53, 'Received', 117, '22.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '13.2000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (124, 2, 52, 'Received', 114, '1.00', '140.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '140.0000', '140.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (125, 2, 52, 'Received', 117, '22.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '11.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (126, 2, 54, 'Received', 114, '1.00', '400.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '400.0000', '400.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (127, 2, 55, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (128, 2, 56, 'Received', 72, '1.00', '4.4900', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.4900', '4.4900', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (129, 2, 57, 'Received', 120, '1.00', '1.8000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.8000', '1.8000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (130, 2, 57, 'Received', 121, '1.00', '0.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.6000', '0.6000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (131, 2, 57, 'Received', 122, '1.00', '0.9000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.9000', '0.9000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (132, 2, 57, 'Received', 123, '1.00', '0.8000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.8000', '0.8000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (133, 2, 58, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (134, 2, 59, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (135, 2, 60, 'Received', 91, '1.00', '1.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.5000', '1.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (136, 2, 61, 'Received', 69, '1.00', '9.0100', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.0100', '9.0100', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (137, 2, 62, 'Received', 130, '16.00', '0.2500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.2500', '4.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (138, 2, 63, 'Received', 91, '1.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '1.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (140, 2, 64, 'Received', 132, '1.00', '8.8200', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.8200', '8.8200', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (141, 2, 64, 'Received', 133, '1.00', '11.1300', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '11.1300', '11.1300', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (142, 2, 65, 'Received', 124, '1.00', '23.1000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '23.1000', '23.1000', NULL, NULL, 1, 'Catridge oil filter Qty 3\r\nFilter assy oil Qty 4\r\nOil filter Qty 3\r\nOil filter Qty 3');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (143, 2, 66, 'Received', 72, '1.00', '5.0000', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (145, 2, 67, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (147, 2, 68, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (148, 2, 69, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (149, 2, 70, 'Received', 124, '1.00', '24.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '24.0000', '24.0000', NULL, NULL, 1, 'VW Oil Filter Qty 2\r\nOil Filter Qty 2\r\nBMW Oil Filter Qty 2\r\nBMW oil Filter Qty 2');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (151, 2, 71, 'Received', 142, '1.00', '2.0000', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '2.0000', NULL, NULL, 1, 'REMO&amp;REFIX ALTERNATOR MOTOR');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (152, 2, 72, 'Received', 69, '1.00', '9.2000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.2000', '9.2000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (154, 2, 74, 'Received', 26, '1.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (155, 2, 75, 'Received', 147, '1.00', '7.0000', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '7.0000', '7.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (156, 2, 76, 'Received', 26, '5.00', '1.9000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.9000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (157, 2, 77, 'Received', 26, '5.00', '2.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.5000', '12.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (158, 2, 78, 'Received', 148, '2.00', '1.8740', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.8740', '3.7480', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (159, 2, 78, 'Received', 26, '2.00', '2.3820', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.3820', '4.7640', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (160, 2, 78, 'Received', 149, '4.00', '1.2790', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.2790', '5.1160', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (164, 2, 73, 'Received', 69, '1.00', '9.0480', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.0480', '9.0480', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (165, 2, 79, 'Received', 34, '1.00', '25.0000', 'Exclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '25.0000', '25.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (173, 2, 80, 'Received', 152, '1.00', '14.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '14.5000', '14.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (174, 2, 80, 'Received', 151, '1.00', '12.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '12.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (175, 2, 81, 'Received', 69, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (176, 2, 82, 'Received', 81, '1.00', '10.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '10.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (177, 2, 83, 'Received', 70, '1.00', '31.5300', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '31.5300', '31.5300', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (178, 2, 84, 'Received', 76, '1.00', '8.2700', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.2700', '8.2700', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (180, 2, 86, 'Received', 79, '1.00', '16.3100', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '16.3100', '16.3100', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (183, 2, 89, 'Received', 78, '1.00', '50.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '50.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (185, 2, 88, 'Received', 80, '1.00', '21.3000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '21.3000', '21.3000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (186, 2, 87, 'Received', 74, '1.00', '27.7200', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '27.7200', '27.7200', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (187, 2, 85, 'Received', 153, '1.00', '4.9500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.9500', '4.9500', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (188, 2, 90, 'Received', 155, '1.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (189, 2, 91, 'Received', 156, '2.00', '2.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.5000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (190, 2, 92, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (191, 2, 93, 'Received', 89, '1.00', '8.4400', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.4400', '8.4400', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (193, 2, 95, 'Received', 69, '1.00', '3.6000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.6000', '3.6000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (194, 2, 94, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (195, 2, 96, 'Received', 124, '1.00', '3.1000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.1000', '3.1000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (196, 2, 97, 'Received', 36, '1.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '2.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (197, 2, 98, 'Received', 124, '1.00', '3.1500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.1500', '3.1500', NULL, NULL, 1, '2 pieces of workshop wears for Manni');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (198, 2, 99, 'Received', 124, '1.00', '5.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.5000', '5.5000', NULL, NULL, 1, 'Safety Boot Purchase for Manni');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (199, 2, 100, 'Received', 69, '1.00', '9.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.5000', '9.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (200, 2, 101, 'Received', 81, '1.00', '10.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '10.5000', '10.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (201, 2, 102, 'Received', 153, '1.00', '4.9000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.9000', '4.9000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (202, 2, 103, 'Received', 70, '1.00', '32.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '32.0000', '32.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (203, 2, 104, 'Received', 158, '1.00', '0.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '0.5000', '0.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (204, 2, 105, 'Received', 91, '1.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '1.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (205, 2, 106, 'Received', 69, '1.00', '7.8000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '7.8000', '7.8000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (206, 2, 107, 'Received', 124, '1.00', '38.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '38.0000', '38.0000', NULL, NULL, 1, 'B/SHOE REAR RIGHT QTY 1 8RIAL\r\nL/ROD Q2 8RIAL\r\nAXLE BOOT QTY 2 10RIAL\r\nTIEROD END OPEN QTY 2 2RIAL');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (208, 2, 108, 'Received', 124, '1.00', '63.9600', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '63.9600', '63.9600', NULL, NULL, 1, 'NISSAN ATF MATIC 4L 21RIAL\r\nLONGLIFE COOLANT 4L 6.21RIAL\r\nAIR FILTER KIT AC QTY1 5.25RIAL\r\nENGINE AIR FILTER QTY1 6.09RIAL\r\nGASKET OIL PAN QTY1 7.77RIAL\r\nSPARKPLUG QTY4 17.64RIAL');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (209, 2, 109, 'Received', 69, '1.00', '9.3000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.3000', '9.3000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (210, 2, 110, 'Received', 124, '1.00', '38.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '38.0000', '38.0000', NULL, NULL, 1, 'Oil filter Audi/vw Qty (2) 4.00omr\r\nLR oil filter Qty(2) 6.999omr\r\nOil filter Qty (2) 6.999omr\r\nOil filter Qty (2) 5omr\r\nVw oil filter Qty (2) 5omr\r\nOil filter Qty (2) 4.001omr\r\nBrakefluid qty(4) 6.002omr');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (211, 2, 111, 'Received', 84, '1.00', '50.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '50.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (212, 2, 112, 'Received', 124, '1.00', '16.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '16.0000', '16.0000', NULL, NULL, 1, 'Front Right Lower arm and\r\nFront Left Lower arm');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (215, 2, 114, 'Received', 124, '1.00', '16.1700', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '16.1700', '16.1700', NULL, NULL, 1, 'Purchase of oil filters');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (216, 2, 113, 'Received', 124, '1.00', '30.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '30.0000', '30.0000', NULL, NULL, 1, 'APlay work visa for ahmad dilshad');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (217, 2, 115, 'Received', 124, '1.00', '12.2850', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '12.2850', '12.2850', NULL, NULL, 1, 'Purchase of oil filters');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (218, 2, 116, 'Received', 124, '1.00', '30.5990', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '30.5990', '30.5990', NULL, NULL, 1, 'Oil filter');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (219, 2, 117, 'Received', 124, '1.00', '9.1000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '9.1000', '9.1000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (220, 2, 118, 'Received', 124, '1.00', '48.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '48.0000', '48.0000', NULL, NULL, 1, 'Nissan sunny insurance');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (221, 2, 119, 'Received', 124, '1.00', '1.1000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.1000', '1.1000', NULL, NULL, 1, 'Airport parking receipt');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (222, 2, 120, 'Received', 124, '1.00', '12.2700', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '12.2700', '12.2700', NULL, NULL, 1, 'Al QBL COMFRTR 1.990\r\nLMST MIX SOCKS \r\nNJIM AL SMA MIX GAR\r\nGRN WTR MIX GRAME\r\nPNK FOOTWEAR\r\nLF TP MIX GARMENTS\r\nBLEND MENS T-SHIRT');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (223, 2, 121, 'Received', 124, '1.00', '7.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '7.0000', '7.0000', NULL, NULL, 1, 'Tools for work shop');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (224, 2, 122, 'Received', 124, '1.00', '35.7000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '35.7000', '35.7000', NULL, NULL, 1, 'Boush break fluid 500 ml');


#
# TABLE STRUCTURE FOR: db_purchaseitemsreturn
#

DROP TABLE IF EXISTS `db_purchaseitemsreturn`;

CREATE TABLE `db_purchaseitemsreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_id` int DEFAULT NULL,
  `return_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `purchase_id` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepayments
#

DROP TABLE IF EXISTS `db_purchasepayments`;

CREATE TABLE `db_purchasepayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  KEY `supplier_id` (`supplier_id`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (1, 1, 'PP/2021/02/0001', 2, 11, '2024-08-08', 'Cash', '5.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:15:36', '2024-08-08', 'Admin', 1, NULL, 13, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (2, 2, 'PP/2021/02/0002', 2, 10, '2024-08-08', 'Bank Transfer', '50.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:18:00', '2024-08-08', 'Admin', 1, NULL, 12, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (3, 3, 'PP/2021/02/0003', 2, 8, '2024-08-08', 'Bank Transfer', '20.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:26:06', '2024-08-08', 'Admin', 1, NULL, 10, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (4, 4, 'PP/2021/02/0004', 2, 9, '2024-08-08', 'Bank Transfer', '5.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:26:25', '2024-08-08', 'Admin', 1, NULL, 11, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (5, 5, 'PP/2021/02/0005', 2, 6, '2024-08-08', 'Bank Transfer', '20.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:28:04', '2024-08-08', 'Admin', 1, NULL, 8, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (6, 6, 'PP/2021/02/0006', 2, 2, '2024-08-08', 'Bank Transfer', '25.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:32:36', '2024-08-08', 'Admin', 1, NULL, 4, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (7, 7, 'PP/2021/02/0007', 2, 12, '2024-08-08', 'Bank Transfer', '10.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:44:07', '2024-08-08', 'Admin', 1, NULL, 15, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (8, 8, 'PP/2021/02/0008', 2, 13, '2024-08-08', 'Bank Transfer', '5.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '11:48:14', '2024-08-08', 'Admin', 1, NULL, 13, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (9, 9, 'PP/2021/02/0009', 2, 14, '2024-08-08', 'Cash', '22.0000', '', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', '12:19:33', '2024-08-08', 'Admin', 1, NULL, 16, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (10, 10, 'PP/2021/02/0010', 2, 15, '2024-08-08', 'Cash', '15.0000', '', '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', '05:13:37', '2024-08-08', 'Admin', 1, NULL, 12, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (11, 11, 'PP/2021/02/0011', 2, 1, '2024-08-08', 'Cash', '12.5000', 'company vehicle petrol purchase between the periods below:\n01-08-2024(5.5 rial)\n05-08-2024(7.5 rial)\nTotal 12.500 rial\n', '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', '05:20:50', '2024-08-08', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (12, 12, 'PP/2021/02/0012', 2, 16, '2024-08-19', 'Cash', '8.3000', '', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '08:03:23', '2024-08-19', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (13, 13, 'PP/2021/02/0013', 2, 17, '2024-08-19', 'Cash', '3.3000', '', '5.36.235.83', '5.36.235.83.dynamic-dsl-ip.omantel.net.om', '08:43:33', '2024-08-19', 'Admin', 1, NULL, 18, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (14, 14, 'PP/2021/02/0014', 2, 18, '2024-08-20', 'Cash', '7.0000', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '09:29:59', '2024-08-20', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (15, 15, 'PP/2021/02/0015', 2, 19, '2024-08-20', 'Cash', '3.7400', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '09:54:05', '2024-08-20', 'Admin', 1, NULL, 20, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (16, 16, 'PP/2021/02/0016', 2, 20, '2024-08-20', 'Cash', '2.2900', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '10:06:43', '2024-08-20', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (17, 17, 'PP/2021/02/0017', 2, 21, '2024-08-20', 'Cash', '3.1000', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '10:21:58', '2024-08-20', 'Admin', 1, NULL, 18, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (18, 18, 'PP/2021/02/0018', 2, 22, '2024-08-20', 'Cash', '8.4950', '', '5.36.207.1', '5.36.207.1.dynamic-dsl-ip.omantel.net.om', '11:50:39', '2024-08-20', 'Admin', 1, NULL, 4, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (19, 19, 'PP/2021/02/0019', 2, 29, '2024-08-26', 'Cash', '30.0000', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:38:50', '2024-08-26', 'Admin', 1, NULL, 24, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (20, 20, 'PP/2021/02/0020', 2, 28, '2024-08-26', 'Cash', '16.9010', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:41:10', '2024-08-26', 'Admin', 1, NULL, 23, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (21, 21, 'PP/2021/02/0021', 2, 27, '2024-08-26', 'Cash', '14.0700', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:41:41', '2024-08-26', 'Admin', 1, NULL, 22, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (22, 22, 'PP/2021/02/0022', 2, 26, '2024-08-26', 'Cash', '23.0000', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:41:49', '2024-08-26', 'Admin', 1, NULL, 22, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (23, 23, 'PP/2021/02/0023', 2, 25, '2024-08-26', 'Cash', '2.2900', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:41:55', '2024-08-26', 'Admin', 1, NULL, 18, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (24, 24, 'PP/2021/02/0024', 2, 24, '2024-08-26', 'Cash', '8.0000', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:42:20', '2024-08-26', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (25, 25, 'PP/2021/02/0025', 2, 23, '2024-08-26', 'Cash', '9.2000', '', '5.36.181.157', '5.36.181.157.dynamic-dsl-ip.omantel.net.om', '10:42:29', '2024-08-26', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (26, 26, 'PP/2021/02/0026', 2, 30, '2024-08-29', 'Cash', '1.0000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '09:46:47', '2024-08-29', 'Admin', 1, NULL, 26, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (27, 27, 'PP/2021/02/0027', 2, 31, '2024-08-29', 'Cash', '3.4000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '09:49:20', '2024-08-29', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (29, 29, 'PP/2021/02/0029', 2, 33, '2024-08-29', 'Cash', '1.0000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '10:04:54', '2024-08-29', 'Admin', 1, NULL, 27, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (30, 30, 'PP/2021/02/0030', 2, 34, '2024-08-29', 'Cash', '3.2000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '10:10:39', '2024-08-29', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (31, 31, 'PP/2021/02/0031', 2, 36, '2024-08-29', 'Cash', '15.0000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '12:16:19', '2024-08-29', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (32, 32, 'PP/2021/02/0032', 2, 37, '2024-08-29', 'Cash', '12.5000', '', '5.37.202.83', '5.37.202.83.dynamic-dsl-ip.omantel.net.om', '12:38:00', '2024-08-29', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (33, 33, 'PP/2021/02/0033', 2, 41, '2024-09-16', 'Cash', '5.0000', '', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', '11:12:26', '2024-09-16', 'Admin', 1, NULL, 29, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (34, 34, 'PP/2021/02/0034', 2, 40, '2024-09-16', 'Cash', '4.9550', '', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', '11:12:34', '2024-09-16', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (35, 35, 'PP/2021/02/0035', 2, 39, '2024-09-16', 'Cash', '9.5000', '', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', '11:12:44', '2024-09-16', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (36, 36, 'PP/2021/02/0036', 2, 38, '2024-09-16', 'Cash', '9.8000', '', '5.36.251.37', '5.36.251.37.dynamic-dsl-ip.omantel.net.om', '11:12:55', '2024-09-16', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (37, 37, 'PP/2021/02/0037', 2, 42, '2024-09-18', 'Visa', '35.0980', '', '5.37.112.133', '5.37.112.133', '05:09:36', '2024-09-18', 'Admin', 1, NULL, 30, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (38, 38, 'PP/2021/02/0038', 2, 43, '2024-09-18', 'Visa', '8.1250', '', '5.37.112.133', '5.37.112.133', '05:14:37', '2024-09-18', 'Admin', 1, NULL, 33, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (39, 39, 'PP/2021/02/0039', 2, 44, '2024-09-18', 'Visa', '35.0000', '', '5.37.112.133', '5.37.112.133', '05:17:08', '2024-09-18', 'Admin', 1, NULL, 34, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (40, 40, 'PP/2021/02/0040', 2, 45, '2024-09-18', 'Visa', '13.5300', '', '5.37.112.133', '5.37.112.133', '05:27:52', '2024-09-18', 'Admin', 1, NULL, 35, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (41, 41, 'PP/2021/02/0041', 2, 46, '2024-09-18', 'Visa', '31.7650', '', '5.37.112.133', '5.37.112.133', '05:28:02', '2024-09-18', 'Admin', 1, NULL, 4, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (42, 42, 'PP/2021/02/0042', 2, 47, '2024-09-18', 'Visa', '50.0000', '', '5.37.112.133', '5.37.112.133', '05:32:44', '2024-09-18', 'Admin', 1, NULL, 36, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (43, 43, 'PP/2021/02/0043', 2, 54, '2024-09-30', 'Visa', '400.0000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '11:56:00', '2024-09-30', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (44, 44, 'PP/2021/02/0044', 2, 53, '2024-09-30', 'Bank Transfer', '183.2000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:05:41', '2024-09-30', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (45, 45, 'PP/2021/02/0045', 2, 52, '2024-09-30', 'Bank Transfer', '151.0000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:06:01', '2024-09-30', 'Admin', 1, NULL, 28, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (46, 46, 'PP/2021/02/0046', 2, 51, '2024-09-30', 'Cash', '1.5000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:07:19', '2024-09-30', 'Admin', 1, NULL, 37, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (47, 47, 'PP/2021/02/0047', 2, 50, '2024-09-30', 'Visa', '5.0000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:07:33', '2024-09-30', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (48, 48, 'PP/2021/02/0048', 2, 49, '2024-09-30', 'Visa', '9.5000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:07:59', '2024-09-30', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (49, 49, 'PP/2021/02/0049', 2, 48, '2024-09-30', 'Visa', '9.5000', '', '5.37.218.8', '5.37.218.8.dynamic-dsl-ip.omantel.net.om', '12:08:12', '2024-09-30', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (50, 50, 'PP/2021/02/0050', 2, 57, '2024-10-08', 'Bank Transfer', '4.1000', '', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '11:09:10', '2024-10-08', 'Admin', 1, NULL, 40, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (51, 51, 'PP/2021/02/0051', 2, 56, '2024-10-08', 'Bank Transfer', '4.4900', '', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '11:09:23', '2024-10-08', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (52, 52, 'PP/2021/02/0052', 2, 55, '2024-10-08', 'Bank Transfer', '9.5000', '', '5.37.245.224', '5.37.245.224.dynamic-dsl-ip.omantel.net.om', '11:09:34', '2024-10-08', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (53, 53, 'PP/2021/02/0053', 2, 60, '2024-10-20', 'Cash', '1.5000', '', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', '05:09:38', '2024-10-20', 'Admin', 1, NULL, 37, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (54, 54, 'PP/2021/02/0054', 2, 59, '2024-10-20', 'Visa', '9.5000', '', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', '05:10:17', '2024-10-20', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (55, 55, 'PP/2021/02/0055', 2, 58, '2024-10-20', 'Visa', '9.5000', '', '5.36.216.140', '5.36.216.140.dynamic-dsl-ip.omantel.net.om', '05:10:35', '2024-10-20', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (56, 56, 'PP/2021/02/0056', 2, 64, '2024-11-03', 'Visa', '19.9500', '', '5.36.92.142', '5.36.92.142.dynamic-dsl-ip.omantel.net.om', '05:11:49', '2024-11-03', 'Admin', 1, NULL, 42, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (57, 57, 'PP/2021/02/0057', 2, 63, '2024-11-03', 'Cash', '1.0000', '', '5.36.92.142', '5.36.92.142.dynamic-dsl-ip.omantel.net.om', '05:12:20', '2024-11-03', 'Admin', 1, NULL, 37, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (58, 58, 'PP/2021/02/0058', 2, 62, '2024-11-03', 'Visa', '4.0000', '', '5.36.92.142', '5.36.92.142.dynamic-dsl-ip.omantel.net.om', '05:12:34', '2024-11-03', 'Admin', 1, NULL, 41, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (59, 59, 'PP/2021/02/0059', 2, 61, '2024-11-03', 'Visa', '9.0100', '', '5.36.92.142', '5.36.92.142.dynamic-dsl-ip.omantel.net.om', '05:12:54', '2024-11-03', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (60, 60, 'PP/2021/02/0060', 2, 65, '2024-11-18', 'Visa', '23.1000', '', '5.36.199.52', '5.36.199.52.dynamic-dsl-ip.omantel.net.om', '04:52:49', '2024-11-18', 'Admin', 1, NULL, 43, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (61, 61, 'PP/2021/02/0061', 2, 66, '2024-11-18', 'Visa', '5.0000', '', '5.36.199.52', '5.36.199.52.dynamic-dsl-ip.omantel.net.om', '04:52:59', '2024-11-18', 'Admin', 1, NULL, 21, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (62, 62, 'PP/2021/02/0062', 2, 67, '2024-11-18', 'Visa', '9.5000', '', '5.36.199.52', '5.36.199.52.dynamic-dsl-ip.omantel.net.om', '04:53:07', '2024-11-18', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (63, 63, 'PP/2021/02/0063', 2, 68, '2024-11-18', 'Visa', '9.5000', '', '5.36.199.52', '5.36.199.52.dynamic-dsl-ip.omantel.net.om', '04:53:17', '2024-11-18', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (64, 64, 'PP/2021/02/0064', 2, 69, '2024-11-18', 'Visa', '9.5000', '', '5.36.199.52', '5.36.199.52.dynamic-dsl-ip.omantel.net.om', '04:53:35', '2024-11-18', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (65, 65, 'PP/2021/02/0065', 2, 72, '2024-11-26', 'Visa', '9.2000', '', '5.36.193.162', '5.36.193.162.dynamic-dsl-ip.omantel.net.om', '08:50:11', '2024-11-26', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (66, 66, 'PP/2021/02/0066', 2, 71, '2024-11-26', 'Cash', '2.0000', '', '5.36.193.162', '5.36.193.162.dynamic-dsl-ip.omantel.net.om', '08:50:22', '2024-11-26', 'Admin', 1, NULL, 45, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (67, 67, 'PP/2021/02/0067', 2, 70, '2024-11-26', 'Visa', '24.0000', '', '5.36.193.162', '5.36.193.162.dynamic-dsl-ip.omantel.net.om', '08:50:46', '2024-11-26', 'Admin', 1, NULL, 44, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (68, 68, 'PP/2021/02/0068', 2, 78, '2024-12-10', 'Visa', '14.3090', '', '185.185.133.69', '185.185.133.69', '09:49:54', '2024-12-10', 'Admin', 1, NULL, 22, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (69, 69, 'PP/2021/02/0069', 2, 77, '2024-12-10', 'Visa', '13.1250', '', '185.185.133.69', '185.185.133.69', '09:50:04', '2024-12-10', 'Admin', 1, NULL, 43, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (70, 70, 'PP/2021/02/0070', 2, 76, '2024-12-10', 'Visa', '9.9750', '', '185.185.133.69', '185.185.133.69', '09:50:12', '2024-12-10', 'Admin', 1, NULL, 46, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (71, 71, 'PP/2021/02/0071', 2, 75, '2024-12-10', 'Visa', '7.0000', '', '185.185.133.69', '185.185.133.69', '09:50:21', '2024-12-10', 'Admin', 1, NULL, 27, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (72, 72, 'PP/2021/02/0072', 2, 74, '2024-12-10', 'Visa', '6.0000', '', '185.185.133.69', '185.185.133.69', '09:50:29', '2024-12-10', 'Admin', 1, NULL, 41, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (73, 73, 'PP/2021/02/0073', 2, 73, '2024-12-10', 'Cash', '9.5000', '', '185.185.133.69', '185.185.133.69', '10:03:38', '2024-12-10', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (75, 74, 'PP/2021/02/0074', 2, 80, '2024-12-10', 'Visa', '26.5000', '', '185.185.132.54', '185.185.132.54', '07:49:04', '2024-12-10', 'Admin', 1, NULL, 23, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (76, 76, 'PP/2021/02/0076', 2, 79, '2024-12-10', 'Visa', '25.0000', '', '185.185.132.54', '185.185.132.54', '07:49:15', '2024-12-10', 'Admin', 1, NULL, 47, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (77, 77, 'PP/2021/02/0077', 2, 81, '2024-12-10', 'Visa', '5.0000', '', '185.185.132.54', '185.185.132.54', '07:54:40', '2024-12-10', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (78, 78, 'PP/2021/02/0078', 2, 89, '2024-12-11', 'Visa', '50.0000', '', '185.185.133.70', '185.185.133.70', '12:28:23', '2024-12-11', 'Admin', 1, NULL, 36, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (79, 79, 'PP/2021/02/0079', 2, 88, '2024-12-11', 'Visa', '21.3000', '', '185.185.133.70', '185.185.133.70', '12:33:37', '2024-12-11', 'Admin', 1, NULL, 14, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (80, 80, 'PP/2021/02/0080', 2, 87, '2024-12-11', 'Visa', '27.7200', '', '185.185.133.70', '185.185.133.70', '12:34:56', '2024-12-11', 'Admin', 1, NULL, 34, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (81, 81, 'PP/2021/02/0081', 2, 86, '2024-12-11', 'Cash', '16.3100', '', '185.185.133.70', '185.185.133.70', '12:35:19', '2024-12-11', 'Admin', 1, NULL, 13, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (82, 82, 'PP/2021/02/0082', 2, 85, '2024-12-11', 'Cash', '4.9500', '', '185.185.133.70', '185.185.133.70', '12:37:36', '2024-12-11', 'Admin', 1, NULL, 39, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (83, 83, 'PP/2021/02/0083', 2, 84, '2024-12-11', 'Cash', '8.2700', '', '185.185.133.70', '185.185.133.70', '12:37:44', '2024-12-11', 'Admin', 1, NULL, 30, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (84, 84, 'PP/2021/02/0084', 2, 83, '2024-12-11', 'Cash', '31.5300', '', '185.185.133.70', '185.185.133.70', '12:37:51', '2024-12-11', 'Admin', 1, NULL, 4, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (85, 85, 'PP/2021/02/0085', 2, 82, '2024-12-11', 'Cash', '10.0000', '', '185.185.133.70', '185.185.133.70', '12:38:33', '2024-12-11', 'Admin', 1, NULL, 15, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (86, 86, 'PP/2021/02/0086', 2, 92, '2024-12-16', 'Visa', '9.5000', '', '5.36.129.91', '5.36.129.91.dynamic-dsl-ip.omantel.net.om', '04:37:17', '2024-12-16', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (87, 87, 'PP/2021/02/0087', 2, 91, '2024-12-16', 'Visa', '5.0000', '', '5.36.129.91', '5.36.129.91.dynamic-dsl-ip.omantel.net.om', '04:37:26', '2024-12-16', 'Admin', 1, NULL, 48, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (88, 88, 'PP/2021/02/0088', 2, 90, '2024-12-16', 'Visa', '6.0000', '', '5.36.129.91', '5.36.129.91.dynamic-dsl-ip.omantel.net.om', '04:37:34', '2024-12-16', 'Admin', 1, NULL, 45, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (89, 89, 'PP/2021/02/0089', 2, 93, '2024-12-29', 'Visa', '8.4400', '', '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', '04:39:53', '2024-12-29', 'Admin', 1, NULL, 2, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (90, 90, 'PP/2021/02/0090', 2, 94, '2024-12-29', 'Visa', '9.5000', '', '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', '04:41:09', '2024-12-29', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (91, 91, 'PP/2021/02/0091', 2, 95, '2024-12-29', 'Visa', '3.6000', '', '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', '04:41:19', '2024-12-29', 'Admin', 1, NULL, 19, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (92, 92, 'PP/2021/02/0092', 2, 96, '2024-12-29', 'Visa', '3.1000', '', '5.36.152.20', '5.36.152.20.dynamic-dsl-ip.omantel.net.om', '05:04:42', '2024-12-29', 'Admin', 1, NULL, 27, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (93, 93, 'PP/2021/02/0093', 2, 99, '2024-12-30', 'Visa', '5.5000', '', '5.36.147.110', '5.36.147.110.dynamic-dsl-ip.omantel.net.om', '05:13:23', '2024-12-30', 'Admin', 1, NULL, 50, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (94, 94, 'PP/2021/02/0094', 2, 98, '2024-12-30', 'Visa', '3.1500', '', '5.36.147.110', '5.36.147.110.dynamic-dsl-ip.omantel.net.om', '05:13:41', '2024-12-30', 'Admin', 1, NULL, 49, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (95, 95, 'PP/2021/02/0095', 2, 97, '2024-12-30', 'Visa', '2.0000', '', '5.36.147.110', '5.36.147.110.dynamic-dsl-ip.omantel.net.om', '05:13:48', '2024-12-30', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (96, 96, 'PP/2021/02/0096', 2, 104, '2025-01-03', 'Visa', '0.5000', '', '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '08:03:52', '2025-01-03', 'Admin', 1, NULL, 51, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (97, 97, 'PP/2021/02/0097', 2, 103, '2025-01-03', 'Visa', '32.0000', '', '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '08:03:58', '2025-01-03', 'Admin', 1, NULL, 4, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (98, 98, 'PP/2021/02/0098', 2, 102, '2025-01-03', 'Visa', '4.9000', '', '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '08:04:07', '2025-01-03', 'Admin', 1, NULL, 39, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (99, 99, 'PP/2021/02/0099', 2, 101, '2025-01-03', 'Visa', '10.5000', '', '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '08:04:21', '2025-01-03', 'Admin', 1, NULL, 15, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (100, 100, 'PP/2021/02/0100', 2, 100, '2025-01-03', 'Visa', '9.5000', '', '5.36.186.200', '5.36.186.200.dynamic-dsl-ip.omantel.net.om', '08:04:31', '2025-01-03', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (101, 101, 'PP/2021/02/0101', 2, 108, '2025-01-08', 'Visa', '63.9600', '', '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', '08:20:00', '2025-01-08', 'Admin', 1, NULL, 53, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (102, 102, 'PP/2021/02/0102', 2, 107, '2025-01-08', 'Visa', '38.0000', '', '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', '08:21:04', '2025-01-08', 'Admin', 1, NULL, 52, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (103, 103, 'PP/2021/02/0103', 2, 106, '2025-01-08', 'Visa', '7.8000', '', '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', '08:21:15', '2025-01-08', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (104, 104, 'PP/2021/02/0104', 2, 105, '2025-01-08', 'Visa', '1.0000', '', '5.37.219.74', '5.37.219.74.dynamic-dsl-ip.omantel.net.om', '08:21:55', '2025-01-08', 'Admin', 1, NULL, 37, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (105, 105, 'PP/2021/02/0105', 2, 109, '2025-01-13', 'Visa', '9.3000', '', '5.36.132.242', '5.36.132.242.dynamic-dsl-ip.omantel.net.om', '05:07:17', '2025-01-13', 'Admin', 1, NULL, 3, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (106, 106, 'PP/2021/02/0106', 2, 110, '2025-01-13', 'Visa', '38.0000', '', '5.36.132.242', '5.36.132.242.dynamic-dsl-ip.omantel.net.om', '05:08:08', '2025-01-13', 'Admin', 1, NULL, 24, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (107, 107, 'PP/2021/02/0107', 2, 111, '2025-01-13', 'Visa', '50.0000', '', '5.36.132.242', '5.36.132.242.dynamic-dsl-ip.omantel.net.om', '05:08:25', '2025-01-13', 'Admin', 1, NULL, 12, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (108, 108, 'PP/2021/02/0108', 2, 112, '2025-01-13', 'Visa', '16.0000', '', '5.36.132.242', '5.36.132.242.dynamic-dsl-ip.omantel.net.om', '05:08:37', '2025-01-13', 'Admin', 1, NULL, 52, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (109, 109, 'PP/2021/02/0109', 2, 116, '2025-01-22', 'Visa', '30.5990', '', '37.200.247.27', '37.200.247.27', '05:39:01', '2025-01-22', 'Admin', 1, NULL, 22, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (110, 110, 'PP/2021/02/0110', 2, 115, '2025-01-22', 'Visa', '12.2850', '', '37.200.247.27', '37.200.247.27', '05:39:17', '2025-01-22', 'Admin', 1, NULL, 43, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (111, 111, 'PP/2021/02/0111', 2, 114, '2025-01-22', 'Cash', '16.1700', '', '37.200.247.27', '37.200.247.27', '05:40:06', '2025-01-22', 'Admin', 1, NULL, 46, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (112, 112, 'PP/2021/02/0112', 2, 113, '2025-01-22', 'Cash', '30.0000', '', '37.200.247.27', '37.200.247.27', '05:40:17', '2025-01-22', 'Admin', 1, NULL, 54, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (113, 113, 'PP/2021/02/0113', 2, 117, '2025-01-25', 'Visa', '9.1000', '', '188.135.25.55', '188.135.25.55', '12:29:13', '2025-01-25', 'Admin', 1, NULL, 17, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (114, 114, 'PP/2021/02/0114', 2, 118, '2025-01-26', 'Visa', '48.0000', '', '188.135.25.55', '188.135.25.55', '06:02:28', '2025-01-26', 'Admin', 1, NULL, 55, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (115, 115, 'PP/2021/02/0115', 2, 120, '2025-01-27', 'Visa', '12.2700', '', '5.36.86.76', '5.36.86.76.dynamic-dsl-ip.omantel.net.om', '05:07:01', '2025-01-27', 'Admin', 1, NULL, 49, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (116, 116, 'PP/2021/02/0116', 2, 119, '2025-01-27', 'Visa', '1.1000', '', '5.36.86.76', '5.36.86.76.dynamic-dsl-ip.omantel.net.om', '05:07:29', '2025-01-27', 'Admin', 1, NULL, 56, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (117, 117, 'PP/2021/02/0117', 2, 121, '2025-02-02', 'Visa', '7.0000', '', '188.135.25.55', '188.135.25.55', '07:24:31', '2025-02-02', 'Admin', 1, NULL, 57, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (118, 118, 'PP/2021/02/0118', 2, 122, '2025-02-02', 'Visa', '35.7000', '', '188.135.25.55', '188.135.25.55', '07:24:43', '2025-02-02', 'Admin', 1, NULL, 23, NULL);


#
# TABLE STRUCTURE FOR: db_purchasepaymentsreturn
#

DROP TABLE IF EXISTS `db_purchasepaymentsreturn`;

CREATE TABLE `db_purchasepaymentsreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `supplier_id` (`supplier_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasereturn
#

DROP TABLE IF EXISTS `db_purchasereturn`;

CREATE TABLE `db_purchasereturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Purchase Return Code',
  `warehouse_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotation
#

DROP TABLE IF EXISTS `db_quotation`;

CREATE TABLE `db_quotation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create quotation Code',
  `quotation_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `quotation_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `quotation_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `quotation_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'quotation return raised',
  `customer_previous_due` double(20,4) DEFAULT NULL,
  `customer_total_due` double(20,4) DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_quotation` (`id`, `store_id`, `warehouse_id`, `count_id`, `quotation_code`, `reference_no`, `quotation_date`, `expire_date`, `quotation_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `quotation_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `sales_status`) VALUES (1, 2, 2, 1, 'QT/2021/02/0001', '', '2024-07-18', NULL, 'Quotation', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '23.2500', NULL, '23.2500', 'Oil and filter service and full inspection ', NULL, NULL, '2024-07-18', '05:00:27 pm', 'Admin', '5.36.223.128', '5.36.223.128.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: db_quotationitems
#

DROP TABLE IF EXISTS `db_quotationitems`;

CREATE TABLE `db_quotationitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `quotation_id` int DEFAULT NULL,
  `quotation_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `quotation_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `seller_points` double(20,4) DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `quotation_id` (`quotation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_quotationitems` (`id`, `store_id`, `quotation_id`, `quotation_status`, `item_id`, `description`, `quotation_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (7, 2, 1, 'Quotation', 3, '', '4.50', '3.5000', 'Inclusive', 151, NULL, 'Percentage', NULL, '0.0000', '3.5000', '15.7500', 1, '0.0000');
INSERT INTO `db_quotationitems` (`id`, `store_id`, `quotation_id`, `quotation_status`, `item_id`, `description`, `quotation_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (8, 2, 1, 'Quotation', 7, '', '1.00', '2.5000', 'Inclusive', 151, NULL, 'Percentage', NULL, '0.0000', '2.5000', '2.5000', 1, '0.0000');
INSERT INTO `db_quotationitems` (`id`, `store_id`, `quotation_id`, `quotation_status`, `item_id`, `description`, `quotation_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (9, 2, 1, 'Quotation', 13, '', '1.00', '5.0000', 'Inclusive', 151, NULL, 'Percentage', NULL, '0.0000', '5.0000', '5.0000', 1, '0.0000');


#
# TABLE STRUCTURE FOR: db_roles
#

DROP TABLE IF EXISTS `db_roles`;

CREATE TABLE `db_roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `role_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (1, 1, 'Admin', 'All Rights Permitted.', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (2, 1, 'Store Admin', 'Note: Apply this role for New Store Admin. ', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (3, 2, 'sales', '', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (4, 2, 'Manager', '', 1);


#
# TABLE STRUCTURE FOR: db_sales
#

DROP TABLE IF EXISTS `db_sales`;

CREATE TABLE `db_sales` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `init_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `count_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL COMMENT 'Use to create Sales Code',
  `sales_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'sales return raised',
  `customer_previous_due` double(20,2) DEFAULT NULL,
  `customer_total_due` double(20,2) DEFAULT NULL,
  `quotation_id` int DEFAULT NULL,
  `vehicle_reg` varchar(50) COLLATE utf8mb3_unicode_ci NOT NULL,
  `vehicle_chassis` varchar(50) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vehicle_model` varchar(50) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vehicle_make` varchar(100) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `vehicle_year` int DEFAULT NULL,
  `next_service_date` date DEFAULT NULL,
  `brake_condition` varchar(100) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tires_condition` text COLLATE utf8mb3_unicode_ci,
  `engine_oil` text COLLATE utf8mb3_unicode_ci,
  `odo_meter` varchar(20) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `picture_gallary` text COLLATE utf8mb3_unicode_ci,
  `brake_fluid_level` text COLLATE utf8mb3_unicode_ci,
  `gear_oil` text COLLATE utf8mb3_unicode_ci,
  `signature` text COLLATE utf8mb3_unicode_ci,
  `inspection_image` text COLLATE utf8mb3_unicode_ci,
  `inspection_data` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB AUTO_INCREMENT=462 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (19, 2, 2, 'GMC/YUKON', '001', 'GMC/YUKON001', '', '2024-08-01', NULL, 'Final', 10, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '40.50', NULL, '40.5000', 'Need to change transmission oil \r\nBrake-fluid change next service .', 'Paid', '40.5000', '2024-08-01', '09:19:00 am', 'Admin', '5.36.125.87', '5.36.125.87.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '6662H', 'NA', 'YUKON', 'GMC', 2015, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (20, 2, 2, 'Nissan/Patrol', '001', 'Nissan/Patrol001', '', '2024-08-01', NULL, 'Final', 11, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.00', NULL, '10.0000', '', 'Paid', '10.0000', '2024-08-01', '12:07:51 pm', 'Admin', '5.36.125.87', '5.36.125.87.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '1681B', 'NA', 'Patrol', 'Nissan', 2013, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (21, 2, 2, 'Chevrolet', '001', 'Chevrolet001', '', '2024-08-01', NULL, 'Final', 12, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.00', NULL, '10.0000', 'Computer scan report attach', 'Paid', '10.0000', '2024-08-01', '08:47:35 pm', 'Admin', '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '31498Y', 'NA', 'Tahoe', 'Chevrolet', 2016, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (22, 2, 2, 'Nissan Patrol', '001', 'Nissan Patrol001', '', '2024-08-01', NULL, 'Final', 13, NULL, NULL, NULL, '35.71', 'in_percentage', '10.00', '28.00', NULL, '18.0010', '', 'Partial', '18.0000', '2024-08-01', '08:58:13 pm', 'Admin', '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '920B', '', 'Patrol', 'Nissan ', 2016, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (23, 2, 2, 'Dodge/Ram', '001', 'Dodge/Ram001', '', '2024-08-01', NULL, 'Final', 14, NULL, NULL, NULL, '14.65', 'in_percentage', '5.49', '37.50', NULL, '32.0060', '', 'Paid', '32.0060', '2024-08-01', '09:35:58 pm', 'Admin', '5.36.148.9', '5.36.148.9.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '78239w', '', 'Ram', 'Dodge', 0, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (24, 2, 2, 'Hyundai', '001', 'Hyundai001', '', '2024-08-04', NULL, 'Final', 15, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '10.00', NULL, '10.0000', '', 'Paid', '10.0000', '2024-08-04', '10:34:30 am', 'Admin', '5.36.140.145', '5.36.140.145.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, 'NA', '', 'Sonata', 'Hyundai ', 2014, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (25, 2, 2, 'Toyota/Camry', '001', 'Toyota/Camry001', '', '2024-08-04', NULL, 'Final', 16, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', '', 'Paid', '5.0000', '2024-08-04', '12:17:58 pm', 'Admin', '5.36.140.145', '5.36.140.145.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '26269B', 'NA', 'Camry', 'Toyota ', 2019, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (27, 2, 2, 'Porsche cayenne ', '001', 'Porsche cayenne 001', '', '2024-08-05', NULL, 'Final', 17, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '59.00', NULL, '59.0020', 'Need change spark plugs\r\nNeed change air filter', 'Partial', '59.0000', '2024-08-05', '12:42:28 pm', 'Admin', '5.36.220.161', '5.36.220.161.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '659 S', '', 'Cayenne gts', 'Porsche ', 2013, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (28, 2, 2, 'Mercedes E', '350', 'Mercedes E350', '', '2024-08-05', NULL, 'Final', 18, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '47.00', NULL, '47.0000', ' Need change air Filter, front and rear brake pads, steblizer bush, engine belt, \r\n', 'Paid', '47.0000', '2024-08-05', '12:57:43 pm', 'Admin', '5.36.220.161', '5.36.220.161.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '9373AS', '', 'E 350', 'Mercedes ', 2011, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (29, 2, 2, NULL, '29', 'SL/ECS/0029', NULL, '2024-08-06', NULL, 'Final', 19, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '28.00', '0.00', '28.0000', '', 'Paid', '28.0000', '2024-08-06', '06:36:08 pm', 'Admin', '5.36.231.215', '5.36.231.215.dynamic-dsl-ip.omantel.net.om', NULL, 1, 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (30, 2, 2, 'Toyota/Camry', '001', 'Toyota/Camry001', '', '2024-08-07', NULL, 'Final', 20, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '5.00', NULL, '5.0000', 'Findings: engine oil pump and drive belt. ', 'Paid', '5.0000', '2024-08-07', '05:56:43 pm', 'Admin', '5.36.168.17', '5.36.168.17.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '65843', 'NA', 'Camry', 'Toyota', 2015, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (31, 2, 2, 'Old oil', '001', 'Old oil001', 'NA', '2024-08-08', NULL, 'Final', 21, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '22.00', NULL, '22.0000', '', 'Paid', '22.0000', '2024-08-08', '12:01:30 pm', 'Admin', '5.37.247.189', '5.37.247.189.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, 'NA', 'NA', 'NA', 'NA', 0, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (32, 2, 2, 'Mazda', '006', 'Mazda006', 'Oil Service', '2024-08-08', NULL, 'Final', 22, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '23.00', NULL, '23.0000', '', 'Paid', '23.0000', '2024-08-08', '05:59:02 pm', 'Admin', '5.37.243.133', '5.37.243.133.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '1347S', '1k1312450', '6', 'Mazda', 2018, NULL, '', '', '', '', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differential_mountings\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_ahc\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_brakes\":{\"inspect_front_brake_pads_rotor\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_rear_brake_pads_rotor_drum\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_abs_system_master_cylinder_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_hand_parking_brake\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_front_rear_windshiekd_wiper\":{\"inspect_front_rear_windshield\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_wiper_blades_rubbers\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_tyres\":{\"inspect_all_tyres_adjust_tyre_pressure\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_wheel_rims_bolts_nuts\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"spare_wheel\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_engine\":{\"check_ac_filter_air_filter\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_drive_belt_pulley\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_oil_coolant_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_engine_mounting\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_transmission\":{\"check_fluid_level_at_mt\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_for_any_leakage\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"check_axle_boots\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}}}');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `vehicle_reg`, `vehicle_chassis`, `vehicle_model`, `vehicle_make`, `vehicle_year`, `next_service_date`, `brake_condition`, `tires_condition`, `engine_oil`, `odo_meter`, `picture_gallary`, `brake_fluid_level`, `gear_oil`, `signature`, `inspection_image`, `inspection_data`) VALUES (33, 2, 2, 'Lexus/RX', '350', 'Lexus/RX350', 'OIL SERVICE', '2024-08-10', NULL, 'Final', 23, NULL, NULL, NULL, '8.40', 'in_percentage', '2.75', '32.75', NULL, '30.0000', 'Need to check condition of engine head gasket for leak . Next Service.', 'Paid', '30.0000', '2024-08-10', '07:33:20 pm', 'Admin', '5.36.117.222', '5.36.117.222.dynamic-dsl-ip.omantel.net.om', NULL, NULL, 1, NULL, NULL, NULL, NULL, '8628AB', '', 'RX350', 'LEXUS', 2017, NULL, '', '', '', '140657KM', '', '', '', 'iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAABGJJREFUeF7t1AEJAAAMAsHZv/RyPNwSyDncOQIECEQEFskpJgECBM5geQICBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAAYPlBwgQyAgYrExVghIgYLD8AAECGQGDlalKUAIEDJYfIEAgI2CwMlUJSoCAwfIDBAhkBAxWpipBCRAwWH6AAIGMgMHKVCUoAQIGyw8QIJARMFiZqgQlQMBg+QECBDICBitTlaAECBgsP0CAQEbAYGWqEpQAgQdWMQCX4yW9owAAAABJRU5ErkJggg==', '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', '{\"list_battery\":{\"inspect_battery\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_battery_terminal\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_fluids\":{\"inspect_for_coolant\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_power_steering_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_transfer_case_differential_fluid\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_lights\":{\"inspect_head_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_indicator_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_fog_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_parking_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_brake_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_reverse_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_high_mounted_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_license_plate_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_roof_lamps\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"}},\"list_suspension\":{\"inspect_front_rear_shocks\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_lower_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_upper_arms\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_front_rear_link_rods\":{\"ok\":\"no\",\"top_up_date\":\"no\",\"cleaned\":\"no\",\"need_repair\":\"no\"},\"inspect_engine_transmission_differen