<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Makers extends MY_Controller {
    
	public function __construct() {
		parent::__construct();
		$this->load_global();
		$this->load->model('makers_model', 'makers');
	}

	public function add() {
	    
		$data = $this->data;
		$data['page_title'] = $this->lang->line('maker');
		$this->load->view('maker', $data);
	}
	public function newmaker() {
		$this->form_validation->set_rules('maker', 'Maker', 'trim|required');
		if ($this->form_validation->run() == TRUE) {

			$this->load->model('makers_model');
			$result = $this->makers_model->verify_and_save();
			echo $result;
		} else {
			echo "Please Enter Maker name.";
		}
	}
	public function update($id) {
	    
		$this->belong_to('db_makers', $id);
		$data = $this->data;

		$this->load->model('makers_model');
		
		$result = $this->makers_model->get_details($id, $data);
		$data = array_merge($data, $result);

		$data['page_title'] = $this->lang->line('maker');
		$this->load->view('maker', $data);
	}
	public function update_maker() {
		$this->form_validation->set_rules('maker', 'Maker', 'trim|required');
		$this->form_validation->set_rules('q_id', '', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$this->load->model('makers_model');
			$result = $this->makers_model->update_maker();
			echo $result;
		} else {
			echo "Please Enter Maker name.";
		}
	}
	public function view() {
		$data = $this->data;
		$data['page_title'] = $this->lang->line('makers_list');
		$this->load->view('maker-view', $data);
	}

	public function ajax_list() {
		$list = $this->makers->get_datatables();

		$data = array();
		$no = $_POST['start'];
		foreach ($list as $maker) {
			$no++;
			$row = array();
			$row[] = '<input type="checkbox" name="checkbox[]" value=' . $maker->id . ' class="checkbox column_checkbox" >';
			$row[] = $maker->name;
		
			$str2 = '<div class="btn-group" title="View Account">
										<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
											Action <span class="caret"></span>
										</a>
										<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

            $str2 .= '<li>
            		<a title="Edit Record ?" href="' . base_url() . 'makers/update/' . $maker->id . '">
            			<i class="fa fa-fw fa-edit text-blue"></i>Edit
            		</a>
            	</li>';

            $str2 .= '<li>
            			<a style="cursor:pointer" title="Delete Record ?" onclick="delete_maker(' . $maker->id . ')">
            				<i class="fa fa-fw fa-trash text-red"></i>Delete
            			</a>
            		</li>
            
            	</ul>
            </div>';


			$row[] = $str2;
			$data[] = $row;
		}

		$output = array(
			"draw" => $_POST['draw'],
			"recordsTotal" => $this->makers->count_all(),
			"recordsFiltered" => $this->makers->count_filtered(),
			"data" => $data,
		);
		//output to json format
		echo json_encode($output);
	}

	public function update_status() {
		$this->permission_check_with_msg('brand_edit');
		$id = $this->input->post('id');
		$status = $this->input->post('status');

		$this->load->model('brand_model');
		$result = $this->brand_model->update_status($id, $status);
		return $result;
	}

	public function delete_maker() {

		$id = $this->input->post('q_id');
		return $this->makers->delete_makers_from_table($id);
	}
	public function multi_delete() {

		$ids = implode(",", $_POST['checkbox']);
		return $this->makers->delete_makers_from_table($ids);
	}

}
