<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Models extends MY_Controller {
    
	public function __construct() {
		parent::__construct();
		$this->load_global();
		$this->load->model('models_model', 'models');
	}

	public function add() {
	    
		$data = $this->data;
		$data['page_title'] = $this->lang->line('model');
		$this->load->view('models', $data);
	}
	public function newmodel() {
		$this->form_validation->set_rules('model', 'Model', 'trim|required');
		$this->form_validation->set_rules('maker_id', 'Maker', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {

			$this->load->model('models_model');
			$result = $this->models_model->verify_and_save();
			echo $result;
		} else {
			echo "Please Enter Model name.";
		}
	}
	public function update($id) {
	    
		$this->belong_to('db_models', $id);
		$data = $this->data;

		$this->load->model('models_model');
		
		$result = $this->models_model->get_details($id, $data);
	
		$data = array_merge($data, $result);

		$data['page_title'] = $this->lang->line('model');
		$this->load->view('models', $data);
	}
	public function update_model() {
		$this->form_validation->set_rules('maker_id', 'Maker', 'trim|required');
		$this->form_validation->set_rules('model', 'Model', 'trim|required');
		$this->form_validation->set_rules('q_id', '', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$this->load->model('models_model');
			$result = $this->models_model->update_model();
			echo $result;
		} else {
			echo "Please Enter All Fields.";
		}
	}
	public function view() {
		$data = $this->data;
		$data['page_title'] = $this->lang->line('models_list');
		$this->load->view('model_view', $data);
	}

	public function ajax_list() {
		$list = $this->models->get_datatables();

		$data = array();
		$no = $_POST['start'];
		foreach ($list as $model) {
			$no++;
			$row = array();
			$row[] = '<input type="checkbox" name="checkbox[]" value=' . $model->id . ' class="checkbox column_checkbox" >';
			$row[] = $model->name;
			$row[] = $model->maker;
		
			$str2 = '<div class="btn-group" title="View Account">
										<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
											Action <span class="caret"></span>
										</a>
										<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

            $str2 .= '<li>
            		<a title="Edit Record ?" href="' . base_url() . 'models/update/' . $model->id . '">
            			<i class="fa fa-fw fa-edit text-blue"></i>Edit
            		</a>
            	</li>';

            $str2 .= '<li>
            			<a style="cursor:pointer" title="Delete Record ?" onclick="delete_model(' . $model->id . ')">
            				<i class="fa fa-fw fa-trash text-red"></i>Delete
            			</a>
            		</li>
            
            	</ul>
            </div>';


			$row[] = $str2;
			$data[] = $row;
		}

		$output = array(
			"draw" => $_POST['draw'],
			"recordsTotal" => $this->models->count_all(),
			"recordsFiltered" => $this->models->count_filtered(),
			"data" => $data,
		);
		//output to json format
		echo json_encode($output);
	}

	public function update_status() {

		$id = $this->input->post('id');
		$status = $this->input->post('status');

		$this->load->model('models_model');
		$result = $this->brand_model->update_status($id, $status);
		return $result;
	}

	public function delete_model() {

		$id = $this->input->post('q_id');
		return $this->models->delete_models_from_table($id);
	}
	public function multi_delete() {

		$ids = implode(",", $_POST['checkbox']);
		return $this->models->delete_models_from_table($ids);
	}
	
	public function get_maker_models() {

        $maker_id = $this->input->post('maker_id');
		$this->load->model('models_model');
		$result = $this->models_model->get_maker_models($maker_id);
	}
	

}
