<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('reports_model','reports');
	}
	
	
	//Supplier Items Report 
	public function supplier_items(){
		$this->permission_check('supplier_items_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('supplier_items_report');
		$this->load->view('report-supplier_items', $data);
	}
	public function show_supplier_items_report(){
		echo $this->reports->show_supplier_items_report();
	}
	
	//Sales Report 
	public function sales(){
		$this->permission_check('sales_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('sales_report');
		$this->load->view('report-sales', $data);
	}
	public function show_sales_report(){
		echo $this->reports->show_sales_report();
	}

	//Sales Return Report 
	public function sales_return(){
		$this->permission_check('sales_return_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('sales_return_report');
		$this->load->view('report-sales-return', $data);
	}
	public function show_sales_return_report(){
		echo $this->reports->show_sales_return_report();
	}

	//Purchase report
	public function purchase(){
		$this->permission_check('purchase_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('purchase_report');
		$this->load->view('report-purchase', $data);
	}
	public function show_purchase_report(){
		echo $this->reports->show_purchase_report();
	}

	//Purchase Return report
	public function purchase_return(){
		$this->permission_check('purchase_return_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('purchase_return_report');
		$this->load->view('report-purchase-return', $data);
	}
	public function show_purchase_return_report(){
		echo $this->reports->show_purchase_return_report();
	}

	//Expense report
	public function expense(){
		$this->permission_check('expense_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('expense_report');
		$this->load->view('report-expense', $data);
	}
	public function show_expense_report(){
		echo $this->reports->show_expense_report();
	}
	//Profit report
	public function profit_loss(){
		$this->permission_check('profit_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('profit_and_loss_report');
		$this->load->view('report-profit-loss', $data);
	}
	public function get_profit_by_item(){
		echo $this->reports->get_profit_by_item();
	}
	public function get_profit_by_invoice(){
		echo $this->reports->get_profit_by_invoice();
	}

	/*CASH REGISTER REPORTS START*/

	//Summary report
	public function cash_register(){
		$this->permission_check('stock_report');
		$data=$this->data;
		$data['page_title']= "Cash Regisgter";
		$this->load->view('report-register', $data);
	}
	/*Stock Report*/
	public function cash_register_report(){
		echo $this->reports->show_cash_register_report();
	}

	public function print_register_sales($register_id)
	{
		$this->db->select("*");
		$this->db->from("db_cash_register");		
		$this->db->where("db_cash_register.`id`= $register_id");
		$register_info = $this->db->get()->row();
		$data['register_info'] = $register_info;

		$start_date = $register_info->o_time;
		$end_date = ($register_info->c_time)?$register_info->c_time:date('Y-m-d', strtotime(date('Y-m-d') . ' +2 day'));

		$v_start_date = date('Y-m-d',strtotime($start_date));
		$v_end_date = date('Y-m-d',strtotime($end_date));

		if($v_start_date === $v_end_date)
		{
			$start_date = $v_start_date;
			$end_date = $v_end_date;

			$start_date_main=date("Y-m-d h:i:s A",strtotime($start_date));
			$end_date_main=date("Y-m-d h:i:s A",strtotime($end_date));
			

			$this->db->select("d.item_name,sum(IFNULL(c.total_cost,0)) as total_costs,a.store_id");
			$this->db->select("sum(IFNULL(c.sales_qty,0)) as total_quantity");

			$this->db->where("a.created_date = '$start_date'");
			$this->db->group_by("c.`item_id`");
			$this->db->from("db_sales as a");
			$this->db->where("a.`id`= c.`sales_id`");
			$this->db->where("a.`sales_status`= 'Final'");
			$this->db->from("db_items as d");
			$this->db->where("d.`id`= c.`item_id`");
			$this->db->from("db_salesitems as c");

			$items_sales_info = $this->db->get()->result();
			$data['items_sales_info'] = $items_sales_info;


			$this->db->select("sum(IFNULL(db_sales.subtotal,0)) as total_sales, sum(IFNULL(db_sales.grand_total,0)) as total_sales_af_discount, sum(IFNULL(db_sales.tot_discount_to_all_amt,0)) as total_discount");
			$this->db->from("db_sales");
			$this->db->where("db_sales.created_date = '$start_date'");
			$this->db->where("db_sales.`sales_status`= 'Final'");

			$sales_info = $this->db->get()->row();
			$data['sales_info'] = $sales_info;



			$start_date_payments=date("Y-m-d h:i:s",strtotime($start_date));
			$end_date_payments=date("Y-m-d h:i:s",strtotime($end_date));
			


			$this->db->select("sum(IFNULL(db_salespayments.payment,0)) as total_payments");
			$this->db->from("db_salespayments");

			$this->db->from("db_sales");
			$this->db->where("db_sales.`sales_status`= 'Final'");
			$this->db->where("db_sales.id=db_salespayments.sales_id");
			$this->db->where("db_sales.created_date = '$start_date'");


			$total_payments = $this->db->get()->row();
			$data['total_payments'] = $total_payments->total_payments;


			$this->db->select("sum(IFNULL(db_salespayments.payment,0)) as total_cash_payments");
			$this->db->from("db_salespayments");
			$this->db->from("db_sales");
			$this->db->where("db_sales.`sales_status`= 'Final'");
			$this->db->where("db_sales.id=db_salespayments.sales_id");
			$this->db->where("db_sales.created_date = '$start_date'");
			$this->db->where("db_salespayments.`payment_type`= 'Cash'");


			$total_cash_payments = $this->db->get()->row();
			$data['total_cash_payments'] = $total_cash_payments->total_cash_payments;



			$this->db->select("sum(IFNULL(db_salespayments.payment,0)) as total_card_payments");
			$this->db->from("db_salespayments");
			$this->db->from("db_sales");
			$this->db->where("db_sales.`sales_status`= 'Final'");
			$this->db->where("db_sales.id=db_salespayments.sales_id");
			$this->db->where("db_sales.created_date = '$start_date'");
			$this->db->where("db_salespayments.`payment_type`= 'Visa'");


			$total_card_payments = $this->db->get()->row();
			$data['total_card_payments'] = $total_card_payments->total_card_payments;



			$this->db->select("sum(IFNULL(db_salespayments.payment,0)) as total_talabat_payments");
			$this->db->from("db_salespayments");
			$this->db->from("db_sales");
			$this->db->where("db_sales.`sales_status`= 'Final'");
			$this->db->where("db_sales.id=db_salespayments.sales_id");
			$this->db->where("db_sales.created_date = '$start_date'");
			$this->db->where("db_salespayments.`payment_type`= 'Talabat'");


			$total_talabat_payments = $this->db->get()->row();
			$data['total_talabat_payments'] = ($total_talabat_payments->total_talabat_payments)?$total_talabat_payments->total_talabat_payments:0;
		}

		else
		{
			//$from_date = system_fromatted_date($start_date);
			//$to_date = system_fromatted_date($end_date);


			$start_date_main=date("Y-m-d h:i:s A",strtotime($start_date));
			$end_date_main=date("Y-m-d h:i:s A",strtotime($end_date));
			

			$this->db->select("d.item_name,sum(IFNULL(c.total_cost,0)) as total_costs,a.store_id");
			$this->db->select("sum(IFNULL(c.sales_qty,0)) as total_quantity");

			$this->db->where("STR_TO_DATE(concat_ws(' ',a.created_date,a.created_time), '%Y-%m-%d %h:%i:%s %p') BETWEEN '$start_date_main' AND '$end_date_main'");
			$this->db->group_by("c.`item_id`");
			$this->db->from("db_sales as a");
			$this->db->where("a.`id`= c.`sales_id`");
			$this->db->where("a.`sales_status`= 'Final'");
			$this->db->from("db_items as d");
			$this->db->where("d.`id`= c.`item_id`");
			$this->db->from("db_salesitems as c");

			$items_sales_info = $this->db->get()->result();
			$data['items_sales_info'] = $items_sales_info;


			$this->db->select("sum(IFNULL(db_sales.subtotal,0)) as total_sales, sum(IFNULL(db_sales.grand_total,0)) as total_sales_af_discount, sum(IFNULL(db_sales.tot_discount_to_all_amt,0)) as total_discount");
			$this->db->from("db_sales");
			$this->db->where("STR_TO_DATE(concat_ws(' ',db_sales.created_date,db_sales.created_time), '%Y-%m-%d %h:%i:%s %p') BETWEEN '$start_date_main' AND '$end_date_main'");
			$this->db->where("db_sales.`sales_status`= 'Final'");

			$sales_info = $this->db->get()->row();
			$data['sales_info'] = $sales_info;



			$start_date_payments=date("Y-m-d h:i:s",strtotime($start_date));
			$end_date_payments=date("Y-m-d h:i:s",strtotime($end_date));
			


			$this->db->select("sum(IFNULL(db_salespayments.payment,0)) as total_payments");
			$this->db->from("db_salespayments");

			$this->db->from("db_sales");
			$this->db->where("db_sales.`sales_status`= 'Final'");
			$this->db->where("db_sales.id=db_salespayments.sales_id");
			$this->db->where("STR_TO_DATE(concat_ws(' ',db_sales.created_date,db_sales.created_time), '%Y-%m-%d %h:%i:%s %p') BETWEEN '$start_date_payments' AND '$end_date_payments'");


			$total_payments = $this->db->get()->row();
			$data['total_payments'] = $total_payments->total_payments;


			$this->db->select("sum(IFNULL(db_salespayments.payment,0)) as total_cash_payments");
			$this->db->from("db_salespayments");
			$this->db->from("db_sales");
			$this->db->where("db_sales.`sales_status`= 'Final'");
			$this->db->where("db_sales.id=db_salespayments.sales_id");
			$this->db->where("STR_TO_DATE(concat_ws(' ',db_sales.created_date,db_sales.created_time), '%Y-%m-%d %h:%i:%s %p') BETWEEN '$start_date_payments' AND '$end_date_payments'");
			$this->db->where("db_salespayments.`payment_type`= 'Cash'");


			$total_cash_payments = $this->db->get()->row();
			$data['total_cash_payments'] = $total_cash_payments->total_cash_payments;



			$this->db->select("sum(IFNULL(db_salespayments.payment,0)) as total_card_payments");
			$this->db->from("db_salespayments");
			$this->db->from("db_sales");
			$this->db->where("db_sales.`sales_status`= 'Final'");
			$this->db->where("db_sales.id=db_salespayments.sales_id");
			$this->db->where("STR_TO_DATE(concat_ws(' ',db_sales.created_date,db_sales.created_time), '%Y-%m-%d %h:%i:%s %p') BETWEEN '$start_date_payments' AND '$end_date_payments'");
			$this->db->where("db_salespayments.`payment_type`= 'Visa'");


			$total_card_payments = $this->db->get()->row();
			$data['total_card_payments'] = $total_card_payments->total_card_payments;



			$this->db->select("sum(IFNULL(db_salespayments.payment,0)) as total_talabat_payments");
			$this->db->from("db_salespayments");
			$this->db->from("db_sales");
			$this->db->where("db_sales.`sales_status`= 'Final'");
			$this->db->where("db_sales.id=db_salespayments.sales_id");
			$this->db->where("STR_TO_DATE(concat_ws(' ',db_sales.created_date,db_sales.created_time), '%Y-%m-%d %h:%i:%s %p') BETWEEN '$start_date_payments' AND '$end_date_payments'");
			$this->db->where("db_salespayments.`payment_type`= 'Talabat'");


			$total_talabat_payments = $this->db->get()->row();
			$data['total_talabat_payments'] = ($total_talabat_payments->total_talabat_payments)?$total_talabat_payments->total_talabat_payments:0;



			/*echo "<pre>";
			print_r($items_sales_info);		
			echo "</pre>";*/

			
		}

		$this->load->view('daily-sales-report',$data);

		

	}

	/*CASH REGISTER REPORTS ENDED*/

	//Summary report
	public function stock(){
		$this->permission_check('stock_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('stock_report');
		$this->load->view('report-stock', $data);
	}
	/*Stock Report*/
	public function show_stock_report(){
		echo $this->reports->show_stock_report();
	}
	public function brand_wise_stock(){
		echo $this->reports->brand_wise_stock();
	}
	//Item Sales Report 
	public function item_sales(){
		$this->permission_check('item_sales_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('item_sales_report');
		$this->load->view('report-sales-item', $data);
	}
	public function show_item_sales_report(){
		echo $this->reports->show_item_sales_report();
	}

	//Item Sales Report 
	public function item_sales2(){
		$this->permission_check('item_sales_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('item_sales_report')." 2";
		$this->load->view('report-sales-item2', $data);
	}
	public function show_item_sales_report2(){
		echo $this->reports->show_item_sales_report2();
	}
	
	//Purchase Payments report
	public function purchase_payments(){
		$this->permission_check('purchase_payments_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('purchase_payments_report');
		$this->load->view('report-purchase-payments', $data);
	}
	public function show_purchase_payments_report(){
		echo $this->reports->show_purchase_payments_report();
	}

	//Sales Payments report
	public function sales_payments(){
		$this->permission_check('sales_payments_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('sales_payments_report');
		$this->load->view('report-sales-payments', $data);
	}
	public function show_sales_payments_report(){
		echo $this->reports->show_sales_payments_report();
	}
	//Expired Items Report 
	public function expired_items(){
		$this->permission_check('expired_items_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('expired_items_report');
		$this->load->view('report-expired-items', $data);
	}
	public function show_expired_items_report(){
		echo $this->reports->show_expired_items_report();
	}
	public function get_profit_loss_report(){
		echo json_encode($this->reports->get_profit_loss_report());
	}


	//Item Sales Report 
	public function seller_points(){
		$this->permission_check('seller_points_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('seller_points_report');
		$this->load->view('report-seller-points', $data);
	}
	public function show_seller_points_report(){
		echo $this->reports->show_seller_points_report();
	}
	
	//Sales Tax Report 
	public function sales_tax(){
		$this->permission_check('sales_tax_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('sales_tax_report');
		$this->load->view('report-sales-tax', $data);
	}
	public function show_sales_tax_report(){
		echo $this->reports->show_sales_tax_report();
	}

	//purchase Tax Report 
	public function purchase_tax(){
		$this->permission_check('purchase_tax_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('purchase_tax_report');
		$this->load->view('report-purchase-tax', $data);
	}
	public function show_purchase_tax_report(){
		echo $this->reports->show_purchase_tax_report();
	}

	//GSTR-1 Report 
	public function gstr_1(){
		$this->permission_check('gstr_1_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('gstr_1_report');
		$this->load->view('gst/report-gstr-1', $data);
	}
	public function show_gstr_1_report(){
		echo $this->reports->show_gstr_1_report();
	}
	//GSTR-2 Report 
	public function gstr_2(){
		$this->permission_check('gstr_2_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('gstr_2_report');
		$this->load->view('gst/report-gstr-2', $data);
	}
	public function show_gstr_2_report(){
		echo $this->reports->show_gstr_2_report();
	}

	//Sales Report 
	public function customer_orders(){
		$this->permission_check('customer_orders_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('customer_orders');
		$this->load->view('report-customer-orders', $data);
	}
	public function show_customer_orders(){
		echo $this->reports->show_customer_orders();
	}

	//Delivery sheet report
	public function delivery_sheet(){
		$this->permission_check('delivery_sheet_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('delivery_sheet_report');
		$this->load->view('report-delivery-sheet', $data);
	}
	public function show_delivery_sheet(){
		echo $this->reports->show_delivery_sheet();
	}

	//Load sheet report
	public function load_sheet(){
		$this->permission_check('load_sheet_report');
		$data=$this->data;
		$data['page_title']=$this->lang->line('load_sheet_report');
		$this->load->view('report-load-sheet', $data);
	}
	public function show_load_sheet(){
		echo $this->reports->show_load_sheet();
	}
	
	//Custom P&L Report
	public function custom_pnl_report(){
		//$this->permission_check('sales_payments_report');
		$data = $this->data;
		$data['page_title']= "Custom P&L";
		$this->load->view('report-custom-pnl', $data);
	}
	public function show_custom_pnl_report(){
		echo $this->reports->custom_pnl_data();
	}
}

