<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Models_model extends CI_Model {

	var $table = 'db_models a';
	var $column_order = array('a.id','a.name', 'b.name as maker'); //set column field database for datatable orderable
	var $column_search = array('a.name','b.name'); //set column field database for datatable searchable 
	var $order = array('a.id' => 'desc'); // default order 

	private function _get_datatables_query()
	{
		$this->db->select($this->column_order);
		$this->db->from($this->table);
		$this->db->join('db_makers as b',"b.id=a.maker_id","left");
		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function get_datatables()
	{
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}


	public function verify_and_save(){
		//Filtering XSS and html escape from user inputs 
		extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST))));
		
		//Validate This brand already exist or not
		//$store_id=(store_module() && is_admin()) ? $store_id : get_current_store_id();	
		$query=$this->db->query("select * from db_models where upper(name)=upper('$model')");
		if($query->num_rows()>0){
			return "This Maker Name already Exist.";
			
		}
		else{
			$info = array('name' => $model, 'maker_id' => $maker_id);

			$q1 = $this->db->insert('db_models', $info);
			if ($q1){
					$this->session->set_flashdata('success', 'Success!! New Model Added Successfully!');
			        return "success";
			}
			else{
			        return "failed";
			}
		}
	}

	//Get brand_details
	public function get_details($id,$data){
		//Validate This brand already exist or not
		$query=$this->db->query("select * from db_models where upper(id)=upper('$id')");
		if($query->num_rows()==0){
			show_404();exit;
		}
		else{
			$query=$query->row();
			$data['q_id']=$query->id;
			$data['name']=$query->name;
			$data['maker_id']=$query->maker_id;
			return $data;
		}
	}
	public function update_model(){
		//Filtering XSS and html escape from user inputs 
		extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST))));


		$query=$this->db->query("select * from db_models where upper(name)=upper('$model') and id<>$q_id");
		if($query->num_rows()>0){
			return "This Maker Name already Exist.";
			
		}
		else{
			$info = array('name' => $model, 'maker_id' =>  $maker_id);

			$q1 = $this->db->where('id',$q_id)->update('db_models', $info);
		
			if ($q1){
					$this->session->set_flashdata('success', 'Success!! Model Updated Successfully!');
			        return "success";
			}
			else{
			        return "failed";
			}
		}
	}
	public function update_status($id,$status){
		if (set_status_of_table($id,$status,'db_models')){
            echo "success";
        }
        else{
            echo "failed";
        }
	}
	public function delete_models_from_table($ids){
			$this->db->trans_begin();

			//find the this BRAND has the items ? 
			$items_rec = $this->db->select("*")->where("vehicle_model in($ids)")->get("db_sales");
			if($items_rec->num_rows()>0){
				echo "Can't Delete!<br>Model Has the sale! You need to delete sale";
				exit;
			}

			$this->db->where("id in ($ids)");
			
			$query1=$this->db->delete("db_models");
			#---------------------------------


	        if ($query1){
	        	$this->db->trans_commit();
	            echo "success";
	        }
	        else{
	            echo "failed";
	        }	
		
	}
	
	public function get_maker_models($maker_id){
	    
	    $this->db->select("*");
		$this->db->where("maker_id",$maker_id);
		$this->db->where("deleted",0);
		$this->db->from($this->table);
		$results =  $this->db->get()->result();
		$options = "<option value=''> - </option>";
		foreach($results as $result){
	        $options .= "<option value='".$result->id."'>".$result->name."</option>";
	    }
		echo $options;
	}

}
